/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.util;

import java.util.List;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.ValueListBox;
import org.jbpm.designer.client.shared.util.StringUtils;
import org.jbpm.designer.client.util.ComboBoxView;
import org.jbpm.designer.client.util.ListBoxValues;

public class ComboBox
implements ComboBoxView.ComboBoxPresenter {
    protected ListBoxValues listBoxValues;
    protected boolean showCustomValues = false;
    protected String currentTextValue = "";
    protected boolean quoteStringValues;
    protected String customPrompt;
    @Inject
    ComboBoxView view;

    @Override
    public void init(ComboBoxView.ModelPresenter modelPresenter, ValueListBox<String> listBox, TextBox textBox, boolean quoteStringValues, String customPrompt, String placeholder) {
        this.quoteStringValues = quoteStringValues;
        this.customPrompt = customPrompt;
        this.view.init(this, modelPresenter, listBox, textBox, placeholder);
    }

    @Override
    public String getValue() {
        return this.view.getValue();
    }

    @Override
    public void setListBoxValues(ListBoxValues listBoxValues) {
        this.listBoxValues = listBoxValues;
    }

    @Override
    public void setShowCustomValues(boolean showCustomValues) {
        this.showCustomValues = showCustomValues;
    }

    @Override
    public void setCurrentTextValue(String currentTextValue) {
        this.currentTextValue = currentTextValue;
    }

    @Override
    public ListBoxValues getListBoxValues() {
        return this.listBoxValues;
    }

    @Override
    public void updateListBoxValues(String listBoxValue) {
        if (this.showCustomValues) {
            List<String> updatedValues = this.listBoxValues.update(listBoxValue);
            this.view.setAcceptableValues(updatedValues);
        } else {
            List<String> values = this.listBoxValues.getAcceptableValuesWithoutCustomValues();
            this.view.setAcceptableValues(values);
        }
    }

    @Override
    public void listBoxValueChanged(String newValue) {
        if (this.customPrompt.equals(newValue)) {
            this.setListBoxValue("");
            this.setTextBoxValue("");
            this.view.setListBoxVisible(false);
            this.view.setTextBoxVisible(true);
            this.view.setTextBoxFocus(true);
        } else if (newValue.startsWith("*")) {
            this.setListBoxValue("");
            this.setTextBoxValue("");
        } else if (newValue.startsWith(this.listBoxValues.getEditPrefix())) {
            String value = this.view.getModelValue();
            this.setTextBoxValue(value);
            this.view.setListBoxVisible(false);
            this.view.setTextBoxVisible(true);
            this.view.setTextBoxFocus(true);
        } else if (this.listBoxValues.isCustomValue(newValue)) {
            String textValue = newValue;
            if (this.quoteStringValues) {
                textValue = StringUtils.createUnquotedConstant(newValue);
            }
            this.setListBoxValue(newValue);
            this.setTextBoxValue(textValue);
        } else if (newValue != null) {
            this.setListBoxValue(newValue);
            this.setTextBoxValue("");
        }
        this.updateListBoxValues(this.view.getListBoxValue());
    }

    @Override
    public void textBoxValueChanged(String newValue) {
        if (newValue != null) {
            if (!this.quoteStringValues) {
                newValue = newValue.trim();
            }
            if (!newValue.isEmpty()) {
                String nonCustomValue = this.listBoxValues.getNonCustomValueForUserString(newValue);
                if (nonCustomValue != null) {
                    this.setListBoxValue(nonCustomValue);
                    this.setTextBoxValue("");
                    this.currentTextValue = "";
                } else {
                    String oldValue = this.currentTextValue;
                    this.addCustomValueToListBoxValues(newValue, oldValue);
                    this.setTextBoxValue(newValue);
                    this.currentTextValue = newValue;
                    if (this.quoteStringValues) {
                        newValue = StringUtils.createQuotedConstant(newValue);
                    }
                    this.setListBoxValue(newValue);
                }
            } else {
                this.setTextBoxValue(newValue);
                this.setListBoxValue(newValue);
                this.currentTextValue = newValue;
            }
        }
        this.view.setTextBoxVisible(false);
        this.view.setListBoxVisible(true);
    }

    @Override
    public void addCustomValueToListBoxValues(String newValue, String oldValue) {
        if (this.quoteStringValues) {
            newValue = StringUtils.createQuotedConstant(newValue);
            oldValue = StringUtils.createQuotedConstant(oldValue);
        }
        this.listBoxValues.addCustomValue(newValue, oldValue);
    }

    public void setTextBoxValue(String value) {
        this.view.setTextBoxValue(value);
        this.view.setTextBoxModelValue(value);
    }

    public void setListBoxValue(String value) {
        this.view.setListBoxValue(value);
        this.view.setListBoxModelValue(value);
    }
}

