/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.popup;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.HeadingElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Composite;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ui.client.widget.ListWidget;
import org.jboss.errai.ui.client.widget.Table;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.designer.client.popup.ActivityDataIOEditorWidgetView;
import org.jbpm.designer.client.popup.AssignmentListItemWidgetView;
import org.jbpm.designer.client.popup.AssignmentListItemWidgetViewImpl;
import org.jbpm.designer.client.resources.i18n.DesignerEditorConstants;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated(value="ActivityDataIOEditorWidget.html#widget")
public class ActivityDataIOEditorWidgetViewImpl
extends Composite
implements ActivityDataIOEditorWidgetView {
    private ActivityDataIOEditorWidgetView.Presenter presenter;
    @Inject
    @DataField
    protected Button addVarButton;
    @DataField
    private final Element table = DOM.createTable();
    @DataField
    private HeadingElement tabletitle = Document.get().createHElement(3);
    @DataField
    private final Element processvarorconstantth = DOM.createTH();
    @Inject
    @DataField
    @Table(root="tbody")
    protected ListWidget<AssignmentRow, AssignmentListItemWidgetViewImpl> assignments;
    @Inject
    private Event<NotificationEvent> notification;

    @Override
    public void init(ActivityDataIOEditorWidgetView.Presenter presenter) {
        this.presenter = presenter;
        this.addVarButton.setText(DesignerEditorConstants.INSTANCE.Add());
        this.addVarButton.setIcon(IconType.PLUS);
    }

    @Override
    public void showOnlySingleEntryAllowed() {
        this.notification.fire((Object)new NotificationEvent(DesignerEditorConstants.INSTANCE.Only_single_entry_allowed(), NotificationEvent.NotificationType.ERROR));
    }

    @Override
    public int getAssignmentsCount() {
        return this.assignments.getValue().size();
    }

    @Override
    public void setTableTitleInputSingle() {
        this.tabletitle.setInnerText(DesignerEditorConstants.INSTANCE.Data_Input_and_Assignment());
    }

    @Override
    public void setTableTitleInputMultiple() {
        this.tabletitle.setInnerText(DesignerEditorConstants.INSTANCE.Data_Inputs_and_Assignments());
    }

    @Override
    public void setTableTitleOutputSingle() {
        this.tabletitle.setInnerText(DesignerEditorConstants.INSTANCE.Data_Output_and_Assignment());
    }

    @Override
    public void setTableTitleOutputMultiple() {
        this.tabletitle.setInnerText(DesignerEditorConstants.INSTANCE.Data_Outputs_and_Assignments());
    }

    @Override
    public void setProcessVarAsSource() {
        this.processvarorconstantth.setInnerText(DesignerEditorConstants.INSTANCE.Source());
    }

    @Override
    public void setProcessVarAsTarget() {
        this.processvarorconstantth.setInnerText(DesignerEditorConstants.INSTANCE.Target());
    }

    @Override
    public void setTableDisplayStyle() {
        this.table.getStyle().setDisplay(Style.Display.TABLE);
    }

    @Override
    public void setNoneDisplayStyle() {
        this.table.getStyle().setDisplay(Style.Display.NONE);
    }

    @Override
    public void setAssignmentRows(List<AssignmentRow> rows) {
        this.assignments.setValue(rows);
    }

    @Override
    public List<AssignmentRow> getAssignmentRows() {
        return this.assignments.getValue();
    }

    @Override
    public AssignmentListItemWidgetView getAssignmentWidget(int index) {
        return (AssignmentListItemWidgetView)this.assignments.getWidget(index);
    }

    @EventHandler(value={"addVarButton"})
    public void handleAddVarButton(ClickEvent e) {
        this.presenter.handleAddClick();
    }
}

