/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.shared;

import org.jbpm.designer.client.shared.AssignmentData;
import org.jbpm.designer.client.shared.Variable;
import org.jbpm.designer.client.shared.util.StringUtils;

public class Assignment {
    private Variable variable;
    AssignmentData assignmentData;
    private Variable processVar;
    private String constant;
    private static final String INPUT_ASSIGNMENT_PREFIX = "[din]";
    private static final String OUTPUT_ASSIGNMENT_PREFIX = "[dout]";
    private static final String ASSIGNMENT_OPERATOR_TOVARIABLE = "->";
    private static final String ASSIGNMENT_OPERATOR_TOCONSTANT = "=";

    public Assignment() {
    }

    public Assignment(AssignmentData assignmentData, String variableName, Variable.VariableType variableType, String dataType, String customDataType, String processVarName, String constant) {
        this.assignmentData = assignmentData;
        this.variable = assignmentData.findVariable(variableName, variableType);
        if (this.variable == null) {
            this.variable = new Variable(variableName, variableType, dataType, customDataType);
            assignmentData.addVariable(this.variable);
        }
        this.processVar = assignmentData.findProcessVariable(processVarName);
        this.constant = constant;
    }

    public Assignment(AssignmentData assignmentData, String variableName, Variable.VariableType variableType, String processVariableName, String constant) {
        this.assignmentData = assignmentData;
        this.variable = assignmentData.findVariable(variableName, variableType);
        if (this.variable == null) {
            this.variable = new Variable(variableName, variableType);
            assignmentData.addVariable(this.variable);
        }
        if (processVariableName != null && !processVariableName.isEmpty()) {
            this.processVar = assignmentData.findProcessVariable(processVariableName);
            if (this.processVar == null) {
                processVariableName = "";
            }
        }
        this.constant = constant;
    }

    public String getName() {
        return this.variable.getName();
    }

    public void setName(String name) {
        this.variable.setName(name);
    }

    public Variable.VariableType getVariableType() {
        return this.variable.getVariableType();
    }

    public void setVariableType(Variable.VariableType variableType) {
        this.variable.setVariableType(variableType);
    }

    public Variable getVariable() {
        return this.variable;
    }

    public String getDataType() {
        return this.variable.getDataType();
    }

    public void setDataType(String dataType) {
        this.variable.setDataType(dataType);
    }

    public String getCustomDataType() {
        return this.variable.getCustomDataType();
    }

    public void setCustomDataType(String customDataType) {
        this.variable.setCustomDataType(customDataType);
    }

    public String getProcessVarName() {
        return this.processVar != null ? this.processVar.getName() : null;
    }

    public void setProcessVarName(String processVarName) {
        this.processVar = this.assignmentData.findProcessVariable(processVarName);
    }

    public String getConstant() {
        return this.constant;
    }

    public void setConstant(String constant) {
        this.constant = constant;
    }

    public AssignmentData getAssignmentData() {
        return this.assignmentData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Assignment)) {
            return false;
        }
        Assignment that = (Assignment)o;
        if (this.getVariable() != null ? !this.getVariable().equals(that.getVariable()) : that.getVariable() != null) {
            return false;
        }
        if (this.processVar != null ? !this.processVar.equals(that.processVar) : that.processVar != null) {
            return false;
        }
        return this.getConstant() != null ? this.getConstant().equals(that.getConstant()) : that.getConstant() == null;
    }

    public int hashCode() {
        int result = this.getVariable() != null ? this.getVariable().hashCode() : 0;
        result = 31 * result + (this.processVar != null ? this.processVar.hashCode() : 0);
        result = 31 * result + (this.getConstant() != null ? this.getConstant().hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getVariableType() == Variable.VariableType.INPUT) {
            if (this.getConstant() != null && !this.getConstant().isEmpty()) {
                sb.append(INPUT_ASSIGNMENT_PREFIX).append(this.getName()).append(ASSIGNMENT_OPERATOR_TOCONSTANT).append(StringUtils.urlEncode(this.getConstant()));
            } else if (this.getProcessVarName() != null && !this.getProcessVarName().isEmpty()) {
                sb.append(INPUT_ASSIGNMENT_PREFIX).append(this.getProcessVarName()).append(ASSIGNMENT_OPERATOR_TOVARIABLE).append(this.getName());
            } else {
                sb.append(INPUT_ASSIGNMENT_PREFIX).append(ASSIGNMENT_OPERATOR_TOVARIABLE).append(this.getName());
            }
        } else if (this.getProcessVarName() != null && !this.getProcessVarName().isEmpty()) {
            sb.append(OUTPUT_ASSIGNMENT_PREFIX).append(this.getName()).append(ASSIGNMENT_OPERATOR_TOVARIABLE).append(this.getProcessVarName());
        } else {
            sb.append(OUTPUT_ASSIGNMENT_PREFIX).append(this.getName()).append(ASSIGNMENT_OPERATOR_TOVARIABLE);
        }
        return sb.toString();
    }

    public static Assignment deserialize(AssignmentData assignmentData, String sAssignment) {
        if (sAssignment == null || sAssignment.isEmpty()) {
            return null;
        }
        Variable.VariableType assignmentType = null;
        if (sAssignment.startsWith(INPUT_ASSIGNMENT_PREFIX)) {
            assignmentType = Variable.VariableType.INPUT;
            sAssignment = sAssignment.substring(INPUT_ASSIGNMENT_PREFIX.length());
        } else if (sAssignment.startsWith(OUTPUT_ASSIGNMENT_PREFIX)) {
            assignmentType = Variable.VariableType.OUTPUT;
            sAssignment = sAssignment.substring(OUTPUT_ASSIGNMENT_PREFIX.length());
        }
        String variableName = null;
        String processVariableName = null;
        String constant = null;
        if (sAssignment.contains(ASSIGNMENT_OPERATOR_TOVARIABLE)) {
            int i = sAssignment.indexOf(ASSIGNMENT_OPERATOR_TOVARIABLE);
            if (assignmentType == Variable.VariableType.INPUT) {
                processVariableName = sAssignment.substring(0, i);
                variableName = sAssignment.substring(i + ASSIGNMENT_OPERATOR_TOVARIABLE.length());
            } else {
                variableName = sAssignment.substring(0, i);
                processVariableName = sAssignment.substring(i + ASSIGNMENT_OPERATOR_TOVARIABLE.length());
            }
        } else if (sAssignment.contains(ASSIGNMENT_OPERATOR_TOCONSTANT)) {
            int i = sAssignment.indexOf(ASSIGNMENT_OPERATOR_TOCONSTANT);
            variableName = sAssignment.substring(0, i);
            constant = StringUtils.urlDecode(sAssignment.substring(i + ASSIGNMENT_OPERATOR_TOCONSTANT.length()));
        }
        return new Assignment(assignmentData, variableName, assignmentType, processVariableName, constant);
    }
}

