/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.shared;

import java.util.List;

public class Variable {
    private VariableType variableType;
    private String name;
    private String dataType;
    private String customDataType;

    public Variable(VariableType variableType) {
        this.variableType = variableType;
    }

    public Variable(String name, VariableType variableType) {
        this.name = name;
        this.variableType = variableType;
    }

    public Variable(String name, VariableType variableType, String dataType, String customDataType) {
        this.name = name;
        this.variableType = variableType;
        this.dataType = dataType;
        this.customDataType = customDataType;
    }

    public VariableType getVariableType() {
        return this.variableType;
    }

    public void setVariableType(VariableType variableType) {
        this.variableType = variableType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getCustomDataType() {
        return this.customDataType;
    }

    public void setCustomDataType(String customDataType) {
        this.customDataType = customDataType;
    }

    public String toString() {
        if (this.name != null && !this.name.isEmpty()) {
            StringBuilder sb = new StringBuilder().append(this.name);
            if (this.customDataType != null && !this.customDataType.isEmpty()) {
                sb.append(':').append(this.customDataType);
            } else if (this.dataType != null && !this.dataType.isEmpty()) {
                sb.append(':').append(this.dataType);
            }
            return sb.toString();
        }
        return null;
    }

    public static Variable deserialize(String s, VariableType variableType, List<String> dataTypes) {
        String name;
        Variable var = new Variable(variableType);
        String[] varParts = s.split(":");
        if (varParts.length > 0 && !(name = varParts[0]).isEmpty()) {
            String dataType;
            var.setName(name);
            if (varParts.length == 2 && !(dataType = varParts[1]).isEmpty()) {
                if (dataTypes != null && dataTypes.contains(dataType)) {
                    var.setDataType(dataType);
                } else {
                    var.setCustomDataType(dataType);
                }
            }
        }
        return var;
    }

    public static Variable deserialize(String s, VariableType variableType) {
        return Variable.deserialize(s, variableType, null);
    }

    public static enum VariableType {
        INPUT,
        OUTPUT,
        PROCESS;

    }
}

