/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.repository.impl;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.repository.IUUIDBasedRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UUIDBasedFileRepository
implements IUUIDBasedRepository {
    private static final Logger _logger = LoggerFactory.getLogger(UUIDBasedFileRepository.class);
    private static final String REPOSITORY_PATH = "repository";
    private String _repositoryPath;

    @Override
    public void configure(HttpServlet servlet) {
        this._repositoryPath = servlet.getServletContext().getRealPath("/repository");
    }

    @Override
    public byte[] load(HttpServletRequest req, String uuid, IDiagramProfile profile, ServletContext servletContext) throws Exception {
        String filename = this._repositoryPath + "/" + uuid + ".json";
        if (!new File(filename).exists()) {
            return new byte[0];
        }
        FileInputStream input = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            int read;
            input = new FileInputStream(filename);
            byte[] buffer = new byte[4096];
            while ((read = ((InputStream)input).read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
        }
        catch (FileNotFoundException e) {
            _logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            _logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (Exception exception) {}
            }
        }
        return output.toByteArray();
    }

    @Override
    public void save(HttpServletRequest req, String uuid, String json, String svg, IDiagramProfile profile, Boolean autosave) {
        String ext = profile.getSerializedModelExtension();
        String preProcessingParam = req.getParameter("pp");
        String model = "";
        try {
            IDiagramProfile.IDiagramMarshaller marshaller = profile.createMarshaller();
            model = marshaller.parseModel(json, preProcessingParam);
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
        UUIDBasedFileRepository.writeFile(model, this._repositoryPath + "/" + uuid + "." + ext);
        UUIDBasedFileRepository.writeFile(json, this._repositoryPath + "/" + uuid + ".json");
        if (!autosave.booleanValue()) {
            UUIDBasedFileRepository.writeFile(svg, this._repositoryPath + "/" + uuid + ".svg");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String contents, String filename) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(filename));
            writer.write(contents);
        }
        catch (IOException e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public String toXML(String json, IDiagramProfile profile, String preProcessingData) throws Exception {
        return profile.createMarshaller().parseModel(json, preProcessingData);
    }
}

