/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server;

import bpsim.impl.BpsimFactoryImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.WeakHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jbpm.designer.repository.vfs.RepositoryDescriptor;
import org.jbpm.designer.util.ConfigurationProvider;
import org.jbpm.designer.util.Utils;
import org.jbpm.designer.web.plugin.IDiagramPlugin;
import org.jbpm.designer.web.plugin.IDiagramPluginService;
import org.jbpm.designer.web.plugin.impl.PluginServiceImpl;
import org.jbpm.designer.web.preprocessing.IDiagramPreprocessingService;
import org.jbpm.designer.web.preprocessing.IDiagramPreprocessingUnit;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.designer.web.profile.impl.RepositoryInfo;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.ST;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.io.IOService;

public class EditorHandler
extends HttpServlet {
    private static final long serialVersionUID = -7439613152623067053L;
    private static final Logger logger = LoggerFactory.getLogger(EditorHandler.class);
    public static final String DESIGNER_PATH = ConfigurationProvider.getInstance().getDesignerContext();
    public static final String DEV = "designer.dev";
    public static final String USEOLDDATAASSIGNMENTS = "designer.useolddataassignments";
    public static final String SHOW_PDF_DOC = "designer.showpdfdoc";
    public static final String PRESET_PERSPECTIVE = "org.jbpm.designer.perspective";
    public static final String BPSIM_DISPLAY = "org.jbpm.designer.bpsimdisplay";
    public static final String FORMS_TYPE = "org.jbpm.designer.formstype";
    public static final String PREPROCESS = "designer.preprocess";
    public static final String SKIN = "designer.skin";
    public static final String SERVICE_REPO = "org.jbpm.service.repository";
    public static final String SERVICE_REPO_TASKS = "org.jbpm.service.servicetasknames";
    public static final String BUNDLE_VERSION = "Bundle-Version";
    public static final String STORE_SVG_ON_SAVE = "org.jbpm.designer.storesvgonsave";
    private boolean devMode;
    private boolean useOldDataAssignments;
    private boolean showPDFDoc;
    private boolean preProcess;
    private String skin;
    private String designerVersion;
    private String doc;
    private IDiagramProfile profile;
    private String serviceRepo;
    private String serviceRepoTasks;
    @Inject
    private IDiagramProfileService profileService = null;
    @Inject
    private VFSService vfsServices;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private RepositoryDescriptor descriptor;
    @Inject
    private IDiagramPreprocessingService preProcessingService;
    private IDiagramPluginService pluginservice = null;
    private List<String> envFiles = new ArrayList<String>();
    private Map<String, List<IDiagramPlugin>> pluginFiles = new HashMap<String, List<IDiagramPlugin>>();
    private Map<String, List<IDiagramPlugin>> uncompressedPlugins = new WeakHashMap<String, List<IDiagramPlugin>>();
    private ST editorTemplate;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        DroolsFactoryImpl.init();
        BpsimFactoryImpl.init();
        this.profileService.init(config.getServletContext());
        this.pluginservice = PluginServiceImpl.getInstance(config.getServletContext());
        this.preProcessingService.init(config.getServletContext(), this.vfsServices);
        this.devMode = Boolean.parseBoolean(System.getProperty(DEV) == null ? config.getInitParameter(DEV) : System.getProperty(DEV));
        this.useOldDataAssignments = Boolean.parseBoolean(System.getProperty(USEOLDDATAASSIGNMENTS) == null ? config.getInitParameter(USEOLDDATAASSIGNMENTS) : System.getProperty(USEOLDDATAASSIGNMENTS));
        this.preProcess = Boolean.parseBoolean(System.getProperty(PREPROCESS) == null ? config.getInitParameter(PREPROCESS) : System.getProperty(PREPROCESS));
        this.skin = System.getProperty(SKIN) == null ? config.getInitParameter(SKIN) : System.getProperty(SKIN);
        this.designerVersion = EditorHandler.readDesignerVersion(config.getServletContext());
        this.showPDFDoc = this.doShowPDFDoc(config);
        this.serviceRepo = System.getProperty(SERVICE_REPO) == null ? config.getInitParameter(SERVICE_REPO) : System.getProperty(SERVICE_REPO);
        this.serviceRepoTasks = System.getProperty(SERVICE_REPO_TASKS) == null ? config.getInitParameter(SERVICE_REPO_TASKS) : System.getProperty(SERVICE_REPO_TASKS);
        String editor_file = config.getServletContext().getRealPath(DESIGNER_PATH + "editor.st");
        try {
            this.doc = this.readFile(editor_file);
        }
        catch (Exception e) {
            throw new ServletException("Error while parsing editor.st", (Throwable)e);
        }
        if (this.doc == null) {
            logger.error("Invalid editor.st, could not be read as a document.");
            throw new ServletException("Invalid editor.st, could not be read as a document.");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONArray scriptsArray;
        String profileName = Utils.getDefaultProfileName(request.getParameter("profile"));
        String uuid = Utils.getUUID(request);
        String editorID = request.getParameter("editorid");
        String readOnly = request.getParameter("readonly");
        String viewLocked = request.getParameter("viewlocked");
        String sessionId = request.getParameter("sessionId");
        if (viewLocked == null || viewLocked.length() < 1) {
            viewLocked = "false";
        }
        if (this.profile == null) {
            this.profile = this.profileService.findProfile(request, profileName);
        }
        if (this.profile == null) {
            logger.error("No profile with the name " + profileName + " was registered");
            throw new IllegalArgumentException("No profile with the name " + profileName + " was registered");
        }
        IDiagramPreprocessingUnit preprocessingUnit = null;
        if (this.preProcess) {
            if (logger.isInfoEnabled()) {
                logger.info("Performing diagram information pre-processing steps. ");
            }
            preprocessingUnit = this.preProcessingService.findPreprocessingUnit(request, this.profile);
            preprocessingUnit.preprocess(request, response, this.profile, this.getServletContext(), Boolean.parseBoolean(readOnly), Boolean.parseBoolean(viewLocked), this.ioService, this.descriptor);
        }
        if (this.devMode) {
            scriptsArray = new JSONArray();
            for (String nextScript : this.envFiles) {
                scriptsArray.put((Object)(DESIGNER_PATH + nextScript));
            }
        } else {
            scriptsArray = new JSONArray();
            scriptsArray.put((Object)(DESIGNER_PATH + "jsc/env_combined.js"));
        }
        if (this.pluginFiles.get(profileName) == null) {
            ArrayList<IDiagramPlugin> compressed = new ArrayList<IDiagramPlugin>();
            Iterator<IDiagramPlugin> uncompressed = new ArrayList();
            this.pluginFiles.put(profileName, compressed);
            this.uncompressedPlugins.put(profileName, (List<IDiagramPlugin>)((Object)uncompressed));
            for (String pluginName : this.profile.getPlugins()) {
                IDiagramPlugin plugin = this.pluginservice.findPlugin(request, pluginName);
                if (plugin == null) {
                    logger.warn("Could not find the plugin " + pluginName + " requested by the profile " + this.profile.getName());
                    continue;
                }
                if (plugin.isCompressable()) {
                    compressed.add(plugin);
                    continue;
                }
                uncompressed.add(plugin);
            }
        }
        JSONArray pluginsArray = new JSONArray();
        if (this.devMode) {
            for (IDiagramPlugin jsFile : this.pluginFiles.get(profileName)) {
                pluginsArray.put((Object)("/plugin/" + jsFile.getName() + ".js"));
            }
        } else {
            pluginsArray.put((Object)(DESIGNER_PATH + "jsc/plugins_" + profileName + ".js"));
        }
        for (IDiagramPlugin uncompressed : this.uncompressedPlugins.get(profileName)) {
            pluginsArray.put((Object)(DESIGNER_PATH + "plugin/" + uncompressed.getName() + ".js"));
        }
        this.editorTemplate = new ST(this.doc, '$', '$');
        this.editorTemplate.add("bopen", (Object)"{");
        this.editorTemplate.add("bclose", (Object)"}");
        this.editorTemplate.add("editorprofile", (Object)profileName);
        this.editorTemplate.add("editoruuid", (Object)uuid);
        this.editorTemplate.add("editorid", (Object)editorID);
        this.editorTemplate.add("sessionid", (Object)sessionId);
        this.editorTemplate.add("instanceviewmode", (Object)this.getInstanceViewMode(request));
        this.editorTemplate.add("readonly", (Object)readOnly);
        this.editorTemplate.add("viewlocked", (Object)viewLocked);
        this.editorTemplate.add("allscripts", (Object)scriptsArray.toString());
        this.editorTemplate.add("allplugins", (Object)pluginsArray.toString());
        this.editorTemplate.add("title", (Object)this.profile.getTitle());
        this.editorTemplate.add("stencilset", (Object)this.profile.getStencilSet());
        this.editorTemplate.add("debug", (Object)this.devMode);
        this.editorTemplate.add("useolddataassignments", (Object)this.useOldDataAssignments);
        this.editorTemplate.add("preprocessing", (Object)(preprocessingUnit == null ? "" : preprocessingUnit.getOutData()));
        this.editorTemplate.add("externalprotocol", (Object)(RepositoryInfo.getRepositoryProtocol(this.profile) == null ? "" : RepositoryInfo.getRepositoryProtocol(this.profile)));
        this.editorTemplate.add("externalhost", (Object)RepositoryInfo.getRepositoryHost(this.profile));
        this.editorTemplate.add("externalsubdomain", (Object)(RepositoryInfo.getRepositorySubdomain(this.profile) != null ? RepositoryInfo.getRepositorySubdomain(this.profile).substring(0, RepositoryInfo.getRepositorySubdomain(this.profile).indexOf("/")) : ""));
        this.editorTemplate.add("repositoryid", (Object)"designer");
        this.editorTemplate.add("localhistoryenabled", (Object)this.profile.getLocalHistoryEnabled());
        this.editorTemplate.add("localhistorytimeout", (Object)this.profile.getLocalHistoryTimeout());
        this.editorTemplate.add("designerversion", (Object)this.designerVersion);
        this.editorTemplate.add("showpdfdoc", (Object)this.showPDFDoc);
        this.editorTemplate.add("storesvgonsave", (Object)this.getCheckedStoreSVGOnSaveOption(this.profile));
        this.editorTemplate.add("defaultSkin", (Object)(DESIGNER_PATH + "css/theme-default.css"));
        this.editorTemplate.add("presetperspective", (Object)(System.getProperty(PRESET_PERSPECTIVE) == null ? "" : System.getProperty(PRESET_PERSPECTIVE)));
        this.editorTemplate.add("bpsimdisplay", (Object)this.profile.getBpsimDisplay());
        this.editorTemplate.add("formstype", (Object)this.profile.getFormsType());
        String overlaySkin = "";
        if (this.skin != null && !this.skin.equals("default")) {
            overlaySkin = DESIGNER_PATH + "css/theme-" + this.skin + ".css";
        }
        this.editorTemplate.add("overlaySkin", (Object)overlaySkin);
        StringBuilder plugins = new StringBuilder();
        boolean commaNeeded = false;
        for (String ext : this.profile.getPlugins()) {
            if (commaNeeded) {
                plugins.append(",");
            } else {
                commaNeeded = true;
            }
            plugins.append("\"").append(ext).append("\"");
        }
        this.editorTemplate.add("profileplugins", (Object)plugins.toString());
        StringBuilder ssexts = new StringBuilder();
        commaNeeded = false;
        for (String ext : this.profile.getStencilSetExtensions()) {
            if (commaNeeded) {
                ssexts.append(",");
            } else {
                commaNeeded = true;
            }
            ssexts.append("\"").append(ext).append("\"");
        }
        this.editorTemplate.add("ssextensions", (Object)ssexts.toString());
        this.editorTemplate.add("contextroot", (Object)request.getContextPath());
        this.editorTemplate.add("servicerepo", (Object)(this.serviceRepo == null ? "" : this.serviceRepo));
        this.editorTemplate.add("servicerepotasks", this.serviceRepoTasks == null ? "" : Arrays.asList(this.serviceRepoTasks.split(",")));
        response.setContentType("text/javascript; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(this.editorTemplate.render());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readDesignerVersion(ServletContext context) {
        String retStr = "";
        BufferedReader br = null;
        try {
            String line;
            InputStream inputStream = context.getResourceAsStream("/META-INF/MANIFEST.MF");
            br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((line = br.readLine()) != null) {
                if (!line.startsWith(BUNDLE_VERSION)) continue;
                retStr = line.substring(BUNDLE_VERSION.length() + 1);
                retStr = retStr.trim();
            }
            inputStream.close();
            if (br == null) return retStr;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return retStr;
        }
        finally {
            if (br != null) {
                IOUtils.closeQuietly(br);
            }
        }
        IOUtils.closeQuietly((Reader)br);
        return retStr;
    }

    public String getInstanceViewMode(HttpServletRequest request) {
        String instanceViewMode = request.getParameter("instanceviewmode");
        return instanceViewMode != null && instanceViewMode.equals("true") ? "true" : "false";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String pathname) throws IOException {
        StringBuilder fileContents = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        try (Scanner scanner = new Scanner(new File(pathname), "UTF-8");){
            while (scanner.hasNextLine()) {
                fileContents.append(scanner.nextLine() + lineSeparator);
            }
            String string = fileContents.toString();
            return string;
        }
    }

    public boolean doShowPDFDoc(ServletConfig config) {
        return Boolean.parseBoolean(System.getProperty(SHOW_PDF_DOC) == null ? config.getInitParameter(SHOW_PDF_DOC) : System.getProperty(SHOW_PDF_DOC));
    }

    public void setProfile(IDiagramProfile profile) {
        this.profile = profile;
    }

    public IDiagramProfile getProfile() {
        return this.profile;
    }

    public ST getEditorTemplate() {
        return this.editorTemplate;
    }

    private String getCheckedStoreSVGOnSaveOption(IDiagramProfile profile) {
        String sysPropOption = System.getProperty(STORE_SVG_ON_SAVE);
        if (sysPropOption != null && ("true".equalsIgnoreCase(sysPropOption) || "false".equalsIgnoreCase(sysPropOption))) {
            return String.valueOf(Boolean.parseBoolean(sysPropOption));
        }
        return profile.getStoreSVGonSaveOption();
    }
}

