/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.enterprise.context.ApplicationScoped;
import org.apache.lucene.search.Query;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.AbstractFindQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueBranchNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueProjectNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringStringPageRow;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.paging.PageResponse;

@ApplicationScoped
public class DesignerFindDataTypesQuery
extends AbstractFindQuery
implements NamedQuery {
    private DataTypesResponseBuilder responseBuilder = new DataTypesResponseBuilder();
    public static final String NAME = DesignerFindDataTypesQuery.class.getSimpleName();

    public String getName() {
        return NAME;
    }

    public Query toQuery(Set<ValueIndexTerm> terms) {
        ValueIndexTerm term = terms.iterator().next();
        return this.buildFromSingleTerm(term);
    }

    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }

    public void validateTerms(Set<ValueIndexTerm> queryTerms) throws IllegalArgumentException {
        this.checkNotNullAndNotEmpty(queryTerms);
        this.checkInvalidAndRequiredTerms(queryTerms, NAME, new String[]{ResourceType.JAVA.toString(), null, null}, new Predicate[]{t -> t.getTerm().equals(ResourceType.JAVA.toString()), t -> t instanceof ValueProjectNameIndexTerm, t -> t instanceof ValueBranchNameIndexTerm});
    }

    private static class DataTypesResponseBuilder
    implements ResponseBuilder {
        private DataTypesResponseBuilder() {
        }

        public PageResponse<RefactoringPageRow> buildResponse(int pageSize, int startRow, List<KObject> kObjects) {
            int hits = kObjects.size();
            PageResponse response = new PageResponse();
            List<RefactoringPageRow> result = this.buildResponse(kObjects);
            response.setTotalRowSize(hits);
            response.setPageRowList(result);
            response.setTotalRowSizeExact(true);
            response.setStartRowIndex(startRow);
            response.setLastPage(pageSize * startRow + 2 >= hits);
            return response;
        }

        public List<RefactoringPageRow> buildResponse(List<KObject> kObjects) {
            ArrayList<RefactoringPageRow> result = new ArrayList<RefactoringPageRow>(kObjects.size());
            HashSet<String> uniqueDataTypeNames = new HashSet<String>();
            for (KObject kObject : kObjects) {
                Set<String> dataTypeNames = this.getDataTypeNamesFromKObject(kObject);
                uniqueDataTypeNames.addAll(dataTypeNames);
            }
            for (String dataTypeName : uniqueDataTypeNames) {
                RefactoringStringPageRow row = new RefactoringStringPageRow();
                row.setValue((Object)dataTypeName);
                result.add((RefactoringPageRow)row);
            }
            return result;
        }

        private Set<String> getDataTypeNamesFromKObject(KObject kObject) {
            HashSet<String> dataTypeNames = new HashSet<String>();
            if (kObject == null) {
                return dataTypeNames;
            }
            for (KProperty property : kObject.getProperties()) {
                if (!property.getName().equals(ResourceType.JAVA.toString())) continue;
                dataTypeNames.add(property.getValue().toString());
            }
            return dataTypeNames;
        }
    }
}

