/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server.indexing;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.core.io.impl.ByteArrayResource;
import org.drools.core.io.impl.ReaderResource;
import org.drools.core.xml.SemanticModule;
import org.drools.core.xml.SemanticModules;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNExtensionsSemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.designer.server.indexing.bpmn2.DesignerProcessDataEventListener;
import org.jbpm.designer.type.Bpmn2TypeDefinition;
import org.jbpm.process.core.validation.ProcessValidationError;
import org.jbpm.process.core.validation.ProcessValidator;
import org.jbpm.process.core.validation.ProcessValidatorRegistry;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.workbench.common.services.backend.project.ProjectClassLoaderHelper;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.AbstractFileIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class BPMN2FileIndexer
extends AbstractFileIndexer {
    private static final Logger logger = LoggerFactory.getLogger(BPMN2FileIndexer.class);
    private static final SemanticModules modules = new SemanticModules();
    @Inject
    protected Bpmn2TypeDefinition bpmn2TypeDefinition;
    @Inject
    protected ProjectClassLoaderHelper classLoaderHelper;

    public boolean supportsPath(Path path) {
        return this.bpmn2TypeDefinition.accept(Paths.convert((Path)path));
    }

    protected DefaultIndexBuilder fillIndexBuilder(Path path) throws Exception {
        KieProject project = (KieProject)this.projectService.resolveProject(Paths.convert((Path)path));
        if (project == null) {
            logger.error("Unable to index " + path.toUri().toString() + ": project could not be resolved.");
            return null;
        }
        DefaultIndexBuilder builder = this.getIndexBuilder(path, (Project)project);
        String bpmnStr = this.ioService.readAllString(path);
        ClassLoader projectClassLoader = this.getProjectClassLoader(project);
        try {
            List<DesignerProcessDataEventListener> procesDataList = this.buildProcessDefinition(bpmnStr, path, projectClassLoader);
            if (procesDataList != null) {
                for (DesignerProcessDataEventListener processData : procesDataList) {
                    this.addReferencedResourcesToIndexBuilder(builder, processData);
                    builder.setPackageName(processData.getProcess().getPackageName());
                }
            }
        }
        catch (Exception e) {
            logger.info("Indexing hampered because BPMN2 compilation failed [" + path.toString() + "]: " + e.getMessage());
        }
        XmlProcessReader processReader = new XmlProcessReader(modules, projectClassLoader);
        List processes = Collections.emptyList();
        try {
            processes = processReader.read((Reader)new StringReader(bpmnStr));
        }
        catch (Exception e) {
            logger.info("Unable to index because BPMN2 parsing failed [" + path.toString() + "]: " + e.getMessage());
        }
        if (processes != null) {
            for (Process process : processes) {
                ReaderResource resource = new ReaderResource((Reader)new StringReader(bpmnStr));
                ProcessValidator validator = ProcessValidatorRegistry.getInstance().getValidator(process, (Resource)resource);
                ProcessValidationError[] errors = validator.validateProcess(process);
                if (errors.length > 0) {
                    logger.error("Trying to finish indexing process '" + process.getId() + "/" + process.getName() + "' despite " + errors.length + " validation errors.");
                }
                processReader.getProcessBuildData().onBuildComplete(process);
                DesignerProcessDataEventListener helper = (DesignerProcessDataEventListener)process.getMetaData().get("ProcessInfoCollector");
                this.addReferencedResourcesToIndexBuilder(builder, helper);
            }
        } else {
            logger.warn("No process was found in file: " + path.toUri());
        }
        return builder;
    }

    protected ClassLoader getProjectClassLoader(KieProject project) {
        return this.classLoaderHelper.getProjectClassLoader(project);
    }

    private List<DesignerProcessDataEventListener> buildProcessDefinition(String bpmn2Content, Path path, ClassLoader projectClassLoader) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)bpmn2Content)) {
            return null;
        }
        KnowledgeBuilder kbuilder = null;
        if (projectClassLoader != null) {
            KnowledgeBuilderConfigurationImpl pconf = new KnowledgeBuilderConfigurationImpl(new ClassLoader[]{projectClassLoader});
            kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)pconf);
        } else {
            kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        }
        kbuilder.add((Resource)new ByteArrayResource(bpmn2Content.getBytes()), ResourceType.BPMN2);
        if (kbuilder.hasErrors()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                logger.error("Error: {}", (Object)error.getMessage());
            }
            logger.debug("Process Cannot be Parsed! \n {} \n", (Object)bpmn2Content);
            return null;
        }
        ArrayList<DesignerProcessDataEventListener> processDataList = new ArrayList<DesignerProcessDataEventListener>();
        kbuilder.getKnowledgePackages().forEach(pkg -> pkg.getProcesses().forEach(p -> {
            DesignerProcessDataEventListener processData = (DesignerProcessDataEventListener)p.getMetaData().get("ProcessInfoCollector");
            processDataList.add(processData);
        }));
        return processDataList;
    }

    protected DefaultIndexBuilder getIndexBuilder(Path path, Project project) {
        Package pkg = this.projectService.resolvePackage(Paths.convert((Path)path));
        if (pkg == null) {
            logger.error("Unable to index " + path.toUri().toString() + ": package could not be resolved.");
            return null;
        }
        return new DefaultIndexBuilder(project, pkg);
    }

    static {
        modules.addSemanticModule((SemanticModule)new BPMNSemanticModule());
        modules.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        modules.addSemanticModule((SemanticModule)new BPMNExtensionsSemanticModule());
    }
}

