/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server.indexing.bpmn2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.bpmn2.core.ItemDefinition;
import org.jbpm.compiler.xml.ProcessDataEventListener;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.kie.api.definition.process.Process;
import org.kie.workbench.common.services.refactoring.backend.server.impact.ResourceReferenceCollector;
import org.kie.workbench.common.services.refactoring.model.index.Resource;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesignerProcessDataEventListener
extends ResourceReferenceCollector
implements ProcessDataEventListener,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DesignerProcessDataEventListener.class);
    public static final String NAME = "ProcessInfoCollector";
    private List<Variable> variables = null;
    private Set<String> signals = new HashSet<String>();
    private Set<String> messages = new HashSet<String>();
    private Map<String, ItemDefinition> itemDefinitions = new HashMap<String, ItemDefinition>();
    private Process process;
    private Set<String> referencedClasses;
    private Set<String> unqualifiedClasses;
    private transient Resource resource;

    public Process getProcess() {
        return this.process;
    }

    public void onNodeAdded(Node node) {
        if (node instanceof RuleSetNode) {
            RuleSetNode ruleSetNode = (RuleSetNode)node;
            String ruleFlowGroup = ruleSetNode.getRuleFlowGroup();
            if (ruleFlowGroup != null) {
                this.addSharedReference(ruleFlowGroup, PartType.RULEFLOW_GROUP);
            }
        } else if (node instanceof WorkItemNode) {
            String taskName = ((WorkItemNode)node).getWork().getName();
            this.addSharedReference(taskName, PartType.TASK_NAME);
        } else if (node instanceof SubProcessNode) {
            String processId;
            SubProcessNode subProcess = (SubProcessNode)node;
            String processName = subProcess.getProcessName();
            if (!StringUtils.isEmpty((CharSequence)processName)) {
                this.addResourceReference(processName, ResourceType.BPMN2_NAME);
            }
            if (!StringUtils.isEmpty((CharSequence)(processId = subProcess.getProcessId()))) {
                this.addResourceReference(processId, ResourceType.BPMN2);
            }
        }
    }

    public void onProcessAdded(Process process) {
        logger.debug("Added process with id {} and name {}", (Object)process.getId(), (Object)process.getName());
        this.process = process;
        this.resource = this.addResource(process.getId(), ResourceType.BPMN2);
        this.addResource(process.getName(), ResourceType.BPMN2_NAME);
        process.getMetaData().put(NAME, this);
    }

    public void onMetaDataAdded(String name, Object data) {
        if (name.equals("Variable")) {
            if (this.variables == null) {
                this.variables = new ArrayList<Variable>();
            }
            this.variables.add((Variable)data);
        } else if ("ItemDefinitions".equals(name)) {
            this.itemDefinitions = (Map)data;
        } else if ("signalNames".equals(name)) {
            this.signals = (Set)data;
        } else if ("Messages".equals(name)) {
            Map builderMessagesMap = (Map)data;
            this.messages = builderMessagesMap.keySet();
        }
    }

    public void onComplete(Process process) {
        if (this.itemDefinitions != null) {
            for (ItemDefinition item : this.itemDefinitions.values()) {
                String structureRef = item.getStructureRef();
                if (structureRef.contains(".")) {
                    this.getReferencedClasses().add(structureRef);
                    continue;
                }
                this.getUnqualifiedClasses().add(structureRef);
            }
        }
        Map globals = ((RuleFlowProcess)process).getGlobals();
        this.visitGlobals(globals);
        Set imports = ((RuleFlowProcess)process).getImports();
        if (imports != null) {
            for (String type : imports) {
                if (type.contains(".")) {
                    this.getReferencedClasses().add(type);
                    continue;
                }
                this.getUnqualifiedClasses().add(type);
            }
        }
    }

    private void visitGlobals(Map<String, String> globals) {
        if (globals != null) {
            HashSet<String> globalNames = new HashSet<String>();
            for (Map.Entry<String, String> globalEntry : globals.entrySet()) {
                globalNames.add(globalEntry.getKey());
                String type = globalEntry.getValue();
                if (type.contains(".")) {
                    this.getReferencedClasses().add(type);
                    continue;
                }
                this.getUnqualifiedClasses().add(type);
            }
            for (String globalName : globalNames) {
                this.addSharedReference(globalName, PartType.GLOBAL);
            }
        }
    }

    public void onBuildComplete(Process process) {
        Set unqualifiedClasses;
        Set referencedTypes = (Set)process.getMetaData().get("JavaDialectReferencedTypes");
        if (referencedTypes != null && !referencedTypes.isEmpty()) {
            this.getReferencedClasses().addAll(referencedTypes);
        }
        if ((unqualifiedClasses = (Set)process.getMetaData().get("JavaDialectUnqualifiedTypes")) != null && !unqualifiedClasses.isEmpty()) {
            this.getUnqualifiedClasses().addAll(unqualifiedClasses);
        }
        if ((referencedTypes = (Set)process.getMetaData().get("JavaReturnValueReferencedTypes")) != null && !referencedTypes.isEmpty()) {
            this.getReferencedClasses().addAll(referencedTypes);
        }
        if ((unqualifiedClasses = (Set)process.getMetaData().get("JavaReturnValueUnqualifiedTypes")) != null && !unqualifiedClasses.isEmpty()) {
            this.getUnqualifiedClasses().addAll(unqualifiedClasses);
        }
        if ((referencedTypes = (Set)process.getMetaData().get("MVELDialectReferencedTypes")) != null && !referencedTypes.isEmpty()) {
            this.getReferencedClasses().addAll(referencedTypes);
        }
        if ((referencedTypes = (Set)process.getMetaData().get("MVELReturnValueReferencedTypes")) != null && !referencedTypes.isEmpty()) {
            this.getReferencedClasses().addAll(referencedTypes);
        }
        this.resolveUnqualifiedClasses();
        if (this.variables != null) {
            for (Variable data : this.variables) {
                String type = data.getType().getStringType();
                String itemSubjectRef = (String)data.getMetaData("ItemSubjectRef");
                if (itemSubjectRef != null && this.itemDefinitions != null) {
                    ItemDefinition itemDef = this.itemDefinitions.get(itemSubjectRef);
                    type = itemDef.getStructureRef();
                }
                this.resource.addPart(data.getName(), PartType.VARIABLE);
                if (type.contains(".")) {
                    this.getReferencedClasses().add(type);
                    continue;
                }
                this.getUnqualifiedClasses().add(type);
            }
        }
        this.visitSignals(this.signals);
        this.visitSignals(this.messages);
        this.visitFunctionImports(((RuleFlowProcess)process).getFunctionImports());
    }

    private void visitFunctionImports(List<String> functionImports) {
        if (functionImports != null) {
            for (String functionImport : functionImports) {
                if (functionImport.endsWith("*")) continue;
                this.addResourceReference(functionImport, ResourceType.FUNCTION);
            }
        }
    }

    private void visitSignals(Collection<String> signals) {
        if (signals != null) {
            for (String signal : signals) {
                this.addSharedReference(signal, PartType.SIGNAL);
            }
        }
    }

    private void resolveUnqualifiedClasses() {
        HashSet<String> qualifiedClassSimpleNames = new HashSet<String>();
        for (String className : this.getReferencedClasses()) {
            qualifiedClassSimpleNames.add(className.substring(className.lastIndexOf(46) + 1));
        }
        Iterator<String> iter = this.getUnqualifiedClasses().iterator();
        while (iter.hasNext()) {
            if (!qualifiedClassSimpleNames.contains(iter.next())) continue;
            iter.remove();
        }
        iter = this.getUnqualifiedClasses().iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            if (!"Object".equals(name) && !"String".equals(name) && !"Float".equals(name) && !"Integer".equals(name) && !"Boolean".equals(name)) continue;
            this.getReferencedClasses().add("java.lang." + name);
            iter.remove();
        }
        for (String className : this.getUnqualifiedClasses()) {
            logger.warn("Unable to resolve unqualified class name, adding to list of classes: '{}'", (Object)className);
            this.getReferencedClasses().add(className);
        }
    }

    private Set<String> getReferencedClasses() {
        if (this.referencedClasses == null) {
            this.referencedClasses = new HashSet<String>(4);
        }
        return this.referencedClasses;
    }

    private Set<String> getUnqualifiedClasses() {
        if (this.unqualifiedClasses == null) {
            this.unqualifiedClasses = new HashSet<String>(4);
        }
        return this.unqualifiedClasses;
    }
}

