/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.bpmn2.impl;

import bpsim.BPSimDataType;
import bpsim.BpsimFactory;
import bpsim.BpsimPackage;
import bpsim.ControlParameters;
import bpsim.CostParameters;
import bpsim.ElementParameters;
import bpsim.FloatingParameterType;
import bpsim.NormalDistributionType;
import bpsim.Parameter;
import bpsim.PoissonDistributionType;
import bpsim.PriorityParameters;
import bpsim.ResourceParameters;
import bpsim.Scenario;
import bpsim.ScenarioParameters;
import bpsim.TimeParameters;
import bpsim.TimeUnit;
import bpsim.UniformDistributionType;
import bpsim.impl.BpsimPackageImpl;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.AdHocOrdering;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.Artifact;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.Auditing;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.BusinessRuleTask;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.Category;
import org.eclipse.bpmn2.CategoryValue;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.DataStore;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Documentation;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.Error;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.Escalation;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.EventSubprocess;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.GatewayDirection;
import org.eclipse.bpmn2.GlobalTask;
import org.eclipse.bpmn2.Group;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.Interface;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.LoopCharacteristics;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.Monitoring;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.OutputSet;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.ProcessType;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.Relationship;
import org.eclipse.bpmn2.ResourceAssignmentExpression;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.ScriptTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.ServiceTask;
import org.eclipse.bpmn2.Signal;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.TextAnnotation;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.eclipse.bpmn2.UserTask;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.BpmnDiFactory;
import org.eclipse.bpmn2.util.Bpmn2Resource;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.DcFactory;
import org.eclipse.dd.dc.Point;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EAttributeImpl;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.DroolsFactory;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.GlobalType;
import org.jboss.drools.ImportType;
import org.jboss.drools.MetaDataType;
import org.jboss.drools.OnEntryScriptType;
import org.jboss.drools.OnExitScriptType;
import org.jboss.drools.impl.DroolsPackageImpl;
import org.jbpm.designer.bpmn2.BpmnMarshallerHelper;
import org.jbpm.designer.bpmn2.impl.Bpmn20Stencil;
import org.jbpm.designer.bpmn2.resource.JBPMBpmn2ResourceFactoryImpl;
import org.jbpm.designer.bpmn2.util.DIZorderComparator;
import org.jbpm.designer.util.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bpmn2JsonUnmarshaller {
    public static final String defaultBgColor = "#fafad2";
    public static final String defaultBrColor = "#000000";
    public static final String defaultFontColor = "#000000";
    public static final String defaultSequenceflowColor = "#000000";
    public static final String defaultRelationshipType = "BPSimData";
    public static final String DEFAULT_USERTASK_NAME_PREFIX = "Task_";
    private int LastUserTaskID = 0;
    private Map<Object, String> _objMap = new HashMap<Object, String>();
    private Map<String, Object> _idMap = new HashMap<String, Object>();
    private Map<Object, List<String>> _outgoingFlows = new HashMap<Object, List<String>>();
    private Set<String> _sequenceFlowTargets = new HashSet<String>();
    private Map<String, Bounds> _bounds = new HashMap<String, Bounds>();
    private Map<String, List<Point>> _dockers = new HashMap<String, List<Point>>();
    private List<Lane> _lanes = new ArrayList<Lane>();
    private List<Artifact> _artifacts = new ArrayList<Artifact>();
    private Map<String, ItemDefinition> _subprocessItemDefs = new HashMap<String, ItemDefinition>();
    private List<Import> _wsdlImports = new ArrayList<Import>();
    private Map<String, List<String>> _elementColors = new HashMap<String, List<String>>();
    private List<BpmnMarshallerHelper> _helpers;
    private String processDocs;
    private Bpmn2Resource _currentResource;
    private Map<String, Escalation> _escalations = new HashMap<String, Escalation>();
    private Map<String, Error> _errors = new HashMap<String, Error>();
    private Map<String, Message> _messages = new HashMap<String, Message>();
    private Map<String, ItemDefinition> _itemDefinitions = new HashMap<String, ItemDefinition>();
    private Map<String, List<EObject>> _simulationElementParameters = new HashMap<String, List<EObject>>();
    private ScenarioParameters _simulationScenarioParameters = BpsimFactory.eINSTANCE.createScenarioParameters();
    private boolean zOrderEnabled;
    private static final Logger _logger = LoggerFactory.getLogger(Bpmn2JsonUnmarshaller.class);

    public Bpmn2JsonUnmarshaller() {
        this._helpers = new ArrayList<BpmnMarshallerHelper>();
        DroolsPackageImpl.init();
        BpsimPackageImpl.init();
        if (this.getClass().getClassLoader() instanceof BundleReference) {
            BundleContext context = ((BundleReference)this.getClass().getClassLoader()).getBundle().getBundleContext();
            try {
                ServiceReference[] refs;
                for (ServiceReference ref : refs = context.getAllServiceReferences(BpmnMarshallerHelper.class.getName(), null)) {
                    BpmnMarshallerHelper helper = (BpmnMarshallerHelper)context.getService(ref);
                    this._helpers.add(helper);
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
    }

    public Bpmn2Resource unmarshall(String json, String preProcessingData) throws JsonParseException, IOException {
        return this.unmarshall(new JsonFactory().createJsonParser(json), preProcessingData);
    }

    public Bpmn2Resource unmarshall(File file, String preProcessingData) throws JsonParseException, IOException {
        return this.unmarshall(new JsonFactory().createJsonParser(file), preProcessingData);
    }

    public void setZOrderEnabled(boolean zOrderEnabled) {
        this.zOrderEnabled = zOrderEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bpmn2Resource unmarshall(JsonParser parser, String preProcessingData) throws JsonParseException, IOException {
        try {
            parser.nextToken();
            ResourceSetImpl rSet = new ResourceSetImpl();
            rSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("bpmn2", new JBPMBpmn2ResourceFactoryImpl());
            Bpmn2Resource bpmn2 = (Bpmn2Resource)rSet.createResource(URI.createURI((String)"virtual.bpmn2"));
            rSet.getResources().add((Object)bpmn2);
            this._currentResource = bpmn2;
            if (preProcessingData == null || preProcessingData.length() < 1) {
                preProcessingData = "ReadOnlyService";
            }
            Definitions def = (Definitions)this.unmarshallItem(parser, preProcessingData);
            def.setExporter("jBPM Designer");
            def.setExporterVersion("6.2.0");
            this.revisitUserTasks(def);
            this.revisitServiceTasks(def);
            this.revisitMessages(def);
            this.revisitCatchEvents(def);
            this.revisitThrowEvents(def);
            this.revisitLanes(def);
            this.revisitSubProcessItemDefs(def);
            this.revisitArtifacts(def);
            this.revisitGroups(def);
            this.revisitTaskAssociations(def);
            this.revisitSendReceiveTasks(def);
            this.reconnectFlows();
            this.revisitGateways(def);
            this.revisitCatchEventsConvertToBoundary(def);
            this.revisitBoundaryEventsPositions(def);
            this.createDiagram(def);
            this.updateIDs(def);
            this.revisitDataObjects(def);
            this.revisitAssociationsIoSpec(def);
            this.revisitWsdlImports(def);
            this.revisitMultiInstanceTasks(def);
            this.addSimulation(def);
            this.revisitItemDefinitions(def);
            this.revisitProcessDoc(def);
            this.revisitDI(def);
            this.revisitSignalRef(def);
            this.orderDiagramElements(def);
            this._currentResource.getContents().add((Object)def);
            Bpmn2Resource bpmn2Resource = this._currentResource;
            return bpmn2Resource;
        }
        catch (Exception e) {
            _logger.error(e.getMessage());
            Bpmn2Resource bpmn2Resource = this._currentResource;
            return bpmn2Resource;
        }
        finally {
            parser.close();
            this._objMap.clear();
            this._idMap.clear();
            this._outgoingFlows.clear();
            this._sequenceFlowTargets.clear();
            this._bounds.clear();
            this._currentResource = null;
        }
    }

    private void orderDiagramElements(Definitions def) {
        if (this.zOrderEnabled && def.getDiagrams() != null) {
            for (BPMNDiagram diagram : def.getDiagrams()) {
                if (diagram == null) continue;
                _logger.info("Sorting diagram elements using DIZorderComparator");
                BPMNPlane plane = diagram.getPlane();
                ArrayList unsortedElements = new ArrayList(plane.getPlaneElement());
                plane.getPlaneElement().clear();
                Collections.sort(unsortedElements, new DIZorderComparator());
                plane.getPlaneElement().addAll(unsortedElements);
                diagram.setPlane(plane);
            }
        }
    }

    public void revisitUserTasks(Definitions def) {
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            this.setUserTaskInfo((FlowElementsContainer)((Process)root));
        }
    }

    private void setUserTaskInfo(FlowElementsContainer container) {
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            UserTask task;
            String name;
            if (fe instanceof UserTask && ((name = (task = (UserTask)fe).getName()) == null || name.length() == 0)) {
                ++this.LastUserTaskID;
                String newName = DEFAULT_USERTASK_NAME_PREFIX + this.LastUserTaskID;
                task.setName(newName);
                if (task.getExtensionValues() != null && task.getExtensionValues().size() > 0) {
                    for (ExtensionAttributeValue extattrval : task.getExtensionValues()) {
                        FeatureMap extensionElements = extattrval.getValue();
                        List metadataExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true);
                        for (MetaDataType eleMetadata : metadataExtensions) {
                            if (eleMetadata.getName() == null || !eleMetadata.getName().equals("elementname")) continue;
                            eleMetadata.setMetaValue(this.wrapInCDATABlock(newName));
                        }
                    }
                }
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setUserTaskInfo((FlowElementsContainer)fe);
        }
    }

    public void revisitItemDefinitions(Definitions def) {
        ArrayList<String> itemIds = new ArrayList<String>();
        for (RootElement root : def.getRootElements()) {
            if (!(root instanceof ItemDefinition)) continue;
            if (!itemIds.contains(root.getId())) {
                itemIds.add(root.getId());
                continue;
            }
            ItemDefinition idef = (ItemDefinition)root;
            Random rand = new Random();
            int randomNum = rand.nextInt(991) + 10;
            idef.setId(idef.getId() + randomNum);
        }
    }

    protected Map<Object, List<String>> getOutgoingFlowsMap() {
        return this._outgoingFlows;
    }

    public void revisitDI(Definitions def) {
        this.revisitDIColors(def);
        BPMNPlane plane = ((BPMNDiagram)def.getDiagrams().get(0)).getPlane();
        List diagramElements = plane.getPlaneElement();
        for (DiagramElement dia : diagramElements) {
            if (!(dia instanceof BPMNShape)) continue;
            BPMNShape shape = (BPMNShape)dia;
            this.updateShapeBounds(def, plane, shape.getBpmnElement());
        }
        this.revisitEdgeBoundsInLanes(def);
        this.revisitEdgeBoundsInContainers(def);
    }

    public BPMNShape getBPMNShapeForElement(BaseElement be, BPMNPlane plane) {
        List diagramElements = plane.getPlaneElement();
        for (DiagramElement dia : diagramElements) {
            BPMNShape shape;
            if (!(dia instanceof BPMNShape) || !(shape = (BPMNShape)dia).getBpmnElement().getId().equals(be.getId())) continue;
            return shape;
        }
        return null;
    }

    public void revisitEdgeBoundsInContainers(Definitions def) {
        BPMNPlane plane = ((BPMNDiagram)def.getDiagrams().get(0)).getPlane();
        List diagramElements = plane.getPlaneElement();
        for (DiagramElement dia : diagramElements) {
            BPMNEdge edge;
            if (!(dia instanceof BPMNEdge) || !((edge = (BPMNEdge)dia).getBpmnElement() instanceof SequenceFlow)) continue;
            SequenceFlow sq = (SequenceFlow)edge.getBpmnElement();
            List rootElements = def.getRootElements();
            for (RootElement root : rootElements) {
                if (!(root instanceof Process)) continue;
                Process process = (Process)root;
                this.updateEdgeBoundsInContainers((FlowElementsContainer)process, sq, plane, edge);
            }
            if (sq.getSourceRef() != null) {
                edge.setSourceElement((DiagramElement)this.getBPMNShapeForElement((BaseElement)sq.getSourceRef(), plane));
            }
            if (sq.getTargetRef() == null) continue;
            edge.setTargetElement((DiagramElement)this.getBPMNShapeForElement((BaseElement)sq.getTargetRef(), plane));
        }
    }

    public void updateEdgeBoundsInContainers(FlowElementsContainer container, SequenceFlow sq, BPMNPlane plane, BPMNEdge edge) {
        for (FlowElement fele : container.getFlowElements()) {
            if (!(container instanceof Process)) {
                List edgePoints;
                if (fele.getId().equals(sq.getSourceRef().getId())) {
                    Bounds sourceBounds = this.getBoundsForElement((BaseElement)sq.getSourceRef(), plane);
                    edgePoints = edge.getWaypoint();
                    if (edgePoints != null && edgePoints.size() > 1 && sourceBounds != null) {
                        Point first = (Point)edgePoints.get(0);
                        first.setX(first.getX() + this.getBoundsForElement((BaseElement)container, plane).getX() + sourceBounds.getWidth() / 2.0f);
                        first.setY(first.getY() + this.getBoundsForElement((BaseElement)container, plane).getY());
                    }
                } else if (fele.getId().equals(sq.getTargetRef().getId())) {
                    Bounds targetBounds = this.getBoundsForElement((BaseElement)sq.getTargetRef(), plane);
                    edgePoints = edge.getWaypoint();
                    if (edgePoints != null && edgePoints.size() > 1 && targetBounds != null) {
                        Point last = (Point)edgePoints.get(edgePoints.size() - 1);
                        last.setX(last.getX() + this.getBoundsForElement((BaseElement)container, plane).getX() - targetBounds.getWidth() / 2.0f);
                        last.setY(last.getY() + this.getBoundsForElement((BaseElement)container, plane).getY());
                    }
                }
            }
            if (!(fele instanceof FlowElementsContainer)) continue;
            this.updateEdgeBoundsInContainers((FlowElementsContainer)fele, sq, plane, edge);
        }
    }

    public void revisitEdgeBoundsInLanes(Definitions def) {
        BPMNPlane plane = ((BPMNDiagram)def.getDiagrams().get(0)).getPlane();
        List diagramElements = plane.getPlaneElement();
        for (DiagramElement dia : diagramElements) {
            if (!(dia instanceof BPMNEdge)) continue;
            BPMNEdge edge = (BPMNEdge)dia;
            this.updateEdgeBoundsInLanes(def, plane, edge, edge.getBpmnElement());
        }
    }

    public void revisitDIColors(Definitions def) {
        BPMNPlane plane = ((BPMNDiagram)def.getDiagrams().get(0)).getPlane();
        List diagramElements = plane.getPlaneElement();
        for (DiagramElement dia : diagramElements) {
            if (dia instanceof BPMNShape) {
                BPMNShape shape = (BPMNShape)dia;
                this.updateShapeColors(shape);
            }
            if (!(dia instanceof BPMNEdge)) continue;
            BPMNEdge edge = (BPMNEdge)dia;
            this.updateEdgeColors(edge);
        }
    }

    public void revisitProcessDoc(Definitions def) {
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            if (this.processDocs == null || this.processDocs.length() <= 0) continue;
            process.getDocumentation().add(this.createDocumentation(this.wrapInCDATABlock(this.processDocs)));
        }
    }

    public void updateShapeColors(BPMNShape shape) {
        List<String> eleColorsForShape = this._elementColors.get(shape.getBpmnElement().getId());
        if (eleColorsForShape != null) {
            String backgroundColor = "";
            String borderColor = "";
            String fontColor = "";
            for (String shapeColor : eleColorsForShape) {
                String[] shapeColorParts = shapeColor.split(":");
                if (shapeColorParts[0].equals("bgcolor")) {
                    backgroundColor = shapeColorParts[1];
                }
                if (shapeColorParts[0].equals("bordercolor")) {
                    borderColor = shapeColorParts[1];
                }
                if (!shapeColorParts[0].equals("fontcolor")) continue;
                fontColor = shapeColorParts[1];
            }
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl extensionAttributeBgColor = (EAttributeImpl)metadata.demandFeature("http://www.omg.org/spec/BPMN/non-normative/color", "background-color", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntryBgColor = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttributeBgColor, (Object)backgroundColor);
            shape.getBpmnElement().getAnyAttribute().add((Object)extensionEntryBgColor);
            EAttributeImpl extensionAttributeBorderColor = (EAttributeImpl)metadata.demandFeature("http://www.omg.org/spec/BPMN/non-normative/color", "border-color", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntryBorderColor = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttributeBorderColor, (Object)borderColor);
            shape.getBpmnElement().getAnyAttribute().add((Object)extensionEntryBorderColor);
            EAttributeImpl extensionAttributeColor = (EAttributeImpl)metadata.demandFeature("http://www.omg.org/spec/BPMN/non-normative/color", "color", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntryColor = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttributeColor, (Object)fontColor);
            shape.getBpmnElement().getAnyAttribute().add((Object)extensionEntryColor);
        } else {
            _logger.warn("Unable to find color information for shape: " + shape.getBpmnElement().getId());
        }
    }

    public void updateEdgeColors(BPMNEdge edge) {
        List<String> eleColorsForEdge = this._elementColors.get(edge.getBpmnElement().getId());
        if (eleColorsForEdge != null) {
            String backgroundColor = "";
            String borderColor = "";
            String fontColor = "";
            for (String edgeColor : eleColorsForEdge) {
                String[] shapeColorParts = edgeColor.split(":");
                if (shapeColorParts[0].equals("bgcolor")) {
                    backgroundColor = shapeColorParts[1];
                }
                if (shapeColorParts[0].equals("bordercolor")) {
                    borderColor = shapeColorParts[1];
                }
                if (!shapeColorParts[0].equals("fontcolor")) continue;
                fontColor = shapeColorParts[1];
            }
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl extensionAttributeBgColor = (EAttributeImpl)metadata.demandFeature("http://www.omg.org/spec/BPMN/non-normative/color", "background-color", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntryBgColor = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttributeBgColor, (Object)backgroundColor);
            edge.getBpmnElement().getAnyAttribute().add((Object)extensionEntryBgColor);
            EAttributeImpl extensionAttributeBorderColor = (EAttributeImpl)metadata.demandFeature("http://www.omg.org/spec/BPMN/non-normative/color", "border-color", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntryBorderColor = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttributeBorderColor, (Object)borderColor);
            edge.getBpmnElement().getAnyAttribute().add((Object)extensionEntryBorderColor);
            EAttributeImpl extensionAttributeColor = (EAttributeImpl)metadata.demandFeature("http://www.omg.org/spec/BPMN/non-normative/color", "color", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntryColor = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttributeColor, (Object)fontColor);
            edge.getBpmnElement().getAnyAttribute().add((Object)extensionEntryColor);
        } else {
            _logger.warn("Unable to find color information for shape: " + edge.getBpmnElement().getId());
        }
    }

    public void updateEdgeBoundsInLanes(Definitions def, BPMNPlane plane, BPMNEdge edge, BaseElement ele) {
        if (ele instanceof SequenceFlow) {
            SequenceFlow sq = (SequenceFlow)ele;
            if (sq.getSourceRef() != null) {
                edge.setSourceElement((DiagramElement)this.getBPMNShapeForElement((BaseElement)sq.getSourceRef(), plane));
            }
            if (sq.getTargetRef() != null) {
                edge.setTargetElement((DiagramElement)this.getBPMNShapeForElement((BaseElement)sq.getTargetRef(), plane));
            }
            List rootElements = def.getRootElements();
            for (RootElement root : rootElements) {
                if (!(root instanceof Process)) continue;
                Process process = (Process)root;
                if (sq.getSourceRef() == null || sq.getTargetRef() == null || process.getLaneSets() == null || process.getLaneSets().size() <= 0) continue;
                for (LaneSet ls : process.getLaneSets()) {
                    for (Lane newLane : ls.getLanes()) {
                        List laneFlowNodes = newLane.getFlowNodeRefs();
                        Bounds laneBounds = this.getBoundsForElement((BaseElement)newLane, plane);
                        for (FlowNode newFlowNode : laneFlowNodes) {
                            List edgePoints;
                            Bounds eleBounds;
                            BPMNShape shape;
                            List diagramElements;
                            if (newFlowNode.getId().equals(sq.getSourceRef().getId())) {
                                diagramElements = plane.getPlaneElement();
                                for (DiagramElement dia : diagramElements) {
                                    if (!(dia instanceof BPMNShape) || !(shape = (BPMNShape)dia).getBpmnElement().getId().equals(sq.getSourceRef().getId())) continue;
                                    eleBounds = shape.getBounds();
                                    edgePoints = edge.getWaypoint();
                                    if (edgePoints == null || edgePoints.size() <= 1 || eleBounds == null) continue;
                                    Point first = (Point)edgePoints.get(0);
                                    first.setX(first.getX() + laneBounds.getX() + eleBounds.getWidth() / 2.0f);
                                    first.setY(first.getY() + laneBounds.getY());
                                }
                                continue;
                            }
                            if (!newFlowNode.getId().equals(sq.getTargetRef().getId())) continue;
                            diagramElements = plane.getPlaneElement();
                            for (DiagramElement dia : diagramElements) {
                                if (!(dia instanceof BPMNShape) || !(shape = (BPMNShape)dia).getBpmnElement().getId().equals(sq.getTargetRef().getId())) continue;
                                eleBounds = shape.getBounds();
                                edgePoints = edge.getWaypoint();
                                if (edgePoints == null || edgePoints.size() <= 1 || eleBounds == null) continue;
                                Point last = (Point)edgePoints.get(edgePoints.size() - 1);
                                last.setX(last.getX() + laneBounds.getX() - eleBounds.getWidth());
                                last.setY(last.getY() + laneBounds.getY());
                            }
                        }
                    }
                }
            }
        }
    }

    public void updateShapeBounds(Definitions def, BPMNPlane plane, BaseElement ele) {
        if (ele instanceof Lane) {
            Lane nextLane = (Lane)ele;
            Bounds laneBounds = this.getBoundsForElement((BaseElement)nextLane, plane);
            this.updateShapeBoundsInLanes(plane, ele, nextLane, laneBounds.getX(), laneBounds.getY());
        } else {
            List rootElements = def.getRootElements();
            for (RootElement root : rootElements) {
                if (!(root instanceof Process)) continue;
                Process process = (Process)root;
                List flowElements = process.getFlowElements();
                boolean foundAsTopLevel = false;
                for (FlowElement fe : flowElements) {
                    if (!fe.getId().equals(ele.getId())) continue;
                    foundAsTopLevel = true;
                    break;
                }
                if (foundAsTopLevel) continue;
                for (FlowElement fe : flowElements) {
                    Bounds subprocessBounds;
                    SubProcess sp;
                    if (!(fe instanceof SubProcess) || (sp = (SubProcess)fe).getLanes().size() >= 1 || (subprocessBounds = this.getBoundsForElement((BaseElement)fe, plane)) == null) continue;
                    this.updateShapeBoundsInSubprocess(plane, ele, (SubProcess)fe, subprocessBounds.getX(), subprocessBounds.getY());
                }
            }
        }
    }

    public void updateShapeBoundsInLanes(BPMNPlane plane, BaseElement ele, Lane lane, float parentX, float parentY) {
        for (FlowNode fn : lane.getFlowNodeRefs()) {
            Bounds fnBounds = this.getBoundsForElement((BaseElement)fn, plane);
            if (fnBounds == null) continue;
            fnBounds.setX(fnBounds.getX() + parentX);
            fnBounds.setY(fnBounds.getY() + parentY);
            if (fn instanceof SubProcess) {
                this.updateShapeBoundsInSubprocessInLanes(plane, ele, (SubProcess)fn, fnBounds.getX(), fnBounds.getY());
                continue;
            }
            if (!(fn instanceof Lane)) continue;
            this.updateShapeBoundsInLanes(plane, ele, (Lane)fn, fnBounds.getX(), fnBounds.getY());
        }
    }

    public void updateShapeBoundsInSubprocessInLanes(BPMNPlane plane, BaseElement ele, SubProcess sub, float parentX, float parentY) {
        for (FlowElement subEle : sub.getFlowElements()) {
            Bounds subEleBounds = this.getBoundsForElement((BaseElement)subEle, plane);
            if (subEleBounds != null) {
                subEleBounds.setX(subEleBounds.getX() + parentX);
                subEleBounds.setY(subEleBounds.getY() + parentY);
            }
            if (!(subEle instanceof SubProcess)) continue;
            this.updateShapeBoundsInSubprocessInLanes(plane, ele, (SubProcess)subEle, subEleBounds.getX(), subEleBounds.getY());
        }
    }

    public void updateShapeBoundsInSubprocess(BPMNPlane plane, BaseElement ele, SubProcess sub, float parentX, float parentY) {
        Bounds subEleBounds;
        boolean foundInSubprocess = false;
        for (FlowElement subEle : sub.getFlowElements()) {
            if (!subEle.getId().equals(ele.getId())) continue;
            foundInSubprocess = true;
            subEleBounds = this.getBoundsForElement((BaseElement)subEle, plane);
            if (subEleBounds == null) continue;
            subEleBounds.setX(subEleBounds.getX() + parentX);
            subEleBounds.setY(subEleBounds.getY() + parentY);
        }
        if (!foundInSubprocess) {
            for (FlowElement subEle : sub.getFlowElements()) {
                if (!(subEle instanceof SubProcess)) continue;
                subEleBounds = this.getBoundsForElement((BaseElement)subEle, plane);
                this.updateShapeBoundsInSubprocess(plane, ele, (SubProcess)subEle, subEleBounds.getX(), subEleBounds.getY());
            }
        }
    }

    private Bounds getBoundsForElement(BaseElement ele, BPMNPlane plane) {
        BPMNShape elementShape = this.getBPMNShapeForElement(ele, plane);
        if (elementShape != null) {
            return elementShape.getBounds();
        }
        return null;
    }

    public void revisitMultiInstanceTasks(Definitions def) {
        try {
            List rootElements = def.getRootElements();
            for (RootElement root : rootElements) {
                if (!(root instanceof Process)) continue;
                Process process = (Process)root;
                List flowElements = process.getFlowElements();
                for (FlowElement fe : flowElements) {
                    if (!(fe instanceof Task)) continue;
                    Task task = (Task)fe;
                    block4: for (FeatureMap.Entry entry : task.getAnyAttribute()) {
                        List properties;
                        String multiValue;
                        String[] multiValueParts;
                        if (!entry.getEStructuralFeature().getName().equals("mitask") || (multiValueParts = (multiValue = (String)entry.getValue()).split("@")) == null || multiValueParts.length != 5) continue;
                        String miCollectionInput = multiValueParts[0].equals(" ") ? "" : multiValueParts[0];
                        String miCollectionOutput = multiValueParts[1].equals(" ") ? "" : multiValueParts[1];
                        String miDataInput = multiValueParts[2].equals(" ") ? "" : multiValueParts[2];
                        String miDataOutput = multiValueParts[3].equals(" ") ? "" : multiValueParts[3];
                        String miCompletionCondition = multiValueParts[4].equals(" ") ? "" : multiValueParts[4];
                        MultiInstanceLoopCharacteristics loopCharacteristics = Bpmn2Factory.eINSTANCE.createMultiInstanceLoopCharacteristics();
                        if (miCollectionInput != null && miCollectionInput.length() > 0) {
                            properties = process.getProperties();
                            for (Property prop : properties) {
                                if (prop.getId() == null || !prop.getId().equals(miCollectionInput)) continue;
                                DataInput miCollectionInputDI = Bpmn2Factory.eINSTANCE.createDataInput();
                                miCollectionInputDI.setName("miinputCollection");
                                ItemDefinition miCollectionInputDIItemDefinition = this.getMessageItemDefinition(def.getRootElements(), prop.getId());
                                miCollectionInputDI.setItemSubjectRef(miCollectionInputDIItemDefinition);
                                task.getIoSpecification().getDataInputs().add(miCollectionInputDI);
                                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                                    InputSet inset = Bpmn2Factory.eINSTANCE.createInputSet();
                                    task.getIoSpecification().getInputSets().add(inset);
                                }
                                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(miCollectionInputDI);
                                loopCharacteristics.setLoopDataInputRef((ItemAwareElement)miCollectionInputDI);
                                DataInputAssociation miCollectionInputDataInputAssociation = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                                miCollectionInputDataInputAssociation.getSourceRef().add(prop);
                                miCollectionInputDataInputAssociation.setTargetRef((ItemAwareElement)miCollectionInputDI);
                                task.getDataInputAssociations().add(miCollectionInputDataInputAssociation);
                                break;
                            }
                        }
                        if (miCollectionOutput != null && miCollectionOutput.length() > 0) {
                            properties = process.getProperties();
                            for (Property prop : properties) {
                                if (prop.getId() == null || !prop.getId().equals(miCollectionOutput)) continue;
                                DataOutput miCollectionOutputDI = Bpmn2Factory.eINSTANCE.createDataOutput();
                                miCollectionOutputDI.setName("mioutputCollection");
                                ItemDefinition miCollectionOutputDIItemDefinition = this.getMessageItemDefinition(def.getRootElements(), prop.getId());
                                miCollectionOutputDI.setItemSubjectRef(miCollectionOutputDIItemDefinition);
                                task.getIoSpecification().getDataOutputs().add(miCollectionOutputDI);
                                if (task.getIoSpecification().getOutputSets() == null || task.getIoSpecification().getOutputSets().size() < 1) {
                                    OutputSet outset = Bpmn2Factory.eINSTANCE.createOutputSet();
                                    task.getIoSpecification().getOutputSets().add(outset);
                                }
                                ((OutputSet)task.getIoSpecification().getOutputSets().get(0)).getDataOutputRefs().add(miCollectionOutputDI);
                                loopCharacteristics.setLoopDataOutputRef((ItemAwareElement)miCollectionOutputDI);
                                DataOutputAssociation miCollectionInputDataOutputAssociation = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                                miCollectionInputDataOutputAssociation.setTargetRef((ItemAwareElement)prop);
                                miCollectionInputDataOutputAssociation.getSourceRef().add(miCollectionOutputDI);
                                task.getDataOutputAssociations().add(miCollectionInputDataOutputAssociation);
                                break;
                            }
                        }
                        if (miDataInput != null && miDataInput.length() > 0) {
                            List dins = task.getIoSpecification().getDataInputs();
                            for (DataInput di : dins) {
                                if (!di.getName().equals(miDataInput)) continue;
                                DataInput inputDataItemObj = Bpmn2Factory.eINSTANCE.createDataInput();
                                inputDataItemObj.setId("miDataInputX");
                                inputDataItemObj.setItemSubjectRef(di.getItemSubjectRef());
                                loopCharacteristics.setInputDataItem(inputDataItemObj);
                                break;
                            }
                        }
                        if (miDataOutput != null && miDataOutput.length() > 0) {
                            List douts = task.getIoSpecification().getDataOutputs();
                            for (DataOutput dout : douts) {
                                if (!dout.getName().equals(miDataOutput)) continue;
                                DataOutput outputDataItemObj = Bpmn2Factory.eINSTANCE.createDataOutput();
                                outputDataItemObj.setId("miDataOutputX");
                                outputDataItemObj.setItemSubjectRef(dout.getItemSubjectRef());
                                loopCharacteristics.setOutputDataItem(outputDataItemObj);
                                break;
                            }
                        }
                        if (miCompletionCondition != null && !miCompletionCondition.isEmpty()) {
                            FormalExpression expr = Bpmn2Factory.eINSTANCE.createFormalExpression();
                            expr.setBody(miCompletionCondition);
                            loopCharacteristics.setCompletionCondition((Expression)expr);
                        }
                        task.setLoopCharacteristics((LoopCharacteristics)loopCharacteristics);
                        if (miDataInput != null && miDataInput.length() > 0 && ((MultiInstanceLoopCharacteristics)task.getLoopCharacteristics()).getInputDataItem() != null) {
                            DataInputAssociation dias = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                            dias.getSourceRef().add(((MultiInstanceLoopCharacteristics)task.getLoopCharacteristics()).getInputDataItem());
                            List dins = task.getIoSpecification().getDataInputs();
                            for (DataInput di : dins) {
                                if (!di.getName().equals(miDataInput)) continue;
                                dias.setTargetRef((ItemAwareElement)di);
                                task.getDataInputAssociations().add(dias);
                                break;
                            }
                        }
                        if (miDataOutput == null || miDataOutput.length() <= 0 || ((MultiInstanceLoopCharacteristics)task.getLoopCharacteristics()).getOutputDataItem() == null) continue;
                        DataOutputAssociation dout = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                        dout.setTargetRef((ItemAwareElement)((MultiInstanceLoopCharacteristics)task.getLoopCharacteristics()).getOutputDataItem());
                        List douts = task.getIoSpecification().getDataOutputs();
                        for (DataOutput dou : douts) {
                            if (!dou.getName().equals(miDataOutput)) continue;
                            dout.getSourceRef().add(dou);
                            task.getDataOutputAssociations().add(dout);
                            continue block4;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void revisitWsdlImports(Definitions def) {
        for (Import imp : this._wsdlImports) {
            def.getImports().add(imp);
        }
        this._wsdlImports.clear();
    }

    public void revisitSubProcessItemDefs(Definitions def) {
        for (String key : this._subprocessItemDefs.keySet()) {
            def.getRootElements().add(this._subprocessItemDefs.get(key));
        }
        this._subprocessItemDefs.clear();
    }

    public void updateIDs(Definitions def) {
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            List flowElements = process.getFlowElements();
            for (FlowElement fe : flowElements) {
                DataObject da;
                if (!(fe instanceof DataObject) || (da = (DataObject)fe).getName() == null) continue;
                String daId = da.getName().trim();
                daId = daId.replaceAll("\\W", "");
                da.setId(daId);
            }
        }
    }

    public void addSimulation(Definitions def) {
        Relationship relationship = Bpmn2Factory.eINSTANCE.createRelationship();
        relationship.getSources().add(def);
        relationship.getTargets().add(def);
        relationship.setType(defaultRelationshipType);
        BPSimDataType simDataType = BpsimFactory.eINSTANCE.createBPSimDataType();
        Scenario defaultScenario = BpsimFactory.eINSTANCE.createScenario();
        defaultScenario.setId("default");
        defaultScenario.setName("Simulationscenario");
        defaultScenario.setScenarioParameters(this._simulationScenarioParameters);
        if (this._simulationElementParameters.size() > 0) {
            for (String key : this._simulationElementParameters.keySet()) {
                ElementParameters etype = BpsimFactory.eINSTANCE.createElementParameters();
                etype.setElementRef(key);
                List<EObject> params = this._simulationElementParameters.get(key);
                for (EObject np : params) {
                    if (np instanceof ControlParameters) {
                        etype.setControlParameters((ControlParameters)np);
                        continue;
                    }
                    if (np instanceof CostParameters) {
                        etype.setCostParameters((CostParameters)np);
                        continue;
                    }
                    if (np instanceof PriorityParameters) {
                        etype.setPriorityParameters((PriorityParameters)np);
                        continue;
                    }
                    if (np instanceof ResourceParameters) {
                        etype.setResourceParameters((ResourceParameters)np);
                        continue;
                    }
                    if (!(np instanceof TimeParameters)) continue;
                    etype.setTimeParameters((TimeParameters)np);
                }
                defaultScenario.getElementParameters().add((Object)etype);
            }
        }
        simDataType.getScenario().add((Object)defaultScenario);
        ExtensionAttributeValue extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
        relationship.getExtensionValues().add(extensionElement);
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)BpsimPackage.Literals.DOCUMENT_ROOT__BP_SIM_DATA, (Object)simDataType);
        ((ExtensionAttributeValue)relationship.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
        def.getRelationships().add(relationship);
    }

    public void revisitDataObjects(Definitions def) {
        List rootElements = def.getRootElements();
        ArrayList<ItemDefinition> itemDefinitionsToAddUnfiltered = new ArrayList<ItemDefinition>();
        ArrayList<ItemDefinition> itemDefinitionsToAddFiltered = new ArrayList<ItemDefinition>();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            List flowElements = process.getFlowElements();
            Iterator iterator = flowElements.iterator();
            while (iterator.hasNext()) {
                FlowElement fe = (FlowElement)iterator.next();
                if (!(fe instanceof DataObject)) continue;
                DataObject da = (DataObject)fe;
                ItemDefinition itemdef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                itemdef.setId("_" + da.getId() + "Item");
                for (FeatureMap.Entry entry : da.getAnyAttribute()) {
                    String typeValue;
                    if (!entry.getEStructuralFeature().getName().equals("datype") || (typeValue = (String)entry.getValue()) == null || typeValue.equals("None")) continue;
                    itemdef.setStructureRef((String)entry.getValue());
                }
                da.setItemSubjectRef(itemdef);
                itemDefinitionsToAddUnfiltered.add(itemdef);
            }
        }
        for (ItemDefinition itemDef : itemDefinitionsToAddUnfiltered) {
            boolean foundItemDef = false;
            for (RootElement ele : rootElements) {
                ItemDefinition idef;
                if (!(ele instanceof ItemDefinition) || !(idef = (ItemDefinition)ele).getId().equals(itemDef.getId())) continue;
                foundItemDef = true;
                break;
            }
            if (foundItemDef) continue;
            itemDefinitionsToAddFiltered.add(itemDef);
        }
        for (ItemDefinition itemDefFil : itemDefinitionsToAddFiltered) {
            def.getRootElements().add(itemDefFil);
        }
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            List artifactElements = process.getArtifacts();
            for (Artifact af : artifactElements) {
                SequenceFlow sf;
                DataOutputAssociation dia;
                DataInput d;
                Task task;
                DataObject da;
                if (!(af instanceof Association)) continue;
                Association as = (Association)af;
                if (as.getSourceRef() != null && as.getSourceRef() instanceof DataObject && as.getTargetRef() != null && (as.getTargetRef() instanceof Task || as.getTargetRef() instanceof ThrowEvent)) {
                    da = (DataObject)as.getSourceRef();
                    if (as.getTargetRef() instanceof Task) {
                        task = (Task)as.getTargetRef();
                        if (task.getIoSpecification() == null) {
                            InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                            task.setIoSpecification(iospec);
                        }
                        if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                            InputSet inset = Bpmn2Factory.eINSTANCE.createInputSet();
                            task.getIoSpecification().getInputSets().add(inset);
                        }
                        InputSet inSet = (InputSet)task.getIoSpecification().getInputSets().get(0);
                        boolean foundDataInput = false;
                        for (DataInput dataInput : inSet.getDataInputRefs()) {
                            if (!dataInput.getId().equals(task.getId() + "_" + da.getId() + "InputX")) continue;
                            foundDataInput = true;
                        }
                        if (!foundDataInput) {
                            d = Bpmn2Factory.eINSTANCE.createDataInput();
                            d.setId(task.getId() + "_" + da.getId() + "InputX");
                            d.setName(da.getId() + "InputX");
                            task.getIoSpecification().getDataInputs().add(d);
                            ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
                            dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                            dia.setTargetRef((ItemAwareElement)d);
                            dia.getSourceRef().add(da);
                            task.getDataInputAssociations().add(dia);
                        }
                    } else if (as.getTargetRef() instanceof ThrowEvent) {
                        ThrowEvent te = (ThrowEvent)as.getTargetRef();
                        boolean foundDataInput = false;
                        List dataInputs = te.getDataInputs();
                        for (DataInput din : dataInputs) {
                            if (!din.getId().equals(te.getId() + "_" + da.getId() + "InputX")) continue;
                            foundDataInput = true;
                        }
                        if (!foundDataInput) {
                            DataInput datain = Bpmn2Factory.eINSTANCE.createDataInput();
                            datain.setId(te.getId() + "_" + da.getId() + "InputX");
                            datain.setName(da.getId() + "InputX");
                            te.getDataInputs().add(datain);
                            if (te.getInputSet() == null) {
                                InputSet inset = Bpmn2Factory.eINSTANCE.createInputSet();
                                te.setInputSet(inset);
                            }
                            te.getInputSet().getDataInputRefs().add(datain);
                            DataInputAssociation dia2 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                            dia2.setTargetRef((ItemAwareElement)datain);
                            dia2.getSourceRef().add(da);
                            te.getDataInputAssociation().add(dia2);
                        }
                    }
                }
                if (as.getTargetRef() != null && as.getTargetRef() instanceof DataObject && as.getSourceRef() != null && (as.getSourceRef() instanceof Task || as.getSourceRef() instanceof CatchEvent)) {
                    da = (DataObject)as.getTargetRef();
                    if (as.getSourceRef() instanceof Task) {
                        task = (Task)as.getSourceRef();
                        if (task.getIoSpecification() == null) {
                            InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                            task.setIoSpecification(iospec);
                        }
                        if (task.getIoSpecification().getOutputSets() == null || task.getIoSpecification().getOutputSets().size() < 1) {
                            OutputSet outSet = Bpmn2Factory.eINSTANCE.createOutputSet();
                            task.getIoSpecification().getOutputSets().add(outSet);
                        }
                        boolean foundDataOutput = false;
                        OutputSet outSet = (OutputSet)task.getIoSpecification().getOutputSets().get(0);
                        for (DataOutput dataOut : outSet.getDataOutputRefs()) {
                            if (!dataOut.getId().equals(task.getId() + "_" + da.getId() + "OutputX")) continue;
                            foundDataOutput = true;
                        }
                        if (!foundDataOutput) {
                            d = Bpmn2Factory.eINSTANCE.createDataOutput();
                            d.setId(task.getId() + "_" + da.getId() + "OutputX");
                            d.setName(da.getId() + "OutputX");
                            task.getIoSpecification().getDataOutputs().add(d);
                            ((OutputSet)task.getIoSpecification().getOutputSets().get(0)).getDataOutputRefs().add(d);
                            DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                            doa.getSourceRef().add(d);
                            doa.setTargetRef((ItemAwareElement)da);
                            task.getDataOutputAssociations().add(doa);
                        }
                    } else if (as.getSourceRef() instanceof CatchEvent) {
                        CatchEvent ce = (CatchEvent)as.getSourceRef();
                        boolean foundDataOutput = false;
                        List dataOutputs = ce.getDataOutputs();
                        for (DataOutput dout : dataOutputs) {
                            if (!dout.getId().equals(ce.getId() + "_" + da.getId() + "OutputX")) continue;
                            foundDataOutput = true;
                        }
                        if (!foundDataOutput) {
                            DataOutput dataout = Bpmn2Factory.eINSTANCE.createDataOutput();
                            dataout.setId(ce.getId() + "_" + da.getId() + "OutputX");
                            dataout.setName(da.getId() + "OutputX");
                            ce.getDataOutputs().add(dataout);
                            if (ce.getOutputSet() == null) {
                                OutputSet outset = Bpmn2Factory.eINSTANCE.createOutputSet();
                                ce.setOutputSet(outset);
                            }
                            ce.getOutputSet().getDataOutputRefs().add(dataout);
                            dia = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                            dia.setTargetRef((ItemAwareElement)da);
                            dia.getSourceRef().add(dataout);
                            ce.getDataOutputAssociation().add(dia);
                        }
                    }
                }
                if (as.getSourceRef() == null || !(as.getSourceRef() instanceof DataObject) || as.getTargetRef() == null || !(as.getTargetRef() instanceof SequenceFlow) || (sf = (SequenceFlow)as.getTargetRef()).getSourceRef() == null || !(sf.getSourceRef() instanceof Activity) || sf.getTargetRef() == null || !(sf.getTargetRef() instanceof Activity)) continue;
                Activity sourceElement = (Activity)sf.getSourceRef();
                Activity targetElement = (Activity)sf.getTargetRef();
                DataObject da2 = (DataObject)as.getSourceRef();
                if (targetElement.getIoSpecification() == null) {
                    InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                    targetElement.setIoSpecification(iospec);
                }
                if (targetElement.getIoSpecification().getInputSets() == null || targetElement.getIoSpecification().getInputSets().size() < 1) {
                    InputSet inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    targetElement.getIoSpecification().getInputSets().add(inset);
                }
                InputSet inSet = (InputSet)targetElement.getIoSpecification().getInputSets().get(0);
                boolean foundDataInput = false;
                for (DataInput dataInput : inSet.getDataInputRefs()) {
                    if (!dataInput.getId().equals(targetElement.getId() + "_" + da2.getId() + "InputX")) continue;
                    foundDataInput = true;
                }
                if (!foundDataInput) {
                    DataInput d2 = Bpmn2Factory.eINSTANCE.createDataInput();
                    d2.setId(targetElement.getId() + "_" + da2.getId() + "InputX");
                    d2.setName(da2.getId() + "InputX");
                    targetElement.getIoSpecification().getDataInputs().add(d2);
                    ((InputSet)targetElement.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d2);
                    DataInputAssociation dia3 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                    dia3.setTargetRef((ItemAwareElement)d2);
                    dia3.getSourceRef().add(da2);
                    targetElement.getDataInputAssociations().add(dia3);
                }
                if (sourceElement.getIoSpecification() == null) {
                    InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                    sourceElement.setIoSpecification(iospec);
                }
                if (sourceElement.getIoSpecification().getOutputSets() == null || sourceElement.getIoSpecification().getOutputSets().size() < 1) {
                    OutputSet outSet = Bpmn2Factory.eINSTANCE.createOutputSet();
                    sourceElement.getIoSpecification().getOutputSets().add(outSet);
                }
                boolean foundDataOutput = false;
                OutputSet outSet = (OutputSet)sourceElement.getIoSpecification().getOutputSets().get(0);
                for (DataOutput dataOut : outSet.getDataOutputRefs()) {
                    if (!dataOut.getId().equals(sourceElement.getId() + "_" + da2.getId() + "OutputX")) continue;
                    foundDataOutput = true;
                }
                if (foundDataOutput) continue;
                DataOutput d3 = Bpmn2Factory.eINSTANCE.createDataOutput();
                d3.setId(sourceElement.getId() + "_" + da2.getId() + "OutputX");
                d3.setName(da2.getId() + "OutputX");
                sourceElement.getIoSpecification().getDataOutputs().add(d3);
                ((OutputSet)sourceElement.getIoSpecification().getOutputSets().get(0)).getDataOutputRefs().add(d3);
                DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                doa.getSourceRef().add(d3);
                doa.setTargetRef((ItemAwareElement)da2);
                sourceElement.getDataOutputAssociations().add(doa);
            }
        }
    }

    public void revisitTaskAssociations(Definitions def) {
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            List flowElements = process.getFlowElements();
            for (FlowElement fe : flowElements) {
                List outputList;
                List inputList;
                if (!(fe instanceof Task)) continue;
                Task t = (Task)fe;
                if (t.getDataInputAssociations() != null && (inputList = t.getDataInputAssociations()) != null) {
                    for (DataInputAssociation input : inputList) {
                        List sourceRef = input.getSourceRef();
                        if (sourceRef == null) continue;
                        for (ItemAwareElement iae : sourceRef) {
                            String[] iaeParts = iae.getId().split("\\.");
                            if (iaeParts.length <= 1) continue;
                        }
                    }
                }
                if (t.getDataOutputAssociations() != null && (outputList = t.getDataOutputAssociations()) != null) {
                    for (DataOutputAssociation output : outputList) {
                        String[] targetEleParts;
                        ItemAwareElement targetEle = output.getTargetRef();
                        if (targetEle != null && (targetEleParts = targetEle.getId().split("\\.")).length <= 1) continue;
                    }
                }
                if (t.getIoSpecification() == null) continue;
                InputOutputSpecification ios = t.getIoSpecification();
                if (ios.getInputSets() == null || ios.getInputSets().size() < 1) {
                    InputSet inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    ios.getInputSets().add(inset);
                }
                if (ios.getOutputSets() != null || ios.getOutputSets() != null && ios.getOutputSets().size() >= 1) continue;
                OutputSet outset = Bpmn2Factory.eINSTANCE.createOutputSet();
                ios.getOutputSets().add(outset);
            }
        }
    }

    public void revisitSendReceiveTasks(Definitions def) {
        ArrayList<Message> toAddMessages = new ArrayList<Message>();
        ArrayList<ItemDefinition> toAddItemDefinitions = new ArrayList<ItemDefinition>();
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            this.setSendReceiveTasksInfo((FlowElementsContainer)((Process)root), def, toAddMessages, toAddItemDefinitions);
        }
        for (ItemDefinition idef : toAddItemDefinitions) {
            def.getRootElements().add(idef);
        }
        for (Message msg : toAddMessages) {
            def.getRootElements().add(msg);
        }
    }

    public void setSendReceiveTasksInfo(FlowElementsContainer container, Definitions def, List<Message> toAddMessages, List<ItemDefinition> toAddItemDefinitions) {
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            if (fe instanceof ReceiveTask) {
                ReceiveTask rt = (ReceiveTask)fe;
                rt.setMessageRef(this.getMessage((BaseElement)rt, toAddMessages, toAddItemDefinitions));
                continue;
            }
            if (fe instanceof SendTask) {
                SendTask st = (SendTask)fe;
                st.setMessageRef(this.getMessage((BaseElement)st, toAddMessages, toAddItemDefinitions));
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setSendReceiveTasksInfo((FlowElementsContainer)fe, def, toAddMessages, toAddItemDefinitions);
        }
    }

    private Message getMessage(BaseElement element, Collection<Message> toAddMessages, Collection<ItemDefinition> toAddItemDefinitions) {
        String idefId = null;
        String msgId = null;
        for (FeatureMap.Entry entry : element.getAnyAttribute()) {
            if (!entry.getEStructuralFeature().getName().equals("msgref")) continue;
            msgId = (String)entry.getValue();
            idefId = (String)entry.getValue() + "Type";
        }
        if (msgId != null && !msgId.isEmpty() && idefId != null && !idefId.isEmpty()) {
            Message msg;
            ItemDefinition idef = this._itemDefinitions.get(idefId);
            if (idef == null) {
                idef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                idef.setId(idefId);
                this._itemDefinitions.put(idefId, idef);
            }
            if ((msg = this._messages.get(msgId)) == null) {
                msg = Bpmn2Factory.eINSTANCE.createMessage();
                msg.setId(this.getIdForRootElement(msgId));
                msg.setName(msgId);
                msg.setItemRef(idef);
                this._messages.put(msgId, msg);
            }
            toAddMessages.add(msg);
            toAddItemDefinitions.add(idef);
            return msg;
        }
        return null;
    }

    public void revisitLanes(Definitions def) {
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            Process process;
            if (!(root instanceof Process) || (process = (Process)root).getLaneSets() != null && process.getLaneSets().size() >= 1 || this._lanes.size() <= 0) continue;
            LaneSet ls = Bpmn2Factory.eINSTANCE.createLaneSet();
            for (Lane lane : this._lanes) {
                ls.getLanes().add(lane);
                List laneFlowNodes = lane.getFlowNodeRefs();
                for (FlowNode fl : laneFlowNodes) {
                    process.getFlowElements().add(fl);
                }
            }
            process.getLaneSets().add(ls);
        }
    }

    public void revisitArtifacts(Definitions def) {
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            for (Artifact a : this._artifacts) {
                process.getArtifacts().add(a);
            }
        }
    }

    public void revisitGroups(Definitions def) {
        List rootElements = def.getRootElements();
        Category defaultCat = Bpmn2Factory.eINSTANCE.createCategory();
        defaultCat.setName("default");
        for (RootElement root : rootElements) {
            Process process;
            List processArtifacts;
            if (!(root instanceof Process) || (processArtifacts = (process = (Process)root).getArtifacts()) == null) continue;
            for (Artifact ar : processArtifacts) {
                if (!(ar instanceof Group)) continue;
                Group group = (Group)ar;
                for (FeatureMap.Entry entry : group.getAnyAttribute()) {
                    if (!entry.getEStructuralFeature().getName().equals("categoryval")) continue;
                    CategoryValue catval = Bpmn2Factory.eINSTANCE.createCategoryValue();
                    catval.setValue((String)entry.getValue());
                    defaultCat.getCategoryValue().add(catval);
                    group.setCategoryValueRef(catval);
                }
            }
        }
        if (defaultCat.getCategoryValue() != null && defaultCat.getCategoryValue().size() > 0) {
            rootElements.add(defaultCat);
        }
    }

    public void revisitThrowEvents(Definitions def) {
        List rootElements = def.getRootElements();
        ArrayList<Signal> toAddSignals = new ArrayList<Signal>();
        HashSet<Error> toAddErrors = new HashSet<Error>();
        HashSet<Escalation> toAddEscalations = new HashSet<Escalation>();
        HashSet<Message> toAddMessages = new HashSet<Message>();
        HashSet<ItemDefinition> toAddItemDefinitions = new HashSet<ItemDefinition>();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            this.setThrowEventsInfo((FlowElementsContainer)((Process)root), def, rootElements, toAddSignals, toAddErrors, toAddEscalations, toAddMessages, toAddItemDefinitions);
        }
        for (Lane lane : this._lanes) {
            this.setThrowEventsInfoForLanes(lane, def, rootElements, toAddSignals, toAddErrors, toAddEscalations, toAddMessages, toAddItemDefinitions);
        }
        for (Signal s : toAddSignals) {
            def.getRootElements().add(s);
        }
        for (Error er : toAddErrors) {
            def.getRootElements().add(er);
        }
        for (Escalation es : toAddEscalations) {
            def.getRootElements().add(es);
        }
        for (ItemDefinition idef : toAddItemDefinitions) {
            def.getRootElements().add(idef);
        }
        for (Message msg : toAddMessages) {
            def.getRootElements().add(msg);
        }
    }

    public void setThrowEventsInfo(FlowElementsContainer container, Definitions def, List<RootElement> rootElements, List<Signal> toAddSignals, Set<Error> toAddErrors, Set<Escalation> toAddEscalations, Set<Message> toAddMessages, Set<ItemDefinition> toAddItemDefinitions) {
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            if (fe instanceof ThrowEvent) {
                if (((ThrowEvent)fe).getEventDefinitions().size() <= 0) continue;
                EventDefinition ed = (EventDefinition)((ThrowEvent)fe).getEventDefinitions().get(0);
                if (ed instanceof SignalEventDefinition) {
                    this.getSignal((SignalEventDefinition)ed, rootElements, toAddSignals);
                    continue;
                }
                if (ed instanceof ErrorEventDefinition) {
                    Error err = this.getError(ed);
                    toAddErrors.add(err);
                    ((ErrorEventDefinition)ed).setErrorRef(err);
                    continue;
                }
                if (ed instanceof EscalationEventDefinition) {
                    Escalation escalation = this.getEscalation(ed);
                    toAddEscalations.add(escalation);
                    ((EscalationEventDefinition)ed).setEscalationRef(escalation);
                    continue;
                }
                if (ed instanceof MessageEventDefinition) {
                    ((MessageEventDefinition)ed).setMessageRef(this.getMessage((BaseElement)ed, toAddMessages, toAddItemDefinitions));
                    continue;
                }
                if (!(ed instanceof CompensateEventDefinition)) continue;
                for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                    if (!entry.getEStructuralFeature().getName().equals("actrefname")) continue;
                    String activityNameRef = (String)entry.getValue();
                    List re = def.getRootElements();
                    for (RootElement r : re) {
                        if (!(r instanceof Process)) continue;
                        Process p = (Process)r;
                        List fes = p.getFlowElements();
                        for (FlowElement f : fes) {
                            if (!(f instanceof Activity) || !((Activity)f).getName().equals(activityNameRef)) continue;
                            ((CompensateEventDefinition)ed).setActivityRef((Activity)f);
                            ((Activity)f).setIsForCompensation(true);
                        }
                    }
                }
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setThrowEventsInfo((FlowElementsContainer)fe, def, rootElements, toAddSignals, toAddErrors, toAddEscalations, toAddMessages, toAddItemDefinitions);
        }
    }

    private Error getError(EventDefinition ed) {
        String errorCode = null;
        for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
            if (!entry.getEStructuralFeature().getName().equals("erefname")) continue;
            errorCode = (String)entry.getValue();
        }
        Error err = this._errors.get(errorCode);
        if (err == null) {
            err = Bpmn2Factory.eINSTANCE.createError();
            err.setId(this.getIdForRootElement(errorCode));
            err.setName(errorCode);
            err.setErrorCode(errorCode);
            this._errors.put(errorCode, err);
        }
        return err;
    }

    public void setThrowEventsInfoForLanes(Lane lane, Definitions def, List<RootElement> rootElements, List<Signal> toAddSignals, Set<Error> toAddErrors, Set<Escalation> toAddEscalations, Set<Message> toAddMessages, Set<ItemDefinition> toAddItemDefinitions) {
        List laneFlowNodes = lane.getFlowNodeRefs();
        for (FlowNode fe : laneFlowNodes) {
            if (fe instanceof ThrowEvent) {
                if (((ThrowEvent)fe).getEventDefinitions().size() <= 0) continue;
                EventDefinition ed = (EventDefinition)((ThrowEvent)fe).getEventDefinitions().get(0);
                if (ed instanceof SignalEventDefinition) {
                    this.getSignal((SignalEventDefinition)ed, rootElements, toAddSignals);
                    continue;
                }
                if (ed instanceof ErrorEventDefinition) {
                    Error err = this.getError(ed);
                    toAddErrors.add(err);
                    ((ErrorEventDefinition)ed).setErrorRef(err);
                    continue;
                }
                if (ed instanceof EscalationEventDefinition) {
                    Escalation escalation = this.getEscalation(ed);
                    toAddEscalations.add(escalation);
                    ((EscalationEventDefinition)ed).setEscalationRef(escalation);
                    continue;
                }
                if (ed instanceof MessageEventDefinition) {
                    ((MessageEventDefinition)ed).setMessageRef(this.getMessage((BaseElement)ed, toAddMessages, toAddItemDefinitions));
                    continue;
                }
                if (!(ed instanceof CompensateEventDefinition)) continue;
                for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                    if (!entry.getEStructuralFeature().getName().equals("actrefname")) continue;
                    String activityNameRef = (String)entry.getValue();
                    List re = def.getRootElements();
                    for (RootElement r : re) {
                        if (!(r instanceof Process)) continue;
                        Process p = (Process)r;
                        List fes = p.getFlowElements();
                        for (FlowElement f : fes) {
                            if (!(f instanceof Activity) || !((Activity)f).getName().equals(activityNameRef)) continue;
                            ((CompensateEventDefinition)ed).setActivityRef((Activity)f);
                            ((Activity)f).setIsForCompensation(true);
                        }
                    }
                }
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setThrowEventsInfo((FlowElementsContainer)fe, def, rootElements, toAddSignals, toAddErrors, toAddEscalations, toAddMessages, toAddItemDefinitions);
        }
    }

    private void getSignal(SignalEventDefinition sed, List<RootElement> rootElements, List<Signal> toAddSignals) {
        if (sed.getSignalRef() != null && sed.getSignalRef().length() > 0) {
            String signalRef = sed.getSignalRef();
            boolean shouldAddSignal = true;
            for (RootElement re : rootElements) {
                if (!(re instanceof Signal) || !((Signal)re).getName().equals(signalRef)) continue;
                shouldAddSignal = false;
                break;
            }
            if (toAddSignals != null) {
                for (Signal s : toAddSignals) {
                    if (!s.getName().equals(signalRef)) continue;
                    shouldAddSignal = false;
                    break;
                }
            }
            if (shouldAddSignal) {
                Signal signal = Bpmn2Factory.eINSTANCE.createSignal();
                signal.setId(this.getIdForRootElement(signalRef));
                signal.setName(signalRef);
                toAddSignals.add(signal);
            }
        }
    }

    protected FlowElementsContainer findContainerForBoundaryEvent(FlowElementsContainer container, BoundaryEvent be) {
        for (FlowElement flowElement : container.getFlowElements()) {
            FlowElementsContainer result;
            if (flowElement.getId().equals(be.getAttachedToRef().getId())) {
                return container;
            }
            if (!(flowElement instanceof FlowElementsContainer) || (result = this.findContainerForBoundaryEvent((FlowElementsContainer)flowElement, be)) == null) continue;
            return result;
        }
        return null;
    }

    private FlowElementsContainer findContanerForFlowElement(FlowElementsContainer container, FlowElement fl) {
        for (FlowElement flowElement : container.getFlowElements()) {
            if (flowElement.getId().equals(fl.getId())) {
                return container;
            }
            if (!(flowElement instanceof FlowElementsContainer)) continue;
            return this.findContanerForFlowElement((FlowElementsContainer)flowElement, fl);
        }
        return null;
    }

    protected void revisitBoundaryEventsPositions(Definitions def) {
        for (RootElement root : def.getRootElements()) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            ArrayList<BoundaryEvent> toRemove = new ArrayList<BoundaryEvent>();
            for (FlowElement fe : process.getFlowElements()) {
                BoundaryEvent be;
                FlowElementsContainer container;
                if (!(fe instanceof BoundaryEvent) || (container = this.findContainerForBoundaryEvent((FlowElementsContainer)process, be = (BoundaryEvent)fe)) == null || container instanceof Process) continue;
                BoundaryEvent beCopy = this.copyBoundaryEvent(be);
                container.getFlowElements().add(beCopy);
                this._outgoingFlows.put(beCopy, this._outgoingFlows.get(be));
                toRemove.add(be);
                this._outgoingFlows.remove(be);
            }
            for (BoundaryEvent be : toRemove) {
                process.getFlowElements().remove(be);
            }
        }
        this.reconnectFlows();
    }

    private BoundaryEvent copyBoundaryEvent(BoundaryEvent beEntry) {
        EventDefinition ed = null;
        if (beEntry.getEventDefinitions() != null && beEntry.getEventDefinitions().size() > 0) {
            ed = (EventDefinition)beEntry.getEventDefinitions().get(0);
        }
        BoundaryEvent be = Bpmn2Factory.eINSTANCE.createBoundaryEvent();
        if (ed instanceof ErrorEventDefinition) {
            be.setCancelActivity(true);
        } else {
            for (FeatureMap.Entry entry2 : beEntry.getAnyAttribute()) {
                if (!entry2.getEStructuralFeature().getName().equals("boundaryca")) continue;
                String boundaryceVal = (String)entry2.getValue();
                be.setCancelActivity(Boolean.parseBoolean(boundaryceVal));
            }
        }
        if (beEntry.getDataOutputs() != null) {
            be.getDataOutputs().addAll(beEntry.getDataOutputs());
        }
        if (beEntry.getDataOutputAssociation() != null) {
            be.getDataOutputAssociation().addAll(beEntry.getDataOutputAssociation());
        }
        if (beEntry.getOutputSet() != null) {
            be.setOutputSet(beEntry.getOutputSet());
        }
        if (beEntry.getEventDefinitions() != null) {
            be.getEventDefinitions().addAll(beEntry.getEventDefinitions());
        }
        if (beEntry.getEventDefinitionRefs() != null) {
            be.getEventDefinitionRefs().addAll(beEntry.getEventDefinitionRefs());
        }
        if (beEntry.getProperties() != null) {
            be.getProperties().addAll(beEntry.getProperties());
        }
        if (beEntry.getAnyAttribute() != null) {
            be.getAnyAttribute().addAll((Collection)beEntry.getAnyAttribute());
        }
        if (beEntry.getOutgoing() != null) {
            be.getOutgoing().addAll(beEntry.getOutgoing());
        }
        if (beEntry.getIncoming() != null) {
            be.getIncoming().addAll(beEntry.getIncoming());
        }
        if (beEntry.getExtensionValues() != null) {
            be.getExtensionValues().addAll(beEntry.getExtensionValues());
        }
        be.getDocumentation().addAll(beEntry.getDocumentation());
        be.setName(beEntry.getName());
        be.setId(beEntry.getId());
        be.setAttachedToRef(beEntry.getAttachedToRef());
        return be;
    }

    protected void revisitCatchEventsConvertToBoundary(Definitions def) {
        ArrayList<CatchEvent> catchEventsToRemove = new ArrayList<CatchEvent>();
        HashMap<BoundaryEvent, List<String>> boundaryEventsToAdd = new HashMap<BoundaryEvent, List<String>>();
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            this.revisitCatchEVentsConvertToBoundaryExecute(process, null, catchEventsToRemove, boundaryEventsToAdd);
        }
        this.reconnectFlows();
    }

    private void revisitCatchEVentsConvertToBoundaryExecute(Process process, FlowElementsContainer subContainer, List<CatchEvent> catchEventsToRemove, Map<BoundaryEvent, List<String>> boundaryEventsToAdd) {
        FlowElementsContainer container = subContainer != null ? subContainer : process;
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            if (fe instanceof CatchEvent) {
                for (Map.Entry<Object, List<String>> entry : this._outgoingFlows.entrySet()) {
                    for (String flowId : entry.getValue()) {
                        if (!(entry.getKey() instanceof Activity) || !flowId.equals(fe.getId())) continue;
                        CatchEvent ce = (CatchEvent)fe;
                        EventDefinition ed = null;
                        if (ce.getEventDefinitions() != null && ce.getEventDefinitions().size() > 0) {
                            ed = (EventDefinition)ce.getEventDefinitions().get(0);
                        }
                        BoundaryEvent be = Bpmn2Factory.eINSTANCE.createBoundaryEvent();
                        if (ed != null && ed instanceof ErrorEventDefinition) {
                            be.setCancelActivity(true);
                        } else {
                            for (FeatureMap.Entry entry2 : ce.getAnyAttribute()) {
                                if (!entry2.getEStructuralFeature().getName().equals("boundaryca")) continue;
                                String boundaryceVal = (String)entry2.getValue();
                                be.setCancelActivity(Boolean.parseBoolean(boundaryceVal));
                            }
                        }
                        if (ce.getDataOutputs() != null) {
                            be.getDataOutputs().addAll(ce.getDataOutputs());
                        }
                        if (ce.getDataOutputAssociation() != null) {
                            be.getDataOutputAssociation().addAll(ce.getDataOutputAssociation());
                        }
                        if (ce.getOutputSet() != null) {
                            be.setOutputSet(ce.getOutputSet());
                        }
                        if (ce.getEventDefinitions() != null) {
                            be.getEventDefinitions().addAll(ce.getEventDefinitions());
                        }
                        if (ce.getEventDefinitionRefs() != null) {
                            be.getEventDefinitionRefs().addAll(ce.getEventDefinitionRefs());
                        }
                        if (ce.getProperties() != null) {
                            be.getProperties().addAll(ce.getProperties());
                        }
                        if (ce.getAnyAttribute() != null) {
                            be.getAnyAttribute().addAll((Collection)ce.getAnyAttribute());
                        }
                        if (ce.getOutgoing() != null) {
                            be.getOutgoing().addAll(ce.getOutgoing());
                        }
                        if (ce.getIncoming() != null) {
                            be.getIncoming().addAll(ce.getIncoming());
                        }
                        if (ce.getProperties() != null) {
                            be.getProperties().addAll(ce.getProperties());
                        }
                        be.getDocumentation().addAll(ce.getDocumentation());
                        be.setName(ce.getName());
                        String ceElementName = Utils.getMetaDataValue(ce.getExtensionValues(), "elementname");
                        if (ceElementName != null) {
                            Utils.setMetaDataExtensionValue((BaseElement)be, "elementname", ceElementName);
                        }
                        be.setId(ce.getId());
                        be.setAttachedToRef((Activity)entry.getKey());
                        ((Activity)entry.getKey()).getBoundaryEventRefs().add(be);
                        catchEventsToRemove.add(ce);
                        boundaryEventsToAdd.put(be, this._outgoingFlows.get(ce));
                    }
                }
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.revisitCatchEVentsConvertToBoundaryExecute(process, (FlowElementsContainer)fe, catchEventsToRemove, boundaryEventsToAdd);
        }
        if (catchEventsToRemove.size() > 0) {
            for (CatchEvent ce : catchEventsToRemove) {
                boolean removed = container.getFlowElements().remove(ce);
                this._outgoingFlows.remove(ce);
            }
        }
        if (boundaryEventsToAdd.size() > 0) {
            for (BoundaryEvent bToAdd : boundaryEventsToAdd.keySet()) {
                container.getFlowElements().add(bToAdd);
                this._outgoingFlows.put(bToAdd, boundaryEventsToAdd.get(bToAdd));
            }
        }
    }

    public void revisitAssociationsIoSpec(Definitions def) {
        List rootElements = def.getRootElements();
        ArrayList<ItemDefinition> toAddItemDefinitions = new ArrayList<ItemDefinition>();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            this.setItemDefinitionsForActivitiesIoSpec((FlowElementsContainer)((Process)root), def, toAddItemDefinitions);
        }
        for (ItemDefinition itemDef : toAddItemDefinitions) {
            def.getRootElements().add(itemDef);
        }
    }

    public void setItemDefinitionsForActivitiesIoSpec(FlowElementsContainer container, Definitions def, List<ItemDefinition> toAddItemDefinitions) {
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            if (fe instanceof Activity) {
                ItemDefinition itemdef;
                Activity ac = (Activity)fe;
                if (ac.getIoSpecification() == null) continue;
                if (ac.getIoSpecification().getDataInputs() != null) {
                    List dataInputs = ac.getIoSpecification().getDataInputs();
                    for (DataInput din : dataInputs) {
                        for (FeatureMap.Entry entry : din.getAnyAttribute()) {
                            String dinType;
                            if (!entry.getEStructuralFeature().getName().equals("dtype") || (dinType = (String)entry.getValue()) == null || dinType.length() <= 0) continue;
                            itemdef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                            itemdef.setId("_" + din.getId() + "Item");
                            itemdef.setStructureRef(dinType);
                            toAddItemDefinitions.add(itemdef);
                            din.setItemSubjectRef(itemdef);
                        }
                    }
                }
                if (ac.getIoSpecification().getDataOutputs() == null) continue;
                List dataOutputs = ac.getIoSpecification().getDataOutputs();
                for (DataOutput dout : dataOutputs) {
                    for (FeatureMap.Entry entry : dout.getAnyAttribute()) {
                        String doutType;
                        if (!entry.getEStructuralFeature().getName().equals("dtype") || (doutType = (String)entry.getValue()) == null || doutType.length() <= 0) continue;
                        itemdef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                        itemdef.setId("_" + dout.getId() + "Item");
                        itemdef.setStructureRef(doutType);
                        toAddItemDefinitions.add(itemdef);
                        dout.setItemSubjectRef(itemdef);
                    }
                }
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setItemDefinitionsForActivitiesIoSpec((FlowElementsContainer)fe, def, toAddItemDefinitions);
        }
    }

    public void revisitSignalRef(Definitions def) {
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            this.setSignalRefForCatchEvents((FlowElementsContainer)((Process)root), def);
            this.setSignalRefForThrowEvents((FlowElementsContainer)((Process)root), def);
            this.setSignalRefForBoundaryEvents((FlowElementsContainer)((Process)root), def);
        }
    }

    public void setSignalRefForCatchEvents(FlowElementsContainer container, Definitions def) {
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            if (fe instanceof CatchEvent) {
                Signal signal;
                SignalEventDefinition sed;
                EventDefinition ed;
                if (((CatchEvent)fe).getEventDefinitions().size() <= 0 || !((ed = (EventDefinition)((CatchEvent)fe).getEventDefinitions().get(0)) instanceof SignalEventDefinition) || (sed = (SignalEventDefinition)ed).getSignalRef() == null || (signal = this.findSignalWithName(sed.getSignalRef(), def)) == null) continue;
                sed.setSignalRef(signal.getId());
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setSignalRefForCatchEvents((FlowElementsContainer)fe, def);
        }
    }

    public void setSignalRefForThrowEvents(FlowElementsContainer container, Definitions def) {
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            if (fe instanceof ThrowEvent) {
                Signal signal;
                SignalEventDefinition sed;
                EventDefinition ed;
                if (((ThrowEvent)fe).getEventDefinitions().size() <= 0 || !((ed = (EventDefinition)((ThrowEvent)fe).getEventDefinitions().get(0)) instanceof SignalEventDefinition) || (sed = (SignalEventDefinition)ed).getSignalRef() == null || (signal = this.findSignalWithName(sed.getSignalRef(), def)) == null) continue;
                sed.setSignalRef(signal.getId());
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setSignalRefForThrowEvents((FlowElementsContainer)fe, def);
        }
    }

    public void setSignalRefForBoundaryEvents(FlowElementsContainer container, Definitions def) {
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            if (fe instanceof BoundaryEvent) {
                Signal signal;
                SignalEventDefinition sed;
                EventDefinition ed;
                if (((BoundaryEvent)fe).getEventDefinitions().size() <= 0 || !((ed = (EventDefinition)((BoundaryEvent)fe).getEventDefinitions().get(0)) instanceof SignalEventDefinition) || (sed = (SignalEventDefinition)ed).getSignalRef() == null || (signal = this.findSignalWithName(sed.getSignalRef(), def)) == null) continue;
                sed.setSignalRef(signal.getId());
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setSignalRefForBoundaryEvents((FlowElementsContainer)fe, def);
        }
    }

    public Signal findSignalWithName(String signalRef, Definitions def) {
        List rootElements = def.getRootElements();
        for (RootElement re : rootElements) {
            if (!(re instanceof Signal) || !((Signal)re).getName().equals(signalRef)) continue;
            return (Signal)re;
        }
        return null;
    }

    public void revisitCatchEvents(Definitions def) {
        List rootElements = def.getRootElements();
        ArrayList<Signal> toAddSignals = new ArrayList<Signal>();
        HashSet<Error> toAddErrors = new HashSet<Error>();
        HashSet<Escalation> toAddEscalations = new HashSet<Escalation>();
        HashSet<Message> toAddMessages = new HashSet<Message>();
        HashSet<ItemDefinition> toAddItemDefinitions = new HashSet<ItemDefinition>();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            this.setCatchEventsInfo((FlowElementsContainer)((Process)root), def, toAddSignals, toAddErrors, toAddEscalations, toAddMessages, toAddItemDefinitions);
        }
        for (Lane lane : this._lanes) {
            this.setCatchEventsInfoForLanes(lane, def, toAddSignals, toAddErrors, toAddEscalations, toAddMessages, toAddItemDefinitions);
        }
        for (Signal s : toAddSignals) {
            def.getRootElements().add(s);
        }
        for (Error er : toAddErrors) {
            def.getRootElements().add(er);
        }
        for (Escalation es : toAddEscalations) {
            def.getRootElements().add(es);
        }
        for (ItemDefinition idef : toAddItemDefinitions) {
            def.getRootElements().add(idef);
        }
        for (Message msg : toAddMessages) {
            def.getRootElements().add(msg);
        }
    }

    public void setCatchEventsInfo(FlowElementsContainer container, Definitions def, List<Signal> toAddSignals, Set<Error> toAddErrors, Set<Escalation> toAddEscalations, Set<Message> toAddMessages, Set<ItemDefinition> toAddItemDefinitions) {
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            if (fe instanceof CatchEvent) {
                if (((CatchEvent)fe).getEventDefinitions().size() <= 0) continue;
                EventDefinition ed = (EventDefinition)((CatchEvent)fe).getEventDefinitions().get(0);
                if (ed instanceof SignalEventDefinition) {
                    this.getSignal((SignalEventDefinition)ed, def.getRootElements(), toAddSignals);
                    continue;
                }
                if (ed instanceof ErrorEventDefinition) {
                    Error err = this.getError(ed);
                    toAddErrors.add(err);
                    ((ErrorEventDefinition)ed).setErrorRef(err);
                    continue;
                }
                if (ed instanceof EscalationEventDefinition) {
                    Escalation escalation = this.getEscalation(ed);
                    toAddEscalations.add(escalation);
                    ((EscalationEventDefinition)ed).setEscalationRef(escalation);
                    continue;
                }
                if (ed instanceof MessageEventDefinition) {
                    ((MessageEventDefinition)ed).setMessageRef(this.getMessage((BaseElement)ed, toAddMessages, toAddItemDefinitions));
                    continue;
                }
                if (!(ed instanceof CompensateEventDefinition)) continue;
                for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                    if (!entry.getEStructuralFeature().getName().equals("actrefname")) continue;
                    String activityNameRef = (String)entry.getValue();
                    List re = def.getRootElements();
                    for (RootElement r : re) {
                        if (!(r instanceof Process)) continue;
                        Process p = (Process)r;
                        List fes = p.getFlowElements();
                        for (FlowElement f : fes) {
                            if (!(f instanceof Activity) || !((Activity)f).getName().equals(activityNameRef)) continue;
                            ((CompensateEventDefinition)ed).setActivityRef((Activity)f);
                            ((Activity)f).setIsForCompensation(true);
                        }
                    }
                }
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setCatchEventsInfo((FlowElementsContainer)fe, def, toAddSignals, toAddErrors, toAddEscalations, toAddMessages, toAddItemDefinitions);
        }
    }

    private Escalation getEscalation(EventDefinition ed) {
        Escalation escalation;
        String escalationCode = null;
        for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
            if (!entry.getEStructuralFeature().getName().equals("esccode")) continue;
            escalationCode = (String)entry.getValue();
            break;
        }
        if ((escalation = this._escalations.get(escalationCode)) == null) {
            escalation = Bpmn2Factory.eINSTANCE.createEscalation();
            escalation.setId(this.getIdForRootElement(escalationCode));
            escalation.setName(escalationCode);
            escalation.setEscalationCode(escalationCode);
            this._escalations.put(escalationCode, escalation);
        }
        return escalation;
    }

    public void setCatchEventsInfoForLanes(Lane lane, Definitions def, List<Signal> toAddSignals, Set<Error> toAddErrors, Set<Escalation> toAddEscalations, Set<Message> toAddMessages, Set<ItemDefinition> toAddItemDefinitions) {
        List laneFlowNodes = lane.getFlowNodeRefs();
        for (FlowElement fe : laneFlowNodes) {
            if (fe instanceof CatchEvent) {
                if (((CatchEvent)fe).getEventDefinitions().size() <= 0) continue;
                EventDefinition ed = (EventDefinition)((CatchEvent)fe).getEventDefinitions().get(0);
                if (ed instanceof SignalEventDefinition) {
                    this.getSignal((SignalEventDefinition)ed, def.getRootElements(), toAddSignals);
                    continue;
                }
                if (ed instanceof ErrorEventDefinition) {
                    Error err = this.getError(ed);
                    toAddErrors.add(err);
                    ((ErrorEventDefinition)ed).setErrorRef(err);
                    continue;
                }
                if (ed instanceof EscalationEventDefinition) {
                    Escalation escalation = this.getEscalation(ed);
                    toAddEscalations.add(escalation);
                    ((EscalationEventDefinition)ed).setEscalationRef(escalation);
                    continue;
                }
                if (ed instanceof MessageEventDefinition) {
                    ((MessageEventDefinition)ed).setMessageRef(this.getMessage((BaseElement)ed, toAddMessages, toAddItemDefinitions));
                    continue;
                }
                if (!(ed instanceof CompensateEventDefinition)) continue;
                for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                    if (!entry.getEStructuralFeature().getName().equals("actrefname")) continue;
                    String activityNameRef = (String)entry.getValue();
                    List re = def.getRootElements();
                    for (RootElement r : re) {
                        if (!(r instanceof Process)) continue;
                        Process p = (Process)r;
                        List fes = p.getFlowElements();
                        for (FlowElement f : fes) {
                            if (!(f instanceof Activity) || !((Activity)f).getName().equals(activityNameRef)) continue;
                            ((CompensateEventDefinition)ed).setActivityRef((Activity)f);
                            ((Activity)f).setIsForCompensation(true);
                        }
                    }
                }
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setCatchEventsInfo((FlowElementsContainer)fe, def, toAddSignals, toAddErrors, toAddEscalations, toAddMessages, toAddItemDefinitions);
        }
    }

    private void revisitGateways(Definitions def) {
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            this.setGatewayInfo((FlowElementsContainer)((Process)root));
        }
    }

    private void setGatewayInfo(FlowElementsContainer container) {
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            FormalExpression expr;
            String[] entryValueParts;
            String entryValueId;
            String entryName;
            String entryValue;
            FeatureMap.Entry entry;
            Iterator iter;
            if (fe instanceof Gateway) {
                int outgoing;
                Gateway gateway = (Gateway)fe;
                int incoming = gateway.getIncoming() == null ? 0 : gateway.getIncoming().size();
                int n = outgoing = gateway.getOutgoing() == null ? 0 : gateway.getOutgoing().size();
                if (incoming <= 1 && outgoing > 1) {
                    gateway.setGatewayDirection(GatewayDirection.DIVERGING);
                } else if (incoming > 1 && outgoing <= 1) {
                    gateway.setGatewayDirection(GatewayDirection.CONVERGING);
                } else {
                    gateway.setGatewayDirection(GatewayDirection.UNSPECIFIED);
                }
            }
            if (fe instanceof InclusiveGateway) {
                iter = fe.getAnyAttribute().iterator();
                InclusiveGateway ig = (InclusiveGateway)fe;
                ArrayList sqList = new ArrayList();
                if (ig.getIncoming() != null) {
                    sqList.addAll(ig.getIncoming());
                }
                if (ig.getOutgoing() != null) {
                    sqList.addAll(ig.getOutgoing());
                }
                while (iter.hasNext()) {
                    entry = (FeatureMap.Entry)iter.next();
                    if (!entry.getEStructuralFeature().getName().equals("dg")) continue;
                    for (SequenceFlow newFlow : sqList) {
                        entryValue = (String)entry.getValue();
                        entryName = null;
                        entryValueId = "";
                        entryValueParts = entryValue.split(" : ");
                        if (entryValueParts.length == 1) {
                            entryValueId = entryValueParts[0];
                        } else if (entryValueParts.length > 1) {
                            entryName = entryValueParts[0];
                            entryValueId = entryValueParts[1];
                        }
                        if (!newFlow.getId().equals(entryValueId) && (newFlow.getName() == null || entryName == null || !newFlow.getName().equals(entryName))) continue;
                        ig.setDefault(newFlow);
                        if (newFlow.getConditionExpression() != null) continue;
                        expr = Bpmn2Factory.eINSTANCE.createFormalExpression();
                        expr.setBody("");
                        newFlow.setConditionExpression((Expression)expr);
                    }
                }
            }
            if (fe instanceof ExclusiveGateway) {
                iter = fe.getAnyAttribute().iterator();
                ExclusiveGateway eg = (ExclusiveGateway)fe;
                ArrayList sqList = new ArrayList();
                if (eg.getIncoming() != null) {
                    sqList.addAll(eg.getIncoming());
                }
                if (eg.getOutgoing() != null) {
                    sqList.addAll(eg.getOutgoing());
                }
                while (iter.hasNext()) {
                    entry = (FeatureMap.Entry)iter.next();
                    if (!entry.getEStructuralFeature().getName().equals("dg")) continue;
                    for (SequenceFlow newFlow : sqList) {
                        entryValue = (String)entry.getValue();
                        entryName = null;
                        entryValueId = "";
                        entryValueParts = entryValue.split(" : ");
                        if (entryValueParts.length == 1) {
                            entryValueId = entryValueParts[0];
                        } else if (entryValueParts.length > 1) {
                            entryName = entryValueParts[0];
                            entryValueId = entryValueParts[1];
                        }
                        if (!newFlow.getId().equals(entryValueId) && (newFlow.getName() == null || entryName == null || !newFlow.getName().equals(entryName))) continue;
                        eg.setDefault(newFlow);
                        if (newFlow.getConditionExpression() != null) continue;
                        expr = Bpmn2Factory.eINSTANCE.createFormalExpression();
                        expr.setBody("");
                        newFlow.setConditionExpression((Expression)expr);
                    }
                }
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setGatewayInfo((FlowElementsContainer)fe);
        }
    }

    private void revisitServiceTasks(Definitions def) {
        List rootElements = def.getRootElements();
        ArrayList<Interface> toAddInterfaces = new ArrayList<Interface>();
        ArrayList<Message> toAddMessages = new ArrayList<Message>();
        ArrayList<ItemDefinition> toAddDefinitions = new ArrayList<ItemDefinition>();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            this.revisitServiceTasksExecute((FlowElementsContainer)((Process)root), rootElements, toAddInterfaces, toAddMessages, toAddDefinitions);
        }
        for (Lane lane : this._lanes) {
            this.revisitServiceTasksExecuteForLanes(lane, def, rootElements, toAddInterfaces, toAddMessages, toAddDefinitions);
        }
        for (ItemDefinition id : toAddDefinitions) {
            def.getRootElements().add(id);
        }
        for (Message m : toAddMessages) {
            def.getRootElements().add(m);
        }
        for (Interface i : toAddInterfaces) {
            def.getRootElements().add(i);
        }
    }

    private void revisitServiceTasksExecuteForLanes(Lane lane, Definitions def, List<RootElement> rootElements, List<Interface> toAddInterfaces, List<Message> toAddMessages, List<ItemDefinition> toAddDefinitions) {
        List laneFlowNodes = lane.getFlowNodeRefs();
        for (FlowElement fe : laneFlowNodes) {
            if (fe instanceof ServiceTask) {
                Interface toadd2;
                Iterator iter = fe.getAnyAttribute().iterator();
                String serviceImplementation = null;
                String serviceInterface = null;
                String serviceOperation = null;
                EStructuralFeature serviceInterfaceFeature = null;
                EStructuralFeature serviceOperationFeature = null;
                while (iter.hasNext()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)iter.next();
                    if (entry.getEStructuralFeature().getName().equals("serviceimplementation")) {
                        serviceImplementation = (String)entry.getValue();
                    }
                    if (entry.getEStructuralFeature().getName().equals("serviceoperation")) {
                        serviceOperation = (String)entry.getValue();
                        serviceOperationFeature = entry.getEStructuralFeature();
                    }
                    if (!entry.getEStructuralFeature().getName().equals("serviceinterface")) continue;
                    serviceInterface = (String)entry.getValue();
                    serviceInterfaceFeature = entry.getEStructuralFeature();
                }
                boolean foundInterface = false;
                Interface touseInterface = null;
                if (serviceImplementation != null && serviceImplementation.equals("Java")) {
                    for (RootElement iroot : rootElements) {
                        if (!(iroot instanceof Interface) || !((Interface)iroot).getName().equals(serviceInterface)) continue;
                        foundInterface = true;
                        touseInterface = (Interface)iroot;
                        break;
                    }
                    if (!foundInterface) {
                        for (Interface toadd2 : toAddInterfaces) {
                            if (toadd2.getName() == null || !toadd2.getName().equals(serviceInterface)) continue;
                            foundInterface = true;
                            touseInterface = toadd2;
                            break;
                        }
                    }
                } else if (serviceImplementation != null && serviceImplementation.equals("##WebService")) {
                    for (RootElement iroot : rootElements) {
                        if (!(iroot instanceof Interface) || !((Interface)iroot).getImplementationRef().equals(serviceInterface)) continue;
                        foundInterface = true;
                        touseInterface = (Interface)iroot;
                        break;
                    }
                    if (!foundInterface) {
                        for (Interface toadd2 : toAddInterfaces) {
                            if (!toadd2.getImplementationRef().equals(serviceInterface)) continue;
                            foundInterface = true;
                            touseInterface = toadd2;
                            break;
                        }
                    }
                }
                if (!foundInterface) {
                    touseInterface = Bpmn2Factory.eINSTANCE.createInterface();
                    if (serviceInterface == null || serviceInterface.length() == 0) {
                        serviceInterface = fe.getId() + "_ServiceInterface";
                        if (serviceInterfaceFeature != null) {
                            fe.getAnyAttribute().set(serviceInterfaceFeature, (Object)serviceInterface);
                        }
                    }
                    touseInterface.setName(serviceInterface);
                    touseInterface.setImplementationRef(serviceInterface);
                    touseInterface.setId(fe.getId() + "_ServiceInterface");
                    toAddInterfaces.add(touseInterface);
                }
                if (serviceOperation == null) continue;
                boolean foundOperation = false;
                toadd2 = touseInterface.getOperations().iterator();
                while (toadd2.hasNext()) {
                    Operation oper = (Operation)toadd2.next();
                    if (serviceImplementation != null && serviceImplementation.equals("Java")) {
                        if (!oper.getName().equals(serviceOperation)) continue;
                        foundOperation = true;
                        break;
                    }
                    if (serviceImplementation == null || !serviceImplementation.equals("##WebService") || !oper.getImplementationRef().equals(serviceOperation)) continue;
                    foundOperation = true;
                    break;
                }
                if (foundOperation) continue;
                Operation touseOperation = Bpmn2Factory.eINSTANCE.createOperation();
                if (serviceOperation == null || serviceOperation.length() == 0) {
                    serviceOperation = fe.getId() + "_ServiceOperation";
                    if (serviceOperationFeature != null) {
                        fe.getAnyAttribute().set(serviceOperationFeature, (Object)serviceOperation);
                    }
                }
                touseOperation.setId(fe.getId() + "_ServiceOperation");
                touseOperation.setName(serviceOperation);
                touseOperation.setImplementationRef(serviceOperation);
                Message message = Bpmn2Factory.eINSTANCE.createMessage();
                message.setId(fe.getId() + "_InMessage");
                ItemDefinition itemdef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                itemdef.setId(message.getId() + "Type");
                message.setItemRef(itemdef);
                toAddDefinitions.add(itemdef);
                toAddMessages.add(message);
                touseOperation.setInMessageRef(message);
                touseInterface.getOperations().add(touseOperation);
                ((ServiceTask)fe).setOperationRef(touseOperation);
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.revisitServiceTasksExecute((FlowElementsContainer)fe, rootElements, toAddInterfaces, toAddMessages, toAddDefinitions);
        }
    }

    private void revisitServiceTasksExecute(FlowElementsContainer container, List<RootElement> rootElements, List<Interface> toAddInterfaces, List<Message> toAddMessages, List<ItemDefinition> toAddDefinitions) {
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            if (fe instanceof ServiceTask) {
                Interface toadd2;
                Iterator iter = fe.getAnyAttribute().iterator();
                String serviceImplementation = null;
                String serviceInterface = null;
                String serviceOperation = null;
                EStructuralFeature serviceInterfaceFeature = null;
                EStructuralFeature serviceOperationFeature = null;
                while (iter.hasNext()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)iter.next();
                    if (entry.getEStructuralFeature().getName().equals("serviceimplementation")) {
                        serviceImplementation = (String)entry.getValue();
                    }
                    if (entry.getEStructuralFeature().getName().equals("serviceoperation")) {
                        serviceOperation = (String)entry.getValue();
                        serviceOperationFeature = entry.getEStructuralFeature();
                    }
                    if (!entry.getEStructuralFeature().getName().equals("serviceinterface")) continue;
                    serviceInterface = (String)entry.getValue();
                    serviceInterfaceFeature = entry.getEStructuralFeature();
                }
                boolean foundInterface = false;
                Interface touseInterface = null;
                if (serviceImplementation != null && serviceImplementation.equals("Java")) {
                    for (RootElement iroot : rootElements) {
                        if (!(iroot instanceof Interface) || !((Interface)iroot).getName().equals(serviceInterface)) continue;
                        foundInterface = true;
                        touseInterface = (Interface)iroot;
                        break;
                    }
                    if (!foundInterface) {
                        for (Interface toadd2 : toAddInterfaces) {
                            if (toadd2.getName() == null || !toadd2.getName().equals(serviceInterface)) continue;
                            foundInterface = true;
                            touseInterface = toadd2;
                            break;
                        }
                    }
                } else if (serviceImplementation != null && serviceImplementation.equals("##WebService")) {
                    for (RootElement iroot : rootElements) {
                        if (!(iroot instanceof Interface) || !((Interface)iroot).getImplementationRef().equals(serviceInterface)) continue;
                        foundInterface = true;
                        touseInterface = (Interface)iroot;
                        break;
                    }
                    if (!foundInterface) {
                        for (Interface toadd2 : toAddInterfaces) {
                            if (!toadd2.getImplementationRef().equals(serviceInterface)) continue;
                            foundInterface = true;
                            touseInterface = toadd2;
                            break;
                        }
                    }
                }
                if (!foundInterface) {
                    touseInterface = Bpmn2Factory.eINSTANCE.createInterface();
                    if (serviceInterface == null || serviceInterface.length() == 0) {
                        serviceInterface = fe.getId() + "_ServiceInterface";
                        if (serviceInterfaceFeature != null) {
                            fe.getAnyAttribute().set(serviceInterfaceFeature, (Object)serviceInterface);
                        }
                    }
                    touseInterface.setName(serviceInterface);
                    touseInterface.setImplementationRef(serviceInterface);
                    touseInterface.setId(fe.getId() + "_ServiceInterface");
                    toAddInterfaces.add(touseInterface);
                }
                if (serviceOperation == null) continue;
                boolean foundOperation = false;
                toadd2 = touseInterface.getOperations().iterator();
                while (toadd2.hasNext()) {
                    Operation oper = (Operation)toadd2.next();
                    if (serviceImplementation != null && serviceImplementation.equals("Java")) {
                        if (!oper.getName().equals(serviceOperation)) continue;
                        foundOperation = true;
                        break;
                    }
                    if (serviceImplementation == null || !serviceImplementation.equals("##WebService") || !oper.getImplementationRef().equals(serviceOperation)) continue;
                    foundOperation = true;
                    break;
                }
                if (foundOperation) continue;
                Operation touseOperation = Bpmn2Factory.eINSTANCE.createOperation();
                if (serviceOperation == null || serviceOperation.length() == 0) {
                    serviceOperation = fe.getId() + "_ServiceOperation";
                    if (serviceOperationFeature != null) {
                        fe.getAnyAttribute().set(serviceOperationFeature, (Object)serviceOperation);
                    }
                }
                touseOperation.setId(fe.getId() + "_ServiceOperation");
                touseOperation.setName(serviceOperation);
                touseOperation.setImplementationRef(serviceOperation);
                Message message = Bpmn2Factory.eINSTANCE.createMessage();
                message.setId(fe.getId() + "_InMessage");
                ItemDefinition itemdef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                itemdef.setId(message.getId() + "Type");
                message.setItemRef(itemdef);
                toAddDefinitions.add(itemdef);
                toAddMessages.add(message);
                touseOperation.setInMessageRef(message);
                touseInterface.getOperations().add(touseOperation);
                ((ServiceTask)fe).setOperationRef(touseOperation);
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.revisitServiceTasksExecute((FlowElementsContainer)fe, rootElements, toAddInterfaces, toAddMessages, toAddDefinitions);
        }
    }

    private void revisitMessages(Definitions def) {
        List rootElements = def.getRootElements();
        ArrayList<ItemDefinition> toAddDefinitions = new ArrayList<ItemDefinition>();
        for (RootElement root : rootElements) {
            if (!(root instanceof Message) || this.existsMessageItemDefinition(rootElements, root.getId())) continue;
            ItemDefinition itemdef = Bpmn2Factory.eINSTANCE.createItemDefinition();
            itemdef.setId(root.getId() + "Type");
            toAddDefinitions.add(itemdef);
            ((Message)root).setItemRef(itemdef);
        }
        for (ItemDefinition id : toAddDefinitions) {
            def.getRootElements().add(id);
        }
    }

    private boolean existsMessageItemDefinition(List<RootElement> rootElements, String id) {
        for (RootElement root : rootElements) {
            if (!(root instanceof ItemDefinition) || !root.getId().equals(id + "Type")) continue;
            return true;
        }
        return false;
    }

    private ItemDefinition getMessageItemDefinition(List<RootElement> rootElements, String id) {
        String testId = "_" + id + "Item";
        for (RootElement root : rootElements) {
            if (!(root instanceof ItemDefinition) || !root.getId().equals(testId)) continue;
            return (ItemDefinition)root;
        }
        return null;
    }

    private void reconnectFlows() {
        for (Map.Entry<Object, List<String>> entry : this._outgoingFlows.entrySet()) {
            for (String flowId : entry.getValue()) {
                if (entry.getKey() instanceof SequenceFlow) {
                    if (this._idMap.get(flowId) instanceof FlowNode) {
                        ((SequenceFlow)entry.getKey()).setTargetRef((FlowNode)this._idMap.get(flowId));
                    }
                    if (!(this._idMap.get(flowId) instanceof Association)) continue;
                    ((Association)this._idMap.get(flowId)).setTargetRef((BaseElement)((SequenceFlow)entry.getKey()));
                    continue;
                }
                if (entry.getKey() instanceof Association) {
                    ((Association)entry.getKey()).setTargetRef((BaseElement)this._idMap.get(flowId));
                    continue;
                }
                if (this._idMap.get(flowId) instanceof SequenceFlow) {
                    ((FlowNode)entry.getKey()).getOutgoing().add((SequenceFlow)this._idMap.get(flowId));
                    continue;
                }
                if (!(this._idMap.get(flowId) instanceof Association)) continue;
                ((Association)this._idMap.get(flowId)).setSourceRef((BaseElement)entry.getKey());
            }
        }
    }

    private void createSubProcessDiagram(BPMNPlane plane, FlowElement flowElement, BpmnDiFactory factory) {
        SubProcess sp = (SubProcess)flowElement;
        for (FlowElement subProcessFlowElement : sp.getFlowElements()) {
            if (subProcessFlowElement instanceof SubProcess) {
                this.createBpmnShapeForElement(factory, plane, (BaseElement)subProcessFlowElement);
                this.createSubProcessDiagram(plane, subProcessFlowElement, factory);
                continue;
            }
            if (subProcessFlowElement instanceof FlowNode) {
                this.createBpmnShapeForElement(factory, plane, (BaseElement)subProcessFlowElement);
                if (!(subProcessFlowElement instanceof BoundaryEvent)) continue;
                this.createDockersForBoundaryEvent((BoundaryEvent)subProcessFlowElement);
                continue;
            }
            if (!(subProcessFlowElement instanceof SequenceFlow)) continue;
            this.createBpmnEdgeForSequenceFlow(factory, plane, (SequenceFlow)subProcessFlowElement);
        }
        if (sp.getArtifacts() != null) {
            ArrayList<Association> incompleteAssociations = new ArrayList<Association>();
            for (Artifact artifact : sp.getArtifacts()) {
                if (artifact instanceof Group) {
                    this.createBpmnShapeForElement(factory, plane, (BaseElement)artifact);
                }
                if (!(artifact instanceof Association)) continue;
                Association association = (Association)artifact;
                if (association.getSourceRef() != null && association.getTargetRef() != null) {
                    this.createBpmnEdgeForAssociation(factory, plane, association);
                    continue;
                }
                incompleteAssociations.add(association);
            }
            if (!incompleteAssociations.isEmpty()) {
                for (Association incompleteAssociation : incompleteAssociations) {
                    sp.getArtifacts().remove(incompleteAssociation);
                }
            }
        }
    }

    private void createDiagram(Definitions def) {
        for (RootElement rootElement : def.getRootElements()) {
            if (!(rootElement instanceof Process)) continue;
            Process process = (Process)rootElement;
            BpmnDiFactory factory = BpmnDiFactory.eINSTANCE;
            BPMNDiagram diagram = factory.createBPMNDiagram();
            BPMNPlane plane = factory.createBPMNPlane();
            plane.setBpmnElement((BaseElement)process);
            diagram.setPlane(plane);
            for (Object flowElement : process.getFlowElements()) {
                if (flowElement instanceof FlowNode) {
                    this.createBpmnShapeForElement(factory, plane, (BaseElement)flowElement);
                    if (flowElement instanceof BoundaryEvent) {
                        this.createDockersForBoundaryEvent((BoundaryEvent)flowElement);
                    }
                    if (!(flowElement instanceof SubProcess)) continue;
                    this.createSubProcessDiagram(plane, (FlowElement)flowElement, factory);
                    continue;
                }
                if (flowElement instanceof DataObject) {
                    this.createBpmnShapeForElement(factory, plane, (BaseElement)flowElement);
                    continue;
                }
                if (!(flowElement instanceof SequenceFlow)) continue;
                this.createBpmnEdgeForSequenceFlow(factory, plane, (SequenceFlow)flowElement);
            }
            if (process.getArtifacts() != null) {
                Object flowElement;
                ArrayList<Association> incompleteAssociations = new ArrayList<Association>();
                flowElement = process.getArtifacts().iterator();
                while (flowElement.hasNext()) {
                    Artifact artifact = (Artifact)flowElement.next();
                    if (artifact instanceof Group) {
                        this.createBpmnShapeForElement(factory, plane, (BaseElement)artifact);
                    }
                    if (!(artifact instanceof Association)) continue;
                    Association association = (Association)artifact;
                    if (association.getSourceRef() != null && association.getTargetRef() != null) {
                        this.createBpmnEdgeForAssociation(factory, plane, association);
                        continue;
                    }
                    incompleteAssociations.add(association);
                }
                if (!incompleteAssociations.isEmpty()) {
                    flowElement = incompleteAssociations.iterator();
                    while (flowElement.hasNext()) {
                        Association incompleteAssociation = (Association)flowElement.next();
                        process.getArtifacts().remove(incompleteAssociation);
                    }
                }
            }
            if (process.getLaneSets() != null && process.getLaneSets().size() > 0) {
                for (LaneSet ls : process.getLaneSets()) {
                    for (Lane lane : ls.getLanes()) {
                        this.createBpmnShapeForElement(factory, plane, (BaseElement)lane);
                    }
                }
            }
            def.getDiagrams().add(diagram);
        }
    }

    private void createBpmnShapeForElement(BpmnDiFactory factory, BPMNPlane plane, BaseElement element) {
        Bounds bounds = this._bounds.get(element.getId());
        if (bounds != null) {
            BPMNShape shape = factory.createBPMNShape();
            shape.setBpmnElement(element);
            shape.setBounds(bounds);
            plane.getPlaneElement().add(shape);
        }
    }

    private void createDockersForBoundaryEvent(BoundaryEvent boundaryEvent) {
        List<Point> dockers = this._dockers.get(boundaryEvent.getId());
        StringBuffer dockerBuff = new StringBuffer();
        for (int i = 0; i < dockers.size(); ++i) {
            dockerBuff.append(dockers.get(i).getX());
            dockerBuff.append("^");
            dockerBuff.append(dockers.get(i).getY());
            dockerBuff.append("|");
        }
        ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
        EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dockerinfo", false, false);
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)dockerBuff.toString());
        boundaryEvent.getAnyAttribute().add((Object)extensionEntry);
    }

    private void createBpmnEdgeForSequenceFlow(BpmnDiFactory factory, BPMNPlane plane, SequenceFlow sequenceFlow) {
        BPMNEdge edge = factory.createBPMNEdge();
        edge.setBpmnElement((BaseElement)sequenceFlow);
        DcFactory dcFactory = DcFactory.eINSTANCE;
        Point point = dcFactory.createPoint();
        if (sequenceFlow.getSourceRef() != null) {
            Bounds sourceBounds = this._bounds.get(sequenceFlow.getSourceRef().getId());
            point.setX(sourceBounds.getX() + sourceBounds.getWidth() / 2.0f);
            point.setY(sourceBounds.getY() + sourceBounds.getHeight() / 2.0f);
        }
        edge.getWaypoint().add(point);
        List<Point> dockers = this._dockers.get(sequenceFlow.getId());
        for (int i = 1; i < dockers.size() - 1; ++i) {
            edge.getWaypoint().add(dockers.get(i));
        }
        point = dcFactory.createPoint();
        if (sequenceFlow.getTargetRef() != null) {
            Bounds targetBounds = this._bounds.get(sequenceFlow.getTargetRef().getId());
            point.setX(targetBounds.getX() + targetBounds.getWidth() / 2.0f);
            point.setY(targetBounds.getY() + targetBounds.getHeight() / 2.0f);
        }
        edge.getWaypoint().add(point);
        plane.getPlaneElement().add(edge);
    }

    private void createBpmnEdgeForAssociation(BpmnDiFactory factory, BPMNPlane plane, Association association) {
        BPMNEdge edge = factory.createBPMNEdge();
        edge.setBpmnElement((BaseElement)association);
        DcFactory dcFactory = DcFactory.eINSTANCE;
        Point point = dcFactory.createPoint();
        Bounds sourceBounds = this._bounds.get(association.getSourceRef().getId());
        point.setX(sourceBounds.getX() + sourceBounds.getWidth() / 2.0f);
        point.setY(sourceBounds.getY() + sourceBounds.getHeight() / 2.0f);
        edge.getWaypoint().add(point);
        List<Point> dockers = this._dockers.get(association.getId());
        for (int i = 1; i < dockers.size() - 1; ++i) {
            edge.getWaypoint().add(dockers.get(i));
        }
        point = dcFactory.createPoint();
        Bounds targetBounds = this._bounds.get(association.getTargetRef().getId());
        point.setX(targetBounds.getX() + targetBounds.getWidth() / 2.0f);
        point.setY(targetBounds.getY() + targetBounds.getHeight() / 2.0f);
        edge.getWaypoint().add(point);
        plane.getPlaneElement().add(edge);
    }

    public BaseElement unmarshallItem(JsonParser parser, String preProcessingData) throws JsonParseException, IOException {
        String resourceId = null;
        Map<String, String> properties = null;
        String stencil = null;
        ArrayList<BaseElement> childElements = new ArrayList<BaseElement>();
        ArrayList<String> outgoing = new ArrayList<String>();
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = parser.getCurrentName();
            parser.nextToken();
            if ("resourceId".equals(fieldname)) {
                resourceId = parser.getText();
                continue;
            }
            if ("properties".equals(fieldname)) {
                properties = this.unmarshallProperties(parser);
                continue;
            }
            if ("stencil".equals(fieldname)) {
                parser.nextToken();
                parser.nextToken();
                stencil = parser.getText();
                parser.nextToken();
                continue;
            }
            if ("childShapes".equals(fieldname)) {
                while (parser.nextToken() != JsonToken.END_ARRAY) {
                    childElements.add(this.unmarshallItem(parser, preProcessingData));
                }
                continue;
            }
            if ("bounds".equals(fieldname)) {
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                Integer x2 = parser.getIntValue();
                parser.nextToken();
                parser.nextToken();
                Integer y2 = parser.getIntValue();
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                Integer x1 = parser.getIntValue();
                parser.nextToken();
                parser.nextToken();
                Integer y1 = parser.getIntValue();
                parser.nextToken();
                parser.nextToken();
                Bounds b = DcFactory.eINSTANCE.createBounds();
                b.setX((float)x1.intValue());
                b.setY((float)y1.intValue());
                b.setWidth((float)(x2 - x1));
                b.setHeight((float)(y2 - y1));
                this._bounds.put(resourceId, b);
                continue;
            }
            if ("dockers".equals(fieldname)) {
                ArrayList<Point> dockers = new ArrayList<Point>();
                JsonToken nextToken = parser.nextToken();
                boolean end = JsonToken.END_ARRAY.equals((Object)nextToken);
                while (!end) {
                    nextToken = parser.nextToken();
                    nextToken = parser.nextToken();
                    String[] x = Integer.valueOf(parser.getIntValue());
                    parser.nextToken();
                    parser.nextToken();
                    Integer y = parser.getIntValue();
                    Point point = DcFactory.eINSTANCE.createPoint();
                    point.setX((float)x.intValue());
                    point.setY((float)y.intValue());
                    dockers.add(point);
                    parser.nextToken();
                    nextToken = parser.nextToken();
                    end = JsonToken.END_ARRAY.equals((Object)nextToken);
                }
                this._dockers.put(resourceId, dockers);
                continue;
            }
            if ("outgoing".equals(fieldname)) {
                while (parser.nextToken() != JsonToken.END_ARRAY) {
                    parser.nextToken();
                    parser.nextToken();
                    outgoing.add(parser.getText());
                    parser.nextToken();
                }
                parser.skipChildren();
                continue;
            }
            if (!"target".equals(fieldname)) continue;
            parser.skipChildren();
        }
        properties.put("resourceId", resourceId);
        boolean customElement = this.isCustomElement((String)properties.get("tasktype"), preProcessingData);
        BaseElement baseElt = this.createBaseElement(stencil, properties.get("tasktype"), customElement);
        if (baseElt instanceof SequenceFlow) {
            this._sequenceFlowTargets.addAll(outgoing);
        }
        this._outgoingFlows.put(baseElt, outgoing);
        this._objMap.put(baseElt, resourceId);
        this._idMap.put(resourceId, baseElt);
        this.applyProperties(baseElt, properties, preProcessingData);
        if (baseElt instanceof Definitions) {
            Process rootLevelProcess = null;
            if (childElements == null || childElements.size() < 1) {
                if (rootLevelProcess == null) {
                    rootLevelProcess = Bpmn2Factory.eINSTANCE.createProcess();
                    if (properties.get("vardefs") != null && properties.get("vardefs").length() > 0) {
                        String[] vardefs;
                        for (String vardef : vardefs = properties.get("vardefs").split(",\\s*")) {
                            Property prop = Bpmn2Factory.eINSTANCE.createProperty();
                            ItemDefinition itemdef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                            if (vardef.contains(":")) {
                                String[] vardefParts = vardef.split(":\\s*");
                                prop.setId(vardefParts[0]);
                                itemdef.setId("_" + prop.getId() + "Item");
                                boolean haveKPI = false;
                                String kpiValue = "";
                                if (vardefParts.length == 3) {
                                    itemdef.setStructureRef(vardefParts[1]);
                                    if (vardefParts[2].equals("true")) {
                                        haveKPI = true;
                                        kpiValue = vardefParts[2];
                                    }
                                }
                                if (vardefParts.length == 2) {
                                    if (vardefParts[1].equals("true") || vardefParts[1].equals("false")) {
                                        if (vardefParts[1].equals("true")) {
                                            haveKPI = true;
                                            kpiValue = vardefParts[1];
                                        }
                                    } else {
                                        itemdef.setStructureRef(vardefParts[1]);
                                    }
                                }
                                if (haveKPI) {
                                    Utils.setMetaDataExtensionValue((BaseElement)prop, "customKPI", this.wrapInCDATABlock(kpiValue));
                                }
                            } else {
                                prop.setId(vardef);
                                itemdef.setId("_" + prop.getId() + "Item");
                            }
                            prop.setItemSubjectRef(itemdef);
                            rootLevelProcess.getProperties().add(prop);
                            ((Definitions)baseElt).getRootElements().add(itemdef);
                        }
                    }
                    if (properties.get("adhocprocess") != null && properties.get("adhocprocess").equals("true")) {
                        ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
                        EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "adHoc", false, false);
                        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("adhocprocess"));
                        rootLevelProcess.getAnyAttribute().add((Object)extensionEntry);
                    }
                    if (properties.get("customdescription") != null && properties.get("customdescription").length() > 0) {
                        Utils.setMetaDataExtensionValue((BaseElement)rootLevelProcess, "customDescription", this.wrapInCDATABlock(properties.get("customdescription")));
                    }
                    if (properties.get("customcaseidprefix") != null && properties.get("customcaseidprefix").length() > 0) {
                        Utils.setMetaDataExtensionValue((BaseElement)rootLevelProcess, "customCaseIdPrefix", this.wrapInCDATABlock(properties.get("customcaseidprefix")));
                    }
                    if (properties.get("customcaseroles") != null && properties.get("customcaseroles").length() > 0) {
                        Utils.setMetaDataExtensionValue((BaseElement)rootLevelProcess, "customCaseRoles", this.wrapInCDATABlock(properties.get("customcaseroles")));
                    }
                    rootLevelProcess.setId(properties.get("id"));
                    this.applyProcessProperties(rootLevelProcess, properties);
                    ((Definitions)baseElt).getRootElements().add(rootLevelProcess);
                }
            } else {
                for (BaseElement child : childElements) {
                    if (child instanceof SequenceFlow) {
                        List<String> ids = this._outgoingFlows.get(child);
                        FlowElementsContainer container = null;
                        for (String id : ids) {
                            Object obj = this._idMap.get(id);
                            if (!(obj instanceof EObject) || !(((EObject)obj).eContainer() instanceof FlowElementsContainer)) continue;
                            container = (FlowElementsContainer)((EObject)obj).eContainer();
                            break;
                        }
                        if (container != null) {
                            container.getFlowElements().add((SequenceFlow)child);
                            continue;
                        }
                    }
                    if ((child instanceof Task || child instanceof SequenceFlow || child instanceof Gateway || child instanceof Event || child instanceof Artifact || child instanceof DataObject || child instanceof SubProcess || child instanceof Lane || child instanceof CallActivity || child instanceof TextAnnotation) && rootLevelProcess == null) {
                        rootLevelProcess = Bpmn2Factory.eINSTANCE.createProcess();
                        if (properties.get("vardefs") != null && properties.get("vardefs").length() > 0) {
                            FlowElementsContainer vardefs;
                            for (FlowElementsContainer vardef : vardefs = properties.get("vardefs").split(",\\s*")) {
                                Property prop = Bpmn2Factory.eINSTANCE.createProperty();
                                ItemDefinition itemdef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                                if (vardef.contains(":")) {
                                    String[] vardefParts = vardef.split(":\\s*");
                                    prop.setId(vardefParts[0]);
                                    itemdef.setId("_" + prop.getId() + "Item");
                                    boolean haveKPI = false;
                                    String kpiValue = "";
                                    if (vardefParts.length == 3) {
                                        itemdef.setStructureRef(vardefParts[1]);
                                        if (vardefParts[2].equals("true")) {
                                            haveKPI = true;
                                            kpiValue = vardefParts[2];
                                        }
                                    }
                                    if (vardefParts.length == 2) {
                                        if (vardefParts[1].equals("true") || vardefParts[1].equals("false")) {
                                            if (vardefParts[1].equals("true")) {
                                                haveKPI = true;
                                                kpiValue = vardefParts[1];
                                            }
                                        } else {
                                            itemdef.setStructureRef(vardefParts[1]);
                                        }
                                    }
                                    if (haveKPI) {
                                        Utils.setMetaDataExtensionValue((BaseElement)prop, "customKPI", this.wrapInCDATABlock(kpiValue));
                                    }
                                } else {
                                    prop.setId((String)vardef);
                                    itemdef.setId("_" + prop.getId() + "Item");
                                }
                                prop.setItemSubjectRef(itemdef);
                                rootLevelProcess.getProperties().add(prop);
                                ((Definitions)baseElt).getRootElements().add(itemdef);
                            }
                        }
                        if (properties.get("adhocprocess") != null && properties.get("adhocprocess").equals("true")) {
                            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
                            EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "adHoc", false, false);
                            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("adhocprocess"));
                            rootLevelProcess.getAnyAttribute().add((Object)extensionEntry);
                        }
                        if (properties.get("customdescription") != null && properties.get("customdescription").length() > 0) {
                            Utils.setMetaDataExtensionValue((BaseElement)rootLevelProcess, "customDescription", this.wrapInCDATABlock(properties.get("customdescription")));
                        }
                        if (properties.get("customcaseidprefix") != null && properties.get("customcaseidprefix").length() > 0) {
                            Utils.setMetaDataExtensionValue((BaseElement)rootLevelProcess, "customCaseIdPrefix", this.wrapInCDATABlock(properties.get("customcaseidprefix")));
                        }
                        if (properties.get("customcaseroles") != null && properties.get("customcaseroles").length() > 0) {
                            Utils.setMetaDataExtensionValue((BaseElement)rootLevelProcess, "customCaseRoles", this.wrapInCDATABlock(properties.get("customcaseroles")));
                        }
                        rootLevelProcess.setId(properties.get("id"));
                        this.applyProcessProperties(rootLevelProcess, properties);
                        ((Definitions)baseElt).getRootElements().add(rootLevelProcess);
                    }
                    if (child instanceof Task) {
                        rootLevelProcess.getFlowElements().add((Task)child);
                        continue;
                    }
                    if (child instanceof CallActivity) {
                        rootLevelProcess.getFlowElements().add((CallActivity)child);
                        continue;
                    }
                    if (child instanceof RootElement) {
                        ((Definitions)baseElt).getRootElements().add((RootElement)child);
                        continue;
                    }
                    if (child instanceof SequenceFlow) {
                        rootLevelProcess.getFlowElements().add((SequenceFlow)child);
                        continue;
                    }
                    if (child instanceof Gateway) {
                        rootLevelProcess.getFlowElements().add((Gateway)child);
                        continue;
                    }
                    if (child instanceof Event) {
                        rootLevelProcess.getFlowElements().add((Event)child);
                        continue;
                    }
                    if (child instanceof TextAnnotation) {
                        rootLevelProcess.getFlowElements().add((TextAnnotation)child);
                        continue;
                    }
                    if (child instanceof Artifact) {
                        rootLevelProcess.getArtifacts().add((Artifact)child);
                        continue;
                    }
                    if (child instanceof DataObject) {
                        rootLevelProcess.getFlowElements().add((DataObject)child);
                        continue;
                    }
                    if (child instanceof SubProcess) {
                        rootLevelProcess.getFlowElements().add((SubProcess)child);
                        continue;
                    }
                    if (child instanceof Lane) continue;
                    _logger.error("Don't know what to do of " + child);
                }
            }
        } else if (baseElt instanceof Process) {
            for (BaseElement child : childElements) {
                if (child instanceof Lane) {
                    if (((Process)baseElt).getLaneSets().isEmpty()) {
                        ((Process)baseElt).getLaneSets().add(Bpmn2Factory.eINSTANCE.createLaneSet());
                    }
                    ((LaneSet)((Process)baseElt).getLaneSets().get(0)).getLanes().add((Lane)child);
                    this.addLaneFlowNodes((Process)baseElt, (Lane)child);
                    continue;
                }
                if (child instanceof Artifact) {
                    ((Process)baseElt).getArtifacts().add((Artifact)child);
                    continue;
                }
                _logger.error("Don't know what to do of " + child);
            }
        } else if (baseElt instanceof SubProcess) {
            for (BaseElement child : childElements) {
                if (child instanceof FlowElement) {
                    ((SubProcess)baseElt).getFlowElements().add((FlowElement)child);
                    continue;
                }
                if (child instanceof Artifact) {
                    ((SubProcess)baseElt).getArtifacts().add((Artifact)child);
                    continue;
                }
                _logger.error("Subprocess - don't know what to do of " + child);
            }
        } else if (!(baseElt instanceof Message)) {
            if (baseElt instanceof Lane) {
                for (BaseElement child : childElements) {
                    if (child instanceof FlowNode) {
                        ((Lane)baseElt).getFlowNodeRefs().add((FlowNode)child);
                        continue;
                    }
                    if (child instanceof Artifact) {
                        this._artifacts.add((Artifact)child);
                        continue;
                    }
                    _logger.error("Don't know what to do of " + childElements);
                }
                this._lanes.add((Lane)baseElt);
            } else if (!childElements.isEmpty()) {
                _logger.error("Don't know what to do of " + childElements + " with " + baseElt);
            }
        }
        return baseElt;
    }

    private void addLaneFlowNodes(Process process, Lane lane) {
        process.getFlowElements().addAll(lane.getFlowNodeRefs());
        if (lane.getChildLaneSet() != null) {
            for (Lane l : lane.getChildLaneSet().getLanes()) {
                this.addLaneFlowNodes(process, l);
            }
        }
    }

    protected void applyProperties(BaseElement baseElement, Map<String, String> properties, String preProcessingData) {
        this.applyBaseElementProperties(baseElement, properties);
        if (baseElement instanceof SubProcess) {
            this.applySubProcessProperties((SubProcess)baseElement, properties);
        }
        if (baseElement instanceof AdHocSubProcess) {
            this.applyAdHocSubProcessProperties((AdHocSubProcess)baseElement, properties);
        }
        if (baseElement instanceof CallActivity) {
            this.applyCallActivityProperties((CallActivity)baseElement, properties);
        }
        if (baseElement instanceof GlobalTask) {
            this.applyGlobalTaskProperties((GlobalTask)baseElement, properties);
        }
        if (baseElement instanceof Definitions) {
            this.applyDefinitionProperties((Definitions)baseElement, properties);
        }
        if (baseElement instanceof Process) {
            this.applyProcessProperties((Process)baseElement, properties);
        }
        if (baseElement instanceof Lane) {
            this.applyLaneProperties((Lane)baseElement, properties);
        }
        if (baseElement instanceof SequenceFlow) {
            this.applySequenceFlowProperties((SequenceFlow)baseElement, properties);
        }
        if (baseElement instanceof Task) {
            this.applyTaskProperties((Task)baseElement, properties, preProcessingData);
        }
        if (baseElement instanceof UserTask) {
            this.applyUserTaskProperties((UserTask)baseElement, properties);
        }
        if (baseElement instanceof BusinessRuleTask) {
            this.applyBusinessRuleTaskProperties((BusinessRuleTask)baseElement, properties);
        }
        if (baseElement instanceof ScriptTask) {
            this.applyScriptTaskProperties((ScriptTask)baseElement, properties);
        }
        if (baseElement instanceof ServiceTask) {
            this.applyServiceTaskProperties((ServiceTask)baseElement, properties);
        }
        if (baseElement instanceof ReceiveTask) {
            this.applyReceiveTaskProperties((ReceiveTask)baseElement, properties);
        }
        if (baseElement instanceof SendTask) {
            this.applySendTaskProperties((SendTask)baseElement, properties);
        }
        if (baseElement instanceof Gateway) {
            this.applyGatewayProperties((Gateway)baseElement, properties);
        }
        if (baseElement instanceof Event) {
            this.applyEventProperties((Event)baseElement, properties);
        }
        if (baseElement instanceof CatchEvent) {
            this.applyCatchEventProperties((CatchEvent)baseElement, properties);
        }
        if (baseElement instanceof ThrowEvent) {
            this.applyThrowEventProperties((ThrowEvent)baseElement, properties);
        }
        if (baseElement instanceof TextAnnotation) {
            this.applyTextAnnotationProperties((TextAnnotation)baseElement, properties);
        }
        if (baseElement instanceof Group) {
            this.applyGroupProperties((Group)baseElement, properties);
        }
        if (baseElement instanceof DataObject) {
            this.applyDataObjectProperties((DataObject)baseElement, properties);
        }
        if (baseElement instanceof DataStore) {
            this.applyDataStoreProperties((DataStore)baseElement, properties);
        }
        if (baseElement instanceof Message) {
            this.applyMessageProperties((Message)baseElement, properties);
        }
        if (baseElement instanceof StartEvent) {
            this.applyStartEventProperties((StartEvent)baseElement, properties);
        }
        if (baseElement instanceof EndEvent) {
            this.applyEndEventProperties((EndEvent)baseElement, properties);
        }
        if (baseElement instanceof Association) {
            this.applyAssociationProperties((Association)baseElement, properties);
        }
        for (BpmnMarshallerHelper helper : this._helpers) {
            helper.applyProperties(baseElement, properties);
        }
    }

    protected void applySubProcessProperties(SubProcess sp, Map<String, String> properties) {
        MultiInstanceLoopCharacteristics loopCharacteristics;
        InputOutputSpecification iospec;
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionElementEntry;
        ExtensionAttributeValue extensionElement;
        String[] scriptLanguage;
        if (properties.get("name") != null) {
            sp.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")).replaceAll("\\r\\n|\\r|\\n", " "));
            Utils.setMetaDataExtensionValue((BaseElement)sp, "elementname", this.wrapInCDATABlock(properties.get("name").replaceAll("\\\\n", "\n")));
        } else {
            sp.setName("");
        }
        if (properties.get("onentryactions") != null && properties.get("onentryactions").length() > 0) {
            OnEntryScriptType onEntryScript = DroolsFactory.eINSTANCE.createOnEntryScriptType();
            onEntryScript.setScript(this.wrapInCDATABlock(this.replaceScriptEscapeAndNewLines(properties.get("onentryactions"))));
            scriptLanguage = this.getScriptLanguageFormat(properties);
            onEntryScript.setScriptFormat((String)scriptLanguage);
            if (sp.getExtensionValues() == null || sp.getExtensionValues().size() < 1) {
                extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                sp.getExtensionValues().add(extensionElement);
            }
            extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__ON_ENTRY_SCRIPT, (Object)onEntryScript);
            ((ExtensionAttributeValue)sp.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
        }
        if (properties.get("onexitactions") != null && properties.get("onexitactions").length() > 0) {
            OnExitScriptType onExitScript = DroolsFactory.eINSTANCE.createOnExitScriptType();
            onExitScript.setScript(this.wrapInCDATABlock(this.replaceScriptEscapeAndNewLines(properties.get("onexitactions"))));
            scriptLanguage = this.getScriptLanguageFormat(properties);
            onExitScript.setScriptFormat((String)scriptLanguage);
            if (sp.getExtensionValues() == null || sp.getExtensionValues().size() < 1) {
                extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                sp.getExtensionValues().add(extensionElement);
            }
            extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__ON_EXIT_SCRIPT, (Object)onExitScript);
            ((ExtensionAttributeValue)sp.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
        }
        if (properties.get("isasync") != null && properties.get("isasync").length() > 0 && properties.get("isasync").equals("true")) {
            Utils.setMetaDataExtensionValue((BaseElement)sp, "customAsync", this.wrapInCDATABlock(properties.get("isasync")));
        }
        if (sp.getIoSpecification() == null) {
            iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
            sp.setIoSpecification(iospec);
        }
        this.applyDataInputProperties((Activity)sp, properties, new HashMap<String, DataInput>());
        this.applyDataOutputProperties((Activity)sp, properties);
        if (properties.get("assignments") != null && properties.get("assignments").length() > 0 && sp.getIoSpecification() != null) {
            String[] allAssignments;
            for (String assignment : allAssignments = properties.get("assignments").split(",\\s*")) {
                ItemAwareElement ie;
                String fromPart;
                String[] assignmentParts;
                if (assignment.contains("=")) {
                    assignmentParts = assignment.split("=\\s*");
                    fromPart = assignmentParts[0];
                    if (fromPart.startsWith("[din]")) {
                        fromPart = fromPart.substring(5, fromPart.length());
                    }
                    DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                    if (sp.getIoSpecification() != null && sp.getIoSpecification().getDataOutputs() != null) {
                        List dataInputs = sp.getIoSpecification().getDataInputs();
                        for (DataInput di : dataInputs) {
                            if (!di.getId().equals(sp.getId() + "_" + fromPart + "InputX")) continue;
                            dia.setTargetRef((ItemAwareElement)di);
                            if (!di.getName().equals("TaskName")) continue;
                            break;
                        }
                    }
                    Assignment a = Bpmn2Factory.eINSTANCE.createAssignment();
                    FormalExpression fromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    if (assignmentParts.length > 1) {
                        String replacer = this.decodeAssociationValue(assignmentParts[1]);
                        fromExpression.setBody(this.wrapInCDATABlock(replacer));
                    } else {
                        fromExpression.setBody("");
                    }
                    FormalExpression toExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    toExpression.setBody(dia.getTargetRef().getId());
                    a.setFrom((Expression)fromExpression);
                    a.setTo((Expression)toExpression);
                    dia.getAssignment().add(a);
                    sp.getDataInputAssociations().add(dia);
                    continue;
                }
                if (!assignment.contains("->")) continue;
                assignmentParts = assignment.split("->\\s*");
                fromPart = assignmentParts[0];
                boolean isDataInput = false;
                boolean isDataOutput = false;
                if (fromPart.startsWith("[din]")) {
                    fromPart = fromPart.substring(5, fromPart.length());
                    isDataInput = true;
                }
                if (fromPart.startsWith("[dout]")) {
                    fromPart = fromPart.substring(6, fromPart.length());
                    isDataOutput = true;
                }
                List dataOutputs = sp.getIoSpecification().getDataOutputs();
                if (isDataOutput) {
                    DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                    for (DataOutput dout : dataOutputs) {
                        if (!dout.getId().equals(sp.getId() + "_" + fromPart + "OutputX")) continue;
                        doa.getSourceRef().add(dout);
                        break;
                    }
                    ie = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                    ie.setId(assignmentParts[1]);
                    doa.setTargetRef(ie);
                    sp.getDataOutputAssociations().add(doa);
                    continue;
                }
                if (!isDataInput) continue;
                DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                ie = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                ie.setId(fromPart);
                dia.getSourceRef().add(ie);
                List dataInputs = sp.getIoSpecification().getDataInputs();
                for (DataInput di : dataInputs) {
                    if (!di.getId().equals(sp.getId() + "_" + assignmentParts[1] + "InputX")) continue;
                    dia.setTargetRef((ItemAwareElement)di);
                    break;
                }
                sp.getDataInputAssociations().add(dia);
            }
        }
        if (properties.get("mitrigger") != null && properties.get("mitrigger").equals("true")) {
            if (sp.getIoSpecification() == null) {
                iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                sp.setIoSpecification(iospec);
            } else {
                sp.getIoSpecification().getDataInputs().clear();
                sp.getIoSpecification().getDataOutputs().clear();
                ((InputSet)sp.getIoSpecification().getInputSets().get(0)).getDataInputRefs().clear();
                ((OutputSet)sp.getIoSpecification().getOutputSets().get(0)).getDataOutputRefs().clear();
                sp.getDataInputAssociations().clear();
                sp.getDataOutputAssociations().clear();
            }
            loopCharacteristics = Bpmn2Factory.eINSTANCE.createMultiInstanceLoopCharacteristics();
            if (properties.get("multipleinstancecollectioninput") != null && properties.get("multipleinstancecollectioninput").length() > 0) {
                String miDataInputStr = properties.get("multipleinstancedatainput");
                if (miDataInputStr == null || miDataInputStr.length() < 1) {
                    miDataInputStr = "defaultDataInput";
                }
                InputSet inset = (InputSet)sp.getIoSpecification().getInputSets().get(0);
                DataInput multiInput = Bpmn2Factory.eINSTANCE.createDataInput();
                multiInput.setId(sp.getId() + "_input");
                multiInput.setName(properties.get("multipleinstancecollectioninput"));
                sp.getIoSpecification().getDataInputs().add(multiInput);
                inset.getDataInputRefs().add(multiInput);
                DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                ItemAwareElement ie = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                ie.setId(properties.get("multipleinstancecollectioninput"));
                dia.getSourceRef().add(ie);
                dia.setTargetRef((ItemAwareElement)multiInput);
                sp.getDataInputAssociations().add(dia);
                loopCharacteristics.setLoopDataInputRef((ItemAwareElement)multiInput);
                DataInput din = Bpmn2Factory.eINSTANCE.createDataInput();
                din.setId(miDataInputStr);
                ItemDefinition itemDef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                itemDef.setId(sp.getId() + "_multiInstanceItemType");
                din.setItemSubjectRef(itemDef);
                this._subprocessItemDefs.put(itemDef.getId(), itemDef);
                loopCharacteristics.setInputDataItem(din);
            }
            if (properties.get("multipleinstancecollectionoutput") != null && properties.get("multipleinstancecollectionoutput").length() > 0) {
                String miDataOutputStr = properties.get("multipleinstancedataoutput");
                if (miDataOutputStr == null || miDataOutputStr.length() < 1) {
                    miDataOutputStr = "defaultDataOutput";
                }
                OutputSet outset = (OutputSet)sp.getIoSpecification().getOutputSets().get(0);
                DataOutput multiOutput = Bpmn2Factory.eINSTANCE.createDataOutput();
                multiOutput.setId(sp.getId() + "_output");
                multiOutput.setName(properties.get("multipleinstancecollectionoutput"));
                sp.getIoSpecification().getDataOutputs().add(multiOutput);
                outset.getDataOutputRefs().add(multiOutput);
                DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                ItemAwareElement ie2 = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                ie2.setId(properties.get("multipleinstancecollectionoutput"));
                doa.getSourceRef().add(multiOutput);
                doa.setTargetRef(ie2);
                sp.getDataOutputAssociations().add(doa);
                loopCharacteristics.setLoopDataOutputRef((ItemAwareElement)multiOutput);
                DataOutput don = Bpmn2Factory.eINSTANCE.createDataOutput();
                don.setId(miDataOutputStr);
                ItemDefinition itemDef2 = Bpmn2Factory.eINSTANCE.createItemDefinition();
                itemDef2.setId(sp.getId() + "_multiInstanceItemType");
                don.setItemSubjectRef(itemDef2);
                this._subprocessItemDefs.put(itemDef2.getId(), itemDef2);
                loopCharacteristics.setOutputDataItem(don);
            }
            if (properties.get("multipleinstancecompletioncondition") != null && !properties.get("multipleinstancecompletioncondition").isEmpty()) {
                FormalExpression expr = Bpmn2Factory.eINSTANCE.createFormalExpression();
                expr.setBody(properties.get("multipleinstancecompletioncondition"));
                loopCharacteristics.setCompletionCondition((Expression)expr);
            }
            sp.setLoopCharacteristics((LoopCharacteristics)loopCharacteristics);
        } else {
            loopCharacteristics = Bpmn2Factory.eINSTANCE.createMultiInstanceLoopCharacteristics();
            sp.setLoopCharacteristics((LoopCharacteristics)loopCharacteristics);
        }
        if (properties.get("vardefs") != null && properties.get("vardefs").length() > 0) {
            FormalExpression vardefs;
            for (String vardef : vardefs = properties.get("vardefs").split(",\\s*")) {
                Property prop = Bpmn2Factory.eINSTANCE.createProperty();
                ItemDefinition itemdef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                if (vardef.contains(":")) {
                    String[] vardefParts = vardef.split(":\\s*");
                    prop.setId(vardefParts[0]);
                    itemdef.setId("_" + prop.getId() + "Item");
                    boolean haveKPI = false;
                    String kpiValue = "";
                    if (vardefParts.length == 3) {
                        itemdef.setStructureRef(vardefParts[1]);
                        if (vardefParts[2].equals("true")) {
                            haveKPI = true;
                            kpiValue = vardefParts[2];
                        }
                    }
                    if (vardefParts.length == 2) {
                        if (vardefParts[1].equals("true") || vardefParts[1].equals("false")) {
                            if (vardefParts[1].equals("true")) {
                                haveKPI = true;
                                kpiValue = vardefParts[1];
                            }
                        } else {
                            itemdef.setStructureRef(vardefParts[1]);
                        }
                    }
                    if (haveKPI) {
                        Utils.setMetaDataExtensionValue((BaseElement)prop, "customKPI", this.wrapInCDATABlock(kpiValue));
                    }
                } else {
                    prop.setId(vardef);
                    itemdef.setId("_" + prop.getId() + "Item");
                }
                prop.setItemSubjectRef(itemdef);
                sp.getProperties().add(prop);
                this._subprocessItemDefs.put(itemdef.getId(), itemdef);
            }
        }
        if (sp instanceof EventSubprocess) {
            sp.setTriggeredByEvent(true);
        }
        if (properties.get("distributiontype") != null && properties.get("distributiontype").length() > 0) {
            TimeParameters timeParams = BpsimFactory.eINSTANCE.createTimeParameters();
            Parameter processingTimeParam = BpsimFactory.eINSTANCE.createParameter();
            if (properties.get("distributiontype").equals("normal")) {
                NormalDistributionType normalDistributionType = BpsimFactory.eINSTANCE.createNormalDistributionType();
                normalDistributionType.setStandardDeviation(Double.valueOf(properties.get("standarddeviation")).doubleValue());
                normalDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)normalDistributionType);
            } else if (properties.get("distributiontype").equals("uniform")) {
                UniformDistributionType uniformDistributionType = BpsimFactory.eINSTANCE.createUniformDistributionType();
                uniformDistributionType.setMax(Double.valueOf(properties.get("max")).doubleValue());
                uniformDistributionType.setMin(Double.valueOf(properties.get("min")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)uniformDistributionType);
            } else if (properties.get("distributiontype").equals("poisson")) {
                PoissonDistributionType poissonDistributionType = BpsimFactory.eINSTANCE.createPoissonDistributionType();
                poissonDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)poissonDistributionType);
            }
            if (properties.get("waittime") != null) {
                Parameter waittimeParam = BpsimFactory.eINSTANCE.createParameter();
                FloatingParameterType waittimeParamValue = BpsimFactory.eINSTANCE.createFloatingParameterType();
                DecimalFormat twoDForm = new DecimalFormat("#.##");
                waittimeParamValue.setValue(Double.valueOf(twoDForm.format(Double.valueOf(properties.get("waittime")))).doubleValue());
                waittimeParam.getParameterValue().add((Object)waittimeParamValue);
                timeParams.setWaitTime(waittimeParam);
            }
            timeParams.setProcessingTime(processingTimeParam);
            if (this._simulationElementParameters.containsKey(sp.getId())) {
                this._simulationElementParameters.get(sp.getId()).add((EObject)timeParams);
            } else {
                ArrayList<TimeParameters> values = new ArrayList<TimeParameters>();
                values.add(timeParams);
                this._simulationElementParameters.put(sp.getId(), values);
            }
        }
        CostParameters costParameters = BpsimFactory.eINSTANCE.createCostParameters();
        if (properties.get("unitcost") != null && properties.get("unitcost").length() > 0) {
            Parameter unitcostParam = BpsimFactory.eINSTANCE.createParameter();
            FloatingParameterType unitCostParameterValue = BpsimFactory.eINSTANCE.createFloatingParameterType();
            unitCostParameterValue.setValue(new Double(properties.get("unitcost")).doubleValue());
            unitcostParam.getParameterValue().add((Object)unitCostParameterValue);
            costParameters.setUnitCost(unitcostParam);
        }
        if (this._simulationElementParameters.containsKey(sp.getId())) {
            this._simulationElementParameters.get(sp.getId()).add((EObject)costParameters);
        } else {
            ArrayList<CostParameters> values = new ArrayList<CostParameters>();
            values.add(costParameters);
            this._simulationElementParameters.put(sp.getId(), values);
        }
    }

    private String getScriptLanguageFormat(Map<String, String> properties) {
        String scriptLanguage = "http://www.java.com/java";
        if (properties.get("script_language") != null && properties.get("script_language").length() > 0) {
            if (properties.get("script_language").equals("java")) {
                scriptLanguage = "http://www.java.com/java";
            } else if (properties.get("script_language").equals("mvel")) {
                scriptLanguage = "http://www.mvel.org/2.0";
            } else if (properties.get("script_language").equals("javascript")) {
                scriptLanguage = "http://www.javascript.com/javascript";
            }
        }
        return scriptLanguage;
    }

    private void applyDataOutputProperties(Activity activity, Map<String, String> properties) {
        if (properties.get("dataoutputset") != null && properties.get("dataoutputset").trim().length() > 0) {
            String[] allDataOutputs = properties.get("dataoutputset").split(",\\s*");
            if (activity.getIoSpecification() == null) {
                InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                activity.setIoSpecification(iospec);
            }
            OutputSet outset = Bpmn2Factory.eINSTANCE.createOutputSet();
            for (String dataOutput : allDataOutputs) {
                EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
                EAttributeImpl extensionAttribute;
                ExtendedMetaData metadata;
                if (dataOutput.trim().length() <= 0) continue;
                DataOutput nextOut = Bpmn2Factory.eINSTANCE.createDataOutput();
                String[] dataOutputParts = dataOutput.split(":\\s*");
                if (dataOutputParts.length == 2) {
                    nextOut.setId(activity.getId() + "_" + dataOutputParts[0] + (dataOutputParts[0].endsWith("OutputX") ? "" : "OutputX"));
                    nextOut.setName(dataOutputParts[0]);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)dataOutputParts[1]);
                    nextOut.getAnyAttribute().add((Object)extensionEntry);
                } else {
                    nextOut.setId(activity.getId() + "_" + dataOutput + (dataOutput.endsWith("OutputX") ? "" : "OutputX"));
                    nextOut.setName(dataOutput);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)"Object");
                    nextOut.getAnyAttribute().add((Object)extensionEntry);
                }
                activity.getIoSpecification().getDataOutputs().add(nextOut);
                outset.getDataOutputRefs().add(nextOut);
            }
            activity.getIoSpecification().getOutputSets().add(outset);
        } else if (activity.getIoSpecification() != null) {
            activity.getIoSpecification().getOutputSets().add(Bpmn2Factory.eINSTANCE.createOutputSet());
        }
    }

    private void applyDataInputProperties(Activity activity, Map<String, String> properties, Map<String, DataInput> alreadyProcessedInputs) {
        if (properties.get("datainputset") != null && properties.get("datainputset").trim().length() > 0) {
            String[] allDataInputs = properties.get("datainputset").split(",\\s*");
            if (activity.getIoSpecification() == null) {
                InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                activity.setIoSpecification(iospec);
            }
            InputSet inset = Bpmn2Factory.eINSTANCE.createInputSet();
            for (String dataInput : allDataInputs) {
                EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
                EAttributeImpl extensionAttribute;
                ExtendedMetaData metadata;
                if (dataInput.trim().length() <= 0) continue;
                DataInput nextInput = Bpmn2Factory.eINSTANCE.createDataInput();
                String[] dataInputParts = dataInput.split(":\\s*");
                if (dataInputParts.length == 2) {
                    for (String inputName : alreadyProcessedInputs.keySet()) {
                        if (inputName.equals(dataInputParts[0]) && alreadyProcessedInputs.get(inputName) != null) break;
                    }
                    nextInput.setId(activity.getId() + "_" + dataInputParts[0] + (dataInputParts[0].endsWith("InputX") ? "" : "InputX"));
                    nextInput.setName(dataInputParts[0]);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)dataInputParts[1]);
                    nextInput.getAnyAttribute().add((Object)extensionEntry);
                } else {
                    for (String inputName : alreadyProcessedInputs.keySet()) {
                        if (inputName.equals(dataInput) && alreadyProcessedInputs.get(inputName) != null) break;
                    }
                    nextInput.setId(activity.getId() + "_" + dataInput + (dataInput.endsWith("InputX") ? "" : "InputX"));
                    nextInput.setName(dataInput);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)"Object");
                    nextInput.getAnyAttribute().add((Object)extensionEntry);
                }
                activity.getIoSpecification().getDataInputs().add(nextInput);
                inset.getDataInputRefs().add(nextInput);
            }
            activity.getIoSpecification().getInputSets().add(inset);
        } else if (activity.getIoSpecification() != null) {
            activity.getIoSpecification().getInputSets().add(Bpmn2Factory.eINSTANCE.createInputSet());
        }
    }

    protected void applyAdHocSubProcessProperties(AdHocSubProcess ahsp, Map<String, String> properties) {
        if (properties.get("adhocordering") != null) {
            if (properties.get("adhocordering").equals("Parallel")) {
                ahsp.setOrdering(AdHocOrdering.PARALLEL);
            } else {
                ahsp.setOrdering(AdHocOrdering.SEQUENTIAL);
            }
        }
        if (properties.get("adhoccompletioncondition") != null) {
            FormalExpression completionConditionExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
            completionConditionExpression.setBody(this.wrapInCDATABlock(properties.get("adhoccompletioncondition")));
            ahsp.setCompletionCondition((Expression)completionConditionExpression);
        }
    }

    protected void applyEndEventProperties(EndEvent ee, Map<String, String> properties) {
        ee.setId(properties.get("resourceId"));
    }

    protected void applyAssociationProperties(Association association, Map<String, String> properties) {
        if (properties.get("type") != null) {
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "type", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("type"));
            association.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("bordercolor") != null && properties.get("bordercolor").length() > 0) {
            if (!this._elementColors.containsKey(association.getId())) {
                ArrayList<String> colorsList = new ArrayList<String>();
                colorsList.add("bordercolor:" + properties.get("bordercolor"));
                this._elementColors.put(association.getId(), colorsList);
            } else {
                this._elementColors.get(association.getId()).add("bordercolor:" + properties.get("bordercolor"));
            }
        }
    }

    protected void applyStartEventProperties(StartEvent se, Map<String, String> properties) {
        se.setIsInterrupting(Boolean.parseBoolean(properties.get("isinterrupting")));
    }

    protected void applyMessageProperties(Message msg, Map<String, String> properties) {
        if (properties.get("name") != null && properties.get("name").length() > 0) {
            msg.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")).replaceAll("\\r\\n|\\r|\\n", " "));
            msg.setId(properties.get("name") + "Message");
            Utils.setMetaDataExtensionValue((BaseElement)msg, "elementname", this.wrapInCDATABlock(properties.get("name").replaceAll("\\\\n", "\n")));
        } else {
            msg.setName("");
            msg.setId("Message");
        }
    }

    protected void applyDataStoreProperties(DataStore da, Map<String, String> properties) {
        if (properties.get("name") != null) {
            da.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")).replaceAll("\\r\\n|\\r|\\n", " "));
            Utils.setMetaDataExtensionValue((BaseElement)da, "elementname", this.wrapInCDATABlock(properties.get("name").replaceAll("\\\\n", "\n")));
        } else {
            da.setName("");
        }
    }

    protected void applyDataObjectProperties(DataObject da, Map<String, String> properties) {
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
        EAttributeImpl extensionAttribute;
        ExtendedMetaData metadata;
        if (properties.get("name") != null && properties.get("name").length() > 0) {
            da.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")).replaceAll("\\r\\n|\\r|\\n", " "));
            Utils.setMetaDataExtensionValue((BaseElement)da, "elementname", this.wrapInCDATABlock(properties.get("name").replaceAll("\\\\n", "\n")));
        } else {
            da.setName(da.getId());
        }
        boolean haveCustomType = false;
        if (properties.get("customtype") != null && properties.get("customtype").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "datype", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("customtype"));
            da.getAnyAttribute().add((Object)extensionEntry);
            haveCustomType = true;
        }
        if (properties.get("standardtype") != null && properties.get("standardtype").length() > 0 && !haveCustomType) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "datype", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("standardtype"));
            da.getAnyAttribute().add((Object)extensionEntry);
        }
    }

    protected void applyTextAnnotationProperties(TextAnnotation ta, Map<String, String> properties) {
        ArrayList<String> colorsList;
        if (properties.get("name") != null) {
            ta.setText(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")).replaceAll("\\r\\n|\\r|\\n", " "));
            Utils.setMetaDataExtensionValue((BaseElement)ta, "elementname", this.wrapInCDATABlock(properties.get("name").replaceAll("\\\\n", "\n")));
        } else {
            ta.setText("");
        }
        ta.setTextFormat("text/plain");
        if (properties.get("bordercolor") != null && properties.get("bordercolor").length() > 0) {
            if (!this._elementColors.containsKey(ta.getId())) {
                colorsList = new ArrayList<String>();
                colorsList.add("bordercolor:" + properties.get("bordercolor"));
                this._elementColors.put(ta.getId(), colorsList);
            } else {
                this._elementColors.get(ta.getId()).add("bordercolor:" + properties.get("bordercolor"));
            }
        }
        if (properties.get("fontsize") != null && properties.get("fontsize").length() > 0) {
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "fontsize", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("fontsize"));
            ta.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("fontcolor") != null && properties.get("fontcolor").length() > 0) {
            if (!this._elementColors.containsKey(ta.getId())) {
                colorsList = new ArrayList();
                colorsList.add("fontcolor:" + properties.get("fontcolor"));
                this._elementColors.put(ta.getId(), colorsList);
            } else {
                this._elementColors.get(ta.getId()).add("fontcolor:" + properties.get("fontcolor"));
            }
        }
    }

    protected void applyGroupProperties(Group group, Map<String, String> properties) {
        if (properties.get("name") != null) {
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "categoryval", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("name"));
            group.getAnyAttribute().add((Object)extensionEntry);
        }
    }

    protected void applyEventProperties(Event event, Map<String, String> properties) {
        if (properties.get("name") != null) {
            event.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")).replaceAll("\\r\\n|\\r|\\n", " "));
            Utils.setMetaDataExtensionValue((BaseElement)event, "elementname", this.wrapInCDATABlock(properties.get("name").replaceAll("\\\\n", "\n")));
        } else {
            event.setName("");
        }
        if (properties.get("auditing") != null && !"".equals(properties.get("auditing"))) {
            Auditing audit = Bpmn2Factory.eINSTANCE.createAuditing();
            audit.getDocumentation().add(this.createDocumentation(properties.get("auditing")));
            event.setAuditing(audit);
        }
        if (properties.get("monitoring") != null && !"".equals(properties.get("monitoring"))) {
            Monitoring monitoring = Bpmn2Factory.eINSTANCE.createMonitoring();
            monitoring.getDocumentation().add(this.createDocumentation(properties.get("monitoring")));
            event.setMonitoring(monitoring);
        }
    }

    protected void applyCatchEventProperties(CatchEvent event, Map<String, String> properties) {
        if (properties.get("dataoutput") != null && !"".equals(properties.get("dataoutput"))) {
            String[] allDataOutputs = properties.get("dataoutput").split(",\\s*");
            OutputSet outSet = Bpmn2Factory.eINSTANCE.createOutputSet();
            String[] stringArray = allDataOutputs;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
                EAttributeImpl extensionAttribute;
                ExtendedMetaData metadata;
                String dataOutput = stringArray[i];
                if (dataOutput.trim().length() <= 0) continue;
                DataOutput nextOutput = Bpmn2Factory.eINSTANCE.createDataOutput();
                String[] doutputParts = dataOutput.split(":\\s*");
                if (doutputParts.length == 2) {
                    nextOutput.setId(event.getId() + "_" + doutputParts[0]);
                    nextOutput.setName(doutputParts[0]);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)doutputParts[1]);
                    nextOutput.getAnyAttribute().add((Object)extensionEntry);
                } else {
                    nextOutput.setId(event.getId() + "_" + dataOutput);
                    nextOutput.setName(dataOutput);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)"Object");
                    nextOutput.getAnyAttribute().add((Object)extensionEntry);
                }
                event.getDataOutputs().add(nextOutput);
                outSet.getDataOutputRefs().add(nextOutput);
            }
            event.setOutputSet(outSet);
        }
        if (properties.get("boundarycancelactivity") != null) {
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            String[] extensionAttribute = (String[])metadata.demandFeature("http://www.jboss.org/drools", "boundaryca", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("boundarycancelactivity"));
            event.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("dataoutputassociations") != null && !"".equals(properties.get("dataoutputassociations"))) {
            String[] allAssociations;
            for (String association : allAssociations = properties.get("dataoutputassociations").split(",\\s*")) {
                String[] associationParts = association.split("->\\s*");
                String fromPart = associationParts[0];
                if (fromPart.startsWith("[dout]")) {
                    fromPart = fromPart.substring(6, fromPart.length());
                }
                DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                List dataOutputs = event.getDataOutputs();
                if (dataOutputs != null) {
                    for (DataOutput ddo : dataOutputs) {
                        if (!ddo.getId().equals(event.getId() + "_" + fromPart)) continue;
                        doa.getSourceRef().add(ddo);
                    }
                }
                ItemAwareElement e = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                e.setId(associationParts[1]);
                doa.setTargetRef(e);
                event.getDataOutputAssociation().add(doa);
            }
        }
        try {
            if (event.getEventDefinitions() != null && event.getEventDefinitions().size() > 0) {
                ExtendedMetaData metadata;
                EventDefinition ed = (EventDefinition)event.getEventDefinitions().get(0);
                if (ed instanceof TimerEventDefinition) {
                    if (properties.get("timedate") != null && !"".equals(properties.get("timedate"))) {
                        FormalExpression timeDateExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                        timeDateExpression.setBody(properties.get("timedate"));
                        ((TimerEventDefinition)event.getEventDefinitions().get(0)).setTimeDate((Expression)timeDateExpression);
                    }
                    if (properties.get("timeduration") != null && !"".equals(properties.get("timeduration"))) {
                        FormalExpression timeDurationExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                        timeDurationExpression.setBody(properties.get("timeduration"));
                        ((TimerEventDefinition)event.getEventDefinitions().get(0)).setTimeDuration((Expression)timeDurationExpression);
                    }
                    if (properties.get("timecycle") != null && !"".equals(properties.get("timecycle"))) {
                        FormalExpression timeCycleExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                        timeCycleExpression.setBody(properties.get("timecycle"));
                        if (properties.get("timecyclelanguage") != null && properties.get("timecyclelanguage").length() > 0) {
                            timeCycleExpression.setLanguage(properties.get("timecyclelanguage"));
                        }
                        ((TimerEventDefinition)event.getEventDefinitions().get(0)).setTimeCycle((Expression)timeCycleExpression);
                    }
                } else if (ed instanceof SignalEventDefinition) {
                    if (properties.get("signalref") != null && !"".equals(properties.get("signalref"))) {
                        ((SignalEventDefinition)ed).setSignalRef(properties.get("signalref"));
                    }
                } else if (ed instanceof ErrorEventDefinition) {
                    if (properties.get("errorref") != null && !"".equals(properties.get("errorref"))) {
                        metadata = ExtendedMetaData.INSTANCE;
                        EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "erefname", false, false);
                        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("errorref"));
                        ((ErrorEventDefinition)event.getEventDefinitions().get(0)).getAnyAttribute().add((Object)extensionEntry);
                    }
                } else if (ed instanceof ConditionalEventDefinition) {
                    FormalExpression conditionExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    if (properties.get("conditionlanguage") != null && !"".equals(properties.get("conditionlanguage"))) {
                        String languageStr = properties.get("conditionlanguage").equals("drools") ? "http://www.jboss.org/drools/rule" : (properties.get("conditionlanguage").equals("mvel") ? "http://www.mvel.org/2.0" : "http://www.jboss.org/drools/rule");
                        conditionExpression.setLanguage(languageStr);
                    }
                    if (properties.get("conditionexpression") != null && !"".equals(properties.get("conditionexpression"))) {
                        String scriptStr = properties.get("conditionexpression").replaceAll("\\\\n", "\n");
                        conditionExpression.setBody(this.wrapInCDATABlock(scriptStr));
                    }
                    ((ConditionalEventDefinition)event.getEventDefinitions().get(0)).setCondition((Expression)conditionExpression);
                } else if (ed instanceof EscalationEventDefinition) {
                    if (properties.get("escalationcode") != null && !"".equals(properties.get("escalationcode"))) {
                        metadata = ExtendedMetaData.INSTANCE;
                        EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "esccode", false, false);
                        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("escalationcode"));
                        ((EscalationEventDefinition)event.getEventDefinitions().get(0)).getAnyAttribute().add((Object)extensionEntry);
                    }
                } else if (ed instanceof MessageEventDefinition) {
                    if (properties.get("messageref") != null && !"".equals(properties.get("messageref"))) {
                        metadata = ExtendedMetaData.INSTANCE;
                        EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "msgref", false, false);
                        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("messageref"));
                        ((MessageEventDefinition)event.getEventDefinitions().get(0)).getAnyAttribute().add((Object)extensionEntry);
                    }
                } else if (ed instanceof CompensateEventDefinition && properties.get("activityref") != null && !"".equals(properties.get("activityref"))) {
                    metadata = ExtendedMetaData.INSTANCE;
                    EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "actrefname", false, false);
                    EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("activityref"));
                    ((CompensateEventDefinition)event.getEventDefinitions().get(0)).getAnyAttribute().add((Object)extensionEntry);
                }
            }
        }
        catch (Exception e) {
            _logger.warn(e.getMessage());
        }
        if (properties.get("distributiontype") != null && properties.get("distributiontype").length() > 0) {
            TimeParameters timeParams = BpsimFactory.eINSTANCE.createTimeParameters();
            Parameter processingTimeParam = BpsimFactory.eINSTANCE.createParameter();
            if (properties.get("distributiontype").equals("normal")) {
                NormalDistributionType normalDistributionType = BpsimFactory.eINSTANCE.createNormalDistributionType();
                normalDistributionType.setStandardDeviation(Double.valueOf(properties.get("standarddeviation")).doubleValue());
                normalDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)normalDistributionType);
            } else if (properties.get("distributiontype").equals("uniform")) {
                UniformDistributionType uniformDistributionType = BpsimFactory.eINSTANCE.createUniformDistributionType();
                uniformDistributionType.setMax(Double.valueOf(properties.get("max")).doubleValue());
                uniformDistributionType.setMin(Double.valueOf(properties.get("min")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)uniformDistributionType);
            } else if (properties.get("distributiontype").equals("poisson")) {
                PoissonDistributionType poissonDistributionType = BpsimFactory.eINSTANCE.createPoissonDistributionType();
                poissonDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)poissonDistributionType);
            }
            timeParams.setProcessingTime(processingTimeParam);
            if (this._simulationElementParameters.containsKey(event.getId())) {
                this._simulationElementParameters.get(event.getId()).add((EObject)timeParams);
            } else {
                ArrayList<TimeParameters> values = new ArrayList<TimeParameters>();
                values.add(timeParams);
                this._simulationElementParameters.put(event.getId(), values);
            }
        }
        if (properties.get("probability") != null && properties.get("probability").length() > 0) {
            ControlParameters controlParams = BpsimFactory.eINSTANCE.createControlParameters();
            Parameter probParam = BpsimFactory.eINSTANCE.createParameter();
            FloatingParameterType probParamValueParam = BpsimFactory.eINSTANCE.createFloatingParameterType();
            DecimalFormat twoDForm = new DecimalFormat("#.##");
            probParamValueParam.setValue(Double.valueOf(twoDForm.format(Double.valueOf(properties.get("probability")))).doubleValue());
            probParam.getParameterValue().add((Object)probParamValueParam);
            controlParams.setProbability(probParam);
            if (this._simulationElementParameters.containsKey(event.getId())) {
                this._simulationElementParameters.get(event.getId()).add((EObject)controlParams);
            } else {
                ArrayList<ControlParameters> values = new ArrayList<ControlParameters>();
                values.add(controlParams);
                this._simulationElementParameters.put(event.getId(), values);
            }
        }
    }

    protected void applyThrowEventProperties(ThrowEvent event, Map<String, String> properties) {
        if (properties.get("datainput") != null && properties.get("datainput").trim().length() > 0) {
            String[] allDataInputs = properties.get("datainput").split(",\\s*");
            String[] inset = Bpmn2Factory.eINSTANCE.createInputSet();
            String[] stringArray = allDataInputs;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
                EAttributeImpl extensionAttribute;
                ExtendedMetaData metadata;
                String dataInput = stringArray[i];
                if (dataInput.trim().length() <= 0) continue;
                DataInput nextInput = Bpmn2Factory.eINSTANCE.createDataInput();
                String[] dataInputParts = dataInput.split(":\\s*");
                if (dataInputParts.length == 2) {
                    nextInput.setId(event.getId() + "_" + dataInputParts[0] + (dataInputParts[0].endsWith("InputX") ? "" : "InputX"));
                    nextInput.setName(dataInputParts[0]);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)dataInputParts[1]);
                    nextInput.getAnyAttribute().add((Object)extensionEntry);
                } else {
                    nextInput.setId(event.getId() + "_" + dataInput + (dataInput.endsWith("InputX") ? "" : "InputX"));
                    nextInput.setName(dataInput);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)"Object");
                    nextInput.getAnyAttribute().add((Object)extensionEntry);
                }
                event.getDataInputs().add(nextInput);
                inset.getDataInputRefs().add(nextInput);
            }
            event.setInputSet((InputSet)inset);
        }
        if (properties.get("datainputassociations") != null && properties.get("datainputassociations").length() > 0) {
            String[] allAssignments;
            for (String assignment : allAssignments = properties.get("datainputassociations").split(",\\s*")) {
                String fromPart;
                String[] assignmentParts;
                if (assignment.contains("=")) {
                    assignmentParts = assignment.split("=\\s*");
                    fromPart = assignmentParts[0];
                    if (fromPart.startsWith("[din]")) {
                        fromPart = fromPart.substring(5, fromPart.length());
                    }
                    DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                    if (event.getInputSet() != null) {
                        List dataInputs = event.getInputSet().getDataInputRefs();
                        for (DataInput di : dataInputs) {
                            if (!di.getId().equals(event.getId() + "_" + fromPart + (fromPart.endsWith("InputX") ? "" : "InputX"))) continue;
                            dia.setTargetRef((ItemAwareElement)di);
                        }
                    }
                    Assignment a = Bpmn2Factory.eINSTANCE.createAssignment();
                    FormalExpression fromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    if (assignmentParts.length > 1) {
                        String replacer = this.decodeAssociationValue(assignmentParts[1]);
                        fromExpression.setBody(this.wrapInCDATABlock(replacer));
                    } else {
                        fromExpression.setBody("");
                    }
                    FormalExpression toExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    toExpression.setBody(dia.getTargetRef().getId());
                    a.setFrom((Expression)fromExpression);
                    a.setTo((Expression)toExpression);
                    dia.getAssignment().add(a);
                    event.getDataInputAssociation().add(dia);
                    continue;
                }
                if (!assignment.contains("->")) continue;
                assignmentParts = assignment.split("->\\s*");
                fromPart = assignmentParts[0];
                boolean isDataInput = false;
                boolean isDataOutput = false;
                if (fromPart.startsWith("[din]")) {
                    fromPart = fromPart.substring(5, fromPart.length());
                    isDataInput = true;
                }
                if (!isDataInput) continue;
                DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                ItemAwareElement ie = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                ie.setId(fromPart);
                dia.getSourceRef().add(ie);
                List dataInputs = event.getInputSet().getDataInputRefs();
                for (DataInput di : dataInputs) {
                    if (!di.getId().equals(event.getId() + "_" + assignmentParts[1] + (assignmentParts[1].endsWith("InputX") ? "" : "InputX"))) continue;
                    dia.setTargetRef((ItemAwareElement)di);
                    break;
                }
                event.getDataInputAssociation().add(dia);
            }
        }
        if (properties.get("signalscope") != null && properties.get("signalscope").length() > 0 && !properties.get("signalscope").equals("default")) {
            Utils.setMetaDataExtensionValue((BaseElement)event, "customScope", this.wrapInCDATABlock(properties.get("signalscope")));
        }
        try {
            EAttributeImpl extensionAttribute;
            ExtendedMetaData metadata;
            EventDefinition ed = (EventDefinition)event.getEventDefinitions().get(0);
            if (ed instanceof TimerEventDefinition) {
                if (properties.get("timedate") != null && !"".equals(properties.get("timedate"))) {
                    FormalExpression timeDateExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    timeDateExpression.setBody(properties.get("timedate"));
                    ((TimerEventDefinition)event.getEventDefinitions().get(0)).setTimeDate((Expression)timeDateExpression);
                }
                if (properties.get("timeduration") != null && !"".equals(properties.get("timeduration"))) {
                    FormalExpression timeDurationExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    timeDurationExpression.setBody(properties.get("timeduration"));
                    ((TimerEventDefinition)event.getEventDefinitions().get(0)).setTimeDuration((Expression)timeDurationExpression);
                }
                if (properties.get("timecycle") != null && !"".equals(properties.get("timecycle"))) {
                    FormalExpression timeCycleExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    timeCycleExpression.setBody(properties.get("timecycle"));
                    if (properties.get("timecyclelanguage") != null && properties.get("timecyclelanguage").length() > 0) {
                        timeCycleExpression.setLanguage(properties.get("timecyclelanguage"));
                    }
                    ((TimerEventDefinition)event.getEventDefinitions().get(0)).setTimeCycle((Expression)timeCycleExpression);
                }
            } else if (ed instanceof SignalEventDefinition) {
                if (properties.get("signalref") != null && !"".equals(properties.get("signalref"))) {
                    ((SignalEventDefinition)ed).setSignalRef(properties.get("signalref"));
                }
            } else if (ed instanceof ErrorEventDefinition) {
                if (properties.get("errorref") != null && !"".equals(properties.get("errorref"))) {
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "erefname", false, false);
                    EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("errorref"));
                    ((ErrorEventDefinition)event.getEventDefinitions().get(0)).getAnyAttribute().add((Object)extensionEntry);
                }
            } else if (ed instanceof ConditionalEventDefinition) {
                FormalExpression conditionExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                if (properties.get("conditionlanguage") != null && !"".equals(properties.get("conditionlanguage"))) {
                    String languageStr = properties.get("conditionlanguage").equals("drools") ? "http://www.jboss.org/drools/rule" : (properties.get("conditionlanguage").equals("mvel") ? "http://www.mvel.org/2.0" : "http://www.jboss.org/drools/rule");
                    conditionExpression.setLanguage(languageStr);
                }
                if (properties.get("conditionexpression") != null && !"".equals(properties.get("conditionexpression"))) {
                    String scriptStr = properties.get("conditionexpression").replaceAll("\\\\n", "\n");
                    conditionExpression.setBody(this.wrapInCDATABlock(scriptStr));
                }
                ((ConditionalEventDefinition)event.getEventDefinitions().get(0)).setCondition((Expression)conditionExpression);
            } else if (ed instanceof EscalationEventDefinition) {
                if (properties.get("escalationcode") != null && !"".equals(properties.get("escalationcode"))) {
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "esccode", false, false);
                    EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("escalationcode"));
                    ((EscalationEventDefinition)event.getEventDefinitions().get(0)).getAnyAttribute().add((Object)extensionEntry);
                }
            } else if (ed instanceof MessageEventDefinition) {
                if (properties.get("messageref") != null && !"".equals(properties.get("messageref"))) {
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "msgref", false, false);
                    EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("messageref"));
                    ((MessageEventDefinition)event.getEventDefinitions().get(0)).getAnyAttribute().add((Object)extensionEntry);
                }
            } else if (ed instanceof CompensateEventDefinition && properties.get("activityref") != null && !"".equals(properties.get("activityref"))) {
                metadata = ExtendedMetaData.INSTANCE;
                extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "actrefname", false, false);
                EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("activityref"));
                ((CompensateEventDefinition)event.getEventDefinitions().get(0)).getAnyAttribute().add((Object)extensionEntry);
            }
        }
        catch (IndexOutOfBoundsException ed) {
            // empty catch block
        }
        if (properties.get("distributiontype") != null && properties.get("distributiontype").length() > 0) {
            TimeParameters timeParams = BpsimFactory.eINSTANCE.createTimeParameters();
            Parameter processingTimeParam = BpsimFactory.eINSTANCE.createParameter();
            if (properties.get("distributiontype").equals("normal")) {
                NormalDistributionType normalDistributionType = BpsimFactory.eINSTANCE.createNormalDistributionType();
                normalDistributionType.setStandardDeviation(Double.valueOf(properties.get("standarddeviation")).doubleValue());
                normalDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)normalDistributionType);
            } else if (properties.get("distributiontype").equals("uniform")) {
                UniformDistributionType uniformDistributionType = BpsimFactory.eINSTANCE.createUniformDistributionType();
                uniformDistributionType.setMax(Double.valueOf(properties.get("max")).doubleValue());
                uniformDistributionType.setMin(Double.valueOf(properties.get("min")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)uniformDistributionType);
            } else if (properties.get("distributiontype").equals("poisson")) {
                PoissonDistributionType poissonDistributionType = BpsimFactory.eINSTANCE.createPoissonDistributionType();
                poissonDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)poissonDistributionType);
            }
            timeParams.setProcessingTime(processingTimeParam);
            if (this._simulationElementParameters.containsKey(event.getId())) {
                this._simulationElementParameters.get(event.getId()).add((EObject)timeParams);
            } else {
                ArrayList<TimeParameters> values = new ArrayList<TimeParameters>();
                values.add(timeParams);
                this._simulationElementParameters.put(event.getId(), values);
            }
        }
    }

    protected void applyGlobalTaskProperties(GlobalTask globalTask, Map<String, String> properties) {
        if (properties.get("name") != null) {
            globalTask.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")).replaceAll("\\r\\n|\\r|\\n", " "));
        } else {
            globalTask.setName("");
        }
        Utils.setMetaDataExtensionValue((BaseElement)globalTask, "elementname", this.wrapInCDATABlock(properties.get("name").replaceAll("\\\\n", "\n")));
    }

    protected void applyBaseElementProperties(BaseElement baseElement, Map<String, String> properties) {
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
        EAttributeImpl extensionAttribute;
        ExtendedMetaData metadata;
        ArrayList<String> colorsList;
        if (properties.get("documentation") != null && !"".equals(properties.get("documentation"))) {
            if (baseElement instanceof Definitions) {
                this.processDocs = properties.get("documentation");
            } else {
                baseElement.getDocumentation().add(this.createDocumentation(this.wrapInCDATABlock(properties.get("documentation"))));
            }
        }
        if (baseElement.getId() == null || baseElement.getId().length() < 1) {
            baseElement.setId(properties.get("resourceId"));
        }
        if (properties.get("bgcolor") != null && properties.get("bgcolor").length() > 0) {
            if (!this._elementColors.containsKey(baseElement.getId())) {
                colorsList = new ArrayList<String>();
                colorsList.add("bgcolor:" + properties.get("bgcolor"));
                this._elementColors.put(baseElement.getId(), colorsList);
            } else {
                this._elementColors.get(baseElement.getId()).add("bgcolor:" + properties.get("bgcolor"));
            }
        }
        if (properties.get("isselectable") != null && properties.get("isselectable").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "selectable", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("isselectable"));
            baseElement.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("bordercolor") != null && properties.get("bordercolor").length() > 0) {
            if (!this._elementColors.containsKey(baseElement.getId())) {
                colorsList = new ArrayList();
                colorsList.add("bordercolor:" + properties.get("bordercolor"));
                this._elementColors.put(baseElement.getId(), colorsList);
            } else {
                this._elementColors.get(baseElement.getId()).add("bordercolor:" + properties.get("bordercolor"));
            }
        }
        if (properties.get("fontsize") != null && properties.get("fontsize").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "fontsize", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("fontsize"));
            baseElement.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("fontcolor") != null && properties.get("fontcolor").length() > 0) {
            if (!this._elementColors.containsKey(baseElement.getId())) {
                colorsList = new ArrayList();
                colorsList.add("fontcolor:" + properties.get("fontcolor"));
                this._elementColors.put(baseElement.getId(), colorsList);
            } else {
                this._elementColors.get(baseElement.getId()).add("fontcolor:" + properties.get("fontcolor"));
            }
        }
    }

    protected void applyDefinitionProperties(Definitions def, Map<String, String> properties) {
        def.setTypeLanguage(properties.get("typelanguage"));
        def.setTargetNamespace("http://www.omg.org/bpmn20");
        def.setExpressionLanguage(properties.get("expressionlanguage"));
        ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
        EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("xsi", "schemaLocation", false, false);
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)"http://www.omg.org/spec/BPMN/20100524/MODEL BPMN20.xsd http://www.jboss.org/drools drools.xsd http://www.bpsim.org/schemas/1.0 bpsim.xsd");
        def.getAnyAttribute().add((Object)extensionEntry);
    }

    protected void applyProcessProperties(Process process, Map<String, String> properties) {
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionElementEntry;
        ExtensionAttributeValue extensionElement;
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
        EAttributeImpl extensionAttribute;
        ExtendedMetaData metadata;
        if (properties.get("processn") != null) {
            process.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("processn")));
        } else {
            process.setName("");
        }
        if (properties.get("auditing") != null && !"".equals(properties.get("auditing"))) {
            Auditing audit = Bpmn2Factory.eINSTANCE.createAuditing();
            audit.getDocumentation().add(this.createDocumentation(properties.get("auditing")));
            process.setAuditing(audit);
        }
        process.setProcessType(ProcessType.getByName((String)properties.get("processtype")));
        process.setIsClosed(Boolean.parseBoolean(properties.get("isclosed")));
        process.setIsExecutable(Boolean.parseBoolean(properties.get("executable")));
        if (properties.get("package") != null && properties.get("package").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "packageName", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("package"));
            process.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("version") != null && properties.get("version").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "version", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("version"));
            process.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("monitoring") != null && !"".equals(properties.get("monitoring"))) {
            Monitoring monitoring = Bpmn2Factory.eINSTANCE.createMonitoring();
            monitoring.getDocumentation().add(this.createDocumentation(properties.get("monitoring")));
            process.setMonitoring(monitoring);
        }
        if (properties.get("imports") != null && properties.get("imports").length() > 0) {
            String[] allImports;
            for (String importStr : allImports = properties.get("imports").split(",\\s*")) {
                ImportType importType;
                String[] importParts = importStr.split("\\|\\s*");
                if (importParts.length == 2 || importParts.length == 3) {
                    if (importParts[1] != null && importParts[1].equals("default")) {
                        importType = DroolsFactory.eINSTANCE.createImportType();
                        importType.setName(importParts[0]);
                        if (process.getExtensionValues() == null || process.getExtensionValues().size() < 1) {
                            extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                            process.getExtensionValues().add(extensionElement);
                        }
                        extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__IMPORT, (Object)importType);
                        ((ExtensionAttributeValue)process.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
                        continue;
                    }
                    Import imp = Bpmn2Factory.eINSTANCE.createImport();
                    imp.setImportType("http://schemas.xmlsoap.org/wsdl/");
                    imp.setLocation(importParts[0]);
                    imp.setNamespace(importParts[1]);
                    this._wsdlImports.add(imp);
                    continue;
                }
                importType = DroolsFactory.eINSTANCE.createImportType();
                importType.setName(importStr);
                if (process.getExtensionValues() == null || process.getExtensionValues().size() < 1) {
                    extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                    process.getExtensionValues().add(extensionElement);
                }
                extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__IMPORT, (Object)importType);
                ((ExtensionAttributeValue)process.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
            }
        }
        if (properties.get("globals") != null && properties.get("globals").length() > 0) {
            String[] allGlobals;
            for (String globalStr : allGlobals = properties.get("globals").split(",\\s*")) {
                GlobalType globalType;
                String[] globalParts = globalStr.split(":\\s*");
                if (globalParts.length == 2) {
                    globalType = DroolsFactory.eINSTANCE.createGlobalType();
                    globalType.setIdentifier(globalParts[0]);
                    globalType.setType(globalParts[1]);
                    if (process.getExtensionValues() == null || process.getExtensionValues().size() < 1) {
                        extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                        process.getExtensionValues().add(extensionElement);
                    }
                    extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__GLOBAL, (Object)globalType);
                    ((ExtensionAttributeValue)process.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
                    continue;
                }
                if (globalParts.length != 1) continue;
                globalType = DroolsFactory.eINSTANCE.createGlobalType();
                globalType.setIdentifier(globalParts[0]);
                globalType.setType("Object");
                if (process.getExtensionValues() == null || process.getExtensionValues().size() < 1) {
                    extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                    process.getExtensionValues().add(extensionElement);
                }
                extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__GLOBAL, (Object)globalType);
                ((ExtensionAttributeValue)process.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
            }
        }
        if (properties.get("timeunit") != null && properties.get("timeunit").length() > 0) {
            this._simulationScenarioParameters.setBaseTimeUnit(TimeUnit.getByName((String)properties.get("timeunit")));
        }
        if (properties.get("currency") != null && properties.get("currency").length() > 0) {
            this._simulationScenarioParameters.setBaseCurrencyUnit(properties.get("currency"));
        }
    }

    protected void applyBusinessRuleTaskProperties(BusinessRuleTask task, Map<String, String> properties) {
        if (properties.get("ruleflowgroup") != null && properties.get("ruleflowgroup").length() > 0) {
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "ruleFlowGroup", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("ruleflowgroup"));
            task.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("script_language") != null && properties.get("script_language").length() > 0) {
            String scriptLanguage = this.getScriptLanguageFormat(properties);
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl scriptLanguageElement = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "scriptFormat", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)scriptLanguageElement, (Object)scriptLanguage);
            task.getAnyAttribute().add((Object)extensionEntry);
        }
    }

    protected void applyScriptTaskProperties(ScriptTask scriptTask, Map<String, String> properties) {
        if (properties.get("script") != null && properties.get("script").length() > 0) {
            String scriptStr = this.replaceScriptEscapeAndNewLines(properties.get("script"));
            scriptTask.setScript(this.wrapInCDATABlock(scriptStr));
        }
        if (properties.get("script_language") != null && properties.get("script_language").length() > 0) {
            String scriptLanguage = this.getScriptLanguageFormat(properties);
            scriptTask.setScriptFormat(scriptLanguage);
        }
    }

    public void applyServiceTaskProperties(ServiceTask serviceTask, Map<String, String> properties) {
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
        EAttributeImpl extensionAttribute;
        ExtendedMetaData metadata;
        if (properties.get("serviceimplementation") != null && properties.get("serviceimplementation").length() > 0) {
            serviceTask.setImplementation(properties.get("serviceimplementation"));
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "serviceimplementation", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("serviceimplementation"));
            serviceTask.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("serviceoperation") != null && properties.get("serviceoperation").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "serviceoperation", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("serviceoperation"));
            serviceTask.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("serviceinterface") != null && properties.get("serviceinterface").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "serviceinterface", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("serviceinterface"));
            serviceTask.getAnyAttribute().add((Object)extensionEntry);
        }
    }

    public void applyReceiveTaskProperties(ReceiveTask receiveTask, Map<String, String> properties) {
        if (properties.get("messageref") != null && properties.get("messageref").length() > 0) {
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "msgref", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("messageref"));
            receiveTask.getAnyAttribute().add((Object)extensionEntry);
        }
        receiveTask.setImplementation("Other");
    }

    public void applySendTaskProperties(SendTask sendTask, Map<String, String> properties) {
        if (properties.get("messageref") != null && properties.get("messageref").length() > 0) {
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "msgref", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("messageref"));
            sendTask.getAnyAttribute().add((Object)extensionEntry);
        }
        sendTask.setImplementation("Other");
    }

    protected void applyLaneProperties(Lane lane, Map<String, String> properties) {
        if (properties.get("name") != null) {
            lane.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")).replaceAll("\\r\\n|\\r|\\n", " "));
            Utils.setMetaDataExtensionValue((BaseElement)lane, "elementname", this.wrapInCDATABlock(properties.get("name").replaceAll("\\\\n", "\n")));
        } else {
            lane.setName("");
        }
    }

    protected void applyCallActivityProperties(CallActivity callActivity, Map<String, String> properties) {
        String scriptLanguage;
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
        String[] extensionAttribute;
        ExtendedMetaData metadata;
        if (properties.get("name") != null) {
            callActivity.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")).replaceAll("\\r\\n|\\r|\\n", " "));
            Utils.setMetaDataExtensionValue((BaseElement)callActivity, "elementname", this.wrapInCDATABlock(properties.get("name").replaceAll("\\\\n", "\n")));
        } else {
            callActivity.setName("");
        }
        if (properties.get("independent") != null && properties.get("independent").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (String[])metadata.demandFeature("http://www.jboss.org/drools", "independent", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("independent"));
            callActivity.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("waitforcompletion") != null && properties.get("waitforcompletion").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "waitForCompletion", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("waitforcompletion"));
            callActivity.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("calledelement") != null && properties.get("calledelement").length() > 0) {
            callActivity.setCalledElement(properties.get("calledelement"));
        }
        if (properties.get("isasync") != null && properties.get("isasync").length() > 0 && properties.get("isasync").equals("true")) {
            Utils.setMetaDataExtensionValue((BaseElement)callActivity, "customAsync", this.wrapInCDATABlock(properties.get("isasync")));
        }
        this.applyDataInputProperties((Activity)callActivity, properties, new HashMap<String, DataInput>());
        this.applyDataOutputProperties((Activity)callActivity, properties);
        if (properties.get("assignments") != null && properties.get("assignments").length() > 0) {
            String[] allAssignments;
            for (String assignment : allAssignments = properties.get("assignments").split(",\\s*")) {
                ItemAwareElement ie;
                String[] assignmentParts;
                if (assignment.contains("=")) {
                    assignmentParts = assignment.split("=\\s*");
                    DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                    String fromPart = assignmentParts[0];
                    if (fromPart.startsWith("[din]")) {
                        fromPart = fromPart.substring(5, fromPart.length());
                    }
                    boolean foundTaskName = false;
                    if (callActivity.getIoSpecification() != null && callActivity.getIoSpecification().getDataOutputs() != null) {
                        List dataInputs = callActivity.getIoSpecification().getDataInputs();
                        for (DataInput di : dataInputs) {
                            if (!di.getId().equals(callActivity.getId() + "_" + fromPart + "InputX")) continue;
                            dia.setTargetRef((ItemAwareElement)di);
                            if (!di.getName().equals("TaskName")) continue;
                            foundTaskName = true;
                            break;
                        }
                    }
                    Assignment a = Bpmn2Factory.eINSTANCE.createAssignment();
                    FormalExpression fromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    if (assignmentParts.length > 1) {
                        String replacer = this.decodeAssociationValue(assignmentParts[1]);
                        fromExpression.setBody(this.wrapInCDATABlock(replacer));
                    } else {
                        fromExpression.setBody("");
                    }
                    FormalExpression toExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    toExpression.setBody(dia.getTargetRef().getId());
                    a.setFrom((Expression)fromExpression);
                    a.setTo((Expression)toExpression);
                    dia.getAssignment().add(a);
                    callActivity.getDataInputAssociations().add(dia);
                    continue;
                }
                if (!assignment.contains("->")) continue;
                assignmentParts = assignment.split("->\\s*");
                String fromPart = assignmentParts[0];
                boolean isDataInput = false;
                boolean isDataOutput = false;
                if (fromPart.startsWith("[din]")) {
                    fromPart = fromPart.substring(5, fromPart.length());
                    isDataInput = true;
                }
                if (fromPart.startsWith("[dout]")) {
                    fromPart = fromPart.substring(6, fromPart.length());
                    isDataOutput = true;
                }
                List dataOutputs = callActivity.getIoSpecification().getDataOutputs();
                if (isDataOutput) {
                    DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                    for (DataOutput dout : dataOutputs) {
                        if (!dout.getId().equals(callActivity.getId() + "_" + fromPart + "OutputX")) continue;
                        doa.getSourceRef().add(dout);
                        break;
                    }
                    ie = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                    ie.setId(assignmentParts[1]);
                    doa.setTargetRef(ie);
                    callActivity.getDataOutputAssociations().add(doa);
                    continue;
                }
                if (!isDataInput) continue;
                DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                ie = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                ie.setId(fromPart);
                dia.getSourceRef().add(ie);
                List dataInputs = callActivity.getIoSpecification().getDataInputs();
                for (DataInput di : dataInputs) {
                    if (!di.getId().equals(callActivity.getId() + "_" + assignmentParts[1] + "InputX")) continue;
                    dia.setTargetRef((ItemAwareElement)di);
                    break;
                }
                callActivity.getDataInputAssociations().add(dia);
            }
        }
        if (properties.get("onentryactions") != null && properties.get("onentryactions").length() > 0) {
            OnEntryScriptType onEntryScript = DroolsFactory.eINSTANCE.createOnEntryScriptType();
            onEntryScript.setScript(this.wrapInCDATABlock(this.replaceScriptEscapeAndNewLines(properties.get("onentryactions"))));
            scriptLanguage = this.getScriptLanguageFormat(properties);
            onEntryScript.setScriptFormat(scriptLanguage);
            if (callActivity.getExtensionValues() == null || callActivity.getExtensionValues().size() < 1) {
                ExtensionAttributeValue extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                callActivity.getExtensionValues().add(extensionElement);
            }
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__ON_ENTRY_SCRIPT, (Object)onEntryScript);
            ((ExtensionAttributeValue)callActivity.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
        }
        if (properties.get("onexitactions") != null && properties.get("onexitactions").length() > 0) {
            OnExitScriptType onExitScript = DroolsFactory.eINSTANCE.createOnExitScriptType();
            onExitScript.setScript(this.wrapInCDATABlock(this.replaceScriptEscapeAndNewLines(properties.get("onexitactions"))));
            scriptLanguage = this.getScriptLanguageFormat(properties);
            onExitScript.setScriptFormat(scriptLanguage);
            if (callActivity.getExtensionValues() == null || callActivity.getExtensionValues().size() < 1) {
                ExtensionAttributeValue extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                callActivity.getExtensionValues().add(extensionElement);
            }
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__ON_EXIT_SCRIPT, (Object)onExitScript);
            ((ExtensionAttributeValue)callActivity.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
        }
        if (properties.get("distributiontype") != null && properties.get("distributiontype").length() > 0) {
            TimeParameters timeParams = BpsimFactory.eINSTANCE.createTimeParameters();
            Parameter processingTimeParam = BpsimFactory.eINSTANCE.createParameter();
            if (properties.get("distributiontype").equals("normal")) {
                NormalDistributionType normalDistributionType = BpsimFactory.eINSTANCE.createNormalDistributionType();
                normalDistributionType.setStandardDeviation(Double.valueOf(properties.get("standarddeviation")).doubleValue());
                normalDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)normalDistributionType);
            } else if (properties.get("distributiontype").equals("uniform")) {
                UniformDistributionType uniformDistributionType = BpsimFactory.eINSTANCE.createUniformDistributionType();
                uniformDistributionType.setMax(Double.valueOf(properties.get("max")).doubleValue());
                uniformDistributionType.setMin(Double.valueOf(properties.get("min")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)uniformDistributionType);
            } else if (properties.get("distributiontype").equals("poisson")) {
                PoissonDistributionType poissonDistributionType = BpsimFactory.eINSTANCE.createPoissonDistributionType();
                poissonDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)poissonDistributionType);
            }
            if (properties.get("waittime") != null) {
                Parameter waittimeParam = BpsimFactory.eINSTANCE.createParameter();
                FloatingParameterType waittimeParamValue = BpsimFactory.eINSTANCE.createFloatingParameterType();
                DecimalFormat twoDForm = new DecimalFormat("#.##");
                waittimeParamValue.setValue(Double.valueOf(twoDForm.format(Double.valueOf(properties.get("waittime")))).doubleValue());
                waittimeParam.getParameterValue().add((Object)waittimeParamValue);
                timeParams.setWaitTime(waittimeParam);
            }
            timeParams.setProcessingTime(processingTimeParam);
            if (this._simulationElementParameters.containsKey(callActivity.getId())) {
                this._simulationElementParameters.get(callActivity.getId()).add((EObject)timeParams);
            } else {
                ArrayList<TimeParameters> values = new ArrayList<TimeParameters>();
                values.add(timeParams);
                this._simulationElementParameters.put(callActivity.getId(), values);
            }
        }
        CostParameters costParameters = BpsimFactory.eINSTANCE.createCostParameters();
        if (properties.get("unitcost") != null && properties.get("unitcost").length() > 0) {
            Parameter unitcostParam = BpsimFactory.eINSTANCE.createParameter();
            FloatingParameterType unitCostParameterValue = BpsimFactory.eINSTANCE.createFloatingParameterType();
            unitCostParameterValue.setValue(new Double(properties.get("unitcost")).doubleValue());
            unitcostParam.getParameterValue().add((Object)unitCostParameterValue);
            costParameters.setUnitCost(unitcostParam);
        }
        if (this._simulationElementParameters.containsKey(callActivity.getId())) {
            this._simulationElementParameters.get(callActivity.getId()).add((EObject)costParameters);
        } else {
            ArrayList<CostParameters> values = new ArrayList<CostParameters>();
            values.add(costParameters);
            this._simulationElementParameters.put(callActivity.getId(), values);
        }
    }

    protected void applyTaskProperties(Task task, Map<String, String> properties, String preProcessingData) {
        String scriptLanguage;
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
        Object extensionAttribute;
        ExtendedMetaData metadata;
        if (properties.get("name") != null) {
            task.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")).replaceAll("\\r\\n|\\r|\\n", " "));
        } else {
            task.setName("");
        }
        Utils.setMetaDataExtensionValue((BaseElement)task, "elementname", this.wrapInCDATABlock(properties.get("name").replaceAll("\\\\n", "\n")));
        DataInput taskNameDataInput = null;
        if (properties.get("taskname") != null && properties.get("taskname").length() > 0) {
            if (this.isCustomElement(properties.get("tasktype"), preProcessingData)) {
                metadata = ExtendedMetaData.INSTANCE;
                extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "taskName", false, false);
                extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("taskname").replaceAll("&", "").replaceAll(" ", ""));
                task.getAnyAttribute().add((Object)extensionEntry);
            }
            taskNameDataInput = Bpmn2Factory.eINSTANCE.createDataInput();
            taskNameDataInput.setId(task.getId() + "_TaskNameInputX");
            taskNameDataInput.setName("TaskName");
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)"String");
            taskNameDataInput.getAnyAttribute().add((Object)extensionEntry);
            if (task.getIoSpecification() == null) {
                InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            task.getIoSpecification().getDataInputs().add(taskNameDataInput);
            DataInputAssociation taskNameDataInputAssociation = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
            taskNameDataInputAssociation.setTargetRef((ItemAwareElement)taskNameDataInput);
            Assignment taskNameAssignment = Bpmn2Factory.eINSTANCE.createAssignment();
            FormalExpression fromExp = Bpmn2Factory.eINSTANCE.createFormalExpression();
            fromExp.setBody(properties.get("taskname").replaceAll("&", "").replaceAll(" ", ""));
            taskNameAssignment.setFrom((Expression)fromExp);
            FormalExpression toExp = Bpmn2Factory.eINSTANCE.createFormalExpression();
            toExp.setBody(task.getId() + "_TaskNameInputX");
            taskNameAssignment.setTo((Expression)toExp);
            taskNameDataInputAssociation.getAssignment().add(taskNameAssignment);
            task.getDataInputAssociations().add(taskNameDataInputAssociation);
        }
        if (properties.get("lanes") != null && properties.get("lanes").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "lanes", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("lanes"));
            task.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("isasync") != null && properties.get("isasync").length() > 0 && properties.get("isasync").equals("true")) {
            Utils.setMetaDataExtensionValue((BaseElement)task, "customAsync", this.wrapInCDATABlock(properties.get("isasync")));
        }
        if (properties.get("customautostart") != null && properties.get("customautostart").length() > 0 && properties.get("customautostart").equals("true")) {
            Utils.setMetaDataExtensionValue((BaseElement)task, "customAutoStart", this.wrapInCDATABlock(properties.get("customautostart")));
        }
        HashMap<String, DataInput> alreadyProcessedInputs = new HashMap<String, DataInput>();
        alreadyProcessedInputs.put("TaskName", taskNameDataInput);
        this.applyDataInputProperties((Activity)task, properties, alreadyProcessedInputs);
        for (String[] processedInput : alreadyProcessedInputs.values()) {
            if (processedInput == null) continue;
            ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(processedInput);
        }
        this.applyDataOutputProperties((Activity)task, properties);
        if (properties.get("assignments") != null && properties.get("assignments").length() > 0) {
            String[] allAssignments;
            for (String assignment : allAssignments = properties.get("assignments").split(",\\s*")) {
                ItemAwareElement ie;
                String fromPart;
                String[] assignmentParts;
                if (assignment.contains("=")) {
                    assignmentParts = assignment.split("=\\s*");
                    fromPart = assignmentParts[0];
                    if (fromPart.startsWith("[din]")) {
                        fromPart = fromPart.substring(5, fromPart.length());
                    }
                    DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                    boolean foundTaskName = false;
                    if (task.getIoSpecification() != null && task.getIoSpecification().getDataOutputs() != null) {
                        List dataInputs = task.getIoSpecification().getDataInputs();
                        for (DataInput di : dataInputs) {
                            if (!di.getId().equals(task.getId() + "_" + fromPart + (fromPart.endsWith("InputX") ? "" : "InputX"))) continue;
                            dia.setTargetRef((ItemAwareElement)di);
                            if (!di.getName().equals("TaskName")) continue;
                            foundTaskName = true;
                            break;
                        }
                    }
                    if (fromPart.equals("TaskName") && !foundTaskName) {
                        DataInput assignmentTaskNameDataInput = Bpmn2Factory.eINSTANCE.createDataInput();
                        assignmentTaskNameDataInput.setId(task.getId() + "_TaskNameInputX");
                        assignmentTaskNameDataInput.setName("TaskName");
                        if (task.getIoSpecification() == null) {
                            InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                            task.setIoSpecification(iospec);
                        }
                        task.getIoSpecification().getDataInputs().add(assignmentTaskNameDataInput);
                        dia.setTargetRef((ItemAwareElement)assignmentTaskNameDataInput);
                        InputSet inset = (InputSet)task.getIoSpecification().getInputSets().get(0);
                        inset.getDataInputRefs().add(assignmentTaskNameDataInput);
                    }
                    Assignment a = Bpmn2Factory.eINSTANCE.createAssignment();
                    FormalExpression fromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    if (assignmentParts.length > 1) {
                        String replacer = this.decodeAssociationValue(assignmentParts[1]);
                        fromExpression.setBody(this.wrapInCDATABlock(replacer));
                    } else if (properties.get(fromPart.toLowerCase()) != null && properties.get(fromPart.toLowerCase()).length() > 0) {
                        fromExpression.setBody(properties.get(fromPart.toLowerCase()));
                    } else {
                        fromExpression.setBody("");
                    }
                    FormalExpression toExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    toExpression.setBody(dia.getTargetRef().getId());
                    a.setFrom((Expression)fromExpression);
                    a.setTo((Expression)toExpression);
                    dia.getAssignment().add(a);
                    task.getDataInputAssociations().add(dia);
                    continue;
                }
                if (!assignment.contains("->")) continue;
                assignmentParts = assignment.split("->\\s*");
                fromPart = assignmentParts[0];
                boolean isDataInput = false;
                boolean isDataOutput = false;
                if (fromPart.startsWith("[din]")) {
                    fromPart = fromPart.substring(5, fromPart.length());
                    isDataInput = true;
                }
                if (fromPart.startsWith("[dout]")) {
                    fromPart = fromPart.substring(6, fromPart.length());
                    isDataOutput = true;
                }
                List dataOutputs = task.getIoSpecification().getDataOutputs();
                if (isDataOutput) {
                    DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                    for (DataOutput dout : dataOutputs) {
                        if (!dout.getId().equals(task.getId() + "_" + fromPart + (fromPart.endsWith("OutputX") ? "" : "OutputX"))) continue;
                        doa.getSourceRef().add(dout);
                        break;
                    }
                    ie = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                    ie.setId(assignmentParts[1]);
                    doa.setTargetRef(ie);
                    task.getDataOutputAssociations().add(doa);
                    continue;
                }
                if (!isDataInput) continue;
                DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                ie = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                ie.setId(fromPart);
                dia.getSourceRef().add(ie);
                List dataInputs = task.getIoSpecification().getDataInputs();
                for (DataInput di : dataInputs) {
                    if (!di.getId().equals(task.getId() + "_" + assignmentParts[1] + (assignmentParts[1].endsWith("InputX") ? "" : "InputX"))) continue;
                    dia.setTargetRef((ItemAwareElement)di);
                    break;
                }
                task.getDataInputAssociations().add(dia);
            }
            List dataInputAssociations = task.getDataInputAssociations();
            boolean haveTaskNameInput = false;
            Iterator itr = dataInputAssociations.iterator();
            while (itr.hasNext()) {
                Assignment a;
                DataInputAssociation da = (DataInputAssociation)itr.next();
                if (da.getAssignment() == null || da.getAssignment().size() <= 0 || !((FormalExpression)(a = (Assignment)da.getAssignment().get(0)).getTo()).getBody().equals(task.getId() + "_TaskNameInputX")) continue;
                if (!haveTaskNameInput) {
                    haveTaskNameInput = true;
                    continue;
                }
                itr.remove();
            }
        }
        if (properties.get("onentryactions") != null && properties.get("onentryactions").length() > 0) {
            OnEntryScriptType onEntryScript = DroolsFactory.eINSTANCE.createOnEntryScriptType();
            onEntryScript.setScript(this.wrapInCDATABlock(this.replaceScriptEscapeAndNewLines(properties.get("onentryactions"))));
            scriptLanguage = this.getScriptLanguageFormat(properties);
            onEntryScript.setScriptFormat(scriptLanguage);
            if (task.getExtensionValues() == null || task.getExtensionValues().size() < 1) {
                ExtensionAttributeValue extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                task.getExtensionValues().add(extensionElement);
            }
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__ON_ENTRY_SCRIPT, (Object)onEntryScript);
            ((ExtensionAttributeValue)task.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
        }
        if (properties.get("onexitactions") != null && properties.get("onexitactions").length() > 0) {
            OnExitScriptType onExitScript = DroolsFactory.eINSTANCE.createOnExitScriptType();
            onExitScript.setScript(this.wrapInCDATABlock(this.replaceScriptEscapeAndNewLines(properties.get("onexitactions"))));
            scriptLanguage = this.getScriptLanguageFormat(properties);
            onExitScript.setScriptFormat(scriptLanguage);
            if (task.getExtensionValues() == null || task.getExtensionValues().size() < 1) {
                ExtensionAttributeValue extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                task.getExtensionValues().add(extensionElement);
            }
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__ON_EXIT_SCRIPT, (Object)onExitScript);
            ((ExtensionAttributeValue)task.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
        }
        if (properties.get("multipleinstance") != null && properties.get("multipleinstance").length() > 0 && properties.get("multipleinstance").equals("true")) {
            ExtendedMetaData metadata2 = ExtendedMetaData.INSTANCE;
            EAttributeImpl extensionAttribute2 = (EAttributeImpl)metadata2.demandFeature("http://www.jboss.org/drools", "mitask", false, false);
            StringBuffer buff = new StringBuffer();
            buff.append(properties.get("multipleinstancecollectioninput") != null && properties.get("multipleinstancecollectioninput").length() > 0 ? properties.get("multipleinstancecollectioninput") : " ");
            buff.append("@");
            buff.append(properties.get("multipleinstancecollectionoutput") != null && properties.get("multipleinstancecollectionoutput").length() > 0 ? properties.get("multipleinstancecollectionoutput") : " ");
            buff.append("@");
            buff.append(properties.get("multipleinstancedatainput") != null && properties.get("multipleinstancedatainput").length() > 0 ? properties.get("multipleinstancedatainput") : " ");
            buff.append("@");
            buff.append(properties.get("multipleinstancedataoutput") != null && properties.get("multipleinstancedataoutput").length() > 0 ? properties.get("multipleinstancedataoutput") : " ");
            buff.append("@");
            buff.append(properties.get("multipleinstancecompletioncondition") != null && properties.get("multipleinstancecompletioncondition").length() > 0 ? properties.get("multipleinstancecompletioncondition") : " ");
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry2 = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute2, (Object)buff.toString());
            task.getAnyAttribute().add((Object)extensionEntry2);
        }
        if (properties.get("distributiontype") != null && properties.get("distributiontype").length() > 0) {
            TimeParameters timeParams = BpsimFactory.eINSTANCE.createTimeParameters();
            Parameter processingTimeParam = BpsimFactory.eINSTANCE.createParameter();
            if (properties.get("distributiontype").equals("normal")) {
                NormalDistributionType normalDistributionType = BpsimFactory.eINSTANCE.createNormalDistributionType();
                normalDistributionType.setStandardDeviation(Double.valueOf(properties.get("standarddeviation")).doubleValue());
                normalDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)normalDistributionType);
            } else if (properties.get("distributiontype").equals("uniform")) {
                UniformDistributionType uniformDistributionType = BpsimFactory.eINSTANCE.createUniformDistributionType();
                uniformDistributionType.setMax(Double.valueOf(properties.get("max")).doubleValue());
                uniformDistributionType.setMin(Double.valueOf(properties.get("min")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)uniformDistributionType);
            } else if (properties.get("distributiontype").equals("poisson")) {
                PoissonDistributionType poissonDistributionType = BpsimFactory.eINSTANCE.createPoissonDistributionType();
                poissonDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)poissonDistributionType);
            }
            if (properties.get("waittime") != null) {
                Parameter waittimeParam = BpsimFactory.eINSTANCE.createParameter();
                FloatingParameterType waittimeParamValue = BpsimFactory.eINSTANCE.createFloatingParameterType();
                DecimalFormat twoDForm = new DecimalFormat("#.##");
                waittimeParamValue.setValue(Double.valueOf(twoDForm.format(Double.valueOf(properties.get("waittime")))).doubleValue());
                waittimeParam.getParameterValue().add((Object)waittimeParamValue);
                timeParams.setWaitTime(waittimeParam);
            }
            timeParams.setProcessingTime(processingTimeParam);
            if (this._simulationElementParameters.containsKey(task.getId())) {
                this._simulationElementParameters.get(task.getId()).add((EObject)timeParams);
            } else {
                ArrayList<TimeParameters> values = new ArrayList<TimeParameters>();
                values.add(timeParams);
                this._simulationElementParameters.put(task.getId(), values);
            }
        }
        CostParameters costParameters = BpsimFactory.eINSTANCE.createCostParameters();
        if (properties.get("unitcost") != null && properties.get("unitcost").length() > 0) {
            Parameter unitcostParam = BpsimFactory.eINSTANCE.createParameter();
            FloatingParameterType unitCostParameterValue = BpsimFactory.eINSTANCE.createFloatingParameterType();
            unitCostParameterValue.setValue(new Double(properties.get("unitcost")).doubleValue());
            unitcostParam.getParameterValue().add((Object)unitCostParameterValue);
            costParameters.setUnitCost(unitcostParam);
        }
        if (this._simulationElementParameters.containsKey(task.getId())) {
            this._simulationElementParameters.get(task.getId()).add((EObject)costParameters);
        } else {
            ArrayList<CostParameters> values = new ArrayList<CostParameters>();
            values.add(costParameters);
            this._simulationElementParameters.put(task.getId(), values);
        }
    }

    protected void applyUserTaskProperties(UserTask task, Map<String, String> properties) {
        DecimalFormat twoDForm;
        FormalExpression notStartedToExpression;
        FormalExpression notStartedFromExpression;
        FormalExpression notCompletedToExpression;
        FormalExpression notCompletedFromExpression;
        Assignment a;
        DataInputAssociation dia;
        List inputAssociations;
        DataInput foundNotStartedDataInput;
        Assignment a2;
        Object dia2;
        List inputAssociations2;
        InputSet inset;
        String skippableStr;
        Object po;
        this.setLastUserTaskID(task);
        if (properties.get("actors") != null && properties.get("actors").length() > 0) {
            String[] allActors;
            for (String actor : allActors = properties.get("actors").split(",\\s*")) {
                po = Bpmn2Factory.eINSTANCE.createPotentialOwner();
                ResourceAssignmentExpression rae = Bpmn2Factory.eINSTANCE.createResourceAssignmentExpression();
                FormalExpression fe = Bpmn2Factory.eINSTANCE.createFormalExpression();
                fe.setBody(actor);
                rae.setExpression((Expression)fe);
                po.setResourceAssignmentExpression(rae);
                task.getResources().add(po);
            }
        }
        if (properties.get("script_language") != null && properties.get("script_language").length() > 0) {
            String scriptLanguage = this.getScriptLanguageFormat(properties);
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl scriptLanguageElement = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "scriptFormat", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)scriptLanguageElement, (Object)scriptLanguage);
            task.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("groupid") != null && properties.get("groupid").length() > 0) {
            if (task.getIoSpecification() == null) {
                InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            List dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundGroupIdInput = false;
            DataInput foundInput = null;
            for (DataInput din : dataInputs) {
                if (!din.getName().equals("GroupId")) continue;
                foundGroupIdInput = true;
                foundInput = din;
                break;
            }
            if (!foundGroupIdInput) {
                DataInput d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_GroupIdInputX");
                d.setName("GroupId");
                task.getIoSpecification().getDataInputs().add(d);
                foundInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    InputSet inset2 = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset2);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundGroupIdAssociation = false;
            List inputAssociations3 = task.getDataInputAssociations();
            po = inputAssociations3.iterator();
            while (po.hasNext()) {
                DataInputAssociation da = (DataInputAssociation)po.next();
                if (da.getTargetRef() == null || !da.getTargetRef().getId().equals(foundInput.getId())) continue;
                foundGroupIdAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.wrapInCDATABlock(properties.get("groupid")));
            }
            if (!foundGroupIdAssociation) {
                DataInputAssociation dia3 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia3.setTargetRef((ItemAwareElement)foundInput);
                Assignment a3 = Bpmn2Factory.eINSTANCE.createAssignment();
                FormalExpression groupFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                groupFromExpression.setBody(this.wrapInCDATABlock(properties.get("groupid")));
                FormalExpression groupToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                groupToExpression.setBody(foundInput.getId());
                a3.setFrom((Expression)groupFromExpression);
                a3.setTo((Expression)groupToExpression);
                dia3.getAssignment().add(a3);
                task.getDataInputAssociations().add(dia3);
            }
        }
        String string = skippableStr = properties.get("skippable") == null ? "true" : properties.get("skippable");
        if (skippableStr.length() > 0) {
            if (task.getIoSpecification() == null) {
                InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            List dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundSkippableInput = false;
            DataInput foundInput = null;
            for (DataInput din : dataInputs) {
                if (!din.getName().equals("Skippable")) continue;
                foundSkippableInput = true;
                foundInput = din;
                break;
            }
            if (!foundSkippableInput) {
                DataInput d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_SkippableInputX");
                d.setName("Skippable");
                task.getIoSpecification().getDataInputs().add(d);
                foundInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundSkippableAssociation = false;
            inputAssociations2 = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations2) {
                if (da.getTargetRef() == null || !da.getTargetRef().getId().equals(foundInput.getId())) continue;
                foundSkippableAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(skippableStr);
            }
            if (!foundSkippableAssociation) {
                dia2 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia2.setTargetRef((ItemAwareElement)foundInput);
                a2 = Bpmn2Factory.eINSTANCE.createAssignment();
                FormalExpression skippableFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                skippableFromExpression.setBody(skippableStr);
                FormalExpression skippableToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                skippableToExpression.setBody(foundInput.getId());
                a2.setFrom((Expression)skippableFromExpression);
                a2.setTo((Expression)skippableToExpression);
                dia2.getAssignment().add(a2);
                task.getDataInputAssociations().add(dia2);
            }
        }
        if (properties.get("subject") != null && properties.get("subject").length() > 0) {
            if (task.getIoSpecification() == null) {
                InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            List dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundCommentInput = false;
            DataInput foundInput = null;
            for (DataInput din : dataInputs) {
                if (!din.getName().equals("Comment")) continue;
                foundCommentInput = true;
                foundInput = din;
                break;
            }
            if (!foundCommentInput) {
                DataInput d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_CommentInputX");
                d.setName("Comment");
                task.getIoSpecification().getDataInputs().add(d);
                foundInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundCommentAssociation = false;
            inputAssociations2 = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations2) {
                if (da.getTargetRef() == null || !da.getTargetRef().getId().equals(foundInput.getId())) continue;
                foundCommentAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.wrapInCDATABlock(properties.get("subject")));
            }
            if (!foundCommentAssociation) {
                dia2 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia2.setTargetRef((ItemAwareElement)foundInput);
                a2 = Bpmn2Factory.eINSTANCE.createAssignment();
                FormalExpression commentFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                commentFromExpression.setBody(this.wrapInCDATABlock(properties.get("subject")));
                FormalExpression commentToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                commentToExpression.setBody(foundInput.getId());
                a2.setFrom((Expression)commentFromExpression);
                a2.setTo((Expression)commentToExpression);
                dia2.getAssignment().add(a2);
                task.getDataInputAssociations().add(dia2);
            }
        }
        if (properties.get("description") != null && properties.get("description").length() > 0) {
            if (task.getIoSpecification() == null) {
                InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            List dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundDescriptionInput = false;
            DataInput foundInput = null;
            for (DataInput din : dataInputs) {
                if (!din.getName().equals("Description")) continue;
                foundDescriptionInput = true;
                foundInput = din;
                break;
            }
            if (!foundDescriptionInput) {
                DataInput d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_DescriptionInputX");
                d.setName("Description");
                task.getIoSpecification().getDataInputs().add(d);
                foundInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundDescriptionAssociation = false;
            inputAssociations2 = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations2) {
                if (da.getTargetRef() == null || !da.getTargetRef().getId().equals(foundInput.getId())) continue;
                foundDescriptionAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.wrapInCDATABlock(properties.get("description")));
            }
            if (!foundDescriptionAssociation) {
                dia2 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia2.setTargetRef((ItemAwareElement)foundInput);
                a2 = Bpmn2Factory.eINSTANCE.createAssignment();
                FormalExpression descriptionFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                descriptionFromExpression.setBody(this.wrapInCDATABlock(properties.get("description")));
                FormalExpression descriptionToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                descriptionToExpression.setBody(foundInput.getId());
                a2.setFrom((Expression)descriptionFromExpression);
                a2.setTo((Expression)descriptionToExpression);
                dia2.getAssignment().add(a2);
                task.getDataInputAssociations().add(dia2);
            }
        }
        if (properties.get("priority") != null && properties.get("priority").length() > 0) {
            if (task.getIoSpecification() == null) {
                InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            List dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundPriorityInput = false;
            DataInput foundInput = null;
            for (DataInput din : dataInputs) {
                if (!din.getName().equals("Priority")) continue;
                foundPriorityInput = true;
                foundInput = din;
                break;
            }
            if (!foundPriorityInput) {
                DataInput d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_PriorityInputX");
                d.setName("Priority");
                task.getIoSpecification().getDataInputs().add(d);
                foundInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundPriorityAssociation = false;
            inputAssociations2 = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations2) {
                if (da.getTargetRef() == null || !da.getTargetRef().getId().equals(foundInput.getId())) continue;
                foundPriorityAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(properties.get("priority"));
            }
            if (!foundPriorityAssociation) {
                dia2 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia2.setTargetRef((ItemAwareElement)foundInput);
                a2 = Bpmn2Factory.eINSTANCE.createAssignment();
                FormalExpression priorityFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                priorityFromExpression.setBody(properties.get("priority"));
                FormalExpression priorityToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                priorityToExpression.setBody(foundInput.getId());
                a2.setFrom((Expression)priorityFromExpression);
                a2.setTo((Expression)priorityToExpression);
                dia2.getAssignment().add(a2);
                task.getDataInputAssociations().add(dia2);
            }
        }
        if (properties.get("content") != null && properties.get("content").length() > 0) {
            if (task.getIoSpecification() == null) {
                InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                OutputSet outSet = Bpmn2Factory.eINSTANCE.createOutputSet();
                iospec.getOutputSets().add(outSet);
                task.setIoSpecification(iospec);
            }
            List dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundContentInput = false;
            DataInput foundInput = null;
            for (DataInput din : dataInputs) {
                if (!din.getName().equals("Content")) continue;
                foundContentInput = true;
                foundInput = din;
                break;
            }
            if (!foundContentInput) {
                DataInput d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_ContentInputX");
                d.setName("Content");
                task.getIoSpecification().getDataInputs().add(d);
                foundInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundContentAssociation = false;
            inputAssociations2 = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations2) {
                if (da.getTargetRef() == null || !da.getTargetRef().getId().equals(foundInput.getId())) continue;
                foundContentAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.wrapInCDATABlock(properties.get("content")));
            }
            if (!foundContentAssociation) {
                dia2 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia2.setTargetRef((ItemAwareElement)foundInput);
                a2 = Bpmn2Factory.eINSTANCE.createAssignment();
                FormalExpression contentFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                contentFromExpression.setBody(this.wrapInCDATABlock(properties.get("content")));
                FormalExpression contentToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                contentToExpression.setBody(foundInput.getId());
                a2.setFrom((Expression)contentFromExpression);
                a2.setTo((Expression)contentToExpression);
                dia2.getAssignment().add(a2);
                task.getDataInputAssociations().add(dia2);
            }
        }
        if (properties.get("locale") != null && properties.get("locale").length() > 0) {
            if (task.getIoSpecification() == null) {
                InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            List dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundLocaleInput = false;
            DataInput foundInput = null;
            for (DataInput din : dataInputs) {
                if (!din.getName().equals("Locale")) continue;
                foundLocaleInput = true;
                foundInput = din;
                break;
            }
            if (!foundLocaleInput) {
                DataInput d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_LocaleInputX");
                d.setName("Locale");
                task.getIoSpecification().getDataInputs().add(d);
                foundInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundLocaleAssociation = false;
            inputAssociations2 = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations2) {
                if (da.getTargetRef() == null || !da.getTargetRef().getId().equals(foundInput.getId())) continue;
                foundLocaleAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.wrapInCDATABlock(properties.get("locale")));
            }
            if (!foundLocaleAssociation) {
                dia2 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia2.setTargetRef((ItemAwareElement)foundInput);
                a2 = Bpmn2Factory.eINSTANCE.createAssignment();
                FormalExpression localeFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                localeFromExpression.setBody(this.wrapInCDATABlock(properties.get("locale")));
                FormalExpression localeToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                localeToExpression.setBody(foundInput.getId());
                a2.setFrom((Expression)localeFromExpression);
                a2.setTo((Expression)localeToExpression);
                dia2.getAssignment().add(a2);
                task.getDataInputAssociations().add(dia2);
            }
        }
        if (properties.get("createdby") != null && properties.get("createdby").length() > 0) {
            if (task.getIoSpecification() == null) {
                InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            List dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundCreatedByInput = false;
            DataInput foundInput = null;
            for (DataInput din : dataInputs) {
                if (!din.getName().equals("CreatedBy")) continue;
                foundCreatedByInput = true;
                foundInput = din;
                break;
            }
            if (!foundCreatedByInput) {
                DataInput d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_CreatedByInputX");
                d.setName("CreatedBy");
                task.getIoSpecification().getDataInputs().add(d);
                foundInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundCreatedByAssociation = false;
            inputAssociations2 = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations2) {
                if (da.getTargetRef() == null || !da.getTargetRef().getId().equals(foundInput.getId())) continue;
                foundCreatedByAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.wrapInCDATABlock(properties.get("createdby")));
            }
            if (!foundCreatedByAssociation) {
                dia2 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia2.setTargetRef((ItemAwareElement)foundInput);
                a2 = Bpmn2Factory.eINSTANCE.createAssignment();
                FormalExpression createdByFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                createdByFromExpression.setBody(this.wrapInCDATABlock(properties.get("createdby")));
                FormalExpression createdByToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                createdByToExpression.setBody(foundInput.getId());
                a2.setFrom((Expression)createdByFromExpression);
                a2.setTo((Expression)createdByToExpression);
                dia2.getAssignment().add(a2);
                task.getDataInputAssociations().add(dia2);
            }
        }
        if (properties.get("reassignment") != null && properties.get("reassignment").length() > 0) {
            InputSet inset3;
            DataInput d;
            if (task.getIoSpecification() == null) {
                InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            List dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundNotCompletedReassignmentsInput = false;
            boolean foundNotStartedReassignmentsInput = false;
            DataInput foundNotCompletedDataInput = null;
            foundNotStartedDataInput = null;
            for (DataInput din : dataInputs) {
                if (din.getName().equals("NotCompletedReassign")) {
                    foundNotCompletedReassignmentsInput = true;
                    foundNotCompletedDataInput = din;
                }
                if (!din.getName().equals("NotStartedReassign")) continue;
                foundNotStartedReassignmentsInput = true;
                foundNotStartedDataInput = din;
            }
            if (!foundNotCompletedReassignmentsInput) {
                d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_NotCompletedReassignInputX");
                d.setName("NotCompletedReassign");
                task.getIoSpecification().getDataInputs().add(d);
                foundNotCompletedDataInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset3 = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset3);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            if (!foundNotStartedReassignmentsInput) {
                d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_NotStartedReassignInputX");
                d.setName("NotStartedReassign");
                task.getIoSpecification().getDataInputs().add(d);
                foundNotStartedDataInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset3 = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset3);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundNotCompletedReassignmentAssociation = false;
            boolean foundNotStartedReassignmentAssociation = false;
            inputAssociations = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations) {
                if (da.getTargetRef() != null && da.getTargetRef().getId().equals(foundNotCompletedDataInput.getId())) {
                    foundNotCompletedReassignmentAssociation = true;
                    ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.getReassignmentsAndNotificationsForType(properties.get("reassignment"), "not-completed"));
                }
                if (da.getTargetRef() == null || !da.getTargetRef().getId().equals(foundNotStartedDataInput.getId())) continue;
                foundNotStartedReassignmentAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.getReassignmentsAndNotificationsForType(properties.get("reassignment"), "not-started"));
            }
            if (!foundNotCompletedReassignmentAssociation) {
                dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia.setTargetRef((ItemAwareElement)foundNotCompletedDataInput);
                a = Bpmn2Factory.eINSTANCE.createAssignment();
                notCompletedFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                notCompletedFromExpression.setBody(this.getReassignmentsAndNotificationsForType(properties.get("reassignment"), "not-completed"));
                notCompletedToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                notCompletedToExpression.setBody(foundNotCompletedDataInput.getId());
                a.setFrom((Expression)notCompletedFromExpression);
                a.setTo((Expression)notCompletedToExpression);
                dia.getAssignment().add(a);
                task.getDataInputAssociations().add(dia);
            }
            if (!foundNotStartedReassignmentAssociation) {
                dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia.setTargetRef((ItemAwareElement)foundNotStartedDataInput);
                a = Bpmn2Factory.eINSTANCE.createAssignment();
                notStartedFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                notStartedFromExpression.setBody(this.getReassignmentsAndNotificationsForType(properties.get("reassignment"), "not-started"));
                notStartedToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                notStartedToExpression.setBody(foundNotStartedDataInput.getId());
                a.setFrom((Expression)notStartedFromExpression);
                a.setTo((Expression)notStartedToExpression);
                dia.getAssignment().add(a);
                task.getDataInputAssociations().add(dia);
            }
        }
        if (properties.get("notifications") != null && properties.get("notifications").length() > 0) {
            DataInput d;
            if (task.getIoSpecification() == null) {
                InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            List dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundNotCompletedNotificationsInput = false;
            boolean foundNotStartedNotificationsInput = false;
            DataInput foundNotCompletedDataInput = null;
            foundNotStartedDataInput = null;
            for (DataInput din : dataInputs) {
                if (din.getName().equals("NotCompletedNotify")) {
                    foundNotCompletedNotificationsInput = true;
                    foundNotCompletedDataInput = din;
                }
                if (!din.getName().equals("NotStartedNotify")) continue;
                foundNotStartedNotificationsInput = true;
                foundNotStartedDataInput = din;
            }
            if (!foundNotCompletedNotificationsInput) {
                d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_NotCompletedNotifyInputX");
                d.setName("NotCompletedNotify");
                task.getIoSpecification().getDataInputs().add(d);
                foundNotCompletedDataInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    InputSet inset4 = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset4);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            if (!foundNotStartedNotificationsInput) {
                d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_NotStartedNotifyInputX");
                d.setName("NotStartedNotify");
                task.getIoSpecification().getDataInputs().add(d);
                foundNotStartedDataInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    InputSet inset5 = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset5);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundNotCompletedNotificationAssociation = false;
            boolean foundNotStartedNotificationAssociation = false;
            inputAssociations = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations) {
                if (da.getTargetRef() != null && da.getTargetRef().getId().equals(foundNotCompletedDataInput.getId())) {
                    foundNotCompletedNotificationAssociation = true;
                    ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.getReassignmentsAndNotificationsForType(properties.get("notifications"), "not-completed"));
                }
                if (da.getTargetRef() == null || !da.getTargetRef().getId().equals(foundNotStartedDataInput.getId())) continue;
                foundNotStartedNotificationAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.getReassignmentsAndNotificationsForType(properties.get("notifications"), "not-started"));
            }
            if (!foundNotCompletedNotificationAssociation) {
                dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia.setTargetRef((ItemAwareElement)foundNotCompletedDataInput);
                a = Bpmn2Factory.eINSTANCE.createAssignment();
                notCompletedFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                notCompletedFromExpression.setBody(this.getReassignmentsAndNotificationsForType(properties.get("notifications"), "not-completed"));
                notCompletedToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                notCompletedToExpression.setBody(foundNotCompletedDataInput.getId());
                a.setFrom((Expression)notCompletedFromExpression);
                a.setTo((Expression)notCompletedToExpression);
                dia.getAssignment().add(a);
                task.getDataInputAssociations().add(dia);
            }
            if (!foundNotStartedNotificationAssociation) {
                dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia.setTargetRef((ItemAwareElement)foundNotStartedDataInput);
                a = Bpmn2Factory.eINSTANCE.createAssignment();
                notStartedFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                notStartedFromExpression.setBody(this.getReassignmentsAndNotificationsForType(properties.get("notifications"), "not-started"));
                notStartedToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                notStartedToExpression.setBody(foundNotStartedDataInput.getId());
                a.setFrom((Expression)notStartedFromExpression);
                a.setTo((Expression)notStartedToExpression);
                dia.getAssignment().add(a);
                task.getDataInputAssociations().add(dia);
            }
        }
        if (task.getDataInputAssociations() != null) {
            List dataInputAssociations = task.getDataInputAssociations();
            ArrayList<DataInputAssociation> incompleteAssociations = new ArrayList<DataInputAssociation>();
            for (DataInputAssociation dia4 : dataInputAssociations) {
                DataInput targetInput = (DataInput)dia4.getTargetRef();
                if (targetInput == null || targetInput.getName() == null) continue;
                if (targetInput.getName().equals("GroupId") && (properties.get("groupid") == null || properties.get("groupid").length() == 0)) {
                    incompleteAssociations.add(dia4);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("Skippable") && (skippableStr == null || skippableStr.length() == 0)) {
                    incompleteAssociations.add(dia4);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("Comment") && (properties.get("subject") == null || properties.get("subject").length() == 0)) {
                    incompleteAssociations.add(dia4);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("Description") && (properties.get("description") == null || properties.get("description").length() == 0)) {
                    incompleteAssociations.add(dia4);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("Priority") && (properties.get("priority") == null || properties.get("priority").length() == 0)) {
                    incompleteAssociations.add(dia4);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("Content") && (properties.get("content") == null || properties.get("content").length() == 0)) {
                    incompleteAssociations.add(dia4);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("Locale") && (properties.get("locale") == null || properties.get("locale").length() == 0)) {
                    incompleteAssociations.add(dia4);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("CreatedBy") && (properties.get("createdby") == null || properties.get("createdby").length() == 0)) {
                    incompleteAssociations.add(dia4);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("NotCompletedReassign") && (properties.get("reassignment") == null || properties.get("reassignment").length() == 0)) {
                    incompleteAssociations.add(dia4);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("NotStartedReassign") && (properties.get("reassignment") == null || properties.get("reassignment").length() == 0)) {
                    incompleteAssociations.add(dia4);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("NotCompletedNotify") && (properties.get("notifications") == null || properties.get("notifications").length() == 0)) {
                    incompleteAssociations.add(dia4);
                    continue;
                }
                if (!targetInput.getName().equalsIgnoreCase("NotStartedNotify") || properties.get("notifications") != null && properties.get("notifications").length() != 0) continue;
                incompleteAssociations.add(dia4);
            }
            for (DataInputAssociation tr : incompleteAssociations) {
                if (task.getDataInputAssociations() == null) continue;
                task.getDataInputAssociations().remove(tr);
            }
        }
        ArrayList<DataInput> toRemoveDataInputs = new ArrayList<DataInput>();
        if (task.getIoSpecification() != null && task.getIoSpecification().getDataInputs() != null) {
            List taskDataInputs = task.getIoSpecification().getDataInputs();
            for (DataInput din : taskDataInputs) {
                if (din.getName().equals("GroupId") && (properties.get("groupid") == null || properties.get("groupid").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("Skippable") && (skippableStr == null || skippableStr.length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("Comment") && (properties.get("subject") == null || properties.get("subject").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("Description") && (properties.get("description") == null || properties.get("description").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("Priority") && (properties.get("priority") == null || properties.get("priority").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("Content") && (properties.get("content") == null || properties.get("content").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("Locale") && (properties.get("locale") == null || properties.get("locale").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("CreatedBy") && (properties.get("createdby") == null || properties.get("createdby").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("NotCompletedReassign") && (properties.get("reassignment") == null || properties.get("reassignment").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("NotStartedReassign") && (properties.get("reassignment") == null || properties.get("reassignment").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("NotCompletedNotify") && (properties.get("notifications") == null || properties.get("notifications").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (!din.getName().equalsIgnoreCase("NotStartedNotify") || properties.get("notifications") != null && properties.get("notifications").length() != 0) continue;
                toRemoveDataInputs.add(din);
            }
        }
        for (DataInput trdin : toRemoveDataInputs) {
            if (task.getIoSpecification() != null && task.getIoSpecification().getDataInputs() != null && task.getIoSpecification().getInputSets().size() > 0) {
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().remove(trdin);
            }
            task.getIoSpecification().getDataInputs().remove(trdin);
        }
        ResourceParameters resourceParameters = BpsimFactory.eINSTANCE.createResourceParameters();
        if (properties.get("quantity") != null && properties.get("quantity").length() > 0) {
            Parameter quantityParam = BpsimFactory.eINSTANCE.createParameter();
            FloatingParameterType quantityValueParam = BpsimFactory.eINSTANCE.createFloatingParameterType();
            twoDForm = new DecimalFormat("#.##");
            quantityValueParam.setValue(Double.valueOf(twoDForm.format(Double.valueOf(properties.get("quantity")))).doubleValue());
            quantityParam.getParameterValue().add((Object)quantityValueParam);
            resourceParameters.setQuantity(quantityParam);
        }
        if (properties.get("workinghours") != null && properties.get("workinghours").length() > 0) {
            Parameter workingHoursParam = BpsimFactory.eINSTANCE.createParameter();
            FloatingParameterType workingHoursValueParam = BpsimFactory.eINSTANCE.createFloatingParameterType();
            twoDForm = new DecimalFormat("#.##");
            workingHoursValueParam.setValue(Double.valueOf(twoDForm.format(Double.valueOf(properties.get("workinghours")))).doubleValue());
            workingHoursParam.getParameterValue().add((Object)workingHoursValueParam);
            resourceParameters.setAvailability(workingHoursParam);
        }
        if (this._simulationElementParameters.containsKey(task.getId())) {
            this._simulationElementParameters.get(task.getId()).add((EObject)resourceParameters);
        } else {
            ArrayList<ResourceParameters> values = new ArrayList<ResourceParameters>();
            values.add(resourceParameters);
            this._simulationElementParameters.put(task.getId(), values);
        }
    }

    protected void setLastUserTaskID(UserTask task) {
        int i;
        String name = task.getName();
        if (name != null && name.length() > 0 && (i = name.indexOf(DEFAULT_USERTASK_NAME_PREFIX)) == 0) {
            String numStr = name.substring(5);
            try {
                int num = Integer.parseInt(numStr);
                if (num >= this.LastUserTaskID) {
                    this.LastUserTaskID = num;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void applyGatewayProperties(Gateway gateway, Map<String, String> properties) {
        if (properties.get("name") != null && properties.get("name").length() > 0) {
            gateway.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")).replaceAll("\\r\\n|\\r|\\n", " "));
            Utils.setMetaDataExtensionValue((BaseElement)gateway, "elementname", this.wrapInCDATABlock(properties.get("name").replaceAll("\\\\n", "\n")));
        } else {
            gateway.setName("");
        }
        if (properties.get("defaultgate") != null && (gateway instanceof InclusiveGateway || gateway instanceof ExclusiveGateway)) {
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dg", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("defaultgate"));
            gateway.getAnyAttribute().add((Object)extensionEntry);
        }
    }

    protected void applySequenceFlowProperties(SequenceFlow sequenceFlow, Map<String, String> properties) {
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
        EAttributeImpl extensionAttribute;
        ExtendedMetaData metadata;
        ArrayList<String> colorsList;
        if (properties.get("name") != null && !"".equals(properties.get("name"))) {
            sequenceFlow.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")).replaceAll("\\r\\n|\\r|\\n", " "));
            Utils.setMetaDataExtensionValue((BaseElement)sequenceFlow, "elementname", this.wrapInCDATABlock(properties.get("name").replaceAll("\\\\n", "\n")));
        }
        if (properties.get("bgcolor") != null && properties.get("bgcolor").length() > 0) {
            if (!this._elementColors.containsKey(sequenceFlow.getId())) {
                colorsList = new ArrayList<String>();
                colorsList.add("bgcolor:" + properties.get("bgcolor"));
                this._elementColors.put(sequenceFlow.getId(), colorsList);
            } else {
                this._elementColors.get(sequenceFlow.getId()).add("bgcolor:" + properties.get("bgcolor"));
            }
        }
        if (properties.get("bordercolor") != null && properties.get("bordercolor").length() > 0) {
            if (!this._elementColors.containsKey(sequenceFlow.getId())) {
                colorsList = new ArrayList();
                colorsList.add("bordercolor:" + properties.get("bordercolor"));
                this._elementColors.put(sequenceFlow.getId(), colorsList);
            } else {
                this._elementColors.get(sequenceFlow.getId()).add("bordercolor:" + properties.get("bordercolor"));
            }
        }
        if (properties.get("fontsize") != null && properties.get("fontsize").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "fontsize", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("fontsize"));
            sequenceFlow.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("fontcolor") != null && properties.get("fontcolor").length() > 0) {
            if (!this._elementColors.containsKey(sequenceFlow.getId())) {
                colorsList = new ArrayList();
                colorsList.add("fontcolor:" + properties.get("fontcolor"));
                this._elementColors.put(sequenceFlow.getId(), colorsList);
            } else {
                this._elementColors.get(sequenceFlow.getId()).add("fontcolor:" + properties.get("fontcolor"));
            }
        }
        if (properties.get("isselectable") != null && properties.get("isselectable").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "selectable", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("isselectable"));
            sequenceFlow.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("auditing") != null && !"".equals(properties.get("auditing"))) {
            Auditing audit = Bpmn2Factory.eINSTANCE.createAuditing();
            audit.getDocumentation().add(this.createDocumentation(properties.get("auditing")));
            sequenceFlow.setAuditing(audit);
        }
        if (properties.get("conditionexpression") != null && !"".equals(properties.get("conditionexpression"))) {
            FormalExpression expr = Bpmn2Factory.eINSTANCE.createFormalExpression();
            String scriptStr = properties.get("conditionexpression").replaceAll("\\\\n", "\n");
            expr.setBody(this.wrapInCDATABlock(scriptStr));
            if (properties.get("conditionexpressionlanguage") != null && !"".equals(properties.get("conditionexpressionlanguage"))) {
                String languageStr = properties.get("conditionexpressionlanguage").equals("drools") ? "http://www.jboss.org/drools/rule" : (properties.get("conditionexpressionlanguage").equals("mvel") ? "http://www.mvel.org/2.0" : (properties.get("conditionexpressionlanguage").equals("java") ? "http://www.java.com/java" : (properties.get("conditionexpressionlanguage").equals("javascript") ? "http://www.javascript.com/javascript" : "http://www.mvel.org/2.0")));
                expr.setLanguage(languageStr);
            }
            sequenceFlow.setConditionExpression((Expression)expr);
        }
        if (properties.get("priority") != null && !"".equals(properties.get("priority"))) {
            metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl priorityElement = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "priority", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)priorityElement, (Object)properties.get("priority"));
            sequenceFlow.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("monitoring") != null && !"".equals(properties.get("monitoring"))) {
            Monitoring monitoring = Bpmn2Factory.eINSTANCE.createMonitoring();
            monitoring.getDocumentation().add(this.createDocumentation(properties.get("monitoring")));
            sequenceFlow.setMonitoring(monitoring);
        }
        sequenceFlow.setIsImmediate(Boolean.parseBoolean(properties.get("isimmediate")));
        if (properties.get("probability") != null && properties.get("probability").length() > 0) {
            ControlParameters controlParams = BpsimFactory.eINSTANCE.createControlParameters();
            Parameter probParam = BpsimFactory.eINSTANCE.createParameter();
            FloatingParameterType probParamValueParam = BpsimFactory.eINSTANCE.createFloatingParameterType();
            DecimalFormat twoDForm = new DecimalFormat("#.##");
            probParamValueParam.setValue(Double.valueOf(twoDForm.format(Double.valueOf(properties.get("probability")))).doubleValue());
            probParam.getParameterValue().add((Object)probParamValueParam);
            controlParams.setProbability(probParam);
            if (this._simulationElementParameters.containsKey(sequenceFlow.getId())) {
                this._simulationElementParameters.get(sequenceFlow.getId()).add((EObject)controlParams);
            } else {
                ArrayList<ControlParameters> values = new ArrayList<ControlParameters>();
                values.add(controlParams);
                this._simulationElementParameters.put(sequenceFlow.getId(), values);
            }
        }
    }

    private Map<String, String> unmarshallProperties(JsonParser parser) throws JsonParseException, IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = parser.getCurrentName();
            parser.nextToken();
            properties.put(fieldname, parser.getText());
        }
        return properties;
    }

    private Documentation createDocumentation(String text) {
        Documentation doc = Bpmn2Factory.eINSTANCE.createDocumentation();
        doc.setText(text);
        return doc;
    }

    private boolean isCustomElement(String taskType, String preProcessingData) {
        if (taskType != null && taskType.length() > 0 && preProcessingData != null && preProcessingData.length() > 0) {
            String[] preProcessingDataElements;
            for (String preProcessingDataElement : preProcessingDataElements = preProcessingData.split(",\\s*")) {
                if (!taskType.equals(preProcessingDataElement)) continue;
                return true;
            }
        }
        return false;
    }

    protected BaseElement createBaseElement(String stencil, String taskType, boolean customElement) {
        return Bpmn20Stencil.createElement(stencil, taskType, customElement);
    }

    protected String wrapInCDATABlock(String value) {
        return "<![CDATA[" + value + "]]>";
    }

    private static String escapeXmlString(String string) {
        StringBuffer sb = new StringBuffer(string.length());
        boolean lastWasBlankChar = false;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                sb.append(' ');
                continue;
            }
            lastWasBlankChar = false;
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            int ci = 0xFFFF & c;
            if (ci < 160) {
                sb.append(c);
                continue;
            }
            sb.append("&#");
            sb.append(Integer.toString(ci));
            sb.append(';');
        }
        return sb.toString();
    }

    private String getReassignmentsAndNotificationsForType(String inputStr, String type) {
        String[] parts = inputStr.split("\\^\\s*");
        String ret = "";
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].endsWith("^")) {
                parts[i] = parts[i].substring(0, parts[i].length() - 1);
            }
            if (!parts[i].endsWith("@" + type)) continue;
            ret = ret + parts[i].substring(0, parts[i].length() - ("@" + type).length());
            ret = ret + "^";
        }
        if (ret.endsWith("^")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return this.wrapInCDATABlock(ret);
    }

    private String replaceScriptEscapeAndNewLines(String str) {
        StringBuilder result = new StringBuilder(str.length());
        char c = '\u0000';
        char prevC = '\u0000';
        boolean atEscape = false;
        for (int i = 0; i < str.length(); ++i) {
            prevC = c;
            c = str.charAt(i);
            if (c == '\\') {
                if (atEscape) {
                    result.append(c);
                    atEscape = false;
                    c = '\u0000';
                } else {
                    atEscape = true;
                }
            } else if (atEscape) {
                if (c == 'n') {
                    result.append("\n");
                } else {
                    result.append(c);
                }
            } else {
                result.append(c);
            }
            if (prevC != '\\' || !atEscape) continue;
            atEscape = false;
        }
        return result.toString();
    }

    private String decodeAssociationValue(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    private String getIdForRootElement(String name) {
        String id = null;
        if (name != null && !name.isEmpty()) {
            try {
                id = "_" + UUID.nameUUIDFromBytes(name.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                id = "_" + UUID.nameUUIDFromBytes(name.getBytes());
            }
        } else {
            id = "_" + UUID.randomUUID();
        }
        return Utils.toBPMNIdentifier(id);
    }
}

