/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import bpsim.impl.BpsimFactoryImpl;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.bpmn2.Definitions;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jbpm.designer.bpmn2.impl.Bpmn2JsonUnmarshaller;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.taskforms.TaskFormInfo;
import org.jbpm.designer.taskforms.TaskFormTemplateManager;
import org.jbpm.designer.util.ConfigurationProvider;
import org.jbpm.designer.util.Utils;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.formModeler.designer.integration.BPMNFormBuilderService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;

public class TaskFormsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = LoggerFactory.getLogger(TaskFormsServlet.class);
    private static final String TASKFORMS_PATH = "taskforms";
    private static final String FORMTEMPLATE_FILE_EXTENSION = "ftl";
    private static final String FORMMODELER_FILE_EXTENSION = "form";
    public static final String DESIGNER_PATH = ConfigurationProvider.getInstance().getDesignerContext();
    private IDiagramProfile profile;
    @Inject
    private IDiagramProfileService _profileService = null;
    @Inject
    private BPMNFormBuilderService formModelerService;
    @Inject
    private VFSService vfsServices;

    public void setProfile(IDiagramProfile profile) {
        this.profile = profile;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        String json = req.getParameter("json");
        String uuid = Utils.getUUID(req);
        String profileName = req.getParameter("profile");
        String preprocessingData = req.getParameter("ppdata");
        String taskId = req.getParameter("taskid");
        if (this.profile == null) {
            this.profile = this._profileService.findProfile(req, profileName);
        }
        Repository repository = this.profile.getRepository();
        Asset processAsset = null;
        try {
            processAsset = repository.loadAsset(uuid);
            DroolsFactoryImpl.init();
            BpsimFactoryImpl.init();
            Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
            Definitions def = (Definitions)unmarshaller.unmarshall(json, preprocessingData).getContents().get(0);
            Path myPath = this.vfsServices.get(uuid);
            TaskFormTemplateManager templateManager = new TaskFormTemplateManager(myPath, this.formModelerService, this.profile, processAsset, this.getServletContext().getRealPath(DESIGNER_PATH + TASKFORMS_PATH), def, taskId);
            templateManager.processTemplates();
            resp.setContentType("application/json");
            resp.getWriter().write(this.storeInRepository(templateManager, processAsset.getAssetLocation(), repository).toString());
        }
        catch (Exception e) {
            _logger.error(e.getMessage());
            resp.setContentType("text/plain");
            resp.getWriter().write("fail");
        }
    }

    public JSONArray storeInRepository(TaskFormTemplateManager templateManager, String location, Repository repository) throws Exception {
        JSONArray retArray = new JSONArray();
        List<TaskFormInfo> taskForms = templateManager.getTaskFormInformationList();
        for (TaskFormInfo taskForm : taskForms) {
            retArray.put((Object)this.storeTaskForm(taskForm, location, repository));
        }
        return retArray;
    }

    public JSONObject storeTaskForm(TaskFormInfo taskForm, String location, Repository repository) throws Exception {
        try {
            JSONObject retObj = new JSONObject();
            repository.deleteAssetFromPath(taskForm.getPkgName() + "/" + taskForm.getId() + "." + FORMTEMPLATE_FILE_EXTENSION);
            AssetBuilder builder = AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Byte);
            builder.name(taskForm.getId()).location(location).type(FORMTEMPLATE_FILE_EXTENSION).content(taskForm.getMetaOutput().getBytes("UTF-8"));
            repository.createAsset(builder.getAsset());
            Asset newFormAsset = repository.loadAssetFromPath(taskForm.getPkgName() + "/" + taskForm.getId() + "." + FORMTEMPLATE_FILE_EXTENSION);
            String uniqueId = newFormAsset.getUniqueId();
            if (Base64.isBase64((String)uniqueId)) {
                byte[] decoded = Base64.decodeBase64((String)uniqueId);
                try {
                    uniqueId = new String(decoded, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            retObj.put("ftluri", (Object)uniqueId);
            repository.deleteAssetFromPath(taskForm.getPkgName() + "/" + taskForm.getId() + "." + FORMMODELER_FILE_EXTENSION);
            AssetBuilder modelerBuilder = AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Byte);
            modelerBuilder.name(taskForm.getId()).location(location).type(FORMMODELER_FILE_EXTENSION).content(taskForm.getModelerOutput().getBytes("UTF-8"));
            repository.createAsset(modelerBuilder.getAsset());
            Asset newModelerFormAsset = repository.loadAssetFromPath(taskForm.getPkgName() + "/" + taskForm.getId() + "." + FORMMODELER_FILE_EXTENSION);
            String modelerUniqueId = newModelerFormAsset.getUniqueId();
            if (Base64.isBase64((String)modelerUniqueId)) {
                byte[] decoded = Base64.decodeBase64((String)modelerUniqueId);
                try {
                    modelerUniqueId = new String(decoded, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            retObj.put("formuri", (Object)modelerUniqueId);
            return retObj;
        }
        catch (Exception e) {
            _logger.error(e.getMessage());
            return new JSONObject();
        }
    }
}

