/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.io.IOException;
import java.io.PrintWriter;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.util.Utils;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_LOAD = "load";
    private static final String ACTION_SAVE = "save";
    private static final String DICTIONARY_FNAME = "processdictionary";
    private static final String DICTIONARY_FEXT = "json";
    private static final Logger _logger = LoggerFactory.getLogger(DictionaryServlet.class);
    private ServletConfig config;
    private IDiagramProfile profile;
    @Inject
    private IDiagramProfileService _profileService = null;

    public void setProfile(IDiagramProfile profile) {
        this.profile = profile;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = req.getParameter("action");
        String uuid = Utils.getUUID(req);
        String profileName = req.getParameter("profile");
        String dvalue = req.getParameter("dvalue");
        if (this.profile == null) {
            this.profile = this._profileService.findProfile(req, profileName);
        }
        Repository repository = this.profile.getRepository();
        if (action != null && action.equals(ACTION_SAVE)) {
            this.storeInRepository(uuid, this.profile, dvalue, repository);
            PrintWriter pw = resp.getWriter();
            resp.setContentType("text/plain");
            resp.setCharacterEncoding("UTF-8");
            pw.write("saved");
        } else if (action != null && action.equals(ACTION_LOAD)) {
            PrintWriter pw = resp.getWriter();
            resp.setContentType("text/json");
            resp.setCharacterEncoding("UTF-8");
            pw.write(this.getFromRepository(uuid, this.profile, repository));
        }
    }

    private String getFromRepository(String uuid, IDiagramProfile profile, Repository repository) {
        try {
            Asset dictionaryAsset = repository.loadAssetFromPath(profile.getRepositoryGlobalDir(uuid) + "/" + DICTIONARY_FNAME + "." + DICTIONARY_FEXT);
            if (dictionaryAsset != null) {
                return (String)dictionaryAsset.getAssetContent();
            }
            return "false";
        }
        catch (Throwable t) {
            _logger.info("Unable to find existing dictionary information.");
            return "false";
        }
    }

    private void storeInRepository(String uuid, IDiagramProfile profile, String dvalue, Repository repository) {
        try {
            repository.deleteAssetFromPath(profile.getRepositoryGlobalDir(uuid) + "/" + DICTIONARY_FNAME + "." + DICTIONARY_FEXT);
            AssetBuilder builder = AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Text);
            builder.name(DICTIONARY_FNAME).type(DICTIONARY_FEXT).location(profile.getRepositoryGlobalDir(uuid)).content(dvalue);
            repository.createAsset(builder.getAsset());
        }
        catch (Exception e) {
            _logger.error(e.getMessage());
        }
    }
}

