/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestHttpServletResponse;
import org.jbpm.designer.helper.TestServletConfig;
import org.jbpm.designer.helper.TestServletContext;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Filter;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.UriUtils;
import org.jbpm.designer.repository.filters.FilterByExtension;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.server.TaskFormsEditorServlet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskFormsEditorServletTest
extends RepositoryBaseTest {
    @Override
    @Before
    public void setup() {
        super.setup();
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testSaveFormAsset() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String uniqueId = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("action", "save");
        params.put("profile", "jbpm");
        params.put("taskname", Base64.encodeBase64String((byte[])UriUtils.encode((String)"evaluate").getBytes()));
        params.put("tfvalue", "this is simple task content");
        params.put("formtype", "ftl");
        TaskFormsEditorServlet taskFormsEditorServlet = new TaskFormsEditorServlet();
        taskFormsEditorServlet.setProfile((IDiagramProfile)this.profile);
        taskFormsEditorServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        taskFormsEditorServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)new TestHttpServletResponse());
        Collection forms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("ftl"));
        Assert.assertNotNull((Object)forms);
        Assert.assertEquals((long)1L, (long)forms.size());
        Iterator assets = forms.iterator();
        Asset asset1 = (Asset)assets.next();
        Assert.assertEquals((Object)"evaluate-taskform", (Object)asset1.getName());
        Assert.assertEquals((Object)"/defaultPackage", (Object)asset1.getAssetLocation());
        Asset form1 = repository.loadAsset(asset1.getUniqueId());
        Assert.assertNotNull((Object)form1.getAssetContent());
        Assert.assertEquals((Object)"this is simple task content", (Object)form1.getAssetContent());
    }

    @Test
    public void testLoadFormAsset() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("testprocess").location("/defaultPackage");
        String uniqueId = repository.createAsset(builder.getAsset());
        AssetBuilder builderForm = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builderForm.content((Object)"this is simple task content").type("ftl").name("evaluate-taskform").location("/defaultPackage");
        String uniqueIdForm = repository.createAsset(builderForm.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("action", "load");
        params.put("profile", "jbpm");
        params.put("taskname", Base64.encodeBase64String((byte[])UriUtils.encode((String)"evaluate").getBytes()));
        params.put("tfvalue", "this is simple task content");
        params.put("formtype", "ftl");
        TaskFormsEditorServlet taskFormsEditorServlet = new TaskFormsEditorServlet();
        taskFormsEditorServlet.setProfile((IDiagramProfile)this.profile);
        taskFormsEditorServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        taskFormsEditorServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String formData = new String(response.getContent());
        System.out.println(formData);
        Assert.assertEquals((Object)"this is simple task content", (Object)formData);
    }

    @Test
    public void testLoadForm_i18nName() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("BPTaskForm_i18nNames").location("/defaultPackage");
        String uniqueId = repository.createAsset(builder.getAsset());
        String taskName = "\u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("action", "load");
        params.put("profile", "jbpm");
        params.put("taskname", Base64.encodeBase64String((byte[])UriUtils.encode((String)taskName).getBytes()));
        params.put("tfvalue", "this is simple task content");
        params.put("formtype", "ftl");
        TaskFormsEditorServlet taskFormsEditorServlet = new TaskFormsEditorServlet();
        taskFormsEditorServlet.setProfile((IDiagramProfile)this.profile);
        taskFormsEditorServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        taskFormsEditorServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        Collection forms = repository.listAssets("/defaultPackage", (Filter)new FilterByExtension("ftl"));
        Assert.assertNotNull((Object)forms);
        Assert.assertEquals((long)1L, (long)forms.size());
        Iterator assets = forms.iterator();
        Asset asset1 = (Asset)assets.next();
        Assert.assertEquals((Object)(taskName + "-taskform"), (Object)asset1.getName());
    }
}

