/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.bpmn2.impl;

import bpsim.BPSimDataType;
import bpsim.BpsimPackage;
import bpsim.ControlParameters;
import bpsim.CostParameters;
import bpsim.ElementParameters;
import bpsim.FloatingParameterType;
import bpsim.NormalDistributionType;
import bpsim.Parameter;
import bpsim.ParameterValue;
import bpsim.PoissonDistributionType;
import bpsim.ResourceParameters;
import bpsim.Scenario;
import bpsim.TimeParameters;
import bpsim.UniformDistributionType;
import bpsim.impl.BpsimPackageImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.AdHocOrdering;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.Artifact;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.AssociationDirection;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.BusinessRuleTask;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CallableElement;
import org.eclipse.bpmn2.CancelEventDefinition;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.Choreography;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ComplexGateway;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.Conversation;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Documentation;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.Error;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.Escalation;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventBasedGateway;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.GlobalBusinessRuleTask;
import org.eclipse.bpmn2.GlobalChoreographyTask;
import org.eclipse.bpmn2.GlobalManualTask;
import org.eclipse.bpmn2.GlobalScriptTask;
import org.eclipse.bpmn2.GlobalTask;
import org.eclipse.bpmn2.GlobalUserTask;
import org.eclipse.bpmn2.Group;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.Interface;
import org.eclipse.bpmn2.IntermediateCatchEvent;
import org.eclipse.bpmn2.IntermediateThrowEvent;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.ManualTask;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.OutputSet;
import org.eclipse.bpmn2.ParallelGateway;
import org.eclipse.bpmn2.PotentialOwner;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.Relationship;
import org.eclipse.bpmn2.Resource;
import org.eclipse.bpmn2.ResourceRole;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.ScriptTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.ServiceTask;
import org.eclipse.bpmn2.Signal;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.TerminateEventDefinition;
import org.eclipse.bpmn2.TextAnnotation;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.eclipse.bpmn2.UserTask;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.Point;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.GlobalType;
import org.jboss.drools.ImportType;
import org.jboss.drools.MetaDataType;
import org.jboss.drools.OnEntryScriptType;
import org.jboss.drools.OnExitScriptType;
import org.jboss.drools.impl.DroolsPackageImpl;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bpmn2JsonMarshaller {
    public static final String defaultBgColor_Activities = "#fafad2";
    public static final String defaultBgColor_Events = "#f5deb3";
    public static final String defaultBgColor_StartEvents = "#9acd32";
    public static final String defaultBgColor_EndEvents = "#ff6347";
    public static final String defaultBgColor_DataObjects = "#C0C0C0";
    public static final String defaultBgColor_CatchingEvents = "#f5deb3";
    public static final String defaultBgColor_ThrowingEvents = "#8cabff";
    public static final String defaultBgColor_Gateways = "#f0e68c";
    public static final String defaultBgColor_Swimlanes = "#ffffff";
    public static final String defaultBrColor = "#000000";
    public static final String defaultBrColor_CatchingEvents = "#a0522d";
    public static final String defaultBrColor_ThrowingEvents = "#008cec";
    public static final String defaultBrColor_Gateways = "#a67f00";
    public static final String defaultFontColor = "#000000";
    public static final String defaultSequenceflowColor = "#000000";
    private static final List<String> defaultTypesList = Arrays.asList("Object", "Boolean", "Float", "Integer", "List", "String");
    private Map<String, DiagramElement> _diagramElements = new HashMap<String, DiagramElement>();
    private Map<String, Association> _diagramAssociations = new HashMap<String, Association>();
    private Scenario _simulationScenario = null;
    private static final Logger _logger = LoggerFactory.getLogger(Bpmn2JsonMarshaller.class);
    private IDiagramProfile profile;
    private boolean coordianteManipulation = true;

    public void setProfile(IDiagramProfile profile) {
        this.profile = profile;
    }

    public String marshall(Definitions def, String preProcessingData) throws IOException {
        boolean haveExporter;
        DroolsPackageImpl.init();
        BpsimPackageImpl.init();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonFactory f = new JsonFactory();
        JsonGenerator generator = f.createJsonGenerator((OutputStream)baos, JsonEncoding.UTF8);
        if (def.getRelationships() != null && def.getRelationships().size() > 0) {
            Relationship relationship = (Relationship)def.getRelationships().get(0);
            for (ExtensionAttributeValue extattrval : relationship.getExtensionValues()) {
                BPSimDataType processAnalysis;
                FeatureMap extensionElements = extattrval.getValue();
                List bpsimExtensions = (List)extensionElements.get((EStructuralFeature)BpsimPackage.Literals.DOCUMENT_ROOT__BP_SIM_DATA, true);
                if (bpsimExtensions == null || bpsimExtensions.size() <= 0 || (processAnalysis = (BPSimDataType)bpsimExtensions.get(0)).getScenario() == null || processAnalysis.getScenario().size() <= 0) continue;
                this._simulationScenario = (Scenario)processAnalysis.getScenario().get(0);
            }
        }
        if (preProcessingData == null || preProcessingData.length() < 1) {
            preProcessingData = "ReadOnlyService";
        }
        String bpmn2Exporter = def.getExporter();
        String bpmn2ExporterVersion = def.getExporterVersion();
        boolean bl = haveExporter = bpmn2Exporter != null && bpmn2ExporterVersion != null;
        if (this._simulationScenario != null && !haveExporter) {
            this.coordianteManipulation = false;
        }
        this.marshallDefinitions(def, generator, preProcessingData);
        generator.close();
        return baos.toString("UTF-8");
    }

    private void linkSequenceFlows(List<FlowElement> flowElements) {
        HashMap<String, FlowNode> nodes = new HashMap<String, FlowNode>();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof FlowNode)) continue;
            nodes.put(flowElement.getId(), (FlowNode)flowElement);
            if (!(flowElement instanceof SubProcess)) continue;
            this.linkSequenceFlows(((SubProcess)flowElement).getFlowElements());
        }
        for (FlowElement flowElement : flowElements) {
            SequenceFlow sequenceFlow;
            if (!(flowElement instanceof SequenceFlow) || (sequenceFlow = (SequenceFlow)flowElement).getSourceRef() != null || sequenceFlow.getTargetRef() != null) continue;
            String id = sequenceFlow.getId();
            try {
                FlowNode target;
                String[] subids = id.split("-_");
                String id1 = subids[0];
                String id2 = "_" + subids[1];
                FlowNode source = (FlowNode)nodes.get(id1);
                if (source != null) {
                    sequenceFlow.setSourceRef(source);
                }
                if ((target = (FlowNode)nodes.get(id2)) == null) continue;
                sequenceFlow.setTargetRef(target);
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void marshallDefinitions(Definitions def, JsonGenerator generator, String preProcessingData) throws JsonGenerationException, IOException {
        try {
            generator.writeStartObject();
            generator.writeObjectField("resourceId", (Object)def.getId());
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("namespaces", "");
            props.put("targetnamespace", "http://www.omg.org/bpmn20");
            props.put("typelanguage", def.getTypeLanguage());
            props.put("name", Bpmn2JsonMarshaller.unescapeXML(def.getName()));
            props.put("id", def.getId());
            props.put("expressionlanguage", def.getExpressionLanguage());
            if (def.getDocumentation() != null && def.getDocumentation().size() > 0) {
                props.put("documentation", ((Documentation)def.getDocumentation().get(0)).getText());
            }
            for (RootElement rootElement : def.getRootElements()) {
                if (rootElement instanceof Process) {
                    List wsdlImports;
                    FeatureMap extensionElements;
                    List processProperties;
                    Process pr;
                    props.put("executable", ((Process)rootElement).isIsExecutable() + "");
                    props.put("id", rootElement.getId());
                    if (rootElement.getDocumentation() != null && rootElement.getDocumentation().size() > 0) {
                        props.put("documentation", ((Documentation)rootElement.getDocumentation().get(0)).getText());
                    }
                    if ((pr = (Process)rootElement).getName() != null && pr.getName().length() > 0) {
                        props.put("processn", Bpmn2JsonMarshaller.unescapeXML(((Process)rootElement).getName()));
                    }
                    if ((processProperties = ((Process)rootElement).getProperties()) != null && processProperties.size() > 0) {
                        String propVal = "";
                        for (int i = 0; i < processProperties.size(); ++i) {
                            Property p = (Property)processProperties.get(i);
                            String pKPI = "";
                            if (p.getExtensionValues() != null && p.getExtensionValues().size() > 0) {
                                for (ExtensionAttributeValue extattrval : p.getExtensionValues()) {
                                    extensionElements = extattrval.getValue();
                                    List metadataExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true);
                                    for (MetaDataType metaType : metadataExtensions) {
                                        if (metaType.getName() == null || !metaType.getName().equals("customKPI") || metaType.getMetaValue() == null || metaType.getMetaValue().length() <= 0) continue;
                                        pKPI = metaType.getMetaValue();
                                    }
                                }
                            }
                            propVal = propVal + p.getId();
                            if (p.getItemSubjectRef() != null && p.getItemSubjectRef().getStructureRef() != null) {
                                propVal = propVal + ":" + p.getItemSubjectRef().getStructureRef();
                            }
                            if (pKPI.length() > 0) {
                                propVal = propVal + ":" + pKPI;
                            }
                            if (i == processProperties.size() - 1) continue;
                            propVal = propVal + ",";
                        }
                        props.put("vardefs", propVal);
                    }
                    for (FeatureMap.Entry entry : ((Process)rootElement).getAnyAttribute()) {
                        if (entry.getEStructuralFeature().getName().equals("packageName")) {
                            props.put("package", entry.getValue());
                        }
                        if (entry.getEStructuralFeature().getName().equals("version")) {
                            props.put("version", entry.getValue());
                        }
                        if (!entry.getEStructuralFeature().getName().equals("adHoc")) continue;
                        props.put("adhocprocess", entry.getValue());
                    }
                    String allImports = "";
                    if (rootElement.getExtensionValues() != null && rootElement.getExtensionValues().size() > 0) {
                        String importsStr = "";
                        String globalsStr = "";
                        for (ExtensionAttributeValue extattrval : rootElement.getExtensionValues()) {
                            extensionElements = extattrval.getValue();
                            List importExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__IMPORT, true);
                            List globalExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__GLOBAL, true);
                            List metadataExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true);
                            for (ImportType importType : importExtensions) {
                                importsStr = importsStr + importType.getName();
                                importsStr = importsStr + "|default,";
                            }
                            for (GlobalType globalType : globalExtensions) {
                                globalsStr = globalsStr + globalType.getIdentifier() + ":" + globalType.getType();
                                globalsStr = globalsStr + ",";
                            }
                            for (MetaDataType metaType : metadataExtensions) {
                                props.put("customdescription", metaType.getMetaValue());
                            }
                        }
                        allImports = allImports + importsStr;
                        if (globalsStr.length() > 0) {
                            if (globalsStr.endsWith(",")) {
                                globalsStr = globalsStr.substring(0, globalsStr.length() - 1);
                            }
                            props.put("globals", globalsStr);
                        }
                    }
                    if ((wsdlImports = def.getImports()) != null) {
                        for (Import imp : wsdlImports) {
                            allImports = allImports + imp.getLocation() + "|" + imp.getNamespace() + "|wsdl,";
                        }
                    }
                    if (allImports.endsWith(",")) {
                        allImports = allImports.substring(0, allImports.length() - 1);
                    }
                    props.put("imports", allImports);
                    if (this._simulationScenario != null && this._simulationScenario.getScenarioParameters() != null) {
                        props.put("currency", this._simulationScenario.getScenarioParameters().getBaseCurrencyUnit() == null ? "" : this._simulationScenario.getScenarioParameters().getBaseCurrencyUnit());
                        props.put("timeunit", this._simulationScenario.getScenarioParameters().getBaseTimeUnit().getName());
                    }
                    this.marshallProperties(props, generator);
                    this.marshallStencil("BPMNDiagram", generator);
                    this.linkSequenceFlows(((Process)rootElement).getFlowElements());
                    this.marshallProcess((Process)rootElement, def, generator, preProcessingData);
                    continue;
                }
                if (rootElement instanceof Interface || rootElement instanceof ItemDefinition || rootElement instanceof Resource || rootElement instanceof Error || rootElement instanceof Message || rootElement instanceof Signal || rootElement instanceof Escalation || rootElement instanceof Collaboration) continue;
                _logger.warn("Unknown root element " + rootElement + ". This element will not be parsed.");
            }
            generator.writeObjectFieldStart("stencilset");
            generator.writeObjectField("url", (Object)this.profile.getStencilSetURL());
            generator.writeObjectField("namespace", (Object)this.profile.getStencilSetNamespaceURL());
            generator.writeEndObject();
            generator.writeArrayFieldStart("ssextensions");
            generator.writeObject((Object)this.profile.getStencilSetExtensionURL());
            generator.writeEndArray();
            generator.writeEndObject();
        }
        finally {
            this._diagramElements.clear();
        }
    }

    protected void marshallCallableElement(CallableElement callableElement, Definitions def, JsonGenerator generator) throws JsonGenerationException, IOException {
        generator.writeStartObject();
        generator.writeObjectField("resourceId", (Object)callableElement.getId());
        if (callableElement instanceof Choreography) {
            this.marshallChoreography((Choreography)callableElement, generator);
        } else if (callableElement instanceof Conversation) {
            this.marshallConversation((Conversation)callableElement, generator);
        } else if (callableElement instanceof GlobalChoreographyTask) {
            this.marshallGlobalChoreographyTask((GlobalChoreographyTask)callableElement, generator);
        } else if (callableElement instanceof GlobalTask) {
            this.marshallGlobalTask((GlobalTask)callableElement, generator);
        } else if (callableElement instanceof Process) {
            this.marshallProcess((Process)callableElement, def, generator, "");
        } else {
            throw new UnsupportedOperationException("TODO");
        }
        generator.writeEndObject();
    }

    protected void marshallProcess(Process process, Definitions def, JsonGenerator generator, String preProcessingData) throws JsonGenerationException, IOException {
        BPMNPlane plane = null;
        for (BPMNDiagram d : def.getDiagrams()) {
            BPMNPlane p;
            if (d == null || (p = d.getPlane()) == null || p.getBpmnElement() != process) continue;
            plane = p;
            break;
        }
        if (plane == null) {
            throw new IllegalArgumentException("Could not find BPMNDI information");
        }
        generator.writeArrayFieldStart("childShapes");
        ArrayList<String> laneFlowElementsIds = new ArrayList<String>();
        for (LaneSet laneSet : process.getLaneSets()) {
            for (Lane lane : laneSet.getLanes()) {
                if (this.findDiagramElement(plane, (BaseElement)lane) == null) continue;
                laneFlowElementsIds.addAll(this.marshallLanes(lane, plane, generator, 0.0f, 0.0f, preProcessingData, def));
            }
        }
        for (FlowElement flowElement : process.getFlowElements()) {
            if (laneFlowElementsIds.contains(flowElement.getId())) continue;
            this.marshallFlowElement(flowElement, plane, generator, 0.0f, 0.0f, preProcessingData, def);
        }
        for (Artifact artifact : process.getArtifacts()) {
            this.marshallArtifact(artifact, plane, generator, 0.0f, 0.0f, preProcessingData, def);
        }
        generator.writeEndArray();
    }

    private void setCatchEventProperties(CatchEvent event, Map<String, Object> properties, Definitions def) {
        if (event.getOutputSet() != null) {
            List dataOutputs = event.getOutputSet().getDataOutputRefs();
            StringBuffer doutbuff = new StringBuffer();
            for (DataOutput dout : dataOutputs) {
                doutbuff.append(dout.getName());
                String dtype = this.getAnyAttributeValue((BaseElement)dout, "dtype");
                if (dtype != null && !dtype.isEmpty()) {
                    doutbuff.append(":").append(dtype);
                }
                doutbuff.append(",");
            }
            if (doutbuff.length() > 0) {
                doutbuff.setLength(doutbuff.length() - 1);
            }
            properties.put("dataoutput", doutbuff.toString());
            List outputAssociations = event.getDataOutputAssociation();
            StringBuffer doutassociationbuff = new StringBuffer();
            for (DataOutputAssociation doa : outputAssociations) {
                String doaName = ((DataOutput)doa.getSourceRef().get(0)).getName();
                if (doaName == null || doaName.length() <= 0) continue;
                doutassociationbuff.append("[dout]" + ((DataOutput)doa.getSourceRef().get(0)).getName());
                doutassociationbuff.append("->");
                doutassociationbuff.append(doa.getTargetRef().getId());
                doutassociationbuff.append(",");
            }
            if (doutassociationbuff.length() > 0) {
                doutassociationbuff.setLength(doutassociationbuff.length() - 1);
            }
            properties.put("dataoutputassociations", doutassociationbuff.toString());
        }
        List eventdefs = event.getEventDefinitions();
        for (EventDefinition ed : eventdefs) {
            if (ed instanceof TimerEventDefinition) {
                TimerEventDefinition ted = (TimerEventDefinition)ed;
                if (ted.getTimeDate() != null) {
                    properties.put("timedate", ((FormalExpression)ted.getTimeDate()).getBody());
                }
                if (ted.getTimeDuration() != null) {
                    properties.put("timeduration", ((FormalExpression)ted.getTimeDuration()).getBody());
                }
                if (ted.getTimeCycle() == null) continue;
                properties.put("timecycle", ((FormalExpression)ted.getTimeCycle()).getBody());
                if (((FormalExpression)ted.getTimeCycle()).getLanguage() == null) continue;
                properties.put("timecyclelanguage", ((FormalExpression)ted.getTimeCycle()).getLanguage());
                continue;
            }
            if (ed instanceof SignalEventDefinition) {
                if (((SignalEventDefinition)ed).getSignalRef() != null) {
                    boolean foundSignalRef = false;
                    List rootElements = def.getRootElements();
                    for (RootElement re : rootElements) {
                        if (!(re instanceof Signal) || !re.getId().equals(((SignalEventDefinition)ed).getSignalRef())) continue;
                        properties.put("signalref", ((Signal)re).getName());
                        foundSignalRef = true;
                    }
                    if (foundSignalRef) continue;
                    properties.put("signalref", "");
                    continue;
                }
                properties.put("signalref", "");
                continue;
            }
            if (ed instanceof ErrorEventDefinition) {
                if (((ErrorEventDefinition)ed).getErrorRef() != null && ((ErrorEventDefinition)ed).getErrorRef().getErrorCode() != null) {
                    properties.put("errorref", ((ErrorEventDefinition)ed).getErrorRef().getErrorCode());
                    continue;
                }
                properties.put("errorref", "");
                continue;
            }
            if (ed instanceof ConditionalEventDefinition) {
                FormalExpression conditionalExp = (FormalExpression)((ConditionalEventDefinition)ed).getCondition();
                if (conditionalExp.getBody() != null) {
                    properties.put("conditionexpression", conditionalExp.getBody().replaceAll("\n", "\\\\n"));
                }
                if (conditionalExp.getLanguage() == null) continue;
                String languageVal = conditionalExp.getLanguage();
                if (languageVal.equals("http://www.jboss.org/drools/rule")) {
                    properties.put("conditionlanguage", "drools");
                    continue;
                }
                if (languageVal.equals("http://www.mvel.org/2.0")) {
                    properties.put("conditionlanguage", "mvel");
                    continue;
                }
                properties.put("conditionlanguage", "drools");
                continue;
            }
            if (ed instanceof EscalationEventDefinition) {
                if (((EscalationEventDefinition)ed).getEscalationRef() == null) continue;
                Escalation esc = ((EscalationEventDefinition)ed).getEscalationRef();
                if (esc.getEscalationCode() != null && esc.getEscalationCode().length() > 0) {
                    properties.put("escalationcode", esc.getEscalationCode());
                    continue;
                }
                properties.put("escalationcode", "");
                continue;
            }
            if (ed instanceof MessageEventDefinition) {
                if (((MessageEventDefinition)ed).getMessageRef() == null) continue;
                Message msg = ((MessageEventDefinition)ed).getMessageRef();
                properties.put("messageref", msg.getId());
                continue;
            }
            if (!(ed instanceof CompensateEventDefinition) || ((CompensateEventDefinition)ed).getActivityRef() == null) continue;
            Activity act = ((CompensateEventDefinition)ed).getActivityRef();
            properties.put("activityref", act.getName());
        }
    }

    private void setThrowEventProperties(ThrowEvent event, Map<String, Object> properties, Definitions def) {
        if (event.getInputSet() != null) {
            List dataInputs = event.getInputSet().getDataInputRefs();
            StringBuffer dinbuff = new StringBuffer();
            for (DataInput din : dataInputs) {
                dinbuff.append(din.getName());
                String dtype = this.getAnyAttributeValue((BaseElement)din, "dtype");
                if (dtype != null && !dtype.isEmpty()) {
                    dinbuff.append(":").append(dtype);
                }
                dinbuff.append(",");
            }
            if (dinbuff.length() > 0) {
                dinbuff.setLength(dinbuff.length() - 1);
            }
            properties.put("datainput", dinbuff.toString());
            StringBuilder associationBuff = new StringBuilder();
            for (DataInputAssociation datain : event.getDataInputAssociation()) {
                String lhsAssociation = "";
                if (datain.getSourceRef() != null && datain.getSourceRef().size() > 0) {
                    lhsAssociation = datain.getTransformation() != null && datain.getTransformation().getBody() != null ? datain.getTransformation().getBody() : ((ItemAwareElement)datain.getSourceRef().get(0)).getId();
                }
                String rhsAssociation = "";
                if (datain.getTargetRef() != null) {
                    rhsAssociation = ((DataInput)datain.getTargetRef()).getName();
                }
                boolean isAssignment = false;
                if (datain.getAssignment() != null && datain.getAssignment().size() > 0) {
                    isAssignment = true;
                }
                if (isAssignment) {
                    if (!(((Assignment)datain.getAssignment().get(0)).getFrom() instanceof FormalExpression)) continue;
                    String associationValue = ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody();
                    if (associationValue == null) {
                        associationValue = "";
                    }
                    String replacer = this.encodeAssociationValue(associationValue);
                    associationBuff.append("[din]" + rhsAssociation).append("=").append(replacer);
                    associationBuff.append(",");
                    continue;
                }
                if (lhsAssociation == null || lhsAssociation.length() <= 0) continue;
                associationBuff.append("[din]" + lhsAssociation).append("->").append(rhsAssociation);
                associationBuff.append(",");
            }
            String assignmentString = associationBuff.toString();
            if (assignmentString.endsWith(",")) {
                assignmentString = assignmentString.substring(0, assignmentString.length() - 1);
            }
            properties.put("datainputassociations", assignmentString);
        }
        String signalScope = null;
        if (event.getExtensionValues() != null && event.getExtensionValues().size() > 0) {
            for (ExtensionAttributeValue extattrval : event.getExtensionValues()) {
                FeatureMap extensionElements = extattrval.getValue();
                List metadataExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true);
                for (MetaDataType metaType : metadataExtensions) {
                    if (metaType.getName() == null || !metaType.getName().equals("customScope") || metaType.getMetaValue() == null || metaType.getMetaValue().length() <= 0) continue;
                    signalScope = metaType.getMetaValue();
                }
            }
        }
        if (signalScope != null) {
            properties.put("signalscope", signalScope);
        }
        List eventdefs = event.getEventDefinitions();
        for (EventDefinition ed : eventdefs) {
            if (ed instanceof TimerEventDefinition) {
                TimerEventDefinition ted = (TimerEventDefinition)ed;
                if (ted.getTimeDate() != null) {
                    properties.put("timedate", ((FormalExpression)ted.getTimeDate()).getBody());
                }
                if (ted.getTimeDuration() != null) {
                    properties.put("timeduration", ((FormalExpression)ted.getTimeDuration()).getBody());
                }
                if (ted.getTimeCycle() == null) continue;
                properties.put("timecycle", ((FormalExpression)ted.getTimeCycle()).getBody());
                if (((FormalExpression)ted.getTimeCycle()).getLanguage() == null) continue;
                properties.put("timecyclelanguage", ((FormalExpression)ted.getTimeCycle()).getLanguage());
                continue;
            }
            if (ed instanceof SignalEventDefinition) {
                if (((SignalEventDefinition)ed).getSignalRef() != null) {
                    boolean foundSignalRef = false;
                    List rootElements = def.getRootElements();
                    for (RootElement re : rootElements) {
                        if (!(re instanceof Signal) || !re.getId().equals(((SignalEventDefinition)ed).getSignalRef())) continue;
                        properties.put("signalref", ((Signal)re).getName());
                        foundSignalRef = true;
                    }
                    if (foundSignalRef) continue;
                    properties.put("signalref", "");
                    continue;
                }
                properties.put("signalref", "");
                continue;
            }
            if (ed instanceof ErrorEventDefinition) {
                if (((ErrorEventDefinition)ed).getErrorRef() != null && ((ErrorEventDefinition)ed).getErrorRef().getErrorCode() != null) {
                    properties.put("errorref", ((ErrorEventDefinition)ed).getErrorRef().getErrorCode());
                    continue;
                }
                properties.put("errorref", "");
                continue;
            }
            if (ed instanceof ConditionalEventDefinition) {
                FormalExpression conditionalExp = (FormalExpression)((ConditionalEventDefinition)ed).getCondition();
                if (conditionalExp.getBody() != null) {
                    properties.put("conditionexpression", conditionalExp.getBody());
                }
                if (conditionalExp.getLanguage() == null) continue;
                String languageVal = conditionalExp.getLanguage();
                if (languageVal.equals("http://www.jboss.org/drools/rule")) {
                    properties.put("conditionlanguage", "drools");
                    continue;
                }
                if (languageVal.equals("http://www.mvel.org/2.0")) {
                    properties.put("conditionlanguage", "mvel");
                    continue;
                }
                properties.put("conditionlanguage", "drools");
                continue;
            }
            if (ed instanceof EscalationEventDefinition) {
                if (((EscalationEventDefinition)ed).getEscalationRef() == null) continue;
                Escalation esc = ((EscalationEventDefinition)ed).getEscalationRef();
                if (esc.getEscalationCode() != null && esc.getEscalationCode().length() > 0) {
                    properties.put("escalationcode", esc.getEscalationCode());
                    continue;
                }
                properties.put("escalationcode", "");
                continue;
            }
            if (ed instanceof MessageEventDefinition) {
                if (((MessageEventDefinition)ed).getMessageRef() == null) continue;
                Message msg = ((MessageEventDefinition)ed).getMessageRef();
                properties.put("messageref", msg.getId());
                continue;
            }
            if (!(ed instanceof CompensateEventDefinition) || ((CompensateEventDefinition)ed).getActivityRef() == null) continue;
            Activity act = ((CompensateEventDefinition)ed).getActivityRef();
            properties.put("activityref", act.getName());
        }
    }

    private List<String> marshallLanes(Lane lane, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, String preProcessingData, Definitions def) throws JsonGenerationException, IOException {
        Bounds bounds = ((BPMNShape)this.findDiagramElement(plane, (BaseElement)lane)).getBounds();
        ArrayList<String> nodeRefIds = new ArrayList<String>();
        if (bounds != null) {
            generator.writeStartObject();
            generator.writeObjectField("resourceId", (Object)lane.getId());
            LinkedHashMap<String, Object> laneProperties = new LinkedHashMap<String, Object>();
            if (lane.getName() != null) {
                laneProperties.put("name", Bpmn2JsonMarshaller.unescapeXML(lane.getName()));
            } else {
                laneProperties.put("name", "");
            }
            String elementName = null;
            if (lane.getExtensionValues() != null && lane.getExtensionValues().size() > 0) {
                for (ExtensionAttributeValue extattrval : lane.getExtensionValues()) {
                    FeatureMap extensionElements = extattrval.getValue();
                    List metadataExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true);
                    for (MetaDataType metaType : metadataExtensions) {
                        if (metaType.getName() == null || !metaType.getName().equals("elementname") || metaType.getMetaValue() == null || metaType.getMetaValue().length() <= 0) continue;
                        elementName = metaType.getMetaValue();
                    }
                }
            }
            if (elementName != null) {
                laneProperties.put("name", elementName);
            }
            Iterator iter = lane.getAnyAttribute().iterator();
            boolean foundBgColor = false;
            boolean foundBrColor = false;
            boolean foundFontColor = false;
            boolean foundSelectable = false;
            while (iter.hasNext()) {
                FeatureMap.Entry entry = (FeatureMap.Entry)iter.next();
                if (entry.getEStructuralFeature().getName().equals("background-color") || entry.getEStructuralFeature().getName().equals("bgcolor")) {
                    laneProperties.put("bgcolor", entry.getValue());
                    foundBgColor = true;
                }
                if (entry.getEStructuralFeature().getName().equals("border-color") || entry.getEStructuralFeature().getName().equals("bordercolor")) {
                    laneProperties.put("bordercolor", entry.getValue());
                    foundBrColor = true;
                }
                if (entry.getEStructuralFeature().getName().equals("fontsize")) {
                    laneProperties.put("fontsize", entry.getValue());
                    foundBrColor = true;
                }
                if (entry.getEStructuralFeature().getName().equals("color") || entry.getEStructuralFeature().getName().equals("fontcolor")) {
                    laneProperties.put("fontcolor", entry.getValue());
                    foundFontColor = true;
                }
                if (!entry.getEStructuralFeature().getName().equals("selectable")) continue;
                laneProperties.put("isselectable", entry.getValue());
                foundSelectable = true;
            }
            if (!foundBgColor) {
                laneProperties.put("bgcolor", defaultBgColor_Swimlanes);
            }
            if (!foundBrColor) {
                laneProperties.put("bordercolor", "#000000");
            }
            if (!foundFontColor) {
                laneProperties.put("fontcolor", "#000000");
            }
            if (!foundSelectable) {
                laneProperties.put("isselectable", "true");
            }
            this.marshallProperties(laneProperties, generator);
            generator.writeObjectFieldStart("stencil");
            generator.writeObjectField("id", (Object)"Lane");
            generator.writeEndObject();
            generator.writeArrayFieldStart("childShapes");
            for (FlowElement flowElement : lane.getFlowNodeRefs()) {
                nodeRefIds.add(flowElement.getId());
                if (this.coordianteManipulation) {
                    this.marshallFlowElement(flowElement, plane, generator, bounds.getX(), bounds.getY(), preProcessingData, def);
                    continue;
                }
                this.marshallFlowElement(flowElement, plane, generator, 0.0f, 0.0f, preProcessingData, def);
            }
            generator.writeEndArray();
            generator.writeArrayFieldStart("outgoing");
            generator.writeEndArray();
            generator.writeObjectFieldStart("bounds");
            generator.writeObjectFieldStart("lowerRight");
            generator.writeObjectField("x", (Object)Float.valueOf(bounds.getX() + bounds.getWidth() - xOffset));
            generator.writeObjectField("y", (Object)Float.valueOf(bounds.getY() + bounds.getHeight() - yOffset));
            generator.writeEndObject();
            generator.writeObjectFieldStart("upperLeft");
            generator.writeObjectField("x", (Object)Float.valueOf(bounds.getX() - xOffset));
            generator.writeObjectField("y", (Object)Float.valueOf(bounds.getY() - yOffset));
            generator.writeEndObject();
            generator.writeEndObject();
            generator.writeEndObject();
        } else {
            for (FlowElement flowElement : lane.getFlowNodeRefs()) {
                nodeRefIds.add(flowElement.getId());
                this.marshallFlowElement(flowElement, plane, generator, 0.0f, 0.0f, preProcessingData, def);
            }
        }
        return nodeRefIds;
    }

    protected void marshallFlowElement(FlowElement flowElement, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, String preProcessingData, Definitions def) throws JsonGenerationException, IOException {
        generator.writeStartObject();
        generator.writeObjectField("resourceId", (Object)flowElement.getId());
        LinkedHashMap<String, Object> flowElementProperties = new LinkedHashMap<String, Object>();
        Iterator iter = flowElement.getAnyAttribute().iterator();
        boolean foundBgColor = false;
        boolean foundBrColor = false;
        boolean foundFontColor = false;
        boolean foundSelectable = false;
        while (iter.hasNext()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)iter.next();
            if (entry.getEStructuralFeature().getName().equals("background-color") || entry.getEStructuralFeature().getName().equals("bgcolor")) {
                flowElementProperties.put("bgcolor", entry.getValue());
                foundBgColor = true;
            }
            if (entry.getEStructuralFeature().getName().equals("border-color") || entry.getEStructuralFeature().getName().equals("bordercolor")) {
                flowElementProperties.put("bordercolor", entry.getValue());
                foundBrColor = true;
            }
            if (entry.getEStructuralFeature().getName().equals("fontsize")) {
                flowElementProperties.put("fontsize", entry.getValue());
                foundBrColor = true;
            }
            if (entry.getEStructuralFeature().getName().equals("color") || entry.getEStructuralFeature().getName().equals("fontcolor")) {
                flowElementProperties.put("fontcolor", entry.getValue());
                foundFontColor = true;
            }
            if (!entry.getEStructuralFeature().getName().equals("selectable")) continue;
            flowElementProperties.put("isselectable", entry.getValue());
            foundSelectable = true;
        }
        if (!foundBgColor) {
            if (flowElement instanceof Activity || flowElement instanceof SubProcess) {
                flowElementProperties.put("bgcolor", defaultBgColor_Activities);
            } else if (flowElement instanceof StartEvent) {
                flowElementProperties.put("bgcolor", defaultBgColor_StartEvents);
            } else if (flowElement instanceof EndEvent) {
                flowElementProperties.put("bgcolor", defaultBgColor_EndEvents);
            } else if (flowElement instanceof DataObject) {
                flowElementProperties.put("bgcolor", defaultBgColor_DataObjects);
            } else if (flowElement instanceof CatchEvent) {
                flowElementProperties.put("bgcolor", "#f5deb3");
            } else if (flowElement instanceof ThrowEvent) {
                flowElementProperties.put("bgcolor", defaultBgColor_ThrowingEvents);
            } else if (flowElement instanceof Gateway) {
                flowElementProperties.put("bgcolor", defaultBgColor_Gateways);
            } else if (flowElement instanceof Lane) {
                flowElementProperties.put("bgcolor", defaultBgColor_Swimlanes);
            } else {
                flowElementProperties.put("bgcolor", "#f5deb3");
            }
        }
        if (!foundBrColor) {
            if (flowElement instanceof CatchEvent && !(flowElement instanceof StartEvent)) {
                flowElementProperties.put("bordercolor", defaultBrColor_CatchingEvents);
            } else if (flowElement instanceof ThrowEvent && !(flowElement instanceof EndEvent)) {
                flowElementProperties.put("bordercolor", defaultBrColor_ThrowingEvents);
            } else if (flowElement instanceof Gateway) {
                flowElementProperties.put("bordercolor", defaultBrColor_Gateways);
            } else {
                flowElementProperties.put("bordercolor", "#000000");
            }
        }
        if (!foundFontColor) {
            flowElementProperties.put("fontcolor", "#000000");
        }
        if (!foundSelectable) {
            flowElementProperties.put("isselectable", "true");
        }
        LinkedHashMap<String, Object> catchEventProperties = new LinkedHashMap<String, Object>(flowElementProperties);
        LinkedHashMap<String, Object> throwEventProperties = new LinkedHashMap<String, Object>(flowElementProperties);
        if (flowElement instanceof CatchEvent) {
            this.setCatchEventProperties((CatchEvent)flowElement, catchEventProperties, def);
        }
        if (flowElement instanceof ThrowEvent) {
            this.setThrowEventProperties((ThrowEvent)flowElement, throwEventProperties, def);
        }
        if (flowElement instanceof StartEvent) {
            this.marshallStartEvent((StartEvent)flowElement, plane, generator, xOffset, yOffset, catchEventProperties);
        } else if (flowElement instanceof EndEvent) {
            this.marshallEndEvent((EndEvent)flowElement, plane, generator, xOffset, yOffset, throwEventProperties);
        } else if (flowElement instanceof IntermediateThrowEvent) {
            this.marshallIntermediateThrowEvent((IntermediateThrowEvent)flowElement, plane, generator, xOffset, yOffset, throwEventProperties);
        } else if (flowElement instanceof IntermediateCatchEvent) {
            this.marshallIntermediateCatchEvent((IntermediateCatchEvent)flowElement, plane, generator, xOffset, yOffset, catchEventProperties);
        } else if (flowElement instanceof BoundaryEvent) {
            this.marshallBoundaryEvent((BoundaryEvent)flowElement, plane, generator, xOffset, yOffset, catchEventProperties);
        } else if (flowElement instanceof Task) {
            this.marshallTask((Task)flowElement, plane, generator, xOffset, yOffset, preProcessingData, def, flowElementProperties);
        } else if (flowElement instanceof TextAnnotation) {
            this.marshallTextAnnotation((TextAnnotation)flowElement, plane, generator, xOffset, yOffset, preProcessingData, def, flowElementProperties);
        } else if (flowElement instanceof SequenceFlow) {
            this.marshallSequenceFlow((SequenceFlow)flowElement, plane, generator, xOffset, yOffset);
        } else if (flowElement instanceof ParallelGateway) {
            this.marshallParallelGateway((ParallelGateway)flowElement, plane, generator, xOffset, yOffset, flowElementProperties);
        } else if (flowElement instanceof ExclusiveGateway) {
            this.marshallExclusiveGateway((ExclusiveGateway)flowElement, plane, generator, xOffset, yOffset, flowElementProperties);
        } else if (flowElement instanceof InclusiveGateway) {
            this.marshallInclusiveGateway((InclusiveGateway)flowElement, plane, generator, xOffset, yOffset, flowElementProperties);
        } else if (flowElement instanceof EventBasedGateway) {
            this.marshallEventBasedGateway((EventBasedGateway)flowElement, plane, generator, xOffset, yOffset, flowElementProperties);
        } else if (flowElement instanceof ComplexGateway) {
            this.marshallComplexGateway((ComplexGateway)flowElement, plane, generator, xOffset, yOffset, flowElementProperties);
        } else if (flowElement instanceof CallActivity) {
            this.marshallCallActivity((CallActivity)flowElement, plane, generator, xOffset, yOffset, flowElementProperties);
        } else if (flowElement instanceof SubProcess) {
            if (flowElement instanceof AdHocSubProcess) {
                this.marshallSubProcess((SubProcess)((AdHocSubProcess)flowElement), plane, generator, xOffset, yOffset, preProcessingData, def, flowElementProperties);
            } else {
                this.marshallSubProcess((SubProcess)flowElement, plane, generator, xOffset, yOffset, preProcessingData, def, flowElementProperties);
            }
        } else if (flowElement instanceof DataObject) {
            if (this.findDiagramElement(plane, (BaseElement)((DataObject)flowElement)) != null) {
                this.marshallDataObject((DataObject)flowElement, plane, generator, xOffset, yOffset, flowElementProperties);
            } else {
                _logger.info("Could not marshall Data Object " + (DataObject)flowElement + " because no DI information could be found.");
            }
        } else {
            throw new UnsupportedOperationException("Unknown flow element " + flowElement);
        }
        generator.writeEndObject();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void marshallStartEvent(StartEvent startEvent, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, Map<String, Object> properties) throws JsonGenerationException, IOException {
        List eventDefinitions = startEvent.getEventDefinitions();
        properties.put("isinterrupting", startEvent.isIsInterrupting());
        if (eventDefinitions == null || eventDefinitions.size() == 0) {
            this.marshallNode((FlowNode)startEvent, properties, "StartNoneEvent", plane, generator, xOffset, yOffset);
            return;
        } else {
            if (eventDefinitions.size() != 1) throw new UnsupportedOperationException("Multiple event definitions not supported for start event");
            EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
            if (eventDefinition instanceof ConditionalEventDefinition) {
                this.marshallNode((FlowNode)startEvent, properties, "StartConditionalEvent", plane, generator, xOffset, yOffset);
                return;
            } else if (eventDefinition instanceof SignalEventDefinition) {
                this.marshallNode((FlowNode)startEvent, properties, "StartSignalEvent", plane, generator, xOffset, yOffset);
                return;
            } else if (eventDefinition instanceof MessageEventDefinition) {
                this.marshallNode((FlowNode)startEvent, properties, "StartMessageEvent", plane, generator, xOffset, yOffset);
                return;
            } else if (eventDefinition instanceof TimerEventDefinition) {
                this.marshallNode((FlowNode)startEvent, properties, "StartTimerEvent", plane, generator, xOffset, yOffset);
                return;
            } else if (eventDefinition instanceof ErrorEventDefinition) {
                this.marshallNode((FlowNode)startEvent, properties, "StartErrorEvent", plane, generator, xOffset, yOffset);
                return;
            } else if (eventDefinition instanceof ConditionalEventDefinition) {
                this.marshallNode((FlowNode)startEvent, properties, "StartConditionalEvent", plane, generator, xOffset, yOffset);
                return;
            } else if (eventDefinition instanceof EscalationEventDefinition) {
                this.marshallNode((FlowNode)startEvent, properties, "StartEscalationEvent", plane, generator, xOffset, yOffset);
                return;
            } else {
                if (!(eventDefinition instanceof CompensateEventDefinition)) throw new UnsupportedOperationException("Event definition not supported: " + eventDefinition);
                this.marshallNode((FlowNode)startEvent, properties, "StartCompensationEvent", plane, generator, xOffset, yOffset);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void marshallEndEvent(EndEvent endEvent, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, Map<String, Object> properties) throws JsonGenerationException, IOException {
        List eventDefinitions = endEvent.getEventDefinitions();
        if (eventDefinitions == null || eventDefinitions.size() == 0) {
            this.marshallNode((FlowNode)endEvent, properties, "EndNoneEvent", plane, generator, xOffset, yOffset);
            return;
        } else {
            if (eventDefinitions.size() != 1) throw new UnsupportedOperationException("Multiple event definitions not supported for end event");
            EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
            if (eventDefinition instanceof TerminateEventDefinition) {
                this.marshallNode((FlowNode)endEvent, properties, "EndTerminateEvent", plane, generator, xOffset, yOffset);
                return;
            } else if (eventDefinition instanceof SignalEventDefinition) {
                this.marshallNode((FlowNode)endEvent, properties, "EndSignalEvent", plane, generator, xOffset, yOffset);
                return;
            } else if (eventDefinition instanceof MessageEventDefinition) {
                this.marshallNode((FlowNode)endEvent, properties, "EndMessageEvent", plane, generator, xOffset, yOffset);
                return;
            } else if (eventDefinition instanceof ErrorEventDefinition) {
                this.marshallNode((FlowNode)endEvent, properties, "EndErrorEvent", plane, generator, xOffset, yOffset);
                return;
            } else if (eventDefinition instanceof EscalationEventDefinition) {
                this.marshallNode((FlowNode)endEvent, properties, "EndEscalationEvent", plane, generator, xOffset, yOffset);
                return;
            } else if (eventDefinition instanceof CompensateEventDefinition) {
                this.marshallNode((FlowNode)endEvent, properties, "EndCompensationEvent", plane, generator, xOffset, yOffset);
                return;
            } else {
                if (!(eventDefinition instanceof CancelEventDefinition)) throw new UnsupportedOperationException("Event definition not supported: " + eventDefinition);
                this.marshallNode((FlowNode)endEvent, properties, "EndCancelEvent", plane, generator, xOffset, yOffset);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void marshallIntermediateCatchEvent(IntermediateCatchEvent catchEvent, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, Map<String, Object> properties) throws JsonGenerationException, IOException {
        List eventDefinitions = catchEvent.getEventDefinitions();
        if (this._simulationScenario != null) {
            for (ElementParameters eleType : this._simulationScenario.getElementParameters()) {
                TimeParameters timeParams;
                Parameter processingTime;
                if (!eleType.getElementRef().equals(catchEvent.getId()) || (processingTime = (timeParams = eleType.getTimeParameters()).getProcessingTime()) == null) continue;
                ParameterValue paramValue = (ParameterValue)processingTime.getParameterValue().get(0);
                if (paramValue instanceof NormalDistributionType) {
                    NormalDistributionType ndt = (NormalDistributionType)paramValue;
                    properties.put("mean", ndt.getMean());
                    properties.put("standarddeviation", ndt.getStandardDeviation());
                    properties.put("distributiontype", "normal");
                    continue;
                }
                if (paramValue instanceof UniformDistributionType) {
                    UniformDistributionType udt = (UniformDistributionType)paramValue;
                    properties.put("min", udt.getMin());
                    properties.put("max", udt.getMax());
                    properties.put("distributiontype", "uniform");
                    continue;
                }
                if (!(paramValue instanceof PoissonDistributionType)) continue;
                PoissonDistributionType pdt = (PoissonDistributionType)paramValue;
                properties.put("mean", pdt.getMean());
                properties.put("distributiontype", "poisson");
            }
        }
        if (eventDefinitions.size() != 1) throw new UnsupportedOperationException("Intermediate catch event does not have event definition.");
        EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
        if (eventDefinition instanceof SignalEventDefinition) {
            this.marshallNode((FlowNode)catchEvent, properties, "IntermediateSignalEventCatching", plane, generator, xOffset, yOffset);
            return;
        } else if (eventDefinition instanceof MessageEventDefinition) {
            this.marshallNode((FlowNode)catchEvent, properties, "IntermediateMessageEventCatching", plane, generator, xOffset, yOffset);
            return;
        } else if (eventDefinition instanceof TimerEventDefinition) {
            this.marshallNode((FlowNode)catchEvent, properties, "IntermediateTimerEvent", plane, generator, xOffset, yOffset);
            return;
        } else if (eventDefinition instanceof ConditionalEventDefinition) {
            this.marshallNode((FlowNode)catchEvent, properties, "IntermediateConditionalEvent", plane, generator, xOffset, yOffset);
            return;
        } else if (eventDefinition instanceof ErrorEventDefinition) {
            this.marshallNode((FlowNode)catchEvent, properties, "IntermediateErrorEvent", plane, generator, xOffset, yOffset);
            return;
        } else if (eventDefinition instanceof EscalationEventDefinition) {
            this.marshallNode((FlowNode)catchEvent, properties, "IntermediateEscalationEvent", plane, generator, xOffset, yOffset);
            return;
        } else {
            if (!(eventDefinition instanceof CompensateEventDefinition)) throw new UnsupportedOperationException("Event definition not supported: " + eventDefinition);
            this.marshallNode((FlowNode)catchEvent, properties, "IntermediateCompensationEventCatching", plane, generator, xOffset, yOffset);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void marshallBoundaryEvent(BoundaryEvent boundaryEvent, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, Map<String, Object> catchEventProperties) throws JsonGenerationException, IOException {
        List eventDefinitions = boundaryEvent.getEventDefinitions();
        if (boundaryEvent.isCancelActivity()) {
            catchEventProperties.put("boundarycancelactivity", "true");
        } else {
            catchEventProperties.put("boundarycancelactivity", "false");
        }
        if (this._simulationScenario != null) {
            for (ElementParameters eleType : this._simulationScenario.getElementParameters()) {
                Parameter probabilityParam;
                ControlParameters controlParams;
                TimeParameters timeParams;
                Parameter processingTime;
                if (!eleType.getElementRef().equals(boundaryEvent.getId()) || (processingTime = (timeParams = eleType.getTimeParameters()).getProcessingTime()) == null) continue;
                ParameterValue paramValue = (ParameterValue)processingTime.getParameterValue().get(0);
                if (paramValue instanceof NormalDistributionType) {
                    NormalDistributionType ndt = (NormalDistributionType)paramValue;
                    catchEventProperties.put("mean", ndt.getMean());
                    catchEventProperties.put("standarddeviation", ndt.getStandardDeviation());
                    catchEventProperties.put("distributiontype", "normal");
                } else if (paramValue instanceof UniformDistributionType) {
                    UniformDistributionType udt = (UniformDistributionType)paramValue;
                    catchEventProperties.put("min", udt.getMin());
                    catchEventProperties.put("max", udt.getMax());
                    catchEventProperties.put("distributiontype", "uniform");
                } else if (paramValue instanceof PoissonDistributionType) {
                    PoissonDistributionType pdt = (PoissonDistributionType)paramValue;
                    catchEventProperties.put("mean", pdt.getMean());
                    catchEventProperties.put("distributiontype", "poisson");
                }
                if ((controlParams = eleType.getControlParameters()) == null || (probabilityParam = controlParams.getProbability()) == null || probabilityParam.getParameterValue() == null) continue;
                FloatingParameterType valType = (FloatingParameterType)probabilityParam.getParameterValue().get(0);
                catchEventProperties.put("probability", valType.getValue());
            }
        }
        if (eventDefinitions.size() != 1) throw new UnsupportedOperationException("None or multiple event definitions not supported for boundary event");
        EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
        if (eventDefinition instanceof SignalEventDefinition) {
            this.marshallNode((FlowNode)boundaryEvent, catchEventProperties, "IntermediateSignalEventCatching", plane, generator, xOffset, yOffset);
            return;
        } else if (eventDefinition instanceof EscalationEventDefinition) {
            this.marshallNode((FlowNode)boundaryEvent, catchEventProperties, "IntermediateEscalationEvent", plane, generator, xOffset, yOffset);
            return;
        } else if (eventDefinition instanceof ErrorEventDefinition) {
            this.marshallNode((FlowNode)boundaryEvent, catchEventProperties, "IntermediateErrorEvent", plane, generator, xOffset, yOffset);
            return;
        } else if (eventDefinition instanceof TimerEventDefinition) {
            this.marshallNode((FlowNode)boundaryEvent, catchEventProperties, "IntermediateTimerEvent", plane, generator, xOffset, yOffset);
            return;
        } else if (eventDefinition instanceof CompensateEventDefinition) {
            this.marshallNode((FlowNode)boundaryEvent, catchEventProperties, "IntermediateCompensationEventCatching", plane, generator, xOffset, yOffset);
            return;
        } else if (eventDefinition instanceof ConditionalEventDefinition) {
            this.marshallNode((FlowNode)boundaryEvent, catchEventProperties, "IntermediateConditionalEvent", plane, generator, xOffset, yOffset);
            return;
        } else {
            if (!(eventDefinition instanceof MessageEventDefinition)) throw new UnsupportedOperationException("Event definition not supported: " + eventDefinition);
            this.marshallNode((FlowNode)boundaryEvent, catchEventProperties, "IntermediateMessageEventCatching", plane, generator, xOffset, yOffset);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void marshallIntermediateThrowEvent(IntermediateThrowEvent throwEvent, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, Map<String, Object> properties) throws JsonGenerationException, IOException {
        List eventDefinitions = throwEvent.getEventDefinitions();
        if (this._simulationScenario != null) {
            for (ElementParameters eleType : this._simulationScenario.getElementParameters()) {
                TimeParameters timeParams;
                Parameter processingTime;
                if (!eleType.getElementRef().equals(throwEvent.getId()) || (processingTime = (timeParams = eleType.getTimeParameters()).getProcessingTime()) == null) continue;
                ParameterValue paramValue = (ParameterValue)processingTime.getParameterValue().get(0);
                if (paramValue instanceof NormalDistributionType) {
                    NormalDistributionType ndt = (NormalDistributionType)paramValue;
                    properties.put("mean", ndt.getMean());
                    properties.put("standarddeviation", ndt.getStandardDeviation());
                    properties.put("distributiontype", "normal");
                    continue;
                }
                if (paramValue instanceof UniformDistributionType) {
                    UniformDistributionType udt = (UniformDistributionType)paramValue;
                    properties.put("min", udt.getMin());
                    properties.put("max", udt.getMax());
                    properties.put("distributiontype", "uniform");
                    continue;
                }
                if (!(paramValue instanceof PoissonDistributionType)) continue;
                PoissonDistributionType pdt = (PoissonDistributionType)paramValue;
                properties.put("mean", pdt.getMean());
                properties.put("distributiontype", "poisson");
            }
        }
        if (eventDefinitions.size() == 0) {
            this.marshallNode((FlowNode)throwEvent, properties, "IntermediateEvent", plane, generator, xOffset, yOffset);
            return;
        } else {
            if (eventDefinitions.size() != 1) throw new UnsupportedOperationException("None or multiple event definitions not supported for intermediate throw event");
            EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
            if (eventDefinition instanceof SignalEventDefinition) {
                this.marshallNode((FlowNode)throwEvent, properties, "IntermediateSignalEventThrowing", plane, generator, xOffset, yOffset);
                return;
            } else if (eventDefinition instanceof MessageEventDefinition) {
                this.marshallNode((FlowNode)throwEvent, properties, "IntermediateMessageEventThrowing", plane, generator, xOffset, yOffset);
                return;
            } else if (eventDefinition instanceof EscalationEventDefinition) {
                this.marshallNode((FlowNode)throwEvent, properties, "IntermediateEscalationEventThrowing", plane, generator, xOffset, yOffset);
                return;
            } else {
                if (!(eventDefinition instanceof CompensateEventDefinition)) throw new UnsupportedOperationException("Event definition not supported: " + eventDefinition);
                this.marshallNode((FlowNode)throwEvent, properties, "IntermediateCompensationEventThrowing", plane, generator, xOffset, yOffset);
            }
        }
    }

    protected void marshallCallActivity(CallActivity callActivity, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, Map<String, Object> flowElementProperties) throws JsonGenerationException, IOException {
        String rhsAssociation;
        String lhsAssociation;
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(flowElementProperties);
        for (FeatureMap.Entry entry : callActivity.getAnyAttribute()) {
            if (entry.getEStructuralFeature().getName().equals("independent")) {
                properties.put("independent", entry.getValue());
            }
            if (!entry.getEStructuralFeature().getName().equals("waitForCompletion")) continue;
            properties.put("waitforcompletion", entry.getValue());
        }
        if (callActivity.getCalledElement() != null && callActivity.getCalledElement().length() > 0) {
            properties.put("calledelement", callActivity.getCalledElement());
        }
        String customAsync = "false";
        if (callActivity.getExtensionValues() != null && callActivity.getExtensionValues().size() > 0) {
            for (ExtensionAttributeValue extattrval : callActivity.getExtensionValues()) {
                FeatureMap extensionElements = extattrval.getValue();
                List metadataExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true);
                for (MetaDataType metaType : metadataExtensions) {
                    if (metaType.getName() == null || !metaType.getName().equals("customAsync") || metaType.getMetaValue() == null || metaType.getMetaValue().length() <= 0) continue;
                    customAsync = metaType.getMetaValue();
                }
            }
        }
        properties.put("isasync", customAsync);
        if (callActivity.getIoSpecification() != null) {
            List inputSetList = callActivity.getIoSpecification().getInputSets();
            StringBuilder dataInBuffer = new StringBuilder();
            for (InputSet inset : inputSetList) {
                List dataInputList = inset.getDataInputRefs();
                for (DataInput dataIn : dataInputList) {
                    if (dataIn.getName() == null) continue;
                    dataInBuffer.append(dataIn.getName());
                    if (dataIn.getItemSubjectRef() != null && dataIn.getItemSubjectRef().getStructureRef() != null && dataIn.getItemSubjectRef().getStructureRef().length() > 0) {
                        dataInBuffer.append(":").append(dataIn.getItemSubjectRef().getStructureRef());
                    }
                    dataInBuffer.append(",");
                }
            }
            if (dataInBuffer.length() > 0) {
                dataInBuffer.setLength(dataInBuffer.length() - 1);
            }
            properties.put("datainputset", dataInBuffer.toString());
        }
        if (callActivity.getIoSpecification() != null) {
            List outputSetList = callActivity.getIoSpecification().getOutputSets();
            StringBuilder dataOutBuffer = new StringBuilder();
            for (OutputSet outset : outputSetList) {
                List dataOutputList = outset.getDataOutputRefs();
                for (DataOutput dataOut : dataOutputList) {
                    dataOutBuffer.append(dataOut.getName());
                    if (dataOut.getItemSubjectRef() != null && dataOut.getItemSubjectRef().getStructureRef() != null && dataOut.getItemSubjectRef().getStructureRef().length() > 0) {
                        dataOutBuffer.append(":").append(dataOut.getItemSubjectRef().getStructureRef());
                    }
                    dataOutBuffer.append(",");
                }
            }
            if (dataOutBuffer.length() > 0) {
                dataOutBuffer.setLength(dataOutBuffer.length() - 1);
            }
            properties.put("dataoutputset", dataOutBuffer.toString());
        }
        StringBuilder associationBuff = new StringBuilder();
        List inputAssociations = callActivity.getDataInputAssociations();
        List outputAssociations = callActivity.getDataOutputAssociations();
        for (DataInputAssociation datain : inputAssociations) {
            lhsAssociation = "";
            if (datain.getSourceRef() != null && datain.getSourceRef().size() > 0) {
                lhsAssociation = datain.getTransformation() != null && datain.getTransformation().getBody() != null ? datain.getTransformation().getBody() : ((ItemAwareElement)datain.getSourceRef().get(0)).getId();
            }
            rhsAssociation = "";
            if (datain.getTargetRef() != null) {
                rhsAssociation = ((DataInput)datain.getTargetRef()).getName();
            }
            boolean isAssignment = false;
            if (datain.getAssignment() != null && datain.getAssignment().size() > 0) {
                isAssignment = true;
            }
            if (isAssignment) {
                if (!(((Assignment)datain.getAssignment().get(0)).getFrom() instanceof FormalExpression)) continue;
                String associationValue = ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody();
                if (associationValue == null) {
                    associationValue = "";
                }
                String replacer = this.encodeAssociationValue(associationValue);
                associationBuff.append(rhsAssociation).append("=").append(replacer);
                associationBuff.append(",");
                continue;
            }
            if (lhsAssociation == null || lhsAssociation.length() <= 0) continue;
            associationBuff.append("[din]" + lhsAssociation).append("->").append(rhsAssociation);
            associationBuff.append(",");
        }
        for (DataOutputAssociation dataout : outputAssociations) {
            if (dataout.getSourceRef().size() <= 0) continue;
            lhsAssociation = ((DataOutput)dataout.getSourceRef().get(0)).getName();
            rhsAssociation = dataout.getTargetRef().getId();
            boolean wasBiDirectional = false;
            if (dataout.getTransformation() != null && dataout.getTransformation().getBody() != null) {
                rhsAssociation = this.encodeAssociationValue(dataout.getTransformation().getBody());
            }
            if (wasBiDirectional || lhsAssociation == null || lhsAssociation.length() <= 0) continue;
            associationBuff.append("[dout]" + lhsAssociation).append("->").append(rhsAssociation);
            associationBuff.append(",");
        }
        String assignmentString = associationBuff.toString();
        if (assignmentString.endsWith(",")) {
            assignmentString = assignmentString.substring(0, assignmentString.length() - 1);
        }
        properties.put("assignments", assignmentString);
        if (callActivity.getExtensionValues() != null && callActivity.getExtensionValues().size() > 0) {
            String onEntryStr = "";
            String onExitStr = "";
            for (ExtensionAttributeValue extattrval : callActivity.getExtensionValues()) {
                String formatToWrite;
                String format;
                FeatureMap extensionElements = extattrval.getValue();
                List onEntryExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__ON_ENTRY_SCRIPT, true);
                List onExitExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__ON_EXIT_SCRIPT, true);
                for (OnEntryScriptType onEntryScript : onEntryExtensions) {
                    onEntryStr = onEntryStr + onEntryScript.getScript();
                    onEntryStr = onEntryStr + "|";
                    if (onEntryScript.getScriptFormat() == null) continue;
                    format = onEntryScript.getScriptFormat();
                    formatToWrite = "";
                    formatToWrite = format.equals("http://www.java.com/java") ? "java" : (format.equals("http://www.mvel.org/2.0") ? "mvel" : (format.equals("http://www.javascript.com/javascript") ? "javascript" : "java"));
                    properties.put("script_language", formatToWrite);
                }
                for (OnExitScriptType onExitScript : onExitExtensions) {
                    onExitStr = onExitStr + onExitScript.getScript();
                    onExitStr = onExitStr + "|";
                    if (onExitScript.getScriptFormat() == null) continue;
                    format = onExitScript.getScriptFormat();
                    formatToWrite = "";
                    formatToWrite = format.equals("http://www.java.com/java") ? "java" : (format.equals("http://www.mvel.org/2.0") ? "mvel" : (format.equals("http://www.javascript.com/javascript") ? "javascript" : "java"));
                    if (properties.get("script_language") != null) continue;
                    properties.put("script_language", formatToWrite);
                }
            }
            if (onEntryStr.length() > 0) {
                if (onEntryStr.endsWith("|")) {
                    onEntryStr = onEntryStr.substring(0, onEntryStr.length() - 1);
                }
                properties.put("onentryactions", onEntryStr);
            }
            if (onExitStr.length() > 0) {
                if (onExitStr.endsWith("|")) {
                    onExitStr = onExitStr.substring(0, onExitStr.length() - 1);
                }
                properties.put("onexitactions", onExitStr);
            }
        }
        if (this._simulationScenario != null) {
            for (ElementParameters eleType : this._simulationScenario.getElementParameters()) {
                CostParameters costParams;
                if (!eleType.getElementRef().equals(callActivity.getId())) continue;
                TimeParameters timeParams = eleType.getTimeParameters();
                Parameter processingTime = timeParams.getProcessingTime();
                ParameterValue paramValue = (ParameterValue)processingTime.getParameterValue().get(0);
                if (paramValue instanceof NormalDistributionType) {
                    NormalDistributionType ndt = (NormalDistributionType)paramValue;
                    properties.put("mean", ndt.getMean());
                    properties.put("standarddeviation", ndt.getStandardDeviation());
                    properties.put("distributiontype", "normal");
                } else if (paramValue instanceof UniformDistributionType) {
                    UniformDistributionType udt = (UniformDistributionType)paramValue;
                    properties.put("min", udt.getMin());
                    properties.put("max", udt.getMax());
                    properties.put("distributiontype", "uniform");
                } else if (paramValue instanceof PoissonDistributionType) {
                    PoissonDistributionType pdt = (PoissonDistributionType)paramValue;
                    properties.put("mean", pdt.getMean());
                    properties.put("distributiontype", "poisson");
                }
                if (timeParams.getWaitTime() != null) {
                    FloatingParameterType waittimeType = (FloatingParameterType)timeParams.getWaitTime().getParameterValue().get(0);
                    properties.put("waittime", waittimeType.getValue());
                }
                if ((costParams = eleType.getCostParameters()) == null || costParams.getUnitCost() == null) continue;
                FloatingParameterType unitCostVal = (FloatingParameterType)costParams.getUnitCost().getParameterValue().get(0);
                properties.put("unitcost", unitCostVal.getValue());
            }
        }
        this.marshallNode((FlowNode)callActivity, properties, "ReusableSubprocess", plane, generator, xOffset, yOffset);
    }

    protected void marshallTask(Task task, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, String preProcessingData, Definitions def, Map<String, Object> flowElementProperties) throws JsonGenerationException, IOException {
        String rhsAssociation;
        String lhsAssociation;
        MultiInstanceLoopCharacteristics taskMultiLoop;
        String dtype;
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(flowElementProperties);
        String taskType = "None";
        if (task instanceof BusinessRuleTask) {
            taskType = "Business Rule";
            for (FeatureMap.Entry entry : task.getAnyAttribute()) {
                if (!entry.getEStructuralFeature().getName().equals("ruleFlowGroup")) continue;
                properties.put("ruleflowgroup", entry.getValue());
            }
        } else if (task instanceof ScriptTask) {
            ScriptTask scriptTask = (ScriptTask)task;
            properties.put("script", scriptTask.getScript() != null ? scriptTask.getScript().replace("\\", "\\\\").replace("\n", "\\n") : "");
            String format = scriptTask.getScriptFormat();
            if (format != null && format.length() > 0) {
                String formatToWrite = "";
                formatToWrite = format.equals("http://www.java.com/java") ? "java" : (format.equals("http://www.mvel.org/2.0") ? "mvel" : (format.equals("http://www.javascript.com/javascript") ? "javascript" : "java"));
                properties.put("script_language", formatToWrite);
            }
            taskType = "Script";
        } else if (task instanceof ServiceTask) {
            taskType = "Service";
            ServiceTask serviceTask = (ServiceTask)task;
            if (serviceTask.getOperationRef() != null && serviceTask.getImplementation() != null) {
                properties.put("serviceimplementation", serviceTask.getImplementation());
                properties.put("serviceoperation", serviceTask.getOperationRef().getName() == null ? serviceTask.getOperationRef().getImplementationRef() : serviceTask.getOperationRef().getName());
                if (def != null) {
                    List roots = def.getRootElements();
                    for (RootElement root : roots) {
                        if (!(root instanceof Interface)) continue;
                        Interface inter = (Interface)root;
                        List interOperations = inter.getOperations();
                        for (Operation interOper : interOperations) {
                            if (!interOper.getId().equals(serviceTask.getOperationRef().getId())) continue;
                            properties.put("serviceinterface", inter.getName() == null ? inter.getImplementationRef() : inter.getName());
                        }
                    }
                }
            }
        } else if (task instanceof ManualTask) {
            taskType = "Manual";
        } else if (task instanceof UserTask) {
            taskType = "User";
            List roles = task.getResources();
            StringBuilder sb = new StringBuilder();
            for (ResourceRole role : roles) {
                FormalExpression fe;
                if (!(role instanceof PotentialOwner) || (fe = (FormalExpression)((PotentialOwner)role).getResourceAssignmentExpression().getExpression()).getBody() == null || fe.getBody().length() <= 0) continue;
                sb.append(fe.getBody());
                sb.append(",");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            properties.put("actors", sb.toString());
            if (this._simulationScenario != null) {
                for (ElementParameters eleType : this._simulationScenario.getElementParameters()) {
                    if (!eleType.getElementRef().equals(task.getId())) continue;
                    CostParameters costParams = eleType.getCostParameters();
                    FloatingParameterType unitCostVal = (FloatingParameterType)costParams.getUnitCost().getParameterValue().get(0);
                    properties.put("unitcost", unitCostVal.getValue());
                    ResourceParameters resourceParams = eleType.getResourceParameters();
                    FloatingParameterType quantityVal = (FloatingParameterType)resourceParams.getQuantity().getParameterValue().get(0);
                    properties.put("quantity", quantityVal.getValue());
                    FloatingParameterType workingHoursVal = (FloatingParameterType)resourceParams.getAvailability().getParameterValue().get(0);
                    properties.put("workinghours", workingHoursVal.getValue());
                }
            }
        } else if (task instanceof SendTask) {
            taskType = "Send";
            SendTask st = (SendTask)task;
            if (st.getMessageRef() != null) {
                properties.put("messageref", st.getMessageRef().getId());
            }
        } else if (task instanceof ReceiveTask) {
            taskType = "Receive";
            ReceiveTask rt = (ReceiveTask)task;
            if (rt.getMessageRef() != null) {
                properties.put("messageref", rt.getMessageRef().getId());
            }
        }
        String customAsync = "false";
        if (task.getExtensionValues() != null && task.getExtensionValues().size() > 0) {
            for (ExtensionAttributeValue extattrval : task.getExtensionValues()) {
                FeatureMap extensionElements = extattrval.getValue();
                List metadataExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true);
                for (MetaDataType metaType : metadataExtensions) {
                    if (metaType.getName() == null || !metaType.getName().equals("customAsync") || metaType.getMetaValue() == null || metaType.getMetaValue().length() <= 0) continue;
                    customAsync = metaType.getMetaValue();
                }
            }
        }
        properties.put("isasync", customAsync);
        boolean foundTaskName = false;
        if (task.getIoSpecification() != null && task.getIoSpecification().getDataInputs() != null) {
            List taskDataInputs = task.getIoSpecification().getDataInputs();
            for (DataInput din : taskDataInputs) {
                if (din.getName() == null || !din.getName().equals("TaskName")) continue;
                List taskDataInputAssociations = task.getDataInputAssociations();
                for (DataInputAssociation dia : taskDataInputAssociations) {
                    if (dia.getTargetRef() == null || !dia.getTargetRef().getId().equals(din.getId())) continue;
                    properties.put("taskname", ((FormalExpression)((Assignment)dia.getAssignment().get(0)).getFrom()).getBody());
                    foundTaskName = true;
                }
            }
        }
        if (!foundTaskName) {
            for (FeatureMap.Entry entry : task.getAnyAttribute()) {
                String tname;
                if (!entry.getEStructuralFeature().getName().equals("taskName") || (tname = (String)entry.getValue()) == null || tname.length() <= 0) continue;
                properties.put("taskname", tname);
            }
        }
        if (this.isCustomElement((String)properties.get("taskname"), preProcessingData)) {
            properties.put("tasktype", properties.get("taskname"));
        } else {
            properties.put("tasktype", taskType);
        }
        if (task.getLoopCharacteristics() != null) {
            properties.put("multipleinstance", "true");
            MultiInstanceLoopCharacteristics taskmi = (MultiInstanceLoopCharacteristics)task.getLoopCharacteristics();
            if (taskmi.getLoopDataInputRef() != null) {
                ItemAwareElement iedatainput = taskmi.getLoopDataInputRef();
                List taskInputAssociations = task.getDataInputAssociations();
                for (DataInputAssociation dia : taskInputAssociations) {
                    if (!dia.getTargetRef().equals(iedatainput)) continue;
                    properties.put("multipleinstancecollectioninput", ((ItemAwareElement)dia.getSourceRef().get(0)).getId());
                    break;
                }
            }
            if (taskmi.getLoopDataOutputRef() != null) {
                ItemAwareElement iedataoutput = taskmi.getLoopDataOutputRef();
                List taskOutputAssociations = task.getDataOutputAssociations();
                for (DataOutputAssociation dout : taskOutputAssociations) {
                    if (!((ItemAwareElement)dout.getSourceRef().get(0)).equals(iedataoutput)) continue;
                    properties.put("multipleinstancecollectionoutput", dout.getTargetRef().getId());
                    break;
                }
            }
            if (taskmi.getInputDataItem() != null && taskmi.getInputDataItem().getItemSubjectRef() != null) {
                List taskDataInputs = task.getIoSpecification().getDataInputs();
                for (DataInput din : taskDataInputs) {
                    if (din == null || din.getItemSubjectRef() == null || taskmi.getInputDataItem() == null || taskmi.getInputDataItem().getItemSubjectRef() == null || !din.getItemSubjectRef().getId().equals(taskmi.getInputDataItem().getItemSubjectRef().getId())) continue;
                    properties.put("multipleinstancedatainput", din.getName());
                }
            }
            if (taskmi.getOutputDataItem() != null && taskmi.getOutputDataItem().getItemSubjectRef() != null) {
                List taskDataOutputs = task.getIoSpecification().getDataOutputs();
                for (DataOutput dout : taskDataOutputs) {
                    if (dout == null || dout.getItemSubjectRef() == null || taskmi.getOutputDataItem() == null || taskmi.getOutputDataItem().getItemSubjectRef() == null || !dout.getItemSubjectRef().getId().equals(taskmi.getOutputDataItem().getItemSubjectRef().getId())) continue;
                    properties.put("multipleinstancedataoutput", dout.getName());
                }
            }
            if (taskmi.getCompletionCondition() != null && taskmi.getCompletionCondition() instanceof FormalExpression) {
                properties.put("multipleinstancecompletioncondition", ((FormalExpression)taskmi.getCompletionCondition()).getBody());
            }
        } else {
            properties.put("multipleinstance", "false");
        }
        DataInput groupDataInput = null;
        DataInput skippableDataInput = null;
        DataInput commentDataInput = null;
        DataInput descriptionDataInput = null;
        DataInput contentDataInput = null;
        DataInput priorityDataInput = null;
        DataInput localeDataInput = null;
        DataInput createdByDataInput = null;
        DataInput notCompletedReassignInput = null;
        DataInput notStartedReassignInput = null;
        DataInput notCompletedNotificationInput = null;
        DataInput notStartedNotificationInput = null;
        if (task.getIoSpecification() != null) {
            List inputSetList = task.getIoSpecification().getInputSets();
            StringBuilder dataInBuffer = new StringBuilder();
            for (InputSet inset : inputSetList) {
                List dataInputList = inset.getDataInputRefs();
                for (DataInput dataIn : dataInputList) {
                    if (dataIn.getName() != null && !dataIn.getName().equals("TaskName") && !dataIn.getName().equals("miinputCollection")) {
                        dataInBuffer.append(dataIn.getName());
                        if (dataIn.getItemSubjectRef() != null && dataIn.getItemSubjectRef().getStructureRef() != null && dataIn.getItemSubjectRef().getStructureRef().length() > 0) {
                            dataInBuffer.append(":").append(dataIn.getItemSubjectRef().getStructureRef());
                        } else if (task.eContainer() instanceof SubProcess && (dtype = this.getAnyAttributeValue((BaseElement)dataIn, "dtype")) != null && !dtype.isEmpty()) {
                            dataInBuffer.append(":").append(dtype);
                        }
                        dataInBuffer.append(",");
                    }
                    if (dataIn.getName() != null && dataIn.getName().equals("GroupId")) {
                        groupDataInput = dataIn;
                    }
                    if (dataIn.getName() != null && dataIn.getName().equals("Skippable")) {
                        skippableDataInput = dataIn;
                    }
                    if (dataIn.getName() != null && dataIn.getName().equals("Comment")) {
                        commentDataInput = dataIn;
                    }
                    if (dataIn.getName() != null && dataIn.getName().equals("Description ")) {
                        descriptionDataInput = dataIn;
                    }
                    if (dataIn.getName() != null && dataIn.getName().equals("Content")) {
                        contentDataInput = dataIn;
                    }
                    if (dataIn.getName() != null && dataIn.getName().equals("Priority")) {
                        priorityDataInput = dataIn;
                    }
                    if (dataIn.getName() != null && dataIn.getName().equals("Locale")) {
                        localeDataInput = dataIn;
                    }
                    if (dataIn.getName() != null && dataIn.getName().equals("CreatedBy")) {
                        createdByDataInput = dataIn;
                    }
                    if (dataIn.getName() != null && dataIn.getName().equals("NotCompletedReassign")) {
                        notCompletedReassignInput = dataIn;
                    }
                    if (dataIn.getName() != null && dataIn.getName().equals("NotStartedReassign")) {
                        notStartedReassignInput = dataIn;
                    }
                    if (dataIn.getName() != null && dataIn.getName().equals("NotCompletedNotify")) {
                        notCompletedNotificationInput = dataIn;
                    }
                    if (dataIn.getName() == null || !dataIn.getName().equals("NotStartedNotify")) continue;
                    notStartedNotificationInput = dataIn;
                }
            }
            if (dataInBuffer.length() > 0) {
                dataInBuffer.setLength(dataInBuffer.length() - 1);
            }
            properties.put("datainputset", dataInBuffer.toString());
        }
        if (task.getIoSpecification() != null) {
            List outputSetList = task.getIoSpecification().getOutputSets();
            StringBuilder dataOutBuffer = new StringBuilder();
            for (OutputSet outset : outputSetList) {
                List dataOutputList = outset.getDataOutputRefs();
                for (DataOutput dataOut : dataOutputList) {
                    if (dataOut.getName().equals("mioutputCollection")) continue;
                    dataOutBuffer.append(dataOut.getName());
                    if (dataOut.getItemSubjectRef() != null && dataOut.getItemSubjectRef().getStructureRef() != null && dataOut.getItemSubjectRef().getStructureRef().length() > 0) {
                        dataOutBuffer.append(":").append(dataOut.getItemSubjectRef().getStructureRef());
                    } else if (task.eContainer() instanceof SubProcess && (dtype = this.getAnyAttributeValue((BaseElement)dataOut, "dtype")) != null && !dtype.isEmpty()) {
                        dataOutBuffer.append(":").append(dtype);
                    }
                    dataOutBuffer.append(",");
                }
            }
            if (dataOutBuffer.length() > 0) {
                dataOutBuffer.setLength(dataOutBuffer.length() - 1);
            }
            properties.put("dataoutputset", dataOutBuffer.toString());
        }
        StringBuilder associationBuff = new StringBuilder();
        List inputAssociations = task.getDataInputAssociations();
        List outputAssociations = task.getDataOutputAssociations();
        ArrayList<String> uniDirectionalAssociations = new ArrayList<String>();
        for (DataInputAssociation datain : inputAssociations) {
            boolean proceed = true;
            if (task.getLoopCharacteristics() != null) {
                taskMultiLoop = (MultiInstanceLoopCharacteristics)task.getLoopCharacteristics();
                if (taskMultiLoop.getInputDataItem() != null && taskMultiLoop.getInputDataItem().getId() != null && datain.getSourceRef() != null && datain.getSourceRef().size() > 0 && ((ItemAwareElement)datain.getSourceRef().get(0)).getId().equals(taskMultiLoop.getInputDataItem().getId())) {
                    proceed = false;
                }
                if (taskMultiLoop.getLoopDataInputRef() != null && datain.getTargetRef().equals(taskMultiLoop.getLoopDataInputRef())) {
                    proceed = false;
                }
            }
            if (!proceed) continue;
            lhsAssociation = "";
            if (datain.getSourceRef() != null && datain.getSourceRef().size() > 0) {
                lhsAssociation = datain.getTransformation() != null && datain.getTransformation().getBody() != null ? datain.getTransformation().getBody() : ((ItemAwareElement)datain.getSourceRef().get(0)).getId();
            }
            rhsAssociation = "";
            if (datain.getTargetRef() != null) {
                rhsAssociation = ((DataInput)datain.getTargetRef()).getName();
            }
            boolean isAssignment = false;
            if (datain.getAssignment() != null && datain.getAssignment().size() > 0) {
                isAssignment = true;
            }
            if (isAssignment) {
                String replacer;
                if (!(((Assignment)datain.getAssignment().get(0)).getFrom() instanceof FormalExpression)) continue;
                String associationValue = ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody();
                if (associationValue == null) {
                    associationValue = "";
                }
                if (this.isCustomElement((String)properties.get("taskname"), preProcessingData)) {
                    if (!rhsAssociation.equals("TaskName")) {
                        replacer = this.encodeAssociationValue(associationValue);
                        associationBuff.append("[din]" + rhsAssociation).append("=").append(replacer);
                        associationBuff.append(",");
                        properties.put(rhsAssociation.toLowerCase(), associationValue);
                    }
                } else if (!(rhsAssociation.equals("GroupId") || rhsAssociation.equals("Skippable") || rhsAssociation.equals("Comment") || rhsAssociation.equals("Description ") || rhsAssociation.equals("Priority") || rhsAssociation.equals("Content") || rhsAssociation.equals("TaskName") || rhsAssociation.equals("Locale") || rhsAssociation.equals("CreatedBy") || rhsAssociation.equals("NotCompletedReassign") || rhsAssociation.equals("NotStartedReassign") || rhsAssociation.equals("NotCompletedNotify") || rhsAssociation.equals("NotStartedNotify"))) {
                    replacer = this.encodeAssociationValue(associationValue);
                    associationBuff.append("[din]" + rhsAssociation).append("=").append(replacer);
                    associationBuff.append(",");
                    properties.put(rhsAssociation.toLowerCase(), associationValue);
                }
                if (rhsAssociation.equalsIgnoreCase("TaskName")) {
                    properties.put("taskname", associationValue);
                }
                if (groupDataInput != null && ((Assignment)datain.getAssignment().get(0)).getTo() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody().equals(groupDataInput.getId())) {
                    properties.put("groupid", ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody() == null ? "" : ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody());
                }
                if (skippableDataInput != null && ((Assignment)datain.getAssignment().get(0)).getTo() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody().equals(skippableDataInput.getId())) {
                    properties.put("skippable", ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody());
                }
                if (commentDataInput != null && ((Assignment)datain.getAssignment().get(0)).getTo() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody().equals(commentDataInput.getId())) {
                    properties.put("subject", ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody());
                }
                if (descriptionDataInput != null && ((Assignment)datain.getAssignment().get(0)).getTo() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody().equals(descriptionDataInput.getId())) {
                    properties.put("description", ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody());
                }
                if (priorityDataInput != null && ((Assignment)datain.getAssignment().get(0)).getTo() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody().equals(priorityDataInput.getId())) {
                    properties.put("priority", ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody() == null ? "" : ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody());
                }
                if (contentDataInput != null && ((Assignment)datain.getAssignment().get(0)).getTo() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody().equals(contentDataInput.getId())) {
                    properties.put("content", ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody());
                }
                if (localeDataInput != null && ((Assignment)datain.getAssignment().get(0)).getTo() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody().equals(localeDataInput.getId())) {
                    properties.put("locale", ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody());
                }
                if (createdByDataInput != null && ((Assignment)datain.getAssignment().get(0)).getTo() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody().equals(createdByDataInput.getId())) {
                    properties.put("createdby", ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody());
                }
                if (notCompletedReassignInput != null && ((Assignment)datain.getAssignment().get(0)).getTo() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody().equals(notCompletedReassignInput.getId())) {
                    properties.put("tmpreassignmentnotcompleted", this.updateReassignmentAndNotificationInput(((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody(), "not-completed"));
                }
                if (notStartedReassignInput != null && ((Assignment)datain.getAssignment().get(0)).getTo() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody().equals(notStartedReassignInput.getId())) {
                    properties.put("tmpreassignmentnotstarted", this.updateReassignmentAndNotificationInput(((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody(), "not-started"));
                }
                if (notCompletedNotificationInput != null && ((Assignment)datain.getAssignment().get(0)).getTo() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody() != null && ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody().equals(notCompletedNotificationInput.getId())) {
                    properties.put("tmpnotificationnotcompleted", this.updateReassignmentAndNotificationInput(((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody(), "not-completed"));
                }
                if (notStartedNotificationInput == null || ((Assignment)datain.getAssignment().get(0)).getTo() == null || ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody() == null || !((FormalExpression)((Assignment)datain.getAssignment().get(0)).getTo()).getBody().equals(notStartedNotificationInput.getId())) continue;
                properties.put("tmpnotificationnotstarted", this.updateReassignmentAndNotificationInput(((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody(), "not-started"));
                continue;
            }
            if (lhsAssociation != null && lhsAssociation.length() > 0) {
                associationBuff.append("[din]" + lhsAssociation).append("->").append(rhsAssociation);
                associationBuff.append(",");
                uniDirectionalAssociations.add(lhsAssociation + "," + rhsAssociation);
            }
            uniDirectionalAssociations.add(lhsAssociation + "," + rhsAssociation);
        }
        if (properties.get("tmpreassignmentnotcompleted") != null && ((String)properties.get("tmpreassignmentnotcompleted")).length() > 0 && properties.get("tmpreassignmentnotstarted") != null && ((String)properties.get("tmpreassignmentnotstarted")).length() > 0) {
            properties.put("reassignment", properties.get("tmpreassignmentnotcompleted") + "^" + properties.get("tmpreassignmentnotstarted"));
        } else if (properties.get("tmpreassignmentnotcompleted") != null && ((String)properties.get("tmpreassignmentnotcompleted")).length() > 0) {
            properties.put("reassignment", properties.get("tmpreassignmentnotcompleted"));
        } else if (properties.get("tmpreassignmentnotstarted") != null && ((String)properties.get("tmpreassignmentnotstarted")).length() > 0) {
            properties.put("reassignment", properties.get("tmpreassignmentnotstarted"));
        }
        if (properties.get("tmpnotificationnotcompleted") != null && ((String)properties.get("tmpnotificationnotcompleted")).length() > 0 && properties.get("tmpnotificationnotstarted") != null && ((String)properties.get("tmpnotificationnotstarted")).length() > 0) {
            properties.put("notifications", properties.get("tmpnotificationnotcompleted") + "^" + properties.get("tmpnotificationnotstarted"));
        } else if (properties.get("tmpnotificationnotcompleted") != null && ((String)properties.get("tmpnotificationnotcompleted")).length() > 0) {
            properties.put("notifications", properties.get("tmpnotificationnotcompleted"));
        } else if (properties.get("tmpnotificationnotstarted") != null && ((String)properties.get("tmpnotificationnotstarted")).length() > 0) {
            properties.put("notifications", properties.get("tmpnotificationnotstarted"));
        }
        for (DataOutputAssociation dataout : outputAssociations) {
            boolean proceed = true;
            if (task.getLoopCharacteristics() != null) {
                taskMultiLoop = (MultiInstanceLoopCharacteristics)task.getLoopCharacteristics();
                if (taskMultiLoop.getOutputDataItem() != null && taskMultiLoop.getOutputDataItem().getId() != null && dataout.getTargetRef().getId().equals(taskMultiLoop.getOutputDataItem().getId())) {
                    proceed = false;
                }
                if (taskMultiLoop.getLoopDataOutputRef() != null && ((ItemAwareElement)dataout.getSourceRef().get(0)).equals(taskMultiLoop.getLoopDataOutputRef())) {
                    proceed = false;
                }
            }
            if (!proceed || dataout.getSourceRef().size() <= 0) continue;
            lhsAssociation = ((DataOutput)dataout.getSourceRef().get(0)).getName();
            rhsAssociation = dataout.getTargetRef().getId();
            boolean wasBiDirectional = false;
            if (dataout.getTransformation() != null && dataout.getTransformation().getBody() != null) {
                rhsAssociation = this.encodeAssociationValue(dataout.getTransformation().getBody());
            }
            if (wasBiDirectional || lhsAssociation == null || lhsAssociation.length() <= 0) continue;
            associationBuff.append("[dout]" + lhsAssociation).append("->").append(rhsAssociation);
            associationBuff.append(",");
        }
        String assignmentString = associationBuff.toString();
        if (assignmentString.endsWith(",")) {
            assignmentString = assignmentString.substring(0, assignmentString.length() - 1);
        }
        properties.put("assignments", assignmentString);
        if (task.getExtensionValues() != null && task.getExtensionValues().size() > 0) {
            String onEntryStr = "";
            String onExitStr = "";
            for (ExtensionAttributeValue extattrval : task.getExtensionValues()) {
                String formatToWrite;
                String format;
                FeatureMap extensionElements = extattrval.getValue();
                List onEntryExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__ON_ENTRY_SCRIPT, true);
                List onExitExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__ON_EXIT_SCRIPT, true);
                for (OnEntryScriptType onEntryScript : onEntryExtensions) {
                    onEntryStr = onEntryStr + onEntryScript.getScript();
                    onEntryStr = onEntryStr + "|";
                    if (onEntryScript.getScriptFormat() == null) continue;
                    format = onEntryScript.getScriptFormat();
                    formatToWrite = "";
                    formatToWrite = format.equals("http://www.java.com/java") ? "java" : (format.equals("http://www.mvel.org/2.0") ? "mvel" : (format.equals("http://www.javascript.com/javascript") ? "javascript" : "java"));
                    properties.put("script_language", formatToWrite);
                }
                for (OnExitScriptType onExitScript : onExitExtensions) {
                    onExitStr = onExitStr + onExitScript.getScript();
                    onExitStr = onExitStr + "|";
                    if (onExitScript.getScriptFormat() == null) continue;
                    format = onExitScript.getScriptFormat();
                    formatToWrite = "";
                    formatToWrite = format.equals("http://www.java.com/java") ? "java" : (format.equals("http://www.mvel.org/2.0") ? "mvel" : (format.equals("http://www.javascript.com/javascript") ? "javascript" : "java"));
                    if (properties.get("script_language") != null) continue;
                    properties.put("script_language", formatToWrite);
                }
            }
            if (onEntryStr.length() > 0) {
                if (onEntryStr.endsWith("|")) {
                    onEntryStr = onEntryStr.substring(0, onEntryStr.length() - 1);
                }
                properties.put("onentryactions", onEntryStr);
            }
            if (onExitStr.length() > 0) {
                if (onExitStr.endsWith("|")) {
                    onExitStr = onExitStr.substring(0, onExitStr.length() - 1);
                }
                properties.put("onexitactions", onExitStr);
            }
        }
        if (this._simulationScenario != null) {
            for (ElementParameters eleType : this._simulationScenario.getElementParameters()) {
                CostParameters costParams;
                if (!eleType.getElementRef().equals(task.getId())) continue;
                TimeParameters timeParams = eleType.getTimeParameters();
                Parameter processingTime = timeParams.getProcessingTime();
                ParameterValue paramValue = (ParameterValue)processingTime.getParameterValue().get(0);
                if (paramValue instanceof NormalDistributionType) {
                    NormalDistributionType ndt = (NormalDistributionType)paramValue;
                    properties.put("mean", ndt.getMean());
                    properties.put("standarddeviation", ndt.getStandardDeviation());
                    properties.put("distributiontype", "normal");
                } else if (paramValue instanceof UniformDistributionType) {
                    UniformDistributionType udt = (UniformDistributionType)paramValue;
                    properties.put("min", udt.getMin());
                    properties.put("max", udt.getMax());
                    properties.put("distributiontype", "uniform");
                } else if (paramValue instanceof PoissonDistributionType) {
                    PoissonDistributionType pdt = (PoissonDistributionType)paramValue;
                    properties.put("mean", pdt.getMean());
                    properties.put("distributiontype", "poisson");
                }
                if (timeParams.getWaitTime() != null) {
                    FloatingParameterType waittimeType = (FloatingParameterType)timeParams.getWaitTime().getParameterValue().get(0);
                    properties.put("waittime", waittimeType.getValue());
                }
                if ((costParams = eleType.getCostParameters()) == null || costParams.getUnitCost() == null) continue;
                FloatingParameterType unitCostVal = (FloatingParameterType)costParams.getUnitCost().getParameterValue().get(0);
                properties.put("unitcost", unitCostVal.getValue());
            }
        }
        if (this.isCustomElement((String)properties.get("taskname"), preProcessingData)) {
            this.marshallNode((FlowNode)task, properties, (String)properties.get("taskname"), plane, generator, xOffset, yOffset);
        } else {
            this.marshallNode((FlowNode)task, properties, "Task", plane, generator, xOffset, yOffset);
        }
    }

    protected void marshallParallelGateway(ParallelGateway gateway, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, Map<String, Object> flowElementProperties) throws JsonGenerationException, IOException {
        this.marshallNode((FlowNode)gateway, flowElementProperties, "ParallelGateway", plane, generator, xOffset, yOffset);
    }

    protected void marshallExclusiveGateway(ExclusiveGateway gateway, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, Map<String, Object> flowElementProperties) throws JsonGenerationException, IOException {
        if (gateway.getDefault() != null) {
            SequenceFlow defsf = gateway.getDefault();
            String defGatewayStr = "";
            defGatewayStr = defsf.getName() != null && defsf.getName().length() > 0 ? defsf.getName() + " : " + defsf.getId() : defsf.getId();
            flowElementProperties.put("defaultgate", defGatewayStr);
        }
        this.marshallNode((FlowNode)gateway, flowElementProperties, "Exclusive_Databased_Gateway", plane, generator, xOffset, yOffset);
    }

    protected void marshallInclusiveGateway(InclusiveGateway gateway, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, Map<String, Object> flowElementProperties) throws JsonGenerationException, IOException {
        if (gateway.getDefault() != null) {
            SequenceFlow defsf = gateway.getDefault();
            String defGatewayStr = "";
            defGatewayStr = defsf.getName() != null && defsf.getName().length() > 0 ? defsf.getName() + " : " + defsf.getId() : defsf.getId();
            flowElementProperties.put("defaultgate", defGatewayStr);
        }
        this.marshallNode((FlowNode)gateway, flowElementProperties, "InclusiveGateway", plane, generator, xOffset, yOffset);
    }

    protected void marshallEventBasedGateway(EventBasedGateway gateway, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, Map<String, Object> flowElementProperties) throws JsonGenerationException, IOException {
        this.marshallNode((FlowNode)gateway, flowElementProperties, "EventbasedGateway", plane, generator, xOffset, yOffset);
    }

    protected void marshallComplexGateway(ComplexGateway gateway, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, Map<String, Object> flowElementProperties) throws JsonGenerationException, IOException {
        this.marshallNode((FlowNode)gateway, flowElementProperties, "ComplexGateway", plane, generator, xOffset, yOffset);
    }

    protected void marshallNode(FlowNode node, Map<String, Object> properties, String stencil, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset) throws JsonGenerationException, IOException {
        if (properties == null) {
            properties = new LinkedHashMap<String, Object>();
        }
        if (node.getDocumentation() != null && node.getDocumentation().size() > 0) {
            properties.put("documentation", ((Documentation)node.getDocumentation().get(0)).getText());
        }
        if (node.getName() != null) {
            properties.put("name", Bpmn2JsonMarshaller.unescapeXML(node.getName()));
        } else if (node instanceof TextAnnotation) {
            if (((TextAnnotation)node).getText() != null) {
                properties.put("name", ((TextAnnotation)node).getText());
            } else {
                properties.put("name", "");
            }
        } else {
            properties.put("name", "");
        }
        String elementName = null;
        if (node.getExtensionValues() != null && node.getExtensionValues().size() > 0) {
            for (ExtensionAttributeValue extattrval : node.getExtensionValues()) {
                FeatureMap extensionElements = extattrval.getValue();
                List metadataExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true);
                for (MetaDataType metaType : metadataExtensions) {
                    if (metaType.getName() == null || !metaType.getName().equals("elementname") || metaType.getMetaValue() == null || metaType.getMetaValue().length() <= 0) continue;
                    elementName = metaType.getMetaValue();
                }
            }
        }
        if (elementName != null) {
            properties.put("name", elementName);
        }
        this.marshallProperties(properties, generator);
        generator.writeObjectFieldStart("stencil");
        generator.writeObjectField("id", (Object)stencil);
        generator.writeEndObject();
        generator.writeArrayFieldStart("childShapes");
        generator.writeEndArray();
        generator.writeArrayFieldStart("outgoing");
        for (SequenceFlow outgoing : node.getOutgoing()) {
            generator.writeStartObject();
            generator.writeObjectField("resourceId", (Object)outgoing.getId());
            generator.writeEndObject();
        }
        Process process = (Process)plane.getBpmnElement();
        for (Artifact artifact : process.getArtifacts()) {
            Association association;
            if (!(artifact instanceof Association) || !(association = (Association)artifact).getSourceRef().getId().equals(node.getId())) continue;
            generator.writeStartObject();
            generator.writeObjectField("resourceId", (Object)association.getId());
            generator.writeEndObject();
        }
        ArrayList<BoundaryEvent> boundaryEvents = new ArrayList<BoundaryEvent>();
        this.findBoundaryEvents((FlowElementsContainer)process, boundaryEvents);
        for (BoundaryEvent be : boundaryEvents) {
            if (!be.getAttachedToRef().getId().equals(node.getId())) continue;
            generator.writeStartObject();
            generator.writeObjectField("resourceId", (Object)be.getId());
            generator.writeEndObject();
        }
        generator.writeEndArray();
        if (node instanceof BoundaryEvent) {
            Iterator iter = node.getAnyAttribute().iterator();
            boolean foundDockerInfo = false;
            while (iter.hasNext()) {
                String[] dockerInfoParts;
                String infoPartsToUse;
                String[] infoPartsToUseParts;
                FeatureMap.Entry entry = (FeatureMap.Entry)iter.next();
                if (!entry.getEStructuralFeature().getName().equals("dockerinfo")) continue;
                foundDockerInfo = true;
                String dockerInfoStr = String.valueOf(entry.getValue());
                if (dockerInfoStr == null || dockerInfoStr.length() <= 0 || !dockerInfoStr.endsWith("|") || (infoPartsToUseParts = (infoPartsToUse = (dockerInfoParts = (dockerInfoStr = dockerInfoStr.substring(0, dockerInfoStr.length() - 1)).split("\\|"))[0]).split("\\^")) == null || infoPartsToUseParts.length <= 0) continue;
                generator.writeArrayFieldStart("dockers");
                generator.writeStartObject();
                generator.writeObjectField("x", (Object)infoPartsToUseParts[0]);
                generator.writeObjectField("y", (Object)infoPartsToUseParts[1]);
                generator.writeEndObject();
                generator.writeEndArray();
            }
            if (!foundDockerInfo) {
                for (DiagramElement element : plane.getPlaneElement()) {
                    Point p;
                    List waypoints;
                    if (!(element instanceof BPMNEdge) || ((BPMNEdge)element).getBpmnElement() != node || (waypoints = ((BPMNEdge)element).getWaypoint()) == null || waypoints.size() <= 0 || (p = (Point)waypoints.get(0)) == null) continue;
                    generator.writeArrayFieldStart("dockers");
                    generator.writeStartObject();
                    generator.writeObjectField("x", (Object)Float.valueOf(p.getX()));
                    generator.writeObjectField("y", (Object)Float.valueOf(p.getY()));
                    generator.writeEndObject();
                    generator.writeEndArray();
                }
            }
        }
        BPMNShape shape = (BPMNShape)this.findDiagramElement(plane, (BaseElement)node);
        Bounds bounds = shape.getBounds();
        this.correctEventNodeSize(shape);
        generator.writeObjectFieldStart("bounds");
        generator.writeObjectFieldStart("lowerRight");
        generator.writeObjectField("x", (Object)Float.valueOf(bounds.getX() + bounds.getWidth() - xOffset));
        generator.writeObjectField("y", (Object)Float.valueOf(bounds.getY() + bounds.getHeight() - yOffset));
        generator.writeEndObject();
        generator.writeObjectFieldStart("upperLeft");
        generator.writeObjectField("x", (Object)Float.valueOf(bounds.getX() - xOffset));
        generator.writeObjectField("y", (Object)Float.valueOf(bounds.getY() - yOffset));
        generator.writeEndObject();
        generator.writeEndObject();
    }

    private void correctEventNodeSize(BPMNShape shape) {
        BaseElement element = shape.getBpmnElement();
        if (!(element instanceof Event) && element instanceof Gateway) {
            Bounds bounds = shape.getBounds();
            float width = bounds.getWidth();
            float height = bounds.getHeight();
            if (width != 40.0f || height != 40.0f) {
                bounds.setWidth(40.0f);
                bounds.setHeight(40.0f);
                float x = bounds.getX();
                float y = bounds.getY();
                bounds.setX(x -= (40.0f - width) / 2.0f);
                bounds.setY(y -= (40.0f - height) / 2.0f);
            }
        }
    }

    protected void marshallDataObject(DataObject dataObject, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, Map<String, Object> flowElementProperties) throws JsonGenerationException, IOException {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(flowElementProperties);
        if (dataObject.getDocumentation() != null && dataObject.getDocumentation().size() > 0) {
            properties.put("documentation", ((Documentation)dataObject.getDocumentation().get(0)).getText());
        }
        if (dataObject.getName() != null && dataObject.getName().length() > 0) {
            properties.put("name", Bpmn2JsonMarshaller.unescapeXML(dataObject.getName()));
        } else {
            properties.put("name", dataObject.getId());
        }
        String elementName = null;
        if (dataObject.getExtensionValues() != null && dataObject.getExtensionValues().size() > 0) {
            for (ExtensionAttributeValue extattrval : dataObject.getExtensionValues()) {
                FeatureMap extensionElements = extattrval.getValue();
                List metadataExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true);
                for (MetaDataType metaType : metadataExtensions) {
                    if (metaType.getName() == null || !metaType.getName().equals("elementname") || metaType.getMetaValue() == null || metaType.getMetaValue().length() <= 0) continue;
                    elementName = metaType.getMetaValue();
                }
            }
        }
        if (elementName != null) {
            properties.put("name", elementName);
        }
        if (dataObject.getItemSubjectRef().getStructureRef() != null && dataObject.getItemSubjectRef().getStructureRef().length() > 0) {
            if (defaultTypesList.contains(dataObject.getItemSubjectRef().getStructureRef())) {
                properties.put("standardtype", dataObject.getItemSubjectRef().getStructureRef());
            } else {
                properties.put("customtype", dataObject.getItemSubjectRef().getStructureRef());
            }
        }
        Association outgoingAssociaton = this.findOutgoingAssociation(plane, (BaseElement)dataObject);
        Association incomingAssociation = null;
        Process process = (Process)plane.getBpmnElement();
        for (Artifact artifact : process.getArtifacts()) {
            Association association;
            if (!(artifact instanceof Association) || (association = (Association)artifact).getTargetRef() != dataObject) continue;
            incomingAssociation = association;
        }
        if (outgoingAssociaton != null && incomingAssociation == null) {
            properties.put("input_output", "Input");
        }
        if (outgoingAssociaton == null && incomingAssociation != null) {
            properties.put("input_output", "Output");
        }
        this.marshallProperties(properties, generator);
        generator.writeObjectFieldStart("stencil");
        generator.writeObjectField("id", (Object)"DataObject");
        generator.writeEndObject();
        generator.writeArrayFieldStart("childShapes");
        generator.writeEndArray();
        generator.writeArrayFieldStart("outgoing");
        List<Association> associations = this.findOutgoingAssociations(plane, (BaseElement)dataObject);
        if (associations != null) {
            for (Association as : associations) {
                generator.writeStartObject();
                generator.writeObjectField("resourceId", (Object)as.getId());
                generator.writeEndObject();
            }
        }
        generator.writeEndArray();
        Bounds bounds = ((BPMNShape)this.findDiagramElement(plane, (BaseElement)dataObject)).getBounds();
        generator.writeObjectFieldStart("bounds");
        generator.writeObjectFieldStart("lowerRight");
        generator.writeObjectField("x", (Object)Float.valueOf(bounds.getX() + bounds.getWidth() - xOffset));
        generator.writeObjectField("y", (Object)Float.valueOf(bounds.getY() + bounds.getHeight() - yOffset));
        generator.writeEndObject();
        generator.writeObjectFieldStart("upperLeft");
        generator.writeObjectField("x", (Object)Float.valueOf(bounds.getX() - xOffset));
        generator.writeObjectField("y", (Object)Float.valueOf(bounds.getY() - yOffset));
        generator.writeEndObject();
        generator.writeEndObject();
    }

    protected void marshallSubProcess(SubProcess subProcess, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, String preProcessingData, Definitions def, Map<String, Object> flowElementProperties) throws JsonGenerationException, IOException {
        List processProperties;
        String rhsAssociation;
        String lhsAssociation;
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(flowElementProperties);
        if (subProcess.getName() != null) {
            properties.put("name", Bpmn2JsonMarshaller.unescapeXML(subProcess.getName()));
        } else {
            properties.put("name", "");
        }
        String elementName = null;
        if (subProcess.getExtensionValues() != null && subProcess.getExtensionValues().size() > 0) {
            for (ExtensionAttributeValue extattrval : subProcess.getExtensionValues()) {
                FeatureMap extensionElements = extattrval.getValue();
                List metadataExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true);
                for (MetaDataType metaType : metadataExtensions) {
                    if (metaType.getName() == null || !metaType.getName().equals("elementname") || metaType.getMetaValue() == null || metaType.getMetaValue().length() <= 0) continue;
                    elementName = metaType.getMetaValue();
                }
            }
        }
        if (elementName != null) {
            properties.put("name", elementName);
        }
        if (subProcess instanceof AdHocSubProcess) {
            AdHocSubProcess ahsp = (AdHocSubProcess)subProcess;
            if (ahsp.getOrdering().equals((Object)AdHocOrdering.PARALLEL)) {
                properties.put("adhocordering", "Parallel");
            } else if (ahsp.getOrdering().equals((Object)AdHocOrdering.SEQUENTIAL)) {
                properties.put("adhocordering", "Sequential");
            } else {
                properties.put("adhocordering", "Parallel");
            }
            if (ahsp.getCompletionCondition() != null) {
                properties.put("adhoccompletioncondition", ((FormalExpression)ahsp.getCompletionCondition()).getBody().replaceAll("\n", "\\\\n"));
            }
        }
        String customAsync = "false";
        if (subProcess.getExtensionValues() != null && subProcess.getExtensionValues().size() > 0) {
            for (ExtensionAttributeValue extattrval : subProcess.getExtensionValues()) {
                FeatureMap extensionElements = extattrval.getValue();
                List metadataExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true);
                for (MetaDataType metaType : metadataExtensions) {
                    if (metaType.getName() == null || !metaType.getName().equals("customAsync") || metaType.getMetaValue() == null || metaType.getMetaValue().length() <= 0) continue;
                    customAsync = metaType.getMetaValue();
                }
            }
        }
        properties.put("isasync", customAsync);
        if (subProcess.getIoSpecification() != null) {
            List inputSetList = subProcess.getIoSpecification().getInputSets();
            StringBuilder dataInBuffer = new StringBuilder();
            for (InputSet inset : inputSetList) {
                List dataInputList = inset.getDataInputRefs();
                for (DataInput dataIn : dataInputList) {
                    if (dataIn.getName() == null) continue;
                    dataInBuffer.append(dataIn.getName());
                    if (dataIn.getItemSubjectRef() != null && dataIn.getItemSubjectRef().getStructureRef() != null && dataIn.getItemSubjectRef().getStructureRef().length() > 0) {
                        dataInBuffer.append(":").append(dataIn.getItemSubjectRef().getStructureRef());
                    }
                    dataInBuffer.append(",");
                }
            }
            if (dataInBuffer.length() > 0) {
                dataInBuffer.setLength(dataInBuffer.length() - 1);
            }
            properties.put("datainputset", dataInBuffer.toString());
        }
        if (subProcess.getIoSpecification() != null) {
            List outputSetList = subProcess.getIoSpecification().getOutputSets();
            StringBuilder dataOutBuffer = new StringBuilder();
            for (OutputSet outset : outputSetList) {
                List dataOutputList = outset.getDataOutputRefs();
                for (DataOutput dataOut : dataOutputList) {
                    dataOutBuffer.append(dataOut.getName());
                    if (dataOut.getItemSubjectRef() != null && dataOut.getItemSubjectRef().getStructureRef() != null && dataOut.getItemSubjectRef().getStructureRef().length() > 0) {
                        dataOutBuffer.append(":").append(dataOut.getItemSubjectRef().getStructureRef());
                    }
                    dataOutBuffer.append(",");
                }
            }
            if (dataOutBuffer.length() > 0) {
                dataOutBuffer.setLength(dataOutBuffer.length() - 1);
            }
            properties.put("dataoutputset", dataOutBuffer.toString());
        }
        StringBuilder associationBuff = new StringBuilder();
        List inputAssociations = subProcess.getDataInputAssociations();
        List outputAssociations = subProcess.getDataOutputAssociations();
        for (DataInputAssociation datain : inputAssociations) {
            lhsAssociation = "";
            if (datain.getSourceRef() != null && datain.getSourceRef().size() > 0) {
                lhsAssociation = datain.getTransformation() != null && datain.getTransformation().getBody() != null ? datain.getTransformation().getBody() : ((ItemAwareElement)datain.getSourceRef().get(0)).getId();
            }
            rhsAssociation = "";
            if (datain.getTargetRef() != null) {
                rhsAssociation = ((DataInput)datain.getTargetRef()).getName();
            }
            boolean isAssignment = false;
            if (datain.getAssignment() != null && datain.getAssignment().size() > 0) {
                isAssignment = true;
            }
            if (isAssignment) {
                if (!(((Assignment)datain.getAssignment().get(0)).getFrom() instanceof FormalExpression)) continue;
                String associationValue = ((FormalExpression)((Assignment)datain.getAssignment().get(0)).getFrom()).getBody();
                if (associationValue == null) {
                    associationValue = "";
                }
                String replacer = this.encodeAssociationValue(associationValue);
                associationBuff.append("[din]" + rhsAssociation).append("=").append(replacer);
                associationBuff.append(",");
                continue;
            }
            if (lhsAssociation == null || lhsAssociation.length() <= 0) continue;
            associationBuff.append("[din]" + lhsAssociation).append("->").append(rhsAssociation);
            associationBuff.append(",");
        }
        for (DataOutputAssociation dataout : outputAssociations) {
            if (dataout.getSourceRef().size() <= 0) continue;
            lhsAssociation = ((DataOutput)dataout.getSourceRef().get(0)).getName();
            rhsAssociation = dataout.getTargetRef().getId();
            boolean wasBiDirectional = false;
            if (dataout.getTransformation() != null && dataout.getTransformation().getBody() != null) {
                rhsAssociation = this.encodeAssociationValue(dataout.getTransformation().getBody());
            }
            if (wasBiDirectional || lhsAssociation == null || lhsAssociation.length() <= 0) continue;
            associationBuff.append("[dout]" + lhsAssociation).append("->").append(rhsAssociation);
            associationBuff.append(",");
        }
        String assignmentString = associationBuff.toString();
        if (assignmentString.endsWith(",")) {
            assignmentString = assignmentString.substring(0, assignmentString.length() - 1);
        }
        properties.put("assignments", assignmentString);
        if (subProcess.getExtensionValues() != null && subProcess.getExtensionValues().size() > 0) {
            String onEntryStr = "";
            String onExitStr = "";
            for (ExtensionAttributeValue extattrval : subProcess.getExtensionValues()) {
                String formatToWrite;
                String format;
                FeatureMap extensionElements = extattrval.getValue();
                List onEntryExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__ON_ENTRY_SCRIPT, true);
                List onExitExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__ON_EXIT_SCRIPT, true);
                for (OnEntryScriptType onEntryScript : onEntryExtensions) {
                    onEntryStr = onEntryStr + onEntryScript.getScript();
                    onEntryStr = onEntryStr + "|";
                    if (onEntryScript.getScriptFormat() == null) continue;
                    format = onEntryScript.getScriptFormat();
                    formatToWrite = "";
                    formatToWrite = format.equals("http://www.java.com/java") ? "java" : (format.equals("http://www.mvel.org/2.0") ? "mvel" : (format.equals("http://www.javascript.com/javascript") ? "javascript" : "java"));
                    properties.put("script_language", formatToWrite);
                }
                for (OnExitScriptType onExitScript : onExitExtensions) {
                    onExitStr = onExitStr + onExitScript.getScript();
                    onExitStr = onExitStr + "|";
                    if (onExitScript.getScriptFormat() == null) continue;
                    format = onExitScript.getScriptFormat();
                    formatToWrite = "";
                    formatToWrite = format.equals("http://www.java.com/java") ? "java" : (format.equals("http://www.mvel.org/2.0") ? "mvel" : (format.equals("http://www.javascript.com/javascript") ? "javascript" : "java"));
                    if (properties.get("script_language") != null) continue;
                    properties.put("script_language", formatToWrite);
                }
            }
            if (onEntryStr.length() > 0) {
                if (onEntryStr.endsWith("|")) {
                    onEntryStr = onEntryStr.substring(0, onEntryStr.length() - 1);
                }
                properties.put("onentryactions", onEntryStr);
            }
            if (onExitStr.length() > 0) {
                if (onExitStr.endsWith("|")) {
                    onExitStr = onExitStr.substring(0, onExitStr.length() - 1);
                }
                properties.put("onexitactions", onExitStr);
            }
        }
        boolean haveValidLoopCharacteristics = false;
        if (subProcess.getLoopCharacteristics() != null && subProcess.getLoopCharacteristics() instanceof MultiInstanceLoopCharacteristics) {
            haveValidLoopCharacteristics = true;
            properties.put("mitrigger", "true");
            MultiInstanceLoopCharacteristics taskmi = (MultiInstanceLoopCharacteristics)subProcess.getLoopCharacteristics();
            if (taskmi.getLoopDataInputRef() != null) {
                ItemAwareElement iedatainput = taskmi.getLoopDataInputRef();
                List taskInputAssociations = subProcess.getDataInputAssociations();
                for (DataInputAssociation dia : taskInputAssociations) {
                    if (!dia.getTargetRef().equals(iedatainput)) continue;
                    properties.put("multipleinstancecollectioninput", ((ItemAwareElement)dia.getSourceRef().get(0)).getId());
                    break;
                }
            }
            if (taskmi.getLoopDataOutputRef() != null) {
                ItemAwareElement iedataoutput = taskmi.getLoopDataOutputRef();
                List taskOutputAssociations = subProcess.getDataOutputAssociations();
                for (DataOutputAssociation dout : taskOutputAssociations) {
                    if (!((ItemAwareElement)dout.getSourceRef().get(0)).equals(iedataoutput)) continue;
                    properties.put("multipleinstancecollectionoutput", dout.getTargetRef().getId());
                    break;
                }
            }
            if (taskmi.getInputDataItem() != null) {
                List taskDataInputs = subProcess.getIoSpecification().getDataInputs();
                for (DataInput din : taskDataInputs) {
                    if (din.getItemSubjectRef() == null) {
                        properties.put("multipleinstancedatainput", taskmi.getInputDataItem().getId());
                    }
                    if (din.getItemSubjectRef() == null || !din.getItemSubjectRef().getId().equals(taskmi.getInputDataItem().getItemSubjectRef().getId())) continue;
                    properties.put("multipleinstancedatainput", din.getName());
                    break;
                }
            }
            if (taskmi.getOutputDataItem() != null) {
                List taskDataOutputs = subProcess.getIoSpecification().getDataOutputs();
                for (DataOutput dout : taskDataOutputs) {
                    if (dout.getItemSubjectRef() == null) {
                        properties.put("multipleinstancedataoutput", taskmi.getOutputDataItem().getId());
                        break;
                    }
                    if (dout.getItemSubjectRef() == null || !dout.getItemSubjectRef().getId().equals(taskmi.getOutputDataItem().getItemSubjectRef().getId())) continue;
                    properties.put("multipleinstancedataoutput", dout.getName());
                    break;
                }
            }
            if (taskmi.getCompletionCondition() != null && taskmi.getCompletionCondition() instanceof FormalExpression) {
                properties.put("multipleinstancecompletioncondition", ((FormalExpression)taskmi.getCompletionCondition()).getBody());
            }
        }
        if ((processProperties = subProcess.getProperties()) != null && processProperties.size() > 0) {
            String propVal = "";
            for (int i = 0; i < processProperties.size(); ++i) {
                Property p = (Property)processProperties.get(i);
                String pKPI = "";
                if (p.getExtensionValues() != null && p.getExtensionValues().size() > 0) {
                    for (ExtensionAttributeValue extattrval : p.getExtensionValues()) {
                        FeatureMap extensionElements = extattrval.getValue();
                        List metadataExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true);
                        for (MetaDataType metaType : metadataExtensions) {
                            if (metaType.getName() == null || !metaType.getName().equals("customKPI") || metaType.getMetaValue() == null || metaType.getMetaValue().length() <= 0) continue;
                            pKPI = metaType.getMetaValue();
                        }
                    }
                }
                propVal = propVal + p.getId();
                if (p.getItemSubjectRef() != null && p.getItemSubjectRef().getStructureRef() != null) {
                    propVal = propVal + ":" + p.getItemSubjectRef().getStructureRef();
                }
                if (pKPI.length() > 0) {
                    propVal = propVal + ":" + pKPI;
                }
                if (i == processProperties.size() - 1) continue;
                propVal = propVal + ",";
            }
            properties.put("vardefs", propVal);
        }
        if (this._simulationScenario != null) {
            for (ElementParameters eleType : this._simulationScenario.getElementParameters()) {
                CostParameters costParams;
                if (!eleType.getElementRef().equals(subProcess.getId())) continue;
                TimeParameters timeParams = eleType.getTimeParameters();
                Parameter processingTime = timeParams.getProcessingTime();
                ParameterValue paramValue = (ParameterValue)processingTime.getParameterValue().get(0);
                if (paramValue instanceof NormalDistributionType) {
                    NormalDistributionType ndt = (NormalDistributionType)paramValue;
                    properties.put("mean", ndt.getMean());
                    properties.put("standarddeviation", ndt.getStandardDeviation());
                    properties.put("distributiontype", "normal");
                } else if (paramValue instanceof UniformDistributionType) {
                    UniformDistributionType udt = (UniformDistributionType)paramValue;
                    properties.put("min", udt.getMin());
                    properties.put("max", udt.getMax());
                    properties.put("distributiontype", "uniform");
                } else if (paramValue instanceof PoissonDistributionType) {
                    PoissonDistributionType pdt = (PoissonDistributionType)paramValue;
                    properties.put("mean", pdt.getMean());
                    properties.put("distributiontype", "poisson");
                }
                if (timeParams.getWaitTime() != null) {
                    FloatingParameterType waittimeType = (FloatingParameterType)timeParams.getWaitTime().getParameterValue().get(0);
                    properties.put("waittime", waittimeType.getValue());
                }
                if ((costParams = eleType.getCostParameters()) == null || costParams.getUnitCost() == null) continue;
                FloatingParameterType unitCostVal = (FloatingParameterType)costParams.getUnitCost().getParameterValue().get(0);
                properties.put("unitcost", unitCostVal.getValue());
            }
        }
        this.marshallProperties(properties, generator);
        generator.writeObjectFieldStart("stencil");
        if (subProcess instanceof AdHocSubProcess) {
            generator.writeObjectField("id", (Object)"AdHocSubprocess");
        } else if (subProcess.isTriggeredByEvent()) {
            generator.writeObjectField("id", (Object)"EventSubprocess");
        } else if (haveValidLoopCharacteristics) {
            generator.writeObjectField("id", (Object)"MultipleInstanceSubprocess");
        } else {
            generator.writeObjectField("id", (Object)"Subprocess");
        }
        generator.writeEndObject();
        generator.writeArrayFieldStart("childShapes");
        Bounds bounds = ((BPMNShape)this.findDiagramElement(plane, (BaseElement)subProcess)).getBounds();
        for (FlowElement flowElement : subProcess.getFlowElements()) {
            if (this.coordianteManipulation) {
                this.marshallFlowElement(flowElement, plane, generator, bounds.getX(), bounds.getY(), preProcessingData, def);
                continue;
            }
            this.marshallFlowElement(flowElement, plane, generator, 0.0f, 0.0f, preProcessingData, def);
        }
        for (Artifact artifact : subProcess.getArtifacts()) {
            if (this.coordianteManipulation) {
                this.marshallArtifact(artifact, plane, generator, bounds.getX(), bounds.getY(), preProcessingData, def);
                continue;
            }
            this.marshallArtifact(artifact, plane, generator, 0.0f, 0.0f, preProcessingData, def);
        }
        generator.writeEndArray();
        generator.writeArrayFieldStart("outgoing");
        for (BoundaryEvent boundaryEvent : subProcess.getBoundaryEventRefs()) {
            generator.writeStartObject();
            generator.writeObjectField("resourceId", (Object)boundaryEvent.getId());
            generator.writeEndObject();
        }
        for (SequenceFlow outgoing : subProcess.getOutgoing()) {
            generator.writeStartObject();
            generator.writeObjectField("resourceId", (Object)outgoing.getId());
            generator.writeEndObject();
        }
        Process process = (Process)plane.getBpmnElement();
        ArrayList<BoundaryEvent> boundaryEvents = new ArrayList<BoundaryEvent>();
        this.findBoundaryEvents((FlowElementsContainer)process, boundaryEvents);
        for (BoundaryEvent be : boundaryEvents) {
            if (!be.getAttachedToRef().getId().equals(subProcess.getId())) continue;
            generator.writeStartObject();
            generator.writeObjectField("resourceId", (Object)be.getId());
            generator.writeEndObject();
        }
        generator.writeEndArray();
        generator.writeObjectFieldStart("bounds");
        generator.writeObjectFieldStart("lowerRight");
        generator.writeObjectField("x", (Object)Float.valueOf(bounds.getX() + bounds.getWidth() - xOffset));
        generator.writeObjectField("y", (Object)Float.valueOf(bounds.getY() + bounds.getHeight() - yOffset));
        generator.writeEndObject();
        generator.writeObjectFieldStart("upperLeft");
        generator.writeObjectField("x", (Object)Float.valueOf(bounds.getX() - xOffset));
        generator.writeObjectField("y", (Object)Float.valueOf(bounds.getY() - yOffset));
        generator.writeEndObject();
        generator.writeEndObject();
    }

    protected void marshallSequenceFlow(SequenceFlow sequenceFlow, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset) throws JsonGenerationException, IOException {
        if (sequenceFlow.getSourceRef() == null || sequenceFlow.getTargetRef() == null) {
            return;
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        if (sequenceFlow.getName() != null && !"".equals(sequenceFlow.getName())) {
            properties.put("name", Bpmn2JsonMarshaller.unescapeXML(sequenceFlow.getName()));
        } else {
            properties.put("name", "");
        }
        String elementName = null;
        if (sequenceFlow.getExtensionValues() != null && sequenceFlow.getExtensionValues().size() > 0) {
            for (ExtensionAttributeValue extattrval : sequenceFlow.getExtensionValues()) {
                FeatureMap extensionElements = extattrval.getValue();
                List metadataExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true);
                for (MetaDataType metaType : metadataExtensions) {
                    if (metaType.getName() == null || !metaType.getName().equals("elementname") || metaType.getMetaValue() == null || metaType.getMetaValue().length() <= 0) continue;
                    elementName = metaType.getMetaValue();
                }
            }
        }
        if (elementName != null) {
            properties.put("name", elementName);
        }
        if (sequenceFlow.getDocumentation() != null && sequenceFlow.getDocumentation().size() > 0) {
            properties.put("documentation", ((Documentation)sequenceFlow.getDocumentation().get(0)).getText());
        }
        if (sequenceFlow.isIsImmediate()) {
            properties.put("isimmediate", "true");
        } else {
            properties.put("isimmediate", "false");
        }
        Expression conditionExpression = sequenceFlow.getConditionExpression();
        if (conditionExpression instanceof FormalExpression) {
            if (((FormalExpression)conditionExpression).getBody() != null) {
                properties.put("conditionexpression", ((FormalExpression)conditionExpression).getBody().replaceAll("\n", "\\\\n"));
            }
            if (((FormalExpression)conditionExpression).getLanguage() != null) {
                String cd = ((FormalExpression)conditionExpression).getLanguage();
                String cdStr = "";
                cdStr = cd.equalsIgnoreCase("http://www.java.com/java") ? "java" : (cd.equalsIgnoreCase("http://www.jboss.org/drools/rule") ? "drools" : (cd.equalsIgnoreCase("http://www.mvel.org/2.0") ? "mvel" : (cd.equalsIgnoreCase("http://www.javascript.com/javascript") ? "javascript" : "mvel")));
                properties.put("conditionexpressionlanguage", cdStr);
            }
        }
        boolean foundBgColor = false;
        boolean foundBrColor = false;
        boolean foundFontColor = false;
        boolean foundSelectable = false;
        for (FeatureMap.Entry entry : sequenceFlow.getAnyAttribute()) {
            String priorityStr;
            if (entry.getEStructuralFeature().getName().equals("priority") && (priorityStr = String.valueOf(entry.getValue())) != null) {
                try {
                    Integer priorityInt = Integer.parseInt(priorityStr);
                    if (priorityInt >= 1) {
                        properties.put("priority", entry.getValue());
                    } else {
                        _logger.error("Priority must be equal or greater than 1.");
                    }
                }
                catch (NumberFormatException e) {
                    _logger.error("Priority must be a number.");
                }
            }
            if (entry.getEStructuralFeature().getName().equals("background-color") || entry.getEStructuralFeature().getName().equals("bgcolor")) {
                properties.put("bgcolor", entry.getValue());
                foundBgColor = true;
            }
            if (entry.getEStructuralFeature().getName().equals("border-color") || entry.getEStructuralFeature().getName().equals("bordercolor")) {
                properties.put("bordercolor", entry.getValue());
                foundBrColor = true;
            }
            if (entry.getEStructuralFeature().getName().equals("fontsize")) {
                properties.put("fontsize", entry.getValue());
                foundBrColor = true;
            }
            if (entry.getEStructuralFeature().getName().equals("color") || entry.getEStructuralFeature().getName().equals("fontcolor")) {
                properties.put("fontcolor", entry.getValue());
                foundFontColor = true;
            }
            if (!entry.getEStructuralFeature().getName().equals("selectable")) continue;
            properties.put("isselectable", entry.getValue());
            foundSelectable = true;
        }
        if (!foundBgColor) {
            properties.put("bgcolor", "#000000");
        }
        if (!foundBrColor) {
            properties.put("bordercolor", "#000000");
        }
        if (!foundFontColor) {
            properties.put("fontcolor", "#000000");
        }
        if (!foundSelectable) {
            properties.put("isselectable", "true");
        }
        if (this._simulationScenario != null) {
            EList elementParams = this._simulationScenario.getElementParameters();
            for (ElementParameters eleType : elementParams) {
                if (!eleType.getElementRef().equals(sequenceFlow.getId())) continue;
                FloatingParameterType valType = (FloatingParameterType)eleType.getControlParameters().getProbability().getParameterValue().get(0);
                properties.put("probability", valType.getValue());
            }
        }
        this.marshallProperties(properties, generator);
        generator.writeObjectFieldStart("stencil");
        generator.writeObjectField("id", (Object)"SequenceFlow");
        generator.writeEndObject();
        generator.writeArrayFieldStart("childShapes");
        generator.writeEndArray();
        generator.writeArrayFieldStart("outgoing");
        generator.writeStartObject();
        generator.writeObjectField("resourceId", (Object)sequenceFlow.getTargetRef().getId());
        generator.writeEndObject();
        generator.writeEndArray();
        Bounds sourceBounds = ((BPMNShape)this.findDiagramElement(plane, (BaseElement)sequenceFlow.getSourceRef())).getBounds();
        Bounds targetBounds = ((BPMNShape)this.findDiagramElement(plane, (BaseElement)sequenceFlow.getTargetRef())).getBounds();
        generator.writeArrayFieldStart("dockers");
        generator.writeStartObject();
        generator.writeObjectField("x", (Object)Float.valueOf(sourceBounds.getWidth() / 2.0f));
        generator.writeObjectField("y", (Object)Float.valueOf(sourceBounds.getHeight() / 2.0f));
        generator.writeEndObject();
        List waypoints = ((BPMNEdge)this.findDiagramElement(plane, (BaseElement)sequenceFlow)).getWaypoint();
        for (int i = 1; i < waypoints.size() - 1; ++i) {
            Point waypoint = (Point)waypoints.get(i);
            generator.writeStartObject();
            generator.writeObjectField("x", (Object)Float.valueOf(waypoint.getX()));
            generator.writeObjectField("y", (Object)Float.valueOf(waypoint.getY()));
            generator.writeEndObject();
        }
        generator.writeStartObject();
        generator.writeObjectField("x", (Object)Float.valueOf(targetBounds.getWidth() / 2.0f));
        generator.writeObjectField("y", (Object)Float.valueOf(targetBounds.getHeight() / 2.0f));
        generator.writeEndObject();
        generator.writeEndArray();
    }

    private DiagramElement findDiagramElement(BPMNPlane plane, BaseElement baseElement) {
        DiagramElement result = this._diagramElements.get(baseElement.getId());
        if (result != null) {
            return result;
        }
        for (DiagramElement element : plane.getPlaneElement()) {
            if ((!(element instanceof BPMNEdge) || ((BPMNEdge)element).getBpmnElement() != baseElement) && (!(element instanceof BPMNShape) || ((BPMNShape)element).getBpmnElement() != baseElement)) continue;
            this._diagramElements.put(baseElement.getId(), element);
            return element;
        }
        _logger.info("Could not find BPMNDI information for " + baseElement);
        return null;
    }

    protected void marshallGlobalTask(GlobalTask globalTask, JsonGenerator generator) {
        if (globalTask instanceof GlobalBusinessRuleTask || globalTask instanceof GlobalManualTask || globalTask instanceof GlobalScriptTask || globalTask instanceof GlobalUserTask) {
            // empty if block
        }
    }

    protected void marshallGlobalChoreographyTask(GlobalChoreographyTask callableElement, JsonGenerator generator) {
        throw new UnsupportedOperationException("TODO");
    }

    protected void marshallConversation(Conversation callableElement, JsonGenerator generator) {
        throw new UnsupportedOperationException("TODO");
    }

    protected void marshallChoreography(Choreography callableElement, JsonGenerator generator) {
        throw new UnsupportedOperationException("TODO");
    }

    protected void marshallProperties(Map<String, Object> properties, JsonGenerator generator) throws JsonGenerationException, IOException {
        generator.writeObjectFieldStart("properties");
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            generator.writeObjectField(entry.getKey(), (Object)String.valueOf(entry.getValue()));
        }
        generator.writeEndObject();
    }

    protected void marshallArtifact(Artifact artifact, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, String preProcessingData, Definitions def) throws IOException {
        generator.writeStartObject();
        generator.writeObjectField("resourceId", (Object)artifact.getId());
        if (artifact instanceof Association) {
            this.marshallAssociation((Association)artifact, plane, generator, xOffset, yOffset, preProcessingData, def);
        } else if (artifact instanceof Group) {
            this.marshallGroup((Group)artifact, plane, generator, xOffset, yOffset, preProcessingData, def);
        }
        generator.writeEndObject();
    }

    protected void marshallAssociation(Association association, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, String preProcessingData, Definitions def) throws JsonGenerationException, IOException {
        List waypoints;
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        Iterator iter = association.getAnyAttribute().iterator();
        boolean foundBrColor = false;
        while (iter.hasNext()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)iter.next();
            if (entry.getEStructuralFeature().getName().equals("type")) {
                properties.put("type", entry.getValue());
            }
            if (!entry.getEStructuralFeature().getName().equals("bordercolor")) continue;
            properties.put("bordercolor", entry.getValue());
            foundBrColor = true;
        }
        if (!foundBrColor) {
            properties.put("bordercolor", "#000000");
        }
        if (association.getDocumentation() != null && association.getDocumentation().size() > 0) {
            properties.put("documentation", ((Documentation)association.getDocumentation().get(0)).getText());
        }
        this.marshallProperties(properties, generator);
        generator.writeObjectFieldStart("stencil");
        if (association.getAssociationDirection().equals((Object)AssociationDirection.ONE)) {
            generator.writeObjectField("id", (Object)"Association_Unidirectional");
        } else if (association.getAssociationDirection().equals((Object)AssociationDirection.BOTH)) {
            generator.writeObjectField("id", (Object)"Association_Bidirectional");
        } else {
            generator.writeObjectField("id", (Object)"Association_Undirected");
        }
        generator.writeEndObject();
        generator.writeArrayFieldStart("childShapes");
        generator.writeEndArray();
        generator.writeArrayFieldStart("outgoing");
        generator.writeStartObject();
        generator.writeObjectField("resourceId", (Object)association.getTargetRef().getId());
        generator.writeEndObject();
        generator.writeEndArray();
        Bounds sourceBounds = ((BPMNShape)this.findDiagramElement(plane, association.getSourceRef())).getBounds();
        Bounds targetBounds = null;
        float tbx = 0.0f;
        float tby = 0.0f;
        if (this.findDiagramElement(plane, association.getTargetRef()) instanceof BPMNShape) {
            targetBounds = ((BPMNShape)this.findDiagramElement(plane, association.getTargetRef())).getBounds();
        } else if (this.findDiagramElement(plane, association.getTargetRef()) instanceof BPMNEdge && (waypoints = ((BPMNEdge)this.findDiagramElement(plane, association.getTargetRef())).getWaypoint()) != null && waypoints.size() > 0) {
            tbx = ((Point)waypoints.get(0)).getX();
            tby = ((Point)waypoints.get(0)).getY();
        }
        generator.writeArrayFieldStart("dockers");
        generator.writeStartObject();
        generator.writeObjectField("x", (Object)Float.valueOf(sourceBounds.getWidth() / 2.0f));
        generator.writeObjectField("y", (Object)Float.valueOf(sourceBounds.getHeight() / 2.0f));
        generator.writeEndObject();
        waypoints = ((BPMNEdge)this.findDiagramElement(plane, (BaseElement)association)).getWaypoint();
        for (int i = 1; i < waypoints.size() - 1; ++i) {
            Point waypoint = (Point)waypoints.get(i);
            generator.writeStartObject();
            generator.writeObjectField("x", (Object)Float.valueOf(waypoint.getX()));
            generator.writeObjectField("y", (Object)Float.valueOf(waypoint.getY()));
            generator.writeEndObject();
        }
        if (targetBounds != null) {
            generator.writeStartObject();
            if (association.getTargetRef() instanceof TextAnnotation) {
                generator.writeObjectField("x", (Object)1);
                generator.writeObjectField("y", (Object)Float.valueOf(targetBounds.getHeight() / 2.0f));
            } else {
                generator.writeObjectField("x", (Object)Float.valueOf(targetBounds.getWidth() / 2.0f));
                generator.writeObjectField("y", (Object)Float.valueOf(targetBounds.getHeight() / 2.0f));
            }
            generator.writeEndObject();
            generator.writeEndArray();
        } else {
            generator.writeStartObject();
            generator.writeObjectField("x", (Object)Float.valueOf(tbx));
            generator.writeObjectField("y", (Object)Float.valueOf(tby));
            generator.writeEndObject();
            generator.writeEndArray();
        }
    }

    protected void marshallTextAnnotation(TextAnnotation textAnnotation, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, String preProcessingData, Definitions def, Map<String, Object> flowElementProperties) throws JsonGenerationException, IOException {
        flowElementProperties.put("name", textAnnotation.getText());
        String elementName = null;
        if (textAnnotation.getExtensionValues() != null && textAnnotation.getExtensionValues().size() > 0) {
            for (ExtensionAttributeValue extattrval : textAnnotation.getExtensionValues()) {
                FeatureMap extensionElements = extattrval.getValue();
                List metadataExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true);
                for (MetaDataType metaType : metadataExtensions) {
                    if (metaType.getName() == null || !metaType.getName().equals("elementname") || metaType.getMetaValue() == null || metaType.getMetaValue().length() <= 0) continue;
                    elementName = metaType.getMetaValue();
                }
            }
        }
        if (elementName != null) {
            flowElementProperties.put("name", elementName);
        }
        if (textAnnotation.getDocumentation() != null && textAnnotation.getDocumentation().size() > 0) {
            flowElementProperties.put("documentation", ((Documentation)textAnnotation.getDocumentation().get(0)).getText());
        }
        flowElementProperties.put("artifacttype", "Annotation");
        this.marshallNode((FlowNode)textAnnotation, flowElementProperties, "TextAnnotation", plane, generator, xOffset, yOffset);
    }

    protected void marshallGroup(Group group, BPMNPlane plane, JsonGenerator generator, float xOffset, float yOffset, String preProcessingData, Definitions def) throws JsonGenerationException, IOException {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        if (group.getCategoryValueRef() != null && group.getCategoryValueRef().getValue() != null) {
            properties.put("name", Bpmn2JsonMarshaller.unescapeXML(group.getCategoryValueRef().getValue()));
        }
        this.marshallProperties(properties, generator);
        generator.writeObjectFieldStart("stencil");
        generator.writeObjectField("id", (Object)"Group");
        generator.writeEndObject();
        generator.writeArrayFieldStart("childShapes");
        generator.writeEndArray();
        generator.writeArrayFieldStart("outgoing");
        if (this.findOutgoingAssociation(plane, (BaseElement)group) != null) {
            generator.writeStartObject();
            generator.writeObjectField("resourceId", (Object)this.findOutgoingAssociation(plane, (BaseElement)group).getId());
            generator.writeEndObject();
        }
        generator.writeEndArray();
        Bounds bounds = ((BPMNShape)this.findDiagramElement(plane, (BaseElement)group)).getBounds();
        generator.writeObjectFieldStart("bounds");
        generator.writeObjectFieldStart("lowerRight");
        generator.writeObjectField("x", (Object)Float.valueOf(bounds.getX() + bounds.getWidth() - xOffset));
        generator.writeObjectField("y", (Object)Float.valueOf(bounds.getY() + bounds.getHeight() - yOffset));
        generator.writeEndObject();
        generator.writeObjectFieldStart("upperLeft");
        generator.writeObjectField("x", (Object)Float.valueOf(bounds.getX() - xOffset));
        generator.writeObjectField("y", (Object)Float.valueOf(bounds.getY() - yOffset));
        generator.writeEndObject();
        generator.writeEndObject();
    }

    protected Association findOutgoingAssociation(BPMNPlane plane, BaseElement baseElement) {
        Association result = this._diagramAssociations.get(baseElement.getId());
        if (result != null) {
            return result;
        }
        if (!(plane.getBpmnElement() instanceof Process)) {
            throw new IllegalArgumentException("Don't know how to get associations from a non-Process Diagram");
        }
        Process process = (Process)plane.getBpmnElement();
        for (Artifact artifact : process.getArtifacts()) {
            Association association;
            if (!(artifact instanceof Association) || (association = (Association)artifact).getSourceRef() != baseElement) continue;
            this._diagramAssociations.put(baseElement.getId(), association);
            return association;
        }
        return null;
    }

    protected List<Association> findOutgoingAssociations(BPMNPlane plane, BaseElement baseElement) {
        ArrayList<Association> retList = new ArrayList<Association>();
        if (!(plane.getBpmnElement() instanceof Process)) {
            throw new IllegalArgumentException("Don't know how to get associations from a non-Process Diagram");
        }
        Process process = (Process)plane.getBpmnElement();
        for (Artifact artifact : process.getArtifacts()) {
            Association association;
            if (!(artifact instanceof Association) || (association = (Association)artifact).getSourceRef() != baseElement) continue;
            retList.add(association);
        }
        return retList;
    }

    protected void marshallStencil(String stencilId, JsonGenerator generator) throws JsonGenerationException, IOException {
        generator.writeObjectFieldStart("stencil");
        generator.writeObjectField("id", (Object)stencilId);
        generator.writeEndObject();
    }

    private boolean isCustomElement(String taskType, String preProcessingData) {
        if (taskType != null && taskType.length() > 0 && preProcessingData != null && preProcessingData.length() > 0) {
            String[] preProcessingDataElements;
            for (String preProcessingDataElement : preProcessingDataElements = preProcessingData.split(",\\s*")) {
                if (!taskType.equals(preProcessingDataElement)) continue;
                return true;
            }
        }
        return false;
    }

    private static String unescapeXML(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '&') {
                int pos = str.indexOf(";", i);
                if (pos == -1) {
                    buf.append('&');
                    continue;
                }
                if (str.charAt(i + 1) == '#') {
                    int val = Integer.parseInt(str.substring(i + 2, pos), 16);
                    buf.append((char)val);
                    i = pos;
                    continue;
                }
                String substr = str.substring(i, pos + 1);
                if (substr.equals("&amp;")) {
                    buf.append('&');
                } else if (substr.equals("&lt;")) {
                    buf.append('<');
                } else if (substr.equals("&gt;")) {
                    buf.append('>');
                } else if (substr.equals("&quot;")) {
                    buf.append('\"');
                } else if (substr.equals("&apos;")) {
                    buf.append('\'');
                } else {
                    buf.append(substr);
                }
                i = pos;
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private String updateReassignmentAndNotificationInput(String inputStr, String type) {
        if (inputStr != null && inputStr.length() > 0) {
            String[] parts;
            String ret = "";
            for (String nextPart : parts = inputStr.split("\\^\\s*")) {
                ret = ret + nextPart + "@" + type + "^";
            }
            if (ret.endsWith("^")) {
                ret = ret.substring(0, ret.length() - 1);
            }
            return ret;
        }
        return "";
    }

    private void findBoundaryEvents(FlowElementsContainer flc, List<BoundaryEvent> boundaryList) {
        for (FlowElement fl : flc.getFlowElements()) {
            if (fl instanceof BoundaryEvent) {
                boundaryList.add((BoundaryEvent)fl);
            }
            if (!(fl instanceof FlowElementsContainer)) continue;
            this.findBoundaryEvents((FlowElementsContainer)fl, boundaryList);
        }
    }

    private String getAnyAttributeValue(BaseElement el, String attrName) {
        if (el == null || attrName == null || attrName.isEmpty()) {
            return null;
        }
        if (el.getAnyAttribute() != null && el.getAnyAttribute().size() > 0) {
            for (FeatureMap.Entry entry : el.getAnyAttribute()) {
                if (!attrName.equals(entry.getEStructuralFeature().getName())) continue;
                return entry.getValue().toString();
            }
        }
        return null;
    }

    private String encodeAssociationValue(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }
}

