/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestHttpServletResponse;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.Filter;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.filters.FilterByExtension;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.server.TransformerServlet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class TransformerServletTest
extends RepositoryBaseTest {
    private static final String BP_CONTENT = "test process";
    private static final String BPMN2_FILE_TYPE = "bpmn2";
    private static final String BP_NAME = "bp1";
    private static final String JBPM_PROFILE_NAME = "jbpm";
    private static final String LOCATION = "/global";
    private static final String FORMATTED_SVG = "<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:oryx=\"http://oryx-editor.org\" id=\"_A3F7A04F-E2E8-43FD-964F-F700B3D42348\" width=\"197.28125\" height=\"235.921875\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:svg=\"http://www.w3.org/2000/svg\"><defs/><g stroke=\"none\" font-family=\"Verdana, sans-serif\" font-size-adjust=\"none\" font-style=\"normal\" font-variant=\"normal\" font-weight=\"normal\" line-heigth=\"normal\" font-size=\"12\"><g class=\"stencils\" transform=\"translate(15, 15.921875)\"><g class=\"me\"/><g class=\"children\"><g id=\"_D1450722-93B9-4CD1-9CFB-0FC82DE31DF8\" bpmn2nodeid=\"processStartEvent\"><g class=\"stencils\" transform=\"translate(120, 165)\"><g class=\"me\"><g pointer-events=\"fill\" id=\"_D1450722-93B9-4CD1-9CFB-0FC82DE31DF8\">        <defs id=\"_D1450722-93B9-4CD1-9CFB-0FC82DE31DF8__D1450722-93B9-4CD1-9CFB-0FC82DE31DF8_5\"> \t\t<radialGradient id=\"_D1450722-93B9-4CD1-9CFB-0FC82DE31DF8background\" cx=\"10%\" cy=\"10%\" r=\"100%\" fx=\"10%\" fy=\"10%\"> \t\t\t<stop offset=\"0%\" stop-color=\"#ffffff\" stop-opacity=\"1\" id=\"_D1450722-93B9-4CD1-9CFB-0FC82DE31DF8__D1450722-93B9-4CD1-9CFB-0FC82DE31DF8_6\"/> \t\t\t<stop id=\"_D1450722-93B9-4CD1-9CFB-0FC82DE31DF8fill_el\" offset=\"100%\" stop-color=\"#9acd32\" stop-opacity=\"1\"/> \t\t</radialGradient> \t</defs> \t     <circle id=\"_D1450722-93B9-4CD1-9CFB-0FC82DE31DF8bg_frame\" cx=\"15\" cy=\"15\" r=\"15\" stroke=\"#000000\" fill=\"url(#_D1450722-93B9-4CD1-9CFB-0FC82DE31DF8background) white\" stroke-width=\"1\" style=\"stroke-dasharray: 5.5, 3\"/>      <circle id=\"_D1450722-93B9-4CD1-9CFB-0FC82DE31DF8frame\" cx=\"15\" cy=\"15\" r=\"15\" stroke=\"#000000\" fill=\"none\" stroke-width=\"1\" display=\"inherit\"/>  \t<text font-size=\"8\" id=\"_D1450722-93B9-4CD1-9CFB-0FC82DE31DF8text_name\" x=\"15\" y=\"32\" oryx:align=\"top center\" stroke=\"black\" stroke-width=\"0pt\" letter-spacing=\"-0.01px\" fill=\"#000000\" text-anchor=\"middle\" transform=\"rotate(0 15 32)\" visibility=\"inherit\" oryx:fontSize=\"11\"/>   </g></g><g class=\"children\" style=\"overflow:hidden\"/><g class=\"edge\"/></g><g class=\"controls\"><g class=\"dockers\"/><g class=\"magnets\" transform=\"translate(120, 165)\"><g pointer-events=\"all\" display=\"none\" transform=\"translate(7, 7)\"><circle cx=\"8\" cy=\"8\" r=\"4\" stroke=\"none\" fill=\"red\" fill-opacity=\"0.3\"/></g></g></g></g></g><g class=\"edge\"/><text id=\"_3260CEE5-4A05-4F4B-91A1-A3CE143D86E0\" style=\"stroke-width:1;fill:rgb(177,194,214);font-family:arial;font-weight:bold\" font-size=\"8\" onclick=\"ORYX.Plugins.CanvasTitle.openTextualAnalysis()\" onmouseover=\"ORYX.Plugins.CanvasTitle.addToolTip('_3260CEE5-4A05-4F4B-91A1-A3CE143D86E0')\" transform=\"translate(10, 20)\">bp1 v.1.0 (Evaluation.bp1)</text></g></g></svg>";
    private static String FORMATTED_SVG_ENCODED;

    public TransformerServletTest() {
        try {
            FORMATTED_SVG_ENCODED = new String(Base64.encodeBase64((byte[])FORMATTED_SVG.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    @Before
    public void setup() {
        super.setup();
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testTransformToPng() throws Exception {
        Repository repository = this.createRepository();
        String id = this.createAsset(repository, LOCATION, BP_NAME, BPMN2_FILE_TYPE, BP_CONTENT);
        TransformerServlet transformerServlet = new TransformerServlet();
        transformerServlet.setProfile((IDiagramProfile)this.profile);
        String targetType = "png";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fsvg", FORMATTED_SVG_ENCODED);
        params.put("uuid", id);
        params.put("profile", JBPM_PROFILE_NAME);
        params.put("transformto", targetType);
        params.put("processid", BP_NAME);
        TestHttpServletResponse response = new TestHttpServletResponse();
        transformerServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        int responseStatus = response.getStatus();
        Assert.assertEquals((long)0L, (long)responseStatus);
        String responseText = new String(response.getContent());
        Assert.assertNotNull((Object)responseText);
        Collection assets = repository.listAssets(LOCATION, (Filter)new FilterByExtension(targetType));
        Asset asset = repository.loadAsset(((Asset)assets.iterator().next()).getUniqueId());
        Assert.assertNotNull((Object)asset);
        Assert.assertNotNull((Object)asset.getAssetContent());
    }

    @Test
    public void testTransformToPdf() throws Exception {
        Repository repository = this.createRepository();
        String id = this.createAsset(repository, LOCATION, BP_NAME, BPMN2_FILE_TYPE, BP_CONTENT);
        TransformerServlet transformerServlet = new TransformerServlet();
        transformerServlet.setProfile((IDiagramProfile)this.profile);
        String targetType = "pdf";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fsvg", FORMATTED_SVG_ENCODED);
        params.put("uuid", id);
        params.put("profile", JBPM_PROFILE_NAME);
        params.put("transformto", targetType);
        params.put("processid", BP_NAME);
        TestHttpServletResponse response = new TestHttpServletResponse();
        transformerServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        int responseStatus = response.getStatus();
        Assert.assertEquals((long)0L, (long)responseStatus);
        String responseText = new String(response.getContent());
        Assert.assertNotNull((Object)responseText);
        Collection assets = repository.listAssets(LOCATION, (Filter)new FilterByExtension(targetType));
        Asset asset = repository.loadAsset(((Asset)assets.iterator().next()).getUniqueId());
        Assert.assertNotNull((Object)asset);
        Assert.assertNotNull((Object)asset.getAssetContent());
    }

    @Test
    public void testSharePng() throws Exception {
        Repository repository = this.createRepository();
        String id = this.createAsset(repository, LOCATION, BP_NAME, BPMN2_FILE_TYPE, BP_CONTENT);
        TransformerServlet transformerServlet = new TransformerServlet();
        transformerServlet.setProfile((IDiagramProfile)this.profile);
        String targetType = "png";
        String respAction = "showurl";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fsvg", FORMATTED_SVG_ENCODED);
        params.put("uuid", id);
        params.put("profile", JBPM_PROFILE_NAME);
        params.put("transformto", targetType);
        params.put("respaction", respAction);
        params.put("processid", BP_NAME);
        TestHttpServletResponse response = new TestHttpServletResponse();
        transformerServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        int responseStatus = response.getStatus();
        Assert.assertEquals((long)0L, (long)responseStatus);
        String responseText = new String(response.getContent());
        Assert.assertNotNull((Object)responseText);
        Assert.assertTrue((boolean)responseText.startsWith("<img"));
        Assert.assertTrue((boolean)responseText.endsWith("\">"));
        Assert.assertTrue((responseText.length() > 1000 ? 1 : 0) != 0);
    }

    @Test
    public void testSharePdf() throws Exception {
        Repository repository = this.createRepository();
        String id = this.createAsset(repository, LOCATION, BP_NAME, BPMN2_FILE_TYPE, BP_CONTENT);
        TransformerServlet transformerServlet = new TransformerServlet();
        transformerServlet.setProfile((IDiagramProfile)this.profile);
        String targetType = "pdf";
        String respAction = "showurl";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fsvg", FORMATTED_SVG_ENCODED);
        params.put("uuid", id);
        params.put("profile", JBPM_PROFILE_NAME);
        params.put("transformto", targetType);
        params.put("respaction", respAction);
        params.put("processid", BP_NAME);
        TestHttpServletResponse response = new TestHttpServletResponse();
        transformerServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        int responseStatus = response.getStatus();
        Assert.assertEquals((long)0L, (long)responseStatus);
        String responseText = new String(response.getContent());
        Assert.assertNotNull((Object)responseText);
        Assert.assertTrue((boolean)responseText.startsWith("<object"));
        Assert.assertTrue((boolean)responseText.endsWith("</object>"));
        Assert.assertTrue((responseText.length() > 1000 ? 1 : 0) != 0);
    }

    @Test
    public void testStoreInRepository() throws Exception {
        Repository repository = this.createRepository();
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        ListAppender listAppender = (ListAppender)root.getAppender("listAppender");
        String bpName = "mytestbp1";
        String id = this.createAsset(repository, LOCATION, bpName, BPMN2_FILE_TYPE, BP_CONTENT);
        TransformerServlet transformerServlet = new TransformerServlet();
        transformerServlet.setProfile((IDiagramProfile)this.profile);
        String targetType = "png";
        transformerServlet.storeInRepository(id, FORMATTED_SVG, targetType, bpName, repository);
        Collection assets = repository.listAssets(LOCATION, (Filter)new FilterByExtension(targetType));
        Assert.assertEquals((long)1L, (long)assets.size());
        Asset asset = repository.loadAsset(((Asset)assets.iterator().next()).getUniqueId());
        Assert.assertNotNull((Object)asset);
        Assert.assertNotNull((Object)asset.getAssetContent());
        transformerServlet.storeInRepository(id, FORMATTED_SVG, targetType, bpName, repository);
        List logList = listAppender.list;
        Assert.assertNotNull((Object)logList);
        for (Object oLoggingEvent : logList) {
            LoggingEvent loggingEvent;
            String message;
            if (!(oLoggingEvent instanceof LoggingEvent) || (message = (loggingEvent = (LoggingEvent)oLoggingEvent).getMessage()) == null) continue;
            Assert.assertFalse((message.contains("FileAlreadyExistsException") && message.contains(bpName) ? 1 : 0) != 0);
        }
        assets = repository.listAssets(LOCATION, (Filter)new FilterByExtension(targetType));
        Assert.assertEquals((long)1L, (long)assets.size());
        asset = repository.loadAsset(((Asset)assets.iterator().next()).getUniqueId());
        Assert.assertNotNull((Object)asset);
        Assert.assertNotNull((Object)asset.getAssetContent());
    }
}

