/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.repository;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Directory;
import org.jbpm.designer.repository.Filter;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.VFSFileSystemProducer;
import org.jbpm.designer.repository.filters.FilterByExtension;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.web.profile.impl.JbpmProfileImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.file.NoSuchFileException;

public class VFSRepositoryDefaultFileSystemTest
extends RepositoryBaseTest {
    @Override
    @Before
    public void setup() {
        new File(REPOSITORY_ROOT).mkdir();
        this.profile = new JbpmProfileImpl();
        this.producer = new VFSFileSystemProducer();
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("repository.root", VFS_REPOSITORY_ROOT);
        env.put("repository.globaldir", "/global");
        this.descriptor = this.producer.produceFileSystem(env);
    }

    @Override
    @After
    public void teardown() {
        File repo = new File(REPOSITORY_ROOT);
        if (repo.exists()) {
            this.deleteFiles(repo);
        }
        repo.delete();
    }

    @Test
    public void testCreateDefaultVFSRepository() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/");
        Assert.assertTrue((boolean)rootFolderExists);
        Collection directories = repository.listDirectories("/");
        Assert.assertNotNull((Object)directories);
        Assert.assertEquals((long)0L, (long)directories.size());
    }

    @Test
    public void testCreateDirectory() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/test");
        Assert.assertFalse((boolean)rootFolderExists);
        Directory directoryId = repository.createDirectory("/test");
        Assert.assertNotNull((Object)directoryId);
        Assert.assertEquals((Object)"test", (Object)directoryId.getName());
        Assert.assertEquals((Object)"/", (Object)directoryId.getLocation());
        Assert.assertNotNull((Object)directoryId.getUniqueId());
        rootFolderExists = repository.directoryExists("/test");
        Assert.assertTrue((boolean)rootFolderExists);
    }

    @Test
    public void testDirectoryExists() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/test");
        Assert.assertFalse((boolean)rootFolderExists);
        Directory directoryId = repository.createDirectory("/test");
        Assert.assertNotNull((Object)directoryId);
        Assert.assertEquals((Object)"test", (Object)directoryId.getName());
        Assert.assertEquals((Object)"/", (Object)directoryId.getLocation());
        Assert.assertNotNull((Object)directoryId.getUniqueId());
        rootFolderExists = repository.directoryExists("/test");
        Assert.assertTrue((boolean)rootFolderExists);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        builder.content((Object)"simple content".getBytes()).type("png").name("test").location("/test");
        String id = repository.createAsset(builder.getAsset());
        Assert.assertNotNull((Object)id);
        boolean assetPathShouldNotExists = repository.directoryExists("/test/test.png");
        Assert.assertFalse((boolean)assetPathShouldNotExists);
    }

    @Test
    public void testListDirectories() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/test");
        Assert.assertFalse((boolean)rootFolderExists);
        Directory directoryId = repository.createDirectory("/test");
        Assert.assertNotNull((Object)directoryId);
        directoryId = repository.createDirectory("/test2");
        Assert.assertNotNull((Object)directoryId);
        directoryId = repository.createDirectory("/test3/nested");
        Assert.assertNotNull((Object)directoryId);
        rootFolderExists = repository.directoryExists("/test");
        Assert.assertTrue((boolean)rootFolderExists);
        rootFolderExists = repository.directoryExists("/test2");
        Assert.assertTrue((boolean)rootFolderExists);
        rootFolderExists = repository.directoryExists("/test3");
        Assert.assertTrue((boolean)rootFolderExists);
        Collection directories = repository.listDirectories("/");
        Assert.assertNotNull((Object)directories);
        Assert.assertEquals((long)3L, (long)directories.size());
        directories = repository.listDirectories("/test3");
        Assert.assertNotNull((Object)directories);
        Assert.assertEquals((long)1L, (long)directories.size());
    }

    @Test
    public void testDeleteDirectory() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/test");
        Assert.assertFalse((boolean)rootFolderExists);
        Directory directoryId = repository.createDirectory("/test");
        Assert.assertNotNull((Object)directoryId);
        rootFolderExists = repository.directoryExists("/test");
        Assert.assertTrue((boolean)rootFolderExists);
        boolean deleted = repository.deleteDirectory("/test", true);
        Assert.assertTrue((boolean)deleted);
        rootFolderExists = repository.directoryExists("/test");
        Assert.assertFalse((boolean)rootFolderExists);
    }

    @Test
    public void testDeleteNonEmptyDirectory() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/test");
        Assert.assertFalse((boolean)rootFolderExists);
        Directory directoryId = repository.createDirectory("/test/nested");
        Assert.assertNotNull((Object)directoryId);
        rootFolderExists = repository.directoryExists("/test");
        Assert.assertTrue((boolean)rootFolderExists);
        rootFolderExists = repository.directoryExists("/test/nested");
        Assert.assertTrue((boolean)rootFolderExists);
        boolean deleted = repository.deleteDirectory("/test", false);
        Assert.assertTrue((boolean)deleted);
        rootFolderExists = repository.directoryExists("/test");
        Assert.assertFalse((boolean)rootFolderExists);
    }

    @Test
    public void testListAsset() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/");
        Assert.assertTrue((boolean)rootFolderExists);
        Collection assets = repository.listAssets("/");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)0L, (long)assets.size());
        try {
            new File(REPOSITORY_ROOT + "/" + "test.txt").createNewFile();
            new File(REPOSITORY_ROOT + "/" + "test.png").createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        assets = repository.listAssets("/");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)2L, (long)assets.size());
    }

    @Test
    public void testListSingleTextAsset() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/");
        Assert.assertTrue((boolean)rootFolderExists);
        Collection assets = repository.listAssets("/");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)0L, (long)assets.size());
        try {
            new File(REPOSITORY_ROOT + "/" + "test.txt").createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        assets = repository.listAssets("/");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)1L, (long)assets.size());
        Asset asset = (Asset)assets.iterator().next();
        Assert.assertEquals((Object)"txt", (Object)asset.getAssetType());
        Assert.assertEquals((Object)"test.txt", (Object)asset.getFullName());
        Assert.assertEquals((Object)"test", (Object)asset.getName());
        Assert.assertEquals((Object)"/", (Object)asset.getAssetLocation());
    }

    @Test
    public void testListSingleBinaryAsset() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/");
        Assert.assertTrue((boolean)rootFolderExists);
        Collection assets = repository.listAssets("/");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)0L, (long)assets.size());
        try {
            new File(REPOSITORY_ROOT + "/" + "test.png").createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        assets = repository.listAssets("/");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)1L, (long)assets.size());
        Asset asset = (Asset)assets.iterator().next();
        Assert.assertEquals((Object)"png", (Object)asset.getAssetType());
        Assert.assertEquals((Object)"test.png", (Object)asset.getFullName());
        Assert.assertEquals((Object)"test", (Object)asset.getName());
        Assert.assertEquals((Object)"/", (Object)asset.getAssetLocation());
    }

    @Test
    public void testListNestedSingleTextAsset() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/");
        Assert.assertTrue((boolean)rootFolderExists);
        Directory directoryId = repository.createDirectory("/test/nested");
        Assert.assertNotNull((Object)directoryId);
        Collection assets = repository.listAssets("/test/nested");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)0L, (long)assets.size());
        try {
            new File(REPOSITORY_ROOT + "/test/nested/" + "test.txt").createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        assets = repository.listAssets("/test/nested");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)1L, (long)assets.size());
        Asset asset = (Asset)assets.iterator().next();
        Assert.assertEquals((Object)"txt", (Object)asset.getAssetType());
        Assert.assertEquals((Object)"test", (Object)asset.getName());
        Assert.assertEquals((Object)"test.txt", (Object)asset.getFullName());
        Assert.assertEquals((Object)"/test/nested", (Object)asset.getAssetLocation());
    }

    @Test
    public void testStoreSingleBinaryAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/");
        Assert.assertTrue((boolean)rootFolderExists);
        Collection assets = repository.listAssets("/");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)0L, (long)assets.size());
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        builder.content((Object)"simple content".getBytes()).type("png").name("test").location("/");
        String id = repository.createAsset(builder.getAsset());
        Assert.assertNotNull((Object)id);
        Asset asset = repository.loadAsset(id);
        Assert.assertEquals((Object)"png", (Object)asset.getAssetType());
        Assert.assertEquals((Object)"test", (Object)asset.getName());
        Assert.assertEquals((Object)"test.png", (Object)asset.getFullName());
        Assert.assertEquals((Object)"/", (Object)asset.getAssetLocation());
        Assert.assertFalse((((byte[])asset.getAssetContent()).length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStoreSingleTextAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/");
        Assert.assertTrue((boolean)rootFolderExists);
        Collection assets = repository.listAssets("/");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)0L, (long)assets.size());
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("txt").name("test").location("/");
        String id = repository.createAsset(builder.getAsset());
        Assert.assertNotNull((Object)id);
        Asset asset = repository.loadAsset(id);
        Assert.assertEquals((Object)"txt", (Object)asset.getAssetType());
        Assert.assertEquals((Object)"test", (Object)asset.getName());
        Assert.assertEquals((Object)"test.txt", (Object)asset.getFullName());
        Assert.assertEquals((Object)"/", (Object)asset.getAssetLocation());
        Assert.assertEquals((Object)"simple content", (Object)asset.getAssetContent());
    }

    @Test
    public void testAssetExists() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        boolean rootFolderExists = repository.directoryExists("/");
        Assert.assertTrue((boolean)rootFolderExists);
        Collection assets = repository.listAssets("/");
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)0L, (long)assets.size());
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("txt").name("test").location("/");
        String id = repository.createAsset(builder.getAsset());
        Assert.assertNotNull((Object)id);
        boolean assetExists = repository.assetExists(id);
        Assert.assertTrue((boolean)assetExists);
    }

    @Test
    public void testListAssetsRecursively() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/1/2/3/4/5/6");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssetsRecursively("/", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
    }

    @Test
    public void testUpdateAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        builder.content((Object)"updated content").uniqueId(id);
        id = repository.updateAsset(builder.getAsset(), "", "");
        foundAsset = repository.listAssetsRecursively("/", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        String content = (String)repository.loadAsset(id).getAssetContent();
        Assert.assertNotNull((Object)content);
        Assert.assertEquals((Object)"updated content", (Object)content);
    }

    @Test
    public void testDeleteAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExistsBeforeDelete = repository.assetExists(id);
        Assert.assertTrue((boolean)assetExistsBeforeDelete);
        boolean deleted = repository.deleteAsset(id);
        Assert.assertTrue((boolean)deleted);
        boolean assetExists = repository.assetExists(id);
        Assert.assertFalse((boolean)assetExists);
    }

    @Test
    public void testDeleteAssetFromPath() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExistsBeforeDelete = repository.assetExists(id);
        Assert.assertTrue((boolean)assetExistsBeforeDelete);
        boolean deleted = repository.deleteAssetFromPath("/process.bpmn2");
        Assert.assertTrue((boolean)deleted);
        boolean assetExists = repository.assetExists(id);
        Assert.assertFalse((boolean)assetExists);
    }

    @Test
    public void testCopyAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/source");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExistsBeforeDelete = repository.assetExists(id);
        Assert.assertTrue((boolean)assetExistsBeforeDelete);
        boolean copied = repository.copyAsset(id, "/target");
        Assert.assertTrue((boolean)copied);
        foundAsset = repository.listAssets("/target", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExists = repository.assetExists("/target/process.bpmn2");
        Assert.assertTrue((boolean)assetExists);
    }

    @Test
    public void testMoveAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/source");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean sourceAssetExists = repository.assetExists(id);
        Assert.assertTrue((boolean)sourceAssetExists);
        boolean copied = repository.moveAsset(id, "/target", null);
        Assert.assertTrue((boolean)copied);
        foundAsset = repository.listAssets("/target", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExists = repository.assetExists("/target/process.bpmn2");
        Assert.assertTrue((boolean)assetExists);
        foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)0L, (long)foundAsset.size());
        sourceAssetExists = repository.assetExists(id);
        Assert.assertFalse((boolean)sourceAssetExists);
    }

    @Test
    public void testMoveAndRenameAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/source");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean sourceAssetExists = repository.assetExists(id);
        Assert.assertTrue((boolean)sourceAssetExists);
        boolean copied = repository.moveAsset(id, "/target", "renamed.bpmn2");
        Assert.assertTrue((boolean)copied);
        foundAsset = repository.listAssets("/target", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExists = repository.assetExists("/target/renamed.bpmn2");
        Assert.assertTrue((boolean)assetExists);
        foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)0L, (long)foundAsset.size());
        sourceAssetExists = repository.assetExists(id);
        Assert.assertFalse((boolean)sourceAssetExists);
    }

    @Test
    public void testRenameAsset() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/source");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean sourceAssetExists = repository.assetExists(id);
        Assert.assertTrue((boolean)sourceAssetExists);
        boolean copied = repository.moveAsset(id, "/source", "renamed.bpmn2");
        Assert.assertTrue((boolean)copied);
        foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExists = repository.assetExists("/source/renamed.bpmn2");
        Assert.assertTrue((boolean)assetExists);
        foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        sourceAssetExists = repository.assetExists(id);
        Assert.assertFalse((boolean)sourceAssetExists);
    }

    @Test
    public void testCopyDirectory() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        Directory sourceDir = repository.createDirectory("/source");
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/source");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExistsBeforeDelete = repository.assetExists(id);
        Assert.assertTrue((boolean)assetExistsBeforeDelete);
        boolean copied = repository.copyDirectory("/source", "/target");
        Assert.assertTrue((boolean)copied);
        foundAsset = repository.listAssets("/target/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExists = repository.assetExists("/target/source/process.bpmn2");
        Assert.assertTrue((boolean)assetExists);
        boolean copiedDirectoryExists = repository.directoryExists("/source");
        Assert.assertTrue((boolean)copiedDirectoryExists);
    }

    @Test
    public void testMoveDirectory() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        Directory sourceDir = repository.createDirectory("/source");
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"simple content").type("bpmn2").name("process").location("/source");
        String id = repository.createAsset(builder.getAsset());
        Collection foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExistsBeforeDelete = repository.assetExists(id);
        Assert.assertTrue((boolean)assetExistsBeforeDelete);
        boolean copied = repository.moveDirectory("/source", "/target", null);
        Assert.assertTrue((boolean)copied);
        foundAsset = repository.listAssets("/target/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)1L, (long)foundAsset.size());
        boolean assetExists = repository.assetExists("/target/source/process.bpmn2");
        Assert.assertTrue((boolean)assetExists);
        boolean movedDirectoryExists = repository.directoryExists("/source");
        Assert.assertFalse((boolean)movedDirectoryExists);
    }

    @Test
    public void testMoveEmptyDirectory() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        Directory sourceDir = repository.createDirectory("/source");
        boolean directoryExists = repository.directoryExists(sourceDir.getLocation() + sourceDir.getName());
        Assert.assertTrue((boolean)directoryExists);
        Collection foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)0L, (long)foundAsset.size());
        boolean copied = repository.moveDirectory("/source", "/", "target");
        Assert.assertTrue((boolean)copied);
        boolean movedDirectoryExists = repository.directoryExists("/source");
        Assert.assertFalse((boolean)movedDirectoryExists);
        movedDirectoryExists = repository.directoryExists("/target");
        Assert.assertTrue((boolean)movedDirectoryExists);
        foundAsset = repository.listAssets("/target", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)0L, (long)foundAsset.size());
    }

    @Test
    public void testCopyEmptyDirectory() throws NoSuchFileException {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        Directory sourceDir = repository.createDirectory("/source");
        boolean directoryExists = repository.directoryExists(sourceDir.getLocation() + sourceDir.getName());
        Assert.assertTrue((boolean)directoryExists);
        Collection foundAsset = repository.listAssets("/source", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)0L, (long)foundAsset.size());
        boolean copied = repository.copyDirectory("/source", "/target");
        Assert.assertTrue((boolean)copied);
        boolean movedDirectoryExists = repository.directoryExists("/source");
        Assert.assertTrue((boolean)movedDirectoryExists);
        movedDirectoryExists = repository.directoryExists("/target");
        Assert.assertTrue((boolean)movedDirectoryExists);
        foundAsset = repository.listAssets("/target", (Filter)new FilterByExtension("bpmn2"));
        Assert.assertNotNull((Object)foundAsset);
        Assert.assertEquals((long)0L, (long)foundAsset.size());
    }
}

