/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.expressioneditor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import junit.framework.Assert;
import org.jbpm.designer.expressioneditor.ExpressionEditorMessageMarshallingTest;
import org.jbpm.designer.expressioneditor.model.Condition;
import org.jbpm.designer.expressioneditor.model.ConditionExpression;
import org.jbpm.designer.expressioneditor.parser.ExpressionParser;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionParserTest {
    Logger logger = LoggerFactory.getLogger(ExpressionParserTest.class);

    @Test
    public void testOneScriptPerLine() throws Exception {
        LineNumberReader lineReader = new LineNumberReader(new InputStreamReader(ExpressionEditorMessageMarshallingTest.class.getResourceAsStream("OneScriptPerLine.txt")));
        String line = null;
        ArrayList<ConditionExpression> expectedExpressions = new ArrayList<ConditionExpression>();
        ConditionExpression expression = new ConditionExpression("AND");
        Condition condition = new Condition("between");
        condition.addParam("a");
        condition.addParam("o\"ne");
        condition.addParam("two");
        expression.getConditions().add(condition);
        expectedExpressions.add(expression);
        expression = new ConditionExpression("AND");
        condition = new Condition("isNull");
        condition.addParam("variable1");
        expression.getConditions().add(condition);
        expectedExpressions.add(expression);
        expression = new ConditionExpression("AND");
        condition = new Condition("greaterThan");
        condition.addParam("variable2");
        condition.addParam(" the value ");
        expression.getConditions().add(condition);
        expectedExpressions.add(expression);
        expression = new ConditionExpression("AND");
        condition = new Condition("isNull");
        condition.addParam("a");
        expression.getConditions().add(condition);
        expectedExpressions.add(expression);
        expression = new ConditionExpression("AND");
        condition = new Condition("greaterOrEqualThan");
        condition.addParam("v");
        condition.addParam("one");
        expression.getConditions().add(condition);
        expectedExpressions.add(expression);
        while ((line = lineReader.readLine()) != null) {
            this.logger.debug("line(" + lineReader.getLineNumber() + "): " + line);
            ExpressionParser parser = new ExpressionParser(line);
            ConditionExpression conditionExpression = parser.parse();
            this.assertEqualsExpression((ConditionExpression)expectedExpressions.get(lineReader.getLineNumber() - 1), conditionExpression);
        }
    }

    String readFile(String fileName) throws IOException {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(ExpressionEditorMessageMarshallingTest.class.getResourceAsStream(fileName)));
        StringBuilder result = new StringBuilder();
        String line = null;
        while ((line = ((BufferedReader)reader).readLine()) != null) {
            result.append(line);
            result.append("\n");
        }
        return result.toString();
    }

    @Test
    public void testScript1() throws Exception {
        String script = this.readFile("Script1.txt");
        ConditionExpression expectedExpression = new ConditionExpression("AND");
        Condition expectedCondition = new Condition("greaterOrEqualThan");
        expectedCondition.addParam("variable");
        expectedCondition.addParam("o\\n\u00e1\u00e9\u00f6 great! \"\n   \u00e1\u00e9\u00ed\u00f3\u00fa\u00f1\u00d1 @|#~!\u00b7$%&/()=?\u00bf");
        expectedExpression.getConditions().add(expectedCondition);
        ExpressionParser parser = new ExpressionParser(script);
        ConditionExpression actualExpression = parser.parse();
        System.out.println(actualExpression.getOperator());
        for (Condition condition : actualExpression.getConditions()) {
            System.out.println("condition: " + condition.getFunction());
            for (String param : condition.getParameters()) {
                System.out.println("\"" + param + "\"");
            }
        }
        this.assertEqualsExpression(expectedExpression, actualExpression);
    }

    public void assertEqualsExpression(ConditionExpression expected, ConditionExpression actual) {
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((String)expected.getOperator(), (String)actual.getOperator());
        Assert.assertEquals((int)expected.getConditions().size(), (int)actual.getConditions().size());
        for (int i = 0; i < expected.getConditions().size(); ++i) {
            this.assertEqualsCondition((Condition)expected.getConditions().get(i), (Condition)actual.getConditions().get(i));
        }
    }

    public void assertEqualsCondition(Condition expected, Condition actual) {
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((String)expected.getFunction(), (String)actual.getFunction());
        Assert.assertEquals((int)expected.getParameters().size(), (int)actual.getParameters().size());
        for (int i = 0; i < expected.getParameters().size(); ++i) {
            Assert.assertEquals((String)((String)expected.getParameters().get(i)), (String)((String)actual.getParameters().get(i)));
        }
    }
}

