/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.profile.impl;

import bpsim.impl.BpsimFactoryImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringEscapeUtils;
import org.codehaus.jackson.JsonParseException;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.designer.bpmn2.impl.Bpmn2JsonMarshaller;
import org.jbpm.designer.bpmn2.impl.Bpmn2JsonUnmarshaller;
import org.jbpm.designer.bpmn2.resource.JBPMBpmn2ResourceFactoryImpl;
import org.jbpm.designer.bpmn2.resource.JBPMBpmn2ResourceImpl;
import org.jbpm.designer.notification.DesignerNotificationEvent;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.UriUtils;
import org.jbpm.designer.util.ConfigurationProvider;
import org.jbpm.designer.web.plugin.IDiagramPlugin;
import org.jbpm.designer.web.plugin.impl.PluginServiceImpl;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
public class JbpmProfileImpl
implements IDiagramProfile {
    private static Logger _logger = LoggerFactory.getLogger(JbpmProfileImpl.class);
    private Map<String, IDiagramPlugin> _plugins = new LinkedHashMap<String, IDiagramPlugin>();
    private String _stencilSet;
    private String _localHistoryEnabled;
    private String _localHistoryTimeout;
    private boolean initializeLocalPlugins;
    private String _storeSVGonSaveOption;
    @Inject
    private Repository repository;
    @Inject
    private VFSService vfsServices;
    @Inject
    private Event<DesignerNotificationEvent> notification;
    @Inject
    private User user;

    public JbpmProfileImpl(ServletContext servletContext) {
        this(servletContext, true, false);
    }

    public JbpmProfileImpl() {
        this(null, false, false);
    }

    public JbpmProfileImpl(ServletContext servletContext, boolean initializeLocalPlugins, boolean initializeRepository) {
        if (initializeLocalPlugins) {
            this.initializeLocalPlugins(servletContext);
        }
    }

    @Override
    public String getTitle() {
        return "jBPM Process Designer";
    }

    @Override
    public String getStencilSet() {
        return this._stencilSet;
    }

    @Override
    public Collection<String> getStencilSetExtensions() {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getPlugins() {
        return Collections.unmodifiableCollection(this._plugins.keySet());
    }

    private void initializeLocalPlugins(ServletContext context) {
        Map<String, IDiagramPlugin> registry = PluginServiceImpl.getLocalPluginsRegistry(context);
        FileInputStream fileStream = null;
        try {
            try {
                fileStream = new FileInputStream(context.getRealPath("/") + "/" + ConfigurationProvider.getInstance().getDesignerContext() + "profiles" + "/" + "jbpm.xml");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(fileStream, "UTF-8");
            while (reader.hasNext()) {
                int i;
                if (reader.next() != 1) continue;
                if ("profile".equals(reader.getLocalName())) {
                    for (i = 0; i < reader.getAttributeCount(); ++i) {
                        if (!"stencilset".equals(reader.getAttributeLocalName(i))) continue;
                        this._stencilSet = reader.getAttributeValue(i);
                    }
                    continue;
                }
                if ("plugin".equals(reader.getLocalName())) {
                    String name = null;
                    for (int i2 = 0; i2 < reader.getAttributeCount(); ++i2) {
                        if (!"name".equals(reader.getAttributeLocalName(i2))) continue;
                        name = reader.getAttributeValue(i2);
                    }
                    this._plugins.put(name, registry.get(name));
                    continue;
                }
                if ("localhistory".equals(reader.getLocalName())) {
                    for (i = 0; i < reader.getAttributeCount(); ++i) {
                        if ("enabled".equals(reader.getAttributeLocalName(i))) {
                            String localhistoryenabled = reader.getAttributeValue(i);
                            if (!this.isEmpty(localhistoryenabled)) {
                                this._localHistoryEnabled = localhistoryenabled;
                            } else {
                                _logger.info("Invalid local history enabled");
                            }
                        }
                        if (!"timeout".equals(reader.getAttributeLocalName(i))) continue;
                        String localhistorytimeout = reader.getAttributeValue(i);
                        if (!this.isEmpty(localhistorytimeout)) {
                            this._localHistoryTimeout = localhistorytimeout;
                            continue;
                        }
                        _logger.info("Invalid local history timeout");
                    }
                    continue;
                }
                if (!"storesvgonsave".equals(reader.getLocalName())) continue;
                for (i = 0; i < reader.getAttributeCount(); ++i) {
                    if (!"enabled".equals(reader.getAttributeLocalName(i))) continue;
                    String storesvgonsaveenabled = reader.getAttributeValue(i);
                    if (!this.isEmpty(storesvgonsaveenabled)) {
                        this._storeSVGonSaveOption = storesvgonsaveenabled;
                        continue;
                    }
                    _logger.info("Invalid store svg on save enabled");
                }
            }
        }
        catch (XMLStreamException e) {
            _logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public String getName() {
        return "jbpm";
    }

    @Override
    public String getSerializedModelExtension() {
        return "bpmn";
    }

    @Override
    public String getLocalHistoryEnabled() {
        return this._localHistoryEnabled;
    }

    @Override
    public String getLocalHistoryTimeout() {
        return this._localHistoryTimeout;
    }

    @Override
    public String getStoreSVGonSaveOption() {
        return this._storeSVGonSaveOption;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public void init(ServletContext context) {
        if (!this.initializeLocalPlugins) {
            this.initializeLocalPlugins(context);
            this.initializeLocalPlugins = true;
        }
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    @Override
    public IDiagramProfile.IDiagramMarshaller createMarshaller() {
        return new IDiagramProfile.IDiagramMarshaller(){

            @Override
            public String parseModel(String jsonModel, String preProcessingData) throws Exception {
                DroolsFactoryImpl.init();
                BpsimFactoryImpl.init();
                Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
                JBPMBpmn2ResourceImpl res = (JBPMBpmn2ResourceImpl)unmarshaller.unmarshall(jsonModel, preProcessingData);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                res.save(outputStream, new HashMap());
                return StringEscapeUtils.unescapeHtml4((String)outputStream.toString("UTF-8"));
            }

            @Override
            public Definitions getDefinitions(String jsonModel, String preProcessingData) {
                try {
                    Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
                    JBPMBpmn2ResourceImpl res = (JBPMBpmn2ResourceImpl)unmarshaller.unmarshall(jsonModel, preProcessingData);
                    return (Definitions)res.getContents().get(0);
                }
                catch (JsonParseException e) {
                    return JbpmProfileImpl.this.getDefaultDefinitions();
                }
                catch (IOException e) {
                    return JbpmProfileImpl.this.getDefaultDefinitions();
                }
            }

            @Override
            public Resource getResource(String jsonModel, String preProcessingData) throws Exception {
                Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
                return (JBPMBpmn2ResourceImpl)unmarshaller.unmarshall(jsonModel, preProcessingData);
            }
        };
    }

    @Override
    public IDiagramProfile.IDiagramUnmarshaller createUnmarshaller() {
        return new IDiagramProfile.IDiagramUnmarshaller(){

            @Override
            public String parseModel(String xmlModel, IDiagramProfile profile, String preProcessingData) throws Exception {
                DroolsFactoryImpl.init();
                BpsimFactoryImpl.init();
                Bpmn2JsonMarshaller marshaller = new Bpmn2JsonMarshaller();
                marshaller.setProfile(profile);
                return marshaller.marshall(JbpmProfileImpl.this.getDefinitions(xmlModel), preProcessingData);
            }
        };
    }

    @Override
    public String getRepositoryGlobalDir() {
        return "/global";
    }

    @Override
    public String getRepositoryGlobalDir(String uuid) {
        if (uuid != null) {
            Path uuidPath = this.vfsServices.get(UriUtils.encode(uuid));
            String pathURI = uuidPath.toURI();
            if (pathURI != "/") {
                String[] pathParts = pathURI.split("/");
                try {
                    String pathProjectName = pathParts[3];
                    if (pathProjectName.length() < 1) {
                        return "/global";
                    }
                    return "/" + pathProjectName + "/global";
                }
                catch (Exception e) {
                    return "/global";
                }
            }
            return "/global";
        }
        return "/global";
    }

    public Definitions getDefinitions(String xml) throws Exception {
        try {
            EList warnings;
            DroolsFactoryImpl.init();
            BpsimFactoryImpl.init();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new JBPMBpmn2ResourceFactoryImpl());
            resourceSet.getPackageRegistry().put((Object)"http://www.omg.org/spec/BPMN/20100524/MODEL", (Object)Bpmn2Package.eINSTANCE);
            resourceSet.getPackageRegistry().put((Object)"http://www.jboss.org/drools", (Object)DroolsPackage.eINSTANCE);
            JBPMBpmn2ResourceImpl resource = (JBPMBpmn2ResourceImpl)resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
            resource.getDefaultLoadOptions().put("ENCODING", "UTF-8");
            resource.setEncoding("UTF-8");
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("ENCODING", "UTF-8");
            options.put("DEFER_IDREF_RESOLUTION", true);
            options.put("DISABLE_NOTIFY", true);
            options.put("PROCESS_DANGLING_HREF", "RECORD");
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            resource.load(is, options);
            if (!resource.getErrors().isEmpty()) {
                String errorMessages = "";
                for (Resource.Diagnostic error : resource.getErrors()) {
                    errorMessages = errorMessages + error.getMessage() + "\n";
                }
                this.notification.fire((Object)new DesignerNotificationEvent(errorMessages, NotificationEvent.NotificationType.ERROR, this.user.getIdentifier()));
            }
            if (!resource.getWarnings().isEmpty()) {
                String warningMessages = "";
                for (Resource.Diagnostic warning : resource.getWarnings()) {
                    warningMessages = warningMessages + warning.getMessage() + "\n";
                }
                this.notification.fire((Object)new DesignerNotificationEvent(warningMessages, NotificationEvent.NotificationType.WARNING, this.user.getIdentifier()));
            }
            if ((warnings = resource.getWarnings()) != null && !warnings.isEmpty()) {
                for (Resource.Diagnostic diagnostic : warnings) {
                    _logger.info("Warning: " + diagnostic.getMessage());
                }
            }
            return ((DocumentRoot)resource.getContents().get(0)).getDefinitions();
        }
        catch (Exception e) {
            return this.getDefaultDefinitions();
        }
    }

    @Override
    public String getStencilSetURL() {
        return ConfigurationProvider.getInstance().getDesignerContext() + "stencilsets/bpmn2.0jbpm/bpmn2.0jbpm.json";
    }

    @Override
    public String getStencilSetNamespaceURL() {
        return "http://b3mn.org/stencilset/bpmn2.0#";
    }

    @Override
    public String getStencilSetExtensionURL() {
        return "http://oryx-editor.org/stencilsets/extensions/bpmncosts-2.0#";
    }

    private boolean isEmpty(CharSequence str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    private Definitions getDefaultDefinitions() {
        try {
            String defaultProcessContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<bpmn2:definitions xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.omg.org/bpmn20\" xmlns:bpmn2=\"http://www.omg.org/spec/BPMN/20100524/MODEL\" xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\" xmlns:bpsim=\"http://www.bpsim.org/schemas/1.0\" xmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\" xmlns:drools=\"http://www.jboss.org/drools\" \nid=\"Definition\" xsi:schemaLocation=\"http://www.omg.org/spec/BPMN/20100524/MODEL BPMN20.xsd http://www.jboss.org/drools drools.xsd http://www.bpsim.org/schemas/1.0 bpsim.xsd\" expressionLanguage=\"http://www.mvel.org/2.0\" targetNamespace=\"http://www.omg.org/bpmn20\" typeLanguage=\"http://www.java.com/javaTypes\"> \n   <bpmn2:process id=\"${processid}\" drools:packageName=\"org.jbpm\" drools:version=\"1.0\" name=\"\" isExecutable=\"true\"> \n      <bpmn2:startEvent id=\"processStartEvent\" drools:bgcolor=\"#9acd32\" drools:selectable=\"true\" name=\"\"/> \n   </bpmn2:process> \n   <bpmndi:BPMNDiagram> \n      <bpmndi:BPMNPlane bpmnElement=\"${processid}\"> \n         <bpmndi:BPMNShape bpmnElement=\"processStartEvent\"> \n            <dc:Bounds height=\"30.0\" width=\"30.0\" x=\"120.0\" y=\"165.0\"/> \n         </bpmndi:BPMNShape> \n      </bpmndi:BPMNPlane> \n   </bpmndi:BPMNDiagram> \n</bpmn2:definitions>".replaceAll("\\$\\{processid\\}", "defaultprocessid");
            String errorMessages = "Unable to load process content due to errors. Displaying default process instead. Check logs for error details.";
            this.notification.fire((Object)new DesignerNotificationEvent(errorMessages, NotificationEvent.NotificationType.ERROR, this.user.getIdentifier()));
            return this.getDefinitions(defaultProcessContent);
        }
        catch (Exception e) {
            _logger.error(e.getMessage());
            return null;
        }
    }
}

