/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.repository.vfs;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.jbpm.designer.repository.vfs.RepositoryDescriptor;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class RepositoryDescriptorProvider {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private RepositoryService repositoryService;
    private Map<String, RepositoryDescriptor> knownRepositories = new ConcurrentHashMap<String, RepositoryDescriptor>();

    @PostConstruct
    public void init() {
        Collection active = this.repositoryService.getRepositories();
        if (active != null) {
            for (Repository repo : active) {
                for (String branchName : repo.getBranches()) {
                    this.buildAndRegister(repo, branchName);
                }
            }
        }
    }

    public RepositoryDescriptor getRepositoryDescriptor(String repositoryAlias, String branchName) {
        if (branchName == null) {
            branchName = "master";
        }
        if (this.knownRepositories.containsKey(branchName + "@" + repositoryAlias)) {
            return this.knownRepositories.get(branchName + "@" + repositoryAlias);
        }
        if (this.knownRepositories.size() == 1) {
            return this.knownRepositories.values().iterator().next();
        }
        Repository repository = this.repositoryService.getRepository(repositoryAlias);
        if (repository != null) {
            return this.buildAndRegister(repository, branchName);
        }
        throw new IllegalStateException("Repository with alias " + repositoryAlias + " not found");
    }

    private RepositoryDescriptor buildAndRegister(Repository repository, String branchName) {
        String repoUri = repository.getRoot().toURI().replaceFirst("://.*?@", "://" + branchName + "@");
        URI root = URI.create(repoUri);
        FileSystem fs = this.ioService.getFileSystem(root);
        Path rootPath = fs.provider().getPath(root);
        RepositoryDescriptor descriptor = new RepositoryDescriptor(root, fs, rootPath);
        this.knownRepositories.put(branchName + "@" + repository.getAlias(), descriptor);
        return descriptor;
    }
}

