/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.preprocessing.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.enterprise.event.Event;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.drools.core.process.core.datatype.DataType;
import org.drools.core.process.core.impl.ParameterDefinitionImpl;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.AssetNotFoundException;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.filters.FilterByExtension;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.util.Base64Backport;
import org.jbpm.designer.util.ConfigurationProvider;
import org.jbpm.designer.web.preprocessing.IDiagramPreprocessingUnit;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.process.workitem.WorkDefinitionImpl;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mvel2.MVEL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.ST;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;
import sun.misc.BASE64Encoder;

public class JbpmPreprocessingUnit
implements IDiagramPreprocessingUnit {
    private static final Logger _logger = LoggerFactory.getLogger(JbpmPreprocessingUnit.class);
    public static final String STENCILSET_PATH = "stencilsets";
    public static final String WORKITEM_DEFINITION_EXT = "wid";
    public static final String THEME_NAME = "themes";
    public static final String THEME_EXT = ".json";
    public static final String DEFAULT_THEME_NAME = "jBPM";
    public static final String CUSTOMEDITORS_NAME = "customeditors";
    public static final String PROCESSDICTIONARY_NAME = "processdictionary";
    public static final String CUSTOMEDITORS_EXT = ".json";
    public static final String THEME_COOKIE_NAME = "designercolortheme";
    public static final String DEFAULT_CATEGORY_NAME = "Service Tasks";
    private String designer_path;
    private String stencilPath;
    private String origStencilFilePath;
    private String stencilFilePath;
    private String outData = "";
    private String workitemSVGFilePath;
    private String origWorkitemSVGFile;
    private String default_emailicon;
    private String default_logicon;
    private String default_servicenodeicon;
    private String default_widconfigtemplate;
    private String defaultClasspathWid = "META-INF/WorkDefinitions.wid";
    private String themeInfo;
    private String formWidgetsDir;
    private String customEditorsInfo;
    private String patternsData;
    private String sampleBpmn2;
    private String globalDir;
    private VFSService vfsService;
    private Event<ResourceUpdatedEvent> resourceUpdatedEvent;
    private Event<ResourceAddedEvent> resourceAddedEvent;

    public JbpmPreprocessingUnit(ServletContext servletContext, VFSService vfsService, Event<ResourceUpdatedEvent> resourceUpdatedEvent, Event<ResourceAddedEvent> resourceAddedEvent) {
        this(servletContext, ConfigurationProvider.getInstance().getDesignerContext(), vfsService, resourceUpdatedEvent, resourceAddedEvent);
    }

    public JbpmPreprocessingUnit(ServletContext servletContext, String designerPath, VFSService vfsService, Event<ResourceUpdatedEvent> resourceUpdatedEvent, Event<ResourceAddedEvent> resourceAddedEvent) {
        this.designer_path = designerPath.substring(0, designerPath.length() - 1);
        this.vfsService = vfsService;
        this.resourceAddedEvent = resourceAddedEvent;
        this.resourceUpdatedEvent = resourceUpdatedEvent;
        this.stencilPath = servletContext.getRealPath(this.designer_path + "/" + STENCILSET_PATH);
        this.origStencilFilePath = this.stencilPath + "/bpmn2.0jbpm/stencildata/" + "bpmn2.0jbpm.orig";
        this.stencilFilePath = this.stencilPath + "/bpmn2.0jbpm/" + "bpmn2.0jbpm.json";
        this.workitemSVGFilePath = this.stencilPath + "/bpmn2.0jbpm/view/activity/workitems/";
        this.origWorkitemSVGFile = this.workitemSVGFilePath + "workitem.orig";
        this.default_emailicon = servletContext.getRealPath(this.designer_path + "/defaults/defaultemailicon.gif");
        this.default_logicon = servletContext.getRealPath(this.designer_path + "/defaults/defaultlogicon.gif");
        this.default_servicenodeicon = servletContext.getRealPath(this.designer_path + "/defaults/defaultservicenodeicon.png");
        this.default_widconfigtemplate = servletContext.getRealPath(this.designer_path + "/defaults/WorkDefinitions.wid.st");
        this.themeInfo = servletContext.getRealPath(this.designer_path + "/defaults/themes.json");
        this.formWidgetsDir = servletContext.getRealPath(this.designer_path + "/defaults/formwidgets");
        this.customEditorsInfo = servletContext.getRealPath(this.designer_path + "/defaults/customeditors.json");
        this.patternsData = servletContext.getRealPath(this.designer_path + "/defaults/patterns.json");
        this.sampleBpmn2 = servletContext.getRealPath(this.designer_path + "/defaults/SampleProcess.bpmn2");
    }

    @Override
    public String getOutData() {
        if (this.outData != null && this.outData.length() > 0 && this.outData.endsWith(",")) {
            this.outData = this.outData.substring(0, this.outData.length() - 1);
        }
        return this.outData;
    }

    @Override
    public void preprocess(HttpServletRequest req, HttpServletResponse res, IDiagramProfile profile, ServletContext serlvetContext) {
        Repository repository = profile.getRepository();
        String uuid = req.getParameter("uuid");
        try {
            String processIdString;
            String packageNameStr;
            Asset asset = repository.loadAsset(uuid);
            this.globalDir = profile.getRepositoryGlobalDir(uuid);
            this.outData = "";
            Map<String, ThemeInfo> themeData = this.setupThemes(req, repository, profile);
            this.setupCustomEditors(repository, profile);
            this.setupFormWidgets(repository, profile);
            this.setupDefaultIcons(this.globalDir, repository);
            Collection<Asset> workitemConfigInfo = this.findWorkitemInfoForUUID(asset.getAssetLocation(), repository);
            Collection<Asset> globalWorkitemConfigInfo = this.findWorkitemInfoForUUID(this.globalDir, repository);
            if (workitemConfigInfo != null) {
                if (globalWorkitemConfigInfo != null) {
                    workitemConfigInfo.addAll(globalWorkitemConfigInfo);
                }
            } else {
                workitemConfigInfo = globalWorkitemConfigInfo;
            }
            if (workitemConfigInfo != null) {
                this.setupDefaultWorkitemConfigs(asset.getAssetLocation(), repository);
                workitemConfigInfo = this.findWorkitemInfoForUUID(asset.getAssetLocation(), repository);
            }
            Collection<Asset> workItemsContent = this.getWorkitemConfigContent(workitemConfigInfo, repository);
            HashMap<String, WorkDefinitionImpl> workDefinitions = new HashMap<String, WorkDefinitionImpl>();
            for (Asset asset2 : workItemsContent) {
                try {
                    this.evaluateWorkDefinitions(workDefinitions, asset2, repository, profile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    _logger.error("Unable to parse a workitem definition: " + e.getMessage());
                }
            }
            for (Map.Entry entry : workDefinitions.entrySet()) {
                this.outData = this.outData + ((WorkDefinitionImpl)entry.getValue()).getName() + ",";
            }
            JSONArray patternsArray = new JSONArray(this.readFile(this.patternsData));
            HashMap<String, PatternInfo> hashMap = new HashMap<String, PatternInfo>();
            for (int i = 0; i < patternsArray.length(); ++i) {
                JSONObject patternObj = patternsArray.getJSONObject(i);
                PatternInfo pi = new PatternInfo(patternObj.getString("id"), patternObj.getString("name"), patternObj.getString("description"));
                hashMap.put(patternObj.getString("id"), pi);
            }
            ST workItemTemplate = new ST(this.readFile(this.origStencilFilePath), '$', '$');
            workItemTemplate.add("bopen", (Object)"{");
            workItemTemplate.add("bclose", (Object)"}");
            workItemTemplate.add("workitemDefs", workDefinitions);
            workItemTemplate.add("patternData", hashMap);
            String processPackage = asset.getAssetLocation();
            if (processPackage.startsWith("/")) {
                processPackage = processPackage.substring(1, processPackage.length());
            }
            if ((processPackage = processPackage.replaceAll("/", ".")).startsWith(".")) {
                processPackage = processPackage.substring(1, processPackage.length());
            }
            workItemTemplate.add("packageName", (Object)"org.jbpm");
            String processName = asset.getName();
            workItemTemplate.add("processn", (Object)processName);
            String string = packageNameStr = processPackage.length() > 0 ? processPackage + "." : "";
            if (packageNameStr.length() > 0) {
                String[] packageNameParts = packageNameStr.split("\\.");
                packageNameStr = packageNameParts[0] + ".";
            }
            if ((processIdString = packageNameStr + processName).startsWith(".")) {
                // empty if block
            }
            if (processIdString.startsWith(".")) {
                processIdString = processIdString.substring(1, processIdString.length());
            }
            workItemTemplate.add("processid", (Object)processIdString);
            workItemTemplate.add("pversion", (Object)"1.0");
            workItemTemplate.add("colortheme", themeData);
            this.deletefile(this.stencilFilePath);
            this.createAndWriteToFile(this.stencilFilePath, workItemTemplate.render());
            this.createAndParseViewSVG(workDefinitions, repository);
        }
        catch (Exception e) {
            _logger.error("Failed to setup workitems : " + e.getMessage());
        }
    }

    private void createAndParseViewSVG(Map<String, WorkDefinitionImpl> workDefinitions, Repository repository) {
        Collection workitemsvgs = FileUtils.listFiles((File)new File(this.workitemSVGFilePath), (String[])new String[]{"svg"}, (boolean)true);
        if (workitemsvgs != null) {
            for (File file : workitemsvgs) {
                this.deletefile(file);
            }
        }
        try {
            for (Map.Entry entry : workDefinitions.entrySet()) {
                ST workItemTemplate = new ST(this.readFile(this.origWorkitemSVGFile), '$', '$');
                workItemTemplate.add("workitemDef", entry.getValue());
                String widIcon = ((WorkDefinitionImpl)entry.getValue()).getIcon();
                Asset iconAsset = repository.loadAssetFromPath(widIcon);
                BASE64Encoder enc = new BASE64Encoder();
                String iconEncoded = "data:image/png;base64," + enc.encode((byte[])iconAsset.getAssetContent());
                workItemTemplate.add("nodeicon", (Object)iconEncoded);
                String fileToWrite = this.workitemSVGFilePath + ((WorkDefinitionImpl)entry.getValue()).getName() + ".svg";
                this.createAndWriteToFile(fileToWrite, workItemTemplate.render());
            }
        }
        catch (Exception e) {
            _logger.error("Failed to setup workitem svg images : " + e.getMessage());
        }
    }

    private void evaluateWorkDefinitions(Map<String, WorkDefinitionImpl> workDefinitions, Asset<String> widAsset, Repository repository, IDiagramProfile profile) throws Exception {
        List workDefinitionsMaps;
        try {
            workDefinitionsMaps = (List)MVEL.eval((String)widAsset.getAssetContent(), new HashMap());
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        for (Map workDefinitionMap : workDefinitionsMaps) {
            if (workDefinitionMap == null) continue;
            WorkDefinitionImpl workDefinition = new WorkDefinitionImpl();
            workDefinition.setName(((String)workDefinitionMap.get("name")).replaceAll("\\s", ""));
            workDefinition.setDisplayName((String)workDefinitionMap.get("displayName"));
            String category = (String)workDefinitionMap.get("category");
            if (category == null || category.length() < 1) {
                category = DEFAULT_CATEGORY_NAME;
            }
            workDefinition.setCategory(category);
            String icon = (String)workDefinitionMap.get("icon");
            Asset iconAsset = null;
            if (!icon.startsWith(this.globalDir)) {
                icon = icon.startsWith("/") ? this.globalDir + icon : this.globalDir + "/" + icon;
            }
            try {
                if (!repository.assetExists(icon)) {
                    icon = this.globalDir + "/defaultservicenodeicon.png";
                }
            }
            catch (Exception e) {
                _logger.error(e.getMessage());
                icon = this.globalDir + "/defaultservicenodeicon.png";
            }
            iconAsset = repository.loadAssetFromPath(icon);
            workDefinition.setIcon(icon);
            BASE64Encoder enc = new BASE64Encoder();
            String iconEncoded = "data:image/png;base64," + enc.encode((byte[])iconAsset.getAssetContent());
            workDefinition.setIconEncoded(URLEncoder.encode(iconEncoded, "UTF-8"));
            workDefinition.setCustomEditor((String)workDefinitionMap.get("customEditor"));
            HashSet<ParameterDefinitionImpl> parameters = new HashSet<ParameterDefinitionImpl>();
            if (workDefinitionMap.get("parameters") != null) {
                Map parameterMap = (Map)workDefinitionMap.get("parameters");
                if (parameterMap != null) {
                    for (Map.Entry entry : parameterMap.entrySet()) {
                        parameters.add(new ParameterDefinitionImpl((String)entry.getKey(), (DataType)entry.getValue()));
                    }
                }
                workDefinition.setParameters(parameters);
            }
            if (workDefinitionMap.get("results") != null) {
                HashSet<ParameterDefinitionImpl> results = new HashSet<ParameterDefinitionImpl>();
                Map resultMap = (Map)workDefinitionMap.get("results");
                if (resultMap != null) {
                    for (Map.Entry entry : resultMap.entrySet()) {
                        results.add(new ParameterDefinitionImpl((String)entry.getKey(), (DataType)entry.getValue()));
                    }
                }
                workDefinition.setResults(results);
            }
            if (workDefinitionMap.get("defaultHandler") != null) {
                workDefinition.setDefaultHandler((String)workDefinitionMap.get("defaultHandler"));
            }
            if (workDefinitionMap.get("dependencies") != null) {
                workDefinition.setDependencies(((List)workDefinitionMap.get("dependencies")).toArray(new String[0]));
            }
            workDefinitions.put(workDefinition.getName(), workDefinition);
        }
    }

    private Collection<Asset> getWorkitemConfigContent(Collection<Asset> widAssets, Repository repository) {
        ArrayList<Asset> loadedAssets = new ArrayList<Asset>();
        for (Asset widAsset : widAssets) {
            try {
                Asset assetWithContent = repository.loadAsset(widAsset.getUniqueId());
                loadedAssets.add(assetWithContent);
            }
            catch (AssetNotFoundException e) {
                _logger.error("Asset " + widAsset.getName() + " not found");
            }
        }
        return loadedAssets;
    }

    private void setupFormWidgets(Repository repository, IDiagramProfile profile) {
        File[] allFormWidgets;
        for (File formWidget : allFormWidgets = new File(this.formWidgetsDir).listFiles()) {
            try {
                int extPosition = formWidget.getName().lastIndexOf(".");
                String extension = formWidget.getName().substring(extPosition + 1);
                String name = formWidget.getName().substring(0, extPosition);
                this.createAssetIfNotExisting(repository, this.globalDir, name, extension, JbpmPreprocessingUnit.getBytesFromFile(formWidget));
            }
            catch (Exception e) {
                _logger.error("Error setting up form widgets: " + e.getMessage());
            }
        }
    }

    private void setupCustomEditors(Repository repository, IDiagramProfile profile) {
        try {
            this.createAssetIfNotExisting(repository, this.globalDir, CUSTOMEDITORS_NAME, "json", JbpmPreprocessingUnit.getBytesFromFile(new File(this.customEditorsInfo)));
        }
        catch (Exception e) {
            _logger.error(e.getMessage());
        }
    }

    private Map<String, ThemeInfo> setupThemes(HttpServletRequest req, Repository repository, IDiagramProfile profile) {
        HashMap<String, ThemeInfo> themeData = new HashMap<String, ThemeInfo>();
        Asset themeAsset = null;
        try {
            boolean themeExists = repository.assetExists(this.globalDir + "/" + THEME_NAME + ".json");
            if (!themeExists) {
                AssetBuilder assetBuilder = AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Text);
                assetBuilder.content(new String(JbpmPreprocessingUnit.getBytesFromFile(new File(this.themeInfo)), "UTF-8")).location(this.globalDir).name(THEME_NAME).type("json").version("1.0");
                themeAsset = assetBuilder.getAsset();
                repository.createAsset(themeAsset);
            } else {
                themeAsset = repository.loadAssetFromPath(this.globalDir + "/" + THEME_NAME + ".json");
            }
            String themesStr = (String)themeAsset.getAssetContent();
            JSONObject themesObject = new JSONObject(themesStr);
            String themeName = DEFAULT_THEME_NAME;
            Cookie[] cookies = req.getCookies();
            if (cookies != null) {
                for (Cookie ck : cookies) {
                    if (!ck.getName().equals(THEME_COOKIE_NAME)) continue;
                    themeName = ck.getValue();
                }
            }
            JSONObject themes = (JSONObject)themesObject.get(THEME_NAME);
            JSONObject selectedTheme = (JSONObject)themes.get(themeName);
            for (String key : JSONObject.getNames((JSONObject)selectedTheme)) {
                String val = (String)selectedTheme.get(key);
                String[] valParts = val.split("\\|\\s*");
                ThemeInfo ti = valParts.length == 3 ? new ThemeInfo(valParts[0], valParts[1], valParts[2]) : new ThemeInfo("#000000", "#000000", "#000000");
                themeData.put(key, ti);
            }
            return themeData;
        }
        catch (Exception e) {
            e.printStackTrace();
            _logger.error(e.getMessage());
            return themeData;
        }
    }

    private void setupDefaultIcons(String location, Repository repository) {
        try {
            this.createAssetIfNotExisting(repository, location, "defaultemailicon", "gif", JbpmPreprocessingUnit.getBytesFromFile(new File(this.default_emailicon)));
            this.createAssetIfNotExisting(repository, location, "defaultlogicon", "gif", JbpmPreprocessingUnit.getBytesFromFile(new File(this.default_logicon)));
            this.createAssetIfNotExisting(repository, location, "defaultservicenodeicon", "png", JbpmPreprocessingUnit.getBytesFromFile(new File(this.default_servicenodeicon)));
        }
        catch (Exception e) {
            _logger.error(e.getMessage());
        }
    }

    private void setupDefaultWorkitemConfigs(String location, Repository repository) {
        try {
            String createdUUID;
            InputStream widIn = this.getClass().getClassLoader().getResourceAsStream(this.defaultClasspathWid);
            if (widIn != null) {
                createdUUID = this.createAssetIfNotExisting(repository, location, "WorkDefinitions", WORKITEM_DEFINITION_EXT, IOUtils.toByteArray((InputStream)widIn));
            } else {
                ST widConfigTemplate = new ST(this.readFile(this.default_widconfigtemplate), '$', '$');
                createdUUID = this.createAssetIfNotExisting(repository, location, "WorkDefinitions", WORKITEM_DEFINITION_EXT, widConfigTemplate.render().getBytes("UTF-8"));
            }
            if (Base64Backport.isBase64(createdUUID)) {
                byte[] decoded = Base64.decodeBase64((String)createdUUID);
                try {
                    createdUUID = new String(decoded, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            if (this.vfsService != null && createdUUID != null) {
                Path newWidAssetPath = this.vfsService.get(createdUUID);
                this.resourceAddedEvent.fire((Object)new ResourceAddedEvent(newWidAssetPath));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Collection<Asset> findWorkitemInfoForUUID(String location, Repository repository) {
        Collection<Asset> widAssets = repository.listAssets(location, new FilterByExtension(WORKITEM_DEFINITION_EXT));
        return widAssets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String pathname) throws IOException {
        StringBuilder fileContents = new StringBuilder();
        Scanner scanner = new Scanner(new File(pathname), "UTF-8");
        String lineSeparator = System.getProperty("line.separator");
        try {
            while (scanner.hasNextLine()) {
                fileContents.append(scanner.nextLine() + lineSeparator);
            }
            String string = fileContents.toString();
            return string;
        }
        finally {
            scanner.close();
        }
    }

    private void deletefile(String file) {
        File f = new File(file);
        boolean success = f.delete();
        if (!success) {
            _logger.info("Unable to delete file :" + file);
        } else {
            _logger.info("Successfully deleted file :" + file);
        }
    }

    private void deletefile(File f) {
        String fname = f.getAbsolutePath();
        boolean success = f.delete();
        if (!success) {
            _logger.info("Unable to delete file :" + fname);
        } else {
            _logger.info("Successfully deleted file :" + fname);
        }
    }

    private void createAndWriteToFile(String file, String content) throws Exception {
        BufferedWriter output = null;
        output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        output.write(content);
        ((Writer)output).close();
        _logger.info("Created file:" + file);
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = null;
        is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            ((InputStream)is).close();
            return null;
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            ((InputStream)is).close();
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    private String createAssetIfNotExisting(Repository repository, String location, String name, String type, byte[] content) {
        try {
            boolean assetExists = repository.assetExists(location + "/" + name + "." + type);
            if (!assetExists) {
                AssetBuilder assetBuilder = AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Byte);
                assetBuilder.content(content).location(location).name(name).type(type).version("1.0");
                Asset customEditorsAsset = assetBuilder.getAsset();
                return repository.createAsset(customEditorsAsset);
            }
        }
        catch (Exception e) {
            _logger.error(e.getMessage());
        }
        return null;
    }

    private class PatternInfo {
        private String id;
        private String name;
        private String description;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public PatternInfo(String id, String name, String description) {
            this.id = id;
            this.name = name;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    private class ThemeInfo {
        private String bgColor;
        private String borderColor;
        private String fontColor;

        public ThemeInfo(String bgColor, String borderColor, String fontColor) {
            this.bgColor = bgColor;
            this.borderColor = borderColor;
            this.fontColor = fontColor;
        }

        public String getBgColor() {
            return this.bgColor;
        }

        public void setBgColor(String bgColor) {
            this.bgColor = bgColor;
        }

        public String getBorderColor() {
            return this.borderColor;
        }

        public void setBorderColor(String borderColor) {
            this.borderColor = borderColor;
        }

        public String getFontColor() {
            return this.fontColor;
        }

        public void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }
    }
}

