/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.designer.web.profile.impl.RepositoryInfo;
import org.jbpm.designer.web.server.ServletUtil;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDiffServiceServlet
extends HttpServlet {
    private static final Logger _logger = LoggerFactory.getLogger(ProcessDiffServiceServlet.class);
    @Inject
    private IDiagramProfileService _profileService = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uuid = req.getParameter("uuid");
        String profileName = req.getParameter("profile");
        String action = req.getParameter("action");
        String versionNum = req.getParameter("version");
        IDiagramProfile profile = this._profileService.findProfile(req, profileName);
        String[] packageAssetInfo = ServletUtil.findPackageAndAssetInfo(uuid, profile);
        String packageName = packageAssetInfo[0];
        String assetName = packageAssetInfo[1];
        if (action != null && action.equals("getversion") && versionNum != null) {
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("text/xml");
            try {
                resp.getWriter().write(this.getAssetVerionSource(packageName, assetName, versionNum, profile));
            }
            catch (Throwable t) {
                resp.getWriter().write("");
            }
        } else {
            List<Object> versionList;
            try {
                versionList = this.getAssetVersions(packageName, assetName, uuid, profile);
            }
            catch (Throwable t) {
                versionList = new ArrayList();
            }
            JSONObject jsonObject = new JSONObject();
            if (versionList != null && versionList.size() > 0) {
                for (String string : versionList) {
                    try {
                        jsonObject.put(string, (Object)string);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/json");
            resp.getWriter().write(jsonObject.toString());
        }
    }

    private String getAssetVerionSource(String packageName, String assetName, String versionNum, IDiagramProfile profile) {
        try {
            String versionURL = RepositoryInfo.getRepositoryProtocol(profile) + "://" + RepositoryInfo.getRepositoryHost(profile) + "/" + RepositoryInfo.getRepositorySubdomain(profile).substring(0, RepositoryInfo.getRepositorySubdomain(profile).indexOf("/")) + "/rest/packages/" + URLEncoder.encode(packageName, "UTF-8") + "/assets/" + assetName + "/versions/" + versionNum + "/source/";
            return IOUtils.toString((InputStream)ServletUtil.getInputStreamForURL(versionURL, "GET", profile), (String)"UTF-8");
        }
        catch (Exception e) {
            return "";
        }
    }

    private List<String> getAssetVersions(String packageName, String assetName, String uuid, IDiagramProfile profile) {
        try {
            String assetVersionURL = RepositoryInfo.getRepositoryProtocol(profile) + "://" + RepositoryInfo.getRepositoryHost(profile) + "/" + RepositoryInfo.getRepositorySubdomain(profile).substring(0, RepositoryInfo.getRepositorySubdomain(profile).indexOf("/")) + "/rest/packages/" + URLEncoder.encode(packageName, "UTF-8") + "/assets/" + assetName + "/versions/";
            ArrayList<String> versionList = new ArrayList<String>();
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(ServletUtil.getInputStreamForURL(assetVersionURL, "GET", profile), "UTF-8");
            boolean isFirstTitle = true;
            String title = "";
            while (reader.hasNext()) {
                int next = reader.next();
                if (next != 1 || !"title".equals(reader.getLocalName())) continue;
                if (isFirstTitle) {
                    isFirstTitle = false;
                    continue;
                }
                versionList.add(reader.getElementText());
            }
            return versionList;
        }
        catch (Exception e) {
            _logger.error(e.getMessage());
            return null;
        }
    }
}

