/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.drools.core.util.ConfFileUtils;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.process.workitem.WorkDefinitionImpl;
import org.jbpm.process.workitem.WorkItemRepository;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JbpmServiceRepositoryServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = LoggerFactory.getLogger(JbpmServiceRepositoryServlet.class);
    private static final String displayRepoContent = "display";
    private static final String installRepoContent = "install";
    private IDiagramProfile profile;
    @Inject
    private IDiagramProfileService _profileService = null;

    public void setProfile(IDiagramProfile profile) {
        this.profile = profile;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uuid = req.getParameter("uuid");
        String profileName = req.getParameter("profile");
        String action = req.getParameter("action");
        String assetsToInstall = req.getParameter("asset");
        String categoryToInstall = req.getParameter("category");
        String repoURL = req.getParameter("repourl");
        if (repoURL == null || repoURL.length() < 1) {
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/json");
            resp.getWriter().write("false");
            return;
        }
        try {
            URL url = new URL(repoURL);
            if (!repoURL.startsWith("file:")) {
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setReadTimeout(5000);
                conn.setConnectTimeout(5000);
                conn.connect();
                if (conn.getResponseCode() != 200) {
                    resp.setCharacterEncoding("UTF-8");
                    resp.setContentType("application/json");
                    resp.getWriter().write("false");
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/json");
            resp.getWriter().write("false");
            return;
        }
        if (repoURL.endsWith("/")) {
            repoURL = repoURL.substring(0, repoURL.length() - 1);
        }
        if (this.profile == null) {
            this.profile = this._profileService.findProfile(req, profileName);
        }
        Repository repository = this.profile.getRepository();
        Map workitemsFromRepo = WorkItemRepository.getWorkDefinitions((String)repoURL);
        if (action != null && action.equalsIgnoreCase(displayRepoContent)) {
            if (workitemsFromRepo != null && workitemsFromRepo.size() > 0) {
                HashMap retMap = new HashMap();
                for (String key : workitemsFromRepo.keySet()) {
                    WorkDefinitionImpl wd = (WorkDefinitionImpl)workitemsFromRepo.get(key);
                    ArrayList<String> keyList = new ArrayList<String>();
                    keyList.add(wd.getName() == null ? "" : wd.getName());
                    keyList.add(wd.getDisplayName() == null ? "" : wd.getDisplayName());
                    keyList.add(repoURL + "/" + wd.getName() + "/" + wd.getIcon());
                    keyList.add(wd.getCategory() == null ? "" : wd.getCategory());
                    keyList.add(wd.getExplanationText() == null ? "" : wd.getExplanationText());
                    keyList.add(repoURL + "/" + wd.getName() + "/" + wd.getDocumentation());
                    StringBuffer bn = new StringBuffer();
                    if (wd.getParameterNames() != null) {
                        String delim = "";
                        for (String name : wd.getParameterNames()) {
                            bn.append(delim).append(name);
                            delim = ",";
                        }
                    }
                    keyList.add(bn.toString());
                    StringBuffer br = new StringBuffer();
                    if (wd.getResultNames() != null) {
                        String delim = "";
                        for (String resName : wd.getResultNames()) {
                            br.append(delim).append(resName);
                            delim = ",";
                        }
                    }
                    keyList.add(br.toString());
                    retMap.put(key, keyList);
                }
                JSONObject jsonObject = new JSONObject();
                for (Map.Entry retMapKey : retMap.entrySet()) {
                    try {
                        jsonObject.put((String)retMapKey.getKey(), (Collection)retMapKey.getValue());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType("application/json");
                resp.getWriter().write(jsonObject.toString());
                return;
            }
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/json");
            resp.getWriter().write("false");
            return;
        }
        if (action == null || !action.equalsIgnoreCase(installRepoContent)) return;
        resp.setCharacterEncoding("UTF-8");
        resp.setContentType("application/json");
        if (workitemsFromRepo != null && workitemsFromRepo.size() > 0) {
            boolean gotPackage = false;
            String pkg = "";
            for (String key : workitemsFromRepo.keySet()) {
                if (!key.equals(assetsToInstall) || !categoryToInstall.equals(((WorkDefinitionImpl)workitemsFromRepo.get(key)).getCategory())) continue;
                String workitemDefinitionURL = ((WorkDefinitionImpl)workitemsFromRepo.get(key)).getPath() + "/" + ((WorkDefinitionImpl)workitemsFromRepo.get(key)).getName() + ".wid";
                String iconFileURL = ((WorkDefinitionImpl)workitemsFromRepo.get(key)).getPath() + "/" + ((WorkDefinitionImpl)workitemsFromRepo.get(key)).getIcon();
                String workItemDefinitionContent = ConfFileUtils.URLContentsToString((URL)new URL(workitemDefinitionURL));
                String iconName = ((WorkDefinitionImpl)workitemsFromRepo.get(key)).getIcon();
                String widName = ((WorkDefinitionImpl)workitemsFromRepo.get(key)).getName();
                byte[] iconContent = null;
                try {
                    iconContent = this.getImageBytes(new URL(iconFileURL).openStream());
                }
                catch (Exception e1) {
                    _logger.error("Could not read icon image: " + e1.getMessage());
                }
                repository.deleteAsset(this.profile.getRepositoryGlobalDir(uuid) + "/" + widName + ".wid");
                AssetBuilder widAssetBuilder = AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Text);
                widAssetBuilder.name(widName).location(this.profile.getRepositoryGlobalDir(uuid)).type("wid").content(workItemDefinitionContent);
                repository.createAsset(widAssetBuilder.getAsset());
                AssetBuilder iconAssetBuilder = AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Byte);
                String iconExtension = iconName.substring(iconName.lastIndexOf(".") + 1);
                String iconFileName = iconName.substring(0, iconName.lastIndexOf("."));
                repository.deleteAsset(this.profile.getRepositoryGlobalDir(uuid) + "/" + iconFileName + "." + iconExtension);
                iconAssetBuilder.name(iconFileName).location(this.profile.getRepositoryGlobalDir(uuid)).type(iconExtension).content(iconContent);
                repository.createAsset(iconAssetBuilder.getAsset());
            }
            return;
        }
        _logger.error("Invalid or empty service repository.");
        resp.setCharacterEncoding("UTF-8");
        resp.setContentType("application/json");
        resp.getWriter().write("false");
    }

    private byte[] getImageBytes(InputStream is) throws Exception {
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            throw new Exception("Error creating image byte array.");
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

