/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server.menu.connector;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.AssetNotFoundException;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.designer.web.server.menu.connector.commands.MakeDirCommand;
import org.jbpm.designer.web.server.menu.connector.commands.MakeFileCommand;
import org.jbpm.designer.web.server.menu.connector.commands.OpenCommand;
import org.jbpm.designer.web.server.menu.connector.commands.PasteCommand;
import org.jbpm.designer.web.server.menu.connector.commands.RemoveAssetCommand;
import org.jbpm.designer.web.server.menu.connector.commands.RenameCommand;
import org.jbpm.designer.web.server.menu.connector.commands.UploadCommand;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractConnectorServlet
extends HttpServlet {
    private static Logger logger = Logger.getLogger(AbstractConnectorServlet.class);
    private Map<String, Object> requestParams;
    private List<FileItemStream> listFiles;
    private List<ByteArrayOutputStream> listFileStreams;
    private boolean initialized = false;
    @Inject
    private IDiagramProfileService _profileService = null;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void initializeDefaultRepo(IDiagramProfile profile, Repository repository, HttpServletRequest request) throws Exception {
        String sampleBpmn2 = this.getServletContext().getRealPath("/defaults/SampleProcess.bpmn2");
        this.createAssetIfNotExisting(repository, "/defaultPackage", "BPMN2-SampleProcess", "bpmn2", AbstractConnectorServlet.getBytesFromFile(new File(sampleBpmn2)));
        if (profile.getRepositoryGlobalDir() != null) {
            this.createDirectoryIfNotExist(repository, profile.getRepositoryGlobalDir());
        }
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) {
        block18: {
            this.parseRequest(request, response);
            IDiagramProfile profile = this._profileService.findProfile(request, "jbpm");
            Repository repository = profile.getRepository();
            if (!this.initialized) {
                try {
                    this.initializeDefaultRepo(profile, repository, request);
                    this.initialized = true;
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to initialize repository: " + e.getMessage()));
                }
            }
            JSONObject returnJson = new JSONObject();
            try {
                for (String key : this.requestParams.keySet()) {
                }
                String cmd = (String)this.requestParams.get("cmd");
                if (cmd != null && cmd.equals("open")) {
                    OpenCommand command = new OpenCommand();
                    command.init(request, response, profile, repository, this.requestParams);
                    AbstractConnectorServlet.output(response, false, command.execute());
                    break block18;
                }
                if (cmd != null && cmd.equals("mkdir")) {
                    MakeDirCommand command = new MakeDirCommand();
                    command.init(request, response, profile, repository, this.requestParams);
                    AbstractConnectorServlet.output(response, false, command.execute());
                    break block18;
                }
                if (cmd != null && cmd.equals("mkfile")) {
                    MakeFileCommand command = new MakeFileCommand();
                    command.init(request, response, profile, repository, this.requestParams);
                    AbstractConnectorServlet.output(response, false, command.execute());
                    break block18;
                }
                if (cmd != null && cmd.equals("rm")) {
                    RemoveAssetCommand command = new RemoveAssetCommand();
                    command.init(request, response, profile, repository, this.requestParams);
                    AbstractConnectorServlet.output(response, false, command.execute());
                    break block18;
                }
                if (cmd != null && cmd.equals("rename")) {
                    RenameCommand command = new RenameCommand();
                    command.init(request, response, profile, repository, this.requestParams);
                    AbstractConnectorServlet.output(response, false, command.execute());
                    break block18;
                }
                if (cmd != null && cmd.equals("paste")) {
                    PasteCommand command = new PasteCommand();
                    command.init(request, response, profile, repository, this.requestParams);
                    AbstractConnectorServlet.output(response, false, command.execute());
                    break block18;
                }
                if (cmd != null && cmd.equals("upload")) {
                    UploadCommand command = new UploadCommand();
                    command.init(request, response, profile, repository, this.requestParams, this.listFiles, this.listFileStreams);
                    AbstractConnectorServlet.output(response, false, command.execute());
                    break block18;
                }
                if (cmd == null || !cmd.equals("getsvg")) break block18;
                try {
                    Asset asset = profile.getRepository().loadAssetFromPath((String)this.requestParams.get("current"));
                    if (asset != null && asset.getAssetContent() != null) {
                        AbstractConnectorServlet.outputPlain(response, false, (String)asset.getAssetContent(), "image/svg+xml");
                        break block18;
                    }
                    AbstractConnectorServlet.outputPlain(response, true, "<p><b>Process image not available.</p><p>You can generate the process image in the process editor.</b></p>", null);
                }
                catch (AssetNotFoundException e) {
                    logger.warn((Object)("Error loading process image: " + e.getMessage()));
                    AbstractConnectorServlet.outputPlain(response, true, "<p><b>Could not find process image.</p><p>You can generate the process image in the process editor.</b></p>", null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)e.getMessage());
                this.putResponse(returnJson, "error", e.getMessage());
                try {
                    AbstractConnectorServlet.output(response, false, returnJson);
                }
                catch (Exception ee) {
                    logger.error((Object)"", (Throwable)ee);
                }
            }
        }
    }

    protected static void output(HttpServletResponse response, boolean isResponseTextHtml, JSONObject json) {
        if (isResponseTextHtml) {
            response.setContentType("text/html; charset=UTF-8");
        } else {
            response.setContentType("application/json; charset=UTF-8");
        }
        try {
            json.write((Writer)response.getWriter());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public static void outputPlain(HttpServletResponse response, boolean isResponseTextHtml, String txt, String ctype) {
        if (isResponseTextHtml) {
            response.setContentType("text/html; charset=UTF-8");
        } else if (ctype != null) {
            response.setContentType(ctype + "; charset=UTF-8");
        } else {
            response.setContentType("text/plain; charset=UTF-8");
        }
        try {
            PrintWriter out = response.getWriter();
            out.print(txt);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected void parseRequest(HttpServletRequest request, HttpServletResponse response) {
        this.requestParams = new HashMap<String, Object>();
        this.listFiles = new ArrayList<FileItemStream>();
        this.listFileStreams = new ArrayList<ByteArrayOutputStream>();
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iter = upload.getItemIterator(request);
                while (iter.hasNext()) {
                    FileItemStream item = iter.next();
                    String name = item.getFieldName();
                    InputStream stream = item.openStream();
                    if (item.isFormField()) {
                        this.requestParams.put(name, Streams.asString((InputStream)stream));
                        continue;
                    }
                    String fileName = item.getName();
                    if (fileName == null || "".equals(fileName.trim())) continue;
                    this.listFiles.add(item);
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)stream, (OutputStream)os);
                    this.listFileStreams.add(os);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Unexpected error parsing multipart content", (Throwable)e);
            }
        } else {
            for (Object mapKey : request.getParameterMap().keySet()) {
                String mapKeyString = (String)mapKey;
                if (mapKeyString.endsWith("[]")) {
                    String[] values = request.getParameterValues(mapKeyString);
                    ArrayList<String> listeValues = new ArrayList<String>();
                    for (String value : values) {
                        listeValues.add(value);
                    }
                    this.requestParams.put(mapKeyString, listeValues);
                    continue;
                }
                String value = request.getParameter(mapKeyString);
                this.requestParams.put(mapKeyString, value);
            }
        }
    }

    protected void putResponse(JSONObject json, String param, Object value) {
        try {
            json.put(param, value);
        }
        catch (JSONException e) {
            logger.error((Object)"json write error", (Throwable)e);
        }
    }

    private void createDirectoryIfNotExist(Repository repository, String location) throws Exception {
        if (!repository.directoryExists(location)) {
            repository.createDirectory(location);
        }
    }

    private String createAssetIfNotExisting(Repository repository, String location, String name, String type, byte[] content) {
        try {
            boolean assetExists = repository.assetExists(location + "/" + name + "." + type);
            if (!assetExists) {
                AssetBuilder assetBuilder = AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Byte);
                assetBuilder.content(content).location(location).name(name).type(type).version("1.0");
                Asset customEditorsAsset = assetBuilder.getAsset();
                return repository.createAsset(customEditorsAsset);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = null;
        is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            ((InputStream)is).close();
            return null;
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            ((InputStream)is).close();
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }
}

