/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.repository.vfs;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.codec.binary.Base64;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.AssetNotFoundException;
import org.jbpm.designer.repository.Directory;
import org.jbpm.designer.repository.Filter;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.impl.AbstractAsset;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.CopyOption;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.FileAlreadyExistsException;
import org.kie.commons.java.nio.file.FileSystem;
import org.kie.commons.java.nio.file.FileVisitResult;
import org.kie.commons.java.nio.file.FileVisitor;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.SimpleFileVisitor;
import org.kie.commons.java.nio.file.StandardCopyOption;
import org.kie.commons.java.nio.file.StandardOpenOption;
import org.kie.commons.java.nio.file.attribute.BasicFileAttributes;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.uberfire.backend.vfs.ActiveFileSystems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class VFSRepository
implements Repository {
    private IOService ioService;
    private URI repositoryRoot;
    private Path repositoryRootPath;
    private ActiveFileSystems fileSystems;
    private FileSystem fileSystem;

    @PostConstruct
    public void init() {
        this.repositoryRoot = URI.create(((org.uberfire.backend.vfs.Path)this.fileSystems.getBootstrapFileSystem().getRootDirectories().get(0)).toURI());
        this.repositoryRootPath = this.fileSystem.provider().getPath(this.repositoryRoot);
    }

    public VFSRepository() {
    }

    @Inject
    public VFSRepository(@Named(value="fileSystem") FileSystem fileSystem, @Named(value="ioStrategy") IOService ioService, @Named(value="fs") ActiveFileSystems fileSystems) {
        this.fileSystem = fileSystem;
        this.ioService = ioService;
        this.fileSystems = fileSystems;
    }

    @Override
    public String getName() {
        return "vfs";
    }

    @Override
    public Collection<Directory> listDirectories(String startAt) {
        Path path = this.fileSystem.provider().getPath(URI.create(this.getRepositoryRoot() + startAt));
        DirectoryStream directories = this.ioService.newDirectoryStream(path, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]);
            }
        });
        ArrayList<Directory> foundDirectories = new ArrayList<Directory>();
        for (Path dir : directories) {
            String uniqueId = this.encodeUniqueId(dir.toUri().toString());
            foundDirectories.add(new Directory(uniqueId, dir.getFileName().toString(), this.trimLocation(dir)));
        }
        return foundDirectories;
    }

    @Override
    public Collection<Asset> listAssetsRecursively(String startAt, final Filter filter) {
        final ArrayList<Asset> foundAssets = new ArrayList<Asset>();
        Path path = this.fileSystem.provider().getPath(URI.create(this.getRepositoryRoot() + startAt));
        Files.walkFileTree((Path)path, (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path paths, BasicFileAttributes basicFileAttributes) throws IOException {
                if (filter.accept(paths)) {
                    foundAssets.add(VFSRepository.this.buildAsset(paths, false));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return foundAssets;
    }

    @Override
    public Directory createDirectory(String location) {
        Path path = this.fileSystem.provider().getPath(URI.create(this.getRepositoryRoot() + location));
        path = this.ioService.createDirectories(path, new FileAttribute[0]);
        String uniqueId = this.encodeUniqueId(path.toUri().toString());
        Directory directory = new Directory(uniqueId, path.getFileName().toString(), this.trimLocation(path));
        return directory;
    }

    @Override
    public boolean directoryExists(String directory) {
        Path path = this.fileSystem.provider().getPath(URI.create(this.getRepositoryRoot() + directory));
        return this.ioService.exists(path) && Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0]);
    }

    @Override
    public boolean deleteDirectory(String directory, boolean failIfNotEmpty) {
        try {
            Path path = this.fileSystem.provider().getPath(URI.create(this.getRepositoryRoot() + directory));
            if (!Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
                return false;
            }
            Files.walkFileTree((Path)path, (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path paths, BasicFileAttributes basicFileAttributes) throws IOException {
                    VFSRepository.this.ioService.delete(paths);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e == null) {
                        VFSRepository.this.ioService.deleteIfExists(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            });
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean copyDirectory(String sourceDirectory, String location) {
        if (!this.directoryExists(sourceDirectory)) {
            throw new IllegalArgumentException("Directory does not exist " + sourceDirectory);
        }
        try {
            final Path sourcePath = this.fileSystem.provider().getPath(URI.create(this.getRepositoryRoot() + sourceDirectory));
            if (!Files.isDirectory((Path)sourcePath, (LinkOption[])new LinkOption[0])) {
                return false;
            }
            final String destinationPathRoot = this.getRepositoryRoot() + location + this.fileSystem.getSeparator() + sourcePath.getFileName().toString();
            Files.walkFileTree((Path)sourcePath, (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path destinationPath = VFSRepository.this.fileSystem.provider().getPath(URI.create(destinationPathRoot + VFSRepository.this.fileSystem.getSeparator() + sourcePath.relativize(dir)));
                    VFSRepository.this.fileSystem.provider().createDirectory(destinationPath, new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFile(Path currentFile, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (!currentFile.endsWith(".gitignore")) {
                        Path destinationPath = VFSRepository.this.fileSystem.provider().getPath(URI.create(destinationPathRoot + VFSRepository.this.fileSystem.getSeparator() + sourcePath.relativize(currentFile)));
                        VFSRepository.this.createIfNotExists(destinationPath);
                        VFSRepository.this.fileSystem.provider().copy(currentFile, destinationPath, null);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean moveDirectory(String sourceDirectory, String location, String name) {
        if (!this.directoryExists(sourceDirectory)) {
            throw new IllegalArgumentException("Directory does not exist " + sourceDirectory);
        }
        try {
            final Path sourcePath = this.fileSystem.provider().getPath(URI.create(this.getRepositoryRoot() + sourceDirectory));
            if (!Files.isDirectory((Path)sourcePath, (LinkOption[])new LinkOption[0])) {
                return false;
            }
            if (name == null) {
                name = sourcePath.getFileName().toString();
            }
            final String destinationPathRoot = this.getRepositoryRoot() + location + this.fileSystem.getSeparator() + name;
            Files.walkFileTree((Path)sourcePath, (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path currentFile, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path destinationPath = VFSRepository.this.fileSystem.provider().getPath(URI.create(destinationPathRoot + VFSRepository.this.fileSystem.getSeparator() + sourcePath.relativize(currentFile)));
                    VFSRepository.this.createIfNotExists(destinationPath);
                    VFSRepository.this.fileSystem.provider().move(currentFile, destinationPath, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e == null) {
                        try {
                            Path destinationPath = VFSRepository.this.fileSystem.provider().getPath(URI.create(destinationPathRoot + VFSRepository.this.fileSystem.getSeparator() + sourcePath.relativize(dir)));
                            VFSRepository.this.createIfNotExists(destinationPath);
                            VFSRepository.this.fileSystem.provider().move(dir, destinationPath, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                        }
                        catch (Exception e1) {
                            VFSRepository.this.fileSystem.provider().deleteIfExists(dir);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            });
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Collection<Asset> listAssets(String location) {
        Path path = this.fileSystem.provider().getPath(URI.create(this.getRepositoryRoot() + location));
        DirectoryStream directories = this.ioService.newDirectoryStream(path, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return !Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]);
            }
        });
        ArrayList<Asset> foundDirectories = new ArrayList<Asset>();
        Iterator it = directories.iterator();
        while (it.hasNext()) {
            Asset asset = this.buildAsset((Path)it.next(), false);
            foundDirectories.add(asset);
        }
        return foundDirectories;
    }

    @Override
    public Collection<Asset> listAssets(String location, final Filter filter) {
        Path path = this.fileSystem.provider().getPath(URI.create(this.getRepositoryRoot() + location));
        DirectoryStream directories = this.ioService.newDirectoryStream(path, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return filter.accept(entry);
            }
        });
        ArrayList<Asset> foundDirectories = new ArrayList<Asset>();
        Iterator it = directories.iterator();
        while (it.hasNext()) {
            Asset asset = this.buildAsset((Path)it.next(), false);
            foundDirectories.add(asset);
        }
        return foundDirectories;
    }

    @Override
    public Asset loadAsset(String assetUniqueId) throws AssetNotFoundException {
        String uniqueId = this.decodeUniqueId(assetUniqueId);
        Path assetPath = this.fileSystem.provider().getPath(URI.create(uniqueId));
        Asset asset = this.buildAsset(assetPath, true);
        return asset;
    }

    @Override
    public Asset loadAssetFromPath(String location) throws AssetNotFoundException {
        Path path = this.fileSystem.provider().getPath(URI.create(this.getRepositoryRoot() + location));
        if (this.ioService.exists(path)) {
            return this.loadAsset(path.toUri().toString());
        }
        throw new AssetNotFoundException();
    }

    @Override
    public String createAsset(Asset asset) {
        URI pathURI = null;
        pathURI = asset.getAssetLocation().startsWith(this.fileSystem.provider().getScheme()) || asset.getAssetLocation().startsWith("default://") ? URI.create(asset.getAssetLocation() + "/" + asset.getFullName()) : URI.create(this.getRepositoryRoot() + (asset.getAssetLocation().equals("/") ? "" : asset.getAssetLocation()) + "/" + asset.getFullName());
        Path filePath = this.fileSystem.provider().getPath(pathURI);
        this.createIfNotExists(filePath);
        try {
            CommentedOption commentedOption = new CommentedOption("admin", "Created asset " + asset.getFullName());
            OutputStream outputStream = this.fileSystem.provider().newOutputStream(filePath, new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING, commentedOption});
            if (((AbstractAsset)asset).acceptBytes()) {
                outputStream.write((byte[])asset.getAssetContent());
            } else {
                outputStream.write(asset.getAssetContent().toString().getBytes());
            }
            outputStream.close();
        }
        catch (java.io.IOException e) {
            throw new RuntimeException("Error when creating asset", e);
        }
        return this.encodeUniqueId(filePath.toUri().toString());
    }

    @Override
    public String updateAsset(Asset asset) throws AssetNotFoundException {
        String uniqueId = this.decodeUniqueId(asset.getUniqueId());
        Path filePath = this.fileSystem.provider().getPath(URI.create(uniqueId));
        if (!this.ioService.exists(filePath)) {
            throw new AssetNotFoundException();
        }
        CommentedOption commentedOption = new CommentedOption("admin", "Updated asset " + asset.getFullName());
        if (((AbstractAsset)asset).acceptBytes()) {
            this.ioService.write(filePath, (byte[])asset.getAssetContent(), new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING, commentedOption});
        } else {
            this.ioService.write(filePath, asset.getAssetContent().toString().getBytes(), new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING, commentedOption});
        }
        return asset.getUniqueId();
    }

    @Override
    public boolean deleteAsset(String assetUniqueId) {
        String uniqueId = this.decodeUniqueId(assetUniqueId);
        try {
            return this.ioService.deleteIfExists(this.fileSystem.provider().getPath(URI.create(uniqueId)));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean deleteAssetFromPath(String path) {
        Path filePath = this.fileSystem.provider().getPath(URI.create(this.getRepositoryRoot() + path));
        return this.deleteAsset(filePath.toUri().toString());
    }

    @Override
    public boolean assetExists(String assetUniqueId) {
        String uniqueId = this.decodeUniqueId(assetUniqueId);
        try {
            return this.ioService.exists(this.fileSystem.provider().getPath(URI.create(uniqueId)));
        }
        catch (Exception e) {
            return this.ioService.exists(this.fileSystem.provider().getPath(URI.create(this.getRepositoryRoot() + assetUniqueId)));
        }
    }

    @Override
    public boolean copyAsset(String uniqueId, String location) {
        String decodedUniqueId = this.decodeUniqueId(uniqueId);
        if (!this.assetExists(decodedUniqueId)) {
            throw new IllegalArgumentException("Asset does not exist");
        }
        try {
            Path sourcePath = this.fileSystem.provider().getPath(URI.create(decodedUniqueId));
            Path destinationPath = this.fileSystem.provider().getPath(URI.create(this.getRepositoryRoot() + location + this.fileSystem.getSeparator() + sourcePath.getFileName().toString()));
            this.createIfNotExists(destinationPath);
            CommentedOption commentedOption = new CommentedOption("admin", "Copied asset " + sourcePath.getFileName() + " into " + location);
            this.fileSystem.provider().copy(sourcePath, destinationPath, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, commentedOption});
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean moveAsset(String uniqueId, String location, String name) {
        String decodedUniqueId = this.decodeUniqueId(uniqueId);
        if (!this.assetExists(decodedUniqueId)) {
            throw new IllegalArgumentException("Asset does not exist");
        }
        try {
            Path sourcePath = this.fileSystem.provider().getPath(URI.create(decodedUniqueId));
            if (name == null) {
                name = sourcePath.getFileName().toString();
            }
            Path destinationPath = this.fileSystem.provider().getPath(URI.create(this.getRepositoryRoot() + location + this.fileSystem.getSeparator() + name));
            this.createIfNotExists(destinationPath);
            CommentedOption commentedOption = new CommentedOption("admin", "Moved asset " + sourcePath.getFileName() + " into " + location);
            this.fileSystem.provider().move(sourcePath, destinationPath, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, commentedOption});
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected Asset buildAsset(Path file, boolean loadContent) {
        String name = file.getFileName().toString();
        String location = this.trimLocation(file);
        AssetBuilder assetBuilder = AssetBuilderFactory.getAssetBuilder(name);
        BasicFileAttributes attrs = this.fileSystem.provider().readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
        assetBuilder.uniqueId(this.encodeUniqueId(file.toUri().toString())).location(location).creationDate(attrs.creationTime() == null ? "" : new Date(attrs.creationTime().toMillis()).toString()).lastModificationDate(attrs.lastModifiedTime() == null ? "" : new Date(attrs.lastModifiedTime().toMillis()).toString()).description("").owner("");
        if (loadContent) {
            if (((AbstractAsset)assetBuilder.getAsset()).acceptBytes()) {
                assetBuilder.content(this.ioService.readAllBytes(file));
            } else {
                assetBuilder.content(this.ioService.readAllString(file, Charset.forName("UTF-8")));
            }
        }
        return assetBuilder.getAsset();
    }

    private String decodeUniqueId(String uniqueId) {
        if (Base64.isBase64((String)uniqueId)) {
            byte[] decoded = Base64.decodeBase64((String)uniqueId);
            try {
                return new String(decoded, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return uniqueId;
    }

    private String encodeUniqueId(String uniqueId) {
        try {
            return Base64.encodeBase64URLSafeString((byte[])uniqueId.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private String getRepositoryRoot() {
        String repo = this.repositoryRoot.toString();
        if (repo.endsWith("/")) {
            return repo.substring(0, repo.length() - 2);
        }
        return repo;
    }

    private String trimLocation(Path file) {
        String location = "";
        String pathAsString = file.getParent().toString();
        location = pathAsString.startsWith(this.repositoryRoot.getScheme()) ? pathAsString.replaceFirst(this.getRepositoryRoot(), "") : pathAsString.replaceFirst(this.repositoryRootPath.toString(), "");
        if (!location.startsWith(this.fileSystem.getSeparator())) {
            location = this.fileSystem.getSeparator() + location;
        }
        return location;
    }

    private void createIfNotExists(Path filePath) {
        if (!this.ioService.exists(filePath.getParent())) {
            try {
                this.fileSystem.provider().createDirectory(filePath.getParent(), null);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
    }
}

