/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.fileexplorer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.FileExplorerRootService;
import org.uberfire.backend.Root;
import org.uberfire.backend.vfs.ActiveFileSystems;
import org.uberfire.backend.vfs.FileSystem;
import org.uberfire.backend.vfs.Path;
import org.uberfire.shared.mvp.PlaceRequest;
import org.uberfire.shared.mvp.impl.DefaultPlaceRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@ApplicationScoped
public class FileExplorerRootServiceImpl
implements FileExplorerRootService {
    protected final Set<Root> roots = new HashSet<Root>();
    @Inject
    @Named(value="fs")
    private ActiveFileSystems fileSystems;

    @PostConstruct
    protected void init() {
        this.setupGitRepos();
    }

    private void setupGitRepos() {
        Collection activefileSystems = this.fileSystems.fileSystems();
        if (activefileSystems != null) {
            for (FileSystem fs : activefileSystems) {
                Path rootP = (Path)fs.getRootDirectories().get(0);
                Root root = new Root(rootP, (PlaceRequest)new DefaultPlaceRequest("RepositoryEditor"));
                this.roots.add(root);
            }
        }
    }

    public Collection<Root> listRoots() {
        return Collections.unmodifiableSet(this.roots);
    }

    public void addRoot(Root root) {
        this.roots.add(root);
    }

    public void removeRoot(Root root) {
        this.roots.remove(root);
    }

    public void clear() {
        this.roots.clear();
    }
}

