/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.variables.edit;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.FormControlStatic;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.TextArea;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.events.ProcessInstancesUpdateEvent;
import org.jbpm.console.ng.pr.service.ProcessService;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class VariableEditPopup
extends BaseModal {
    @UiField
    public FormControlStatic variableNameTextBox;
    @UiField
    public TextArea variableValueTextBox;
    @UiField
    public HelpBlock errorMessages;
    @UiField
    public FormGroup errorMessagesGroup;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private Caller<ProcessService> processService;
    @Inject
    private Event<ProcessInstancesUpdateEvent> processInstancesUpdateEvent;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private String serverTemplateId;
    private String deploymentId;
    private long processInstanceId;

    public VariableEditPopup() {
        this.setTitle(Constants.INSTANCE.Edit());
        this.setBody((Widget)uiBinder.createAndBindUi((Object)this));
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(Constants.INSTANCE.Clear(), new Command(){

            public void execute() {
                VariableEditPopup.this.variableValueTextBox.setText("");
            }
        }, null, ButtonType.DEFAULT);
        footer.addButton(Constants.INSTANCE.Save(), new Command(){

            public void execute() {
                VariableEditPopup.this.setProcessVariable();
            }
        }, null, ButtonType.PRIMARY);
        this.add((Widget)footer);
    }

    public void show(String serverTemplateId, String deploymentId, long processInstanceId, String variableId, String variableValue) {
        this.serverTemplateId = serverTemplateId;
        this.deploymentId = deploymentId;
        this.processInstanceId = processInstanceId;
        this.variableNameTextBox.setText(variableId);
        this.variableValueTextBox.setText(variableValue);
        this.cleanErrorMessages();
        super.show();
    }

    private void cleanErrorMessages() {
        this.errorMessages.setText("");
        this.errorMessagesGroup.setValidationState(ValidationState.NONE);
    }

    public void closePopup() {
        this.hide();
        super.hide();
        this.processInstancesUpdateEvent.fire((Object)new ProcessInstancesUpdateEvent());
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    public void setProcessVariable() {
        ((ProcessService)this.processService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                VariableEditPopup.this.displayNotification(Constants.INSTANCE.VariableValueUpdated(VariableEditPopup.this.variableNameTextBox.getText()));
                VariableEditPopup.this.closePopup();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                VariableEditPopup.this.errorMessages.setText(throwable.getMessage());
                VariableEditPopup.this.errorMessagesGroup.setValidationState(ValidationState.ERROR);
                return true;
            }
        })).setProcessVariable(this.serverTemplateId, this.deploymentId, this.processInstanceId, this.variableNameTextBox.getText(), this.variableValueTextBox.getValue());
    }

    static interface Binder
    extends UiBinder<Widget, VariableEditPopup> {
    }
}

