/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.definition.details.multi;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jbpm.console.ng.gc.forms.client.display.views.FormDisplayerView;
import org.jbpm.console.ng.pr.client.editors.diagram.ProcessDiagramUtil;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.events.ProcessDefSelectionEvent;
import org.jbpm.console.ng.pr.forms.client.display.providers.StartProcessFormDisplayProviderImpl;
import org.jbpm.console.ng.pr.forms.client.display.views.PopupFormDisplayerView;
import org.jbpm.console.ng.pr.forms.display.process.api.ProcessDisplayerConfig;
import org.jbpm.console.ng.pr.model.ProcessDefinitionKey;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

public abstract class BaseProcessDefDetailsMultiPresenter
implements RefreshMenuBuilder.SupportsRefresh {
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    protected PopupFormDisplayerView formDisplayPopUp;
    @Inject
    private PlaceManager placeManager;
    @Inject
    protected StartProcessFormDisplayProviderImpl startProcessDisplayProvider;
    @Inject
    private Event<ProcessDefSelectionEvent> processDefSelectionEvent;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent;
    private PlaceRequest place;
    private String deploymentId = "";
    private String processId = "";
    private String processDefName = "";
    private String serverTemplateId = "";

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Details();
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    public void onProcessSelectionEvent(@Observes ProcessDefSelectionEvent event) {
        this.deploymentId = event.getDeploymentId();
        this.processId = event.getProcessId();
        this.processDefName = event.getProcessDefName();
        this.serverTemplateId = event.getServerTemplateId();
        this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.place, String.valueOf(this.deploymentId) + " - " + this.processDefName));
    }

    public void createNewProcessInstance() {
        ProcessDisplayerConfig config = new ProcessDisplayerConfig(new ProcessDefinitionKey(this.serverTemplateId, this.deploymentId, this.processId, this.processDefName), this.processDefName);
        this.formDisplayPopUp.setTitle("");
        this.startProcessDisplayProvider.setup(config, (FormDisplayerView)this.formDisplayPopUp);
    }

    public void goToProcessDefModelPopup() {
        if (this.place != null && !this.deploymentId.equals("")) {
            this.placeManager.goTo(ProcessDiagramUtil.buildPlaceRequest(this.serverTemplateId, this.deploymentId, this.processId));
        }
    }

    public void viewProcessInstances() {
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("DataSet Process Instances With Variables");
        placeRequestImpl.addParameter("processDefinitionId", this.processId);
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
    }

    public void onRefresh() {
        this.processDefSelectionEvent.fire((Object)new ProcessDefSelectionEvent(this.processId, this.deploymentId, this.serverTemplateId, this.processDefName));
    }

    public void closeDetails() {
        this.placeManager.forceClosePlace(this.place);
    }

    public static interface BaseProcessDefDetailsMultiView {
        public IsWidget getNewInstanceButton();
    }
}

