/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.instance.signal;

import com.google.gwt.core.client.GWT;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.model.events.ProcessInstancesUpdateEvent;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchPopup;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchPopup(identifier="Signal Process Popup")
public class ProcessInstanceSignalPresenter {
    public static final String SIGNAL_PROCESS_POPUP = "Signal Process Popup";
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private PopupView view;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private Event<ProcessInstancesUpdateEvent> processInstancesUpdatedEvent;
    private PlaceRequest place;
    @Inject
    private Caller<KieSessionEntryPoint> kieSessionServices;

    @PostConstruct
    public void init() {
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Signaling_Process_Instance();
    }

    @WorkbenchPartView
    public UberView<ProcessInstanceSignalPresenter> getView() {
        return this.view;
    }

    public void signalProcessInstances(List<Long> processInstanceIds) {
        ((KieSessionEntryPoint)this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                ProcessInstanceSignalPresenter.this.processInstancesUpdatedEvent.fire((Object)new ProcessInstancesUpdateEvent(Long.valueOf(0L)));
                ProcessInstanceSignalPresenter.this.placeManager.closePlace(ProcessInstanceSignalPresenter.this.place);
            }
        }, (ErrorCallback)new DefaultErrorCallback())).signalProcessInstances(processInstanceIds, this.view.getSignalRefText(), (Object)this.view.getEventText());
    }

    @OnOpen
    public void onOpen() {
        String[] ids;
        String processInstanceIds = this.place.getParameter("processInstanceId", "-1").toString();
        for (String id : ids = processInstanceIds.split(",")) {
            long processInstanceId = Long.parseLong(id);
            this.view.addProcessInstanceId(processInstanceId);
        }
        if (ids.length == 1 && Long.parseLong(ids[0]) != -1L) {
            this.getAvailableSignals(Long.parseLong(ids[0]));
        }
    }

    public void getAvailableSignals(long processInstanceId) {
        ((KieSessionEntryPoint)this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Collection<String>>(){

            public void callback(Collection<String> signals) {
                ProcessInstanceSignalPresenter.this.view.setAvailableSignals(signals);
            }
        }, (ErrorCallback)new DefaultErrorCallback())).getAvailableSignals(processInstanceId);
    }

    public static interface PopupView
    extends UberView<ProcessInstanceSignalPresenter> {
        public void displayNotification(String var1);

        public void addProcessInstanceId(long var1);

        public String getSignalRefText();

        public String getEventText();

        public void setAvailableSignals(Collection<String> var1);
    }
}

