/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.instance.details.multi;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.service.DataServiceEntryPoint;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;
import org.jbpm.console.ng.pr.client.editors.diagram.ProcessDiagramUtil;
import org.jbpm.console.ng.pr.client.editors.documents.list.ProcessDocumentListPresenter;
import org.jbpm.console.ng.pr.client.editors.instance.details.ProcessInstanceDetailsPresenter;
import org.jbpm.console.ng.pr.client.editors.instance.log.RuntimeLogPresenter;
import org.jbpm.console.ng.pr.client.editors.variables.list.ProcessVariableListPresenter;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.model.NodeInstanceSummary;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.console.ng.pr.model.events.ProcessInstanceSelectionEvent;
import org.jbpm.console.ng.pr.model.events.ProcessInstancesUpdateEvent;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@Dependent
@WorkbenchScreen(identifier="Process Instance Details Multi", preferredWidth=500)
public class ProcessInstanceDetailsMultiPresenter
implements RefreshMenuBuilder.SupportsRefresh {
    @Inject
    public ProcessInstanceDetailsMultiView view;
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private PlaceManager placeManager;
    @Inject
    private Caller<KieSessionEntryPoint> kieSessionServices;
    @Inject
    private Caller<DataServiceEntryPoint> dataServices;
    @Inject
    private Event<ProcessInstanceSelectionEvent> processInstanceSelected;
    @Inject
    private Event<ProcessInstancesUpdateEvent> processInstancesUpdatedEvent;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent;
    @Inject
    private ProcessInstanceDetailsPresenter detailsPresenter;
    @Inject
    private ProcessVariableListPresenter variableListPresenter;
    @Inject
    private ProcessDocumentListPresenter documentListPresenter;
    @Inject
    private RuntimeLogPresenter runtimeLogPresenter;
    private String selectedDeploymentId = "";
    private int selectedProcessInstanceStatus = 0;
    private String selectedProcessDefName = "";
    private PlaceRequest place;
    private String processInstanceId = "";
    private String processId = "";
    private boolean forLog = false;

    @WorkbenchPartView
    public UberView<ProcessInstanceDetailsMultiPresenter> getView() {
        return this.view;
    }

    @DefaultPosition
    public Position getPosition() {
        return CompassPosition.EAST;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Details();
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    public boolean isForLog() {
        return this.forLog;
    }

    public void setIsForLog(boolean isForLog) {
        this.forLog = isForLog;
    }

    public void onProcessSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        this.processInstanceId = String.valueOf(event.getProcessInstanceId());
        this.processId = event.getProcessDefId();
        this.selectedDeploymentId = event.getDeploymentId();
        this.selectedProcessInstanceStatus = event.getProcessInstanceStatus();
        this.selectedProcessDefName = event.getProcessDefName();
        this.setIsForLog(event.isForLog());
        this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.place, String.valueOf(this.processInstanceId) + " - " + this.selectedProcessDefName));
        if (this.isForLog()) {
            this.view.displayOnlyLogTab();
        } else {
            this.view.displayAllTabs();
        }
        this.view.selectInstanceDetailsTab();
    }

    public void onRefresh() {
        this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(this.selectedDeploymentId, Long.valueOf(this.processInstanceId), this.processId, this.selectedProcessDefName, Integer.valueOf(this.selectedProcessInstanceStatus), this.isForLog()));
    }

    public void signalProcessInstance() {
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
        placeRequestImpl.addParameter("processInstanceId", this.processInstanceId);
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
    }

    public void abortProcessInstance() {
        final long pInstanceId = Long.parseLong(this.processInstanceId);
        ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<ProcessInstanceSummary>(){

            public void callback(ProcessInstanceSummary processInstance) {
                if (processInstance.getState() == 1 || processInstance.getState() == 0) {
                    if (Window.confirm((String)ProcessInstanceDetailsMultiPresenter.this.constants.Abort_Process_Instance())) {
                        ((KieSessionEntryPoint)ProcessInstanceDetailsMultiPresenter.this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

                            public void callback(Void v) {
                                ProcessInstanceDetailsMultiPresenter.this.processInstancesUpdatedEvent.fire((Object)new ProcessInstancesUpdateEvent(Long.valueOf(0L)));
                            }
                        }, (ErrorCallback)new DefaultErrorCallback())).abortProcessInstance(pInstanceId);
                    }
                } else {
                    Window.alert((String)ProcessInstanceDetailsMultiPresenter.this.constants.ProcessInstanceNeedsToBeActiveInOrderToBeAborted());
                }
            }
        }, (ErrorCallback)new DefaultErrorCallback())).getProcessInstanceById(pInstanceId);
    }

    public void goToProcessInstanceModelPopup() {
        if (this.place != null && !this.processInstanceId.equals("")) {
            ((DataServiceEntryPoint)this.dataServices.call((RemoteCallback)new RemoteCallback<List<NodeInstanceSummary>>(){

                public void callback(List<NodeInstanceSummary> activeNodes) {
                    final StringBuffer nodeParam = new StringBuffer();
                    for (NodeInstanceSummary activeNode : activeNodes) {
                        nodeParam.append(activeNode.getNodeUniqueName() + ",");
                    }
                    if (nodeParam.length() > 0) {
                        nodeParam.deleteCharAt(nodeParam.length() - 1);
                    }
                    ((DataServiceEntryPoint)ProcessInstanceDetailsMultiPresenter.this.dataServices.call((RemoteCallback)new RemoteCallback<List<NodeInstanceSummary>>(){

                        public void callback(List<NodeInstanceSummary> completedNodes) {
                            StringBuffer completedNodeParam = new StringBuffer();
                            for (NodeInstanceSummary completedNode : completedNodes) {
                                if (completedNode.isCompleted()) {
                                    completedNodeParam.append(completedNode.getNodeUniqueName() + ",");
                                    completedNodeParam.append(completedNode.getConnection() + ",");
                                    continue;
                                }
                                if (completedNode.getConnection() == null) continue;
                                completedNodeParam.append(completedNode.getConnection() + ",");
                            }
                            completedNodeParam.deleteCharAt(completedNodeParam.length() - 1);
                            ProcessInstanceDetailsMultiPresenter.this.placeManager.goTo(ProcessDiagramUtil.buildPlaceRequest(new DefaultPlaceRequest("").addParameter("activeNodes", nodeParam.toString()).addParameter("completedNodes", completedNodeParam.toString()).addParameter("readOnly", "true").addParameter("processId", ProcessInstanceDetailsMultiPresenter.this.processId).addParameter("deploymentId", ProcessInstanceDetailsMultiPresenter.this.selectedDeploymentId)));
                        }
                    }, (ErrorCallback)new DefaultErrorCallback())).getProcessInstanceCompletedNodes(Long.parseLong(ProcessInstanceDetailsMultiPresenter.this.processInstanceId));
                }
            }, (ErrorCallback)new DefaultErrorCallback())).getProcessInstanceActiveNodes(Long.parseLong(this.processInstanceId));
        }
    }

    @WorkbenchMenu
    public Menus buildMenu() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        return ProcessInstanceDetailsMultiPresenter.this.view.getOptionsButton();
                    }
                };
            }
        }).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).build();
    }

    public void closeDetails() {
        this.placeManager.closePlace(this.place);
    }

    public void variableListRefreshGrid() {
        this.variableListPresenter.refreshGrid();
    }

    public void documentListRefreshGrid() {
        this.documentListPresenter.refreshGrid();
    }

    public IsWidget getProcessIntanceView() {
        return this.detailsPresenter.getWidget();
    }

    public IsWidget getProcessVariablesView() {
        return this.variableListPresenter.getWidget();
    }

    public IsWidget getDocumentView() {
        return this.documentListPresenter.getWidget();
    }

    public IsWidget getLogsView() {
        return this.runtimeLogPresenter.getWidget();
    }

    public static interface ProcessInstanceDetailsMultiView
    extends UberView<ProcessInstanceDetailsMultiPresenter> {
        public IsWidget getOptionsButton();

        public void selectInstanceDetailsTab();

        public void displayAllTabs();

        public void displayOnlyLogTab();
    }
}

