/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.documents.list;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import org.gwtbootstrap3.client.ui.AnchorButton;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jbpm.console.ng.ga.model.GenericSummary;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.pr.client.editors.documents.list.ProcessDocumentListPresenter;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.model.DocumentSummary;
import org.uberfire.client.workbench.events.BeforeClosePlaceEvent;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.ColumnMeta;

@Dependent
public class ProcessDocumentListViewImpl
extends AbstractListView<DocumentSummary, ProcessDocumentListPresenter>
implements ProcessDocumentListPresenter.ProcessDocumentListView {
    private Constants constants = (Constants)GWT.create(Constants.class);
    public static final String COL_ID_DOCID = "documentId";
    public static final String COL_ID_LASTMOD = "lastModified";
    public static final String COL_ID_DOCSIZE = "docSize";
    public static final String COL_ID_PATH = "Path";
    public static final String COL_ID_ACTIONS = "Actions";
    final String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
    private Column actionsColumn;

    @Override
    public void init(ProcessDocumentListPresenter presenter) {
        ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add(COL_ID_DOCID);
        bannedColumns.add(COL_ID_ACTIONS);
        ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add(COL_ID_DOCID);
        initColumns.add(COL_ID_LASTMOD);
        initColumns.add(COL_ID_DOCSIZE);
        initColumns.add(COL_ID_ACTIONS);
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences("DocumentGrid", initColumns, bannedColumns));
        this.listGrid.setEmptyTableCaption(this.constants.No_Documents_Available());
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                if (ProcessDocumentListViewImpl.this.selectedRow == -1) {
                    ProcessDocumentListViewImpl.this.listGrid.setRowStyles(ProcessDocumentListViewImpl.this.selectedStyles);
                    ProcessDocumentListViewImpl.this.selectedRow = ProcessDocumentListViewImpl.this.listGrid.getKeyboardSelectedRow();
                    ProcessDocumentListViewImpl.this.listGrid.redraw();
                } else if (ProcessDocumentListViewImpl.this.listGrid.getKeyboardSelectedRow() != ProcessDocumentListViewImpl.this.selectedRow) {
                    ProcessDocumentListViewImpl.this.listGrid.setRowStyles(ProcessDocumentListViewImpl.this.selectedStyles);
                    ProcessDocumentListViewImpl.this.selectedRow = ProcessDocumentListViewImpl.this.listGrid.getKeyboardSelectedRow();
                    ProcessDocumentListViewImpl.this.listGrid.redraw();
                }
                ProcessDocumentListViewImpl.this.selectedItem = (GenericSummary)ProcessDocumentListViewImpl.this.selectionModel.getLastSelectedObject();
            }
        });
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<DocumentSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<DocumentSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<DocumentSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType()) && ProcessDocumentListViewImpl.this.listGrid.getColumnIndex(ProcessDocumentListViewImpl.this.actionsColumn) == event.getColumn()) {
                    return DefaultSelectionEventManager.SelectAction.IGNORE;
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
        this.listGrid.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        this.listGrid.setRowStyles(this.selectedStyles);
    }

    public void initColumns(ExtendedPagedTable extendedPagedTable) {
        Column documentId = this.initDocumentIdColumn();
        Column lastModifiedColumn = this.initDocumentLastModifiedColumn();
        Column sizeColumn = this.initDocumentSizeColumn();
        this.actionsColumn = this.initActionsColumn();
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(documentId, this.constants.Name()));
        columnMetas.add(new ColumnMeta(lastModifiedColumn, this.constants.Last_Modification()));
        columnMetas.add(new ColumnMeta(sizeColumn, this.constants.Size()));
        columnMetas.add(new ColumnMeta(this.actionsColumn, this.constants.Actions()));
        extendedPagedTable.addColumns(columnMetas);
    }

    private Column initDocumentIdColumn() {
        Column<DocumentSummary, String> documentId = new Column<DocumentSummary, String>((Cell)new TextCell()){

            public String getValue(DocumentSummary object) {
                return object.getDocumentId();
            }
        };
        documentId.setSortable(true);
        documentId.setDataStoreName(COL_ID_DOCID);
        return documentId;
    }

    private Column initDocumentLastModifiedColumn() {
        Column<DocumentSummary, String> lastModifiedColumn = new Column<DocumentSummary, String>((Cell)new TextCell()){

            public String getValue(DocumentSummary object) {
                return object.getDocumentLastModified().toString();
            }
        };
        lastModifiedColumn.setSortable(true);
        lastModifiedColumn.setDataStoreName(COL_ID_LASTMOD);
        return lastModifiedColumn;
    }

    private Column initDocumentSizeColumn() {
        Column<DocumentSummary, String> sizeColumn = new Column<DocumentSummary, String>((Cell)new TextCell()){

            public String getValue(DocumentSummary object) {
                return ProcessDocumentListViewImpl.this.readableFileSize(object.getDocumentSize());
            }
        };
        sizeColumn.setSortable(true);
        sizeColumn.setDataStoreName(COL_ID_DOCSIZE);
        return sizeColumn;
    }

    public String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return NumberFormat.getDecimalFormat().format((double)size / Math.pow(1024.0, digitGroups)) + " " + this.units[digitGroups];
    }

    public Column initDocumentLinkColumn() {
        Column<DocumentSummary, String> pathColumn = new Column<DocumentSummary, String>((Cell)new TextCell()){

            public String getValue(DocumentSummary object) {
                return String.valueOf(object.getDocumentSize());
            }
        };
        pathColumn.setSortable(true);
        pathColumn.setDataStoreName(COL_ID_PATH);
        return pathColumn;
    }

    private Column initActionsColumn() {
        LinkedList<AccessDocumentActionHasCell> cells = new LinkedList<AccessDocumentActionHasCell>();
        cells.add(new AccessDocumentActionHasCell(this.constants.AccessDocument(), new ActionCell.Delegate<DocumentSummary>(){

            public void execute(DocumentSummary document) {
                if (document != null) {
                    GWT.log((String)("Accessing document: " + document.getDocumentLink()));
                }
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<DocumentSummary, DocumentSummary> actionsColumn = new Column<DocumentSummary, DocumentSummary>((Cell)cell){

            public DocumentSummary getValue(DocumentSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        return actionsColumn;
    }

    public void formClosed(@Observes BeforeClosePlaceEvent closed) {
        if ("Edit Variable Popup".equals(closed.getPlace().getIdentifier())) {
            ((ProcessDocumentListPresenter)this.presenter).refreshGrid();
        }
    }

    private class AccessDocumentActionHasCell
    implements HasCell<DocumentSummary, DocumentSummary> {
        private ActionCell<DocumentSummary> cell;

        public AccessDocumentActionHasCell(String text, ActionCell.Delegate<DocumentSummary> delegate) {
            this.cell = new ActionCell<DocumentSummary>(text, delegate){

                public void render(Cell.Context context, final DocumentSummary value, SafeHtmlBuilder sb) {
                    SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                    mysb.appendHtmlConstant(new SimplePanel((Widget)new AnchorButton(ButtonType.DEFAULT){
                        {
                            super(x0);
                            this.setText(ProcessDocumentListViewImpl.this.constants.download());
                            this.getElement().setPropertyString("target", "_blank");
                            this.setHref(value.getDocumentLink());
                            this.setSize(ButtonSize.SMALL);
                            this.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
                        }
                    }).getElement().getInnerHTML());
                    sb.append(mysb.toSafeHtml());
                }
            };
        }

        public Cell<DocumentSummary> getCell() {
            return this.cell;
        }

        public FieldUpdater<DocumentSummary, DocumentSummary> getFieldUpdater() {
            return null;
        }

        public DocumentSummary getValue(DocumentSummary object) {
            return object;
        }
    }
}

