/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.perspectives;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jbpm.console.ng.gc.client.list.base.events.SearchEvent;
import org.kie.workbench.common.widgets.client.search.ContextualSearch;
import org.kie.workbench.common.widgets.client.search.SearchBehavior;
import org.kie.workbench.common.widgets.client.search.SetSearchTextEvent;
import org.uberfire.client.annotations.Perspective;
import org.uberfire.client.annotations.WorkbenchPerspective;
import org.uberfire.client.workbench.panels.impl.ClosableSimpleWorkbenchPanelPresenter;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;

@ApplicationScoped
@WorkbenchPerspective(identifier="Process Instances")
public class ProcessInstancesPerspective {
    @Inject
    private ContextualSearch contextualSearch;
    @Inject
    private Event<SearchEvent> searchEvents;
    @Inject
    private Event<SetSearchTextEvent> setSearchTextEvents;
    private String currentProcessDefinition = "";

    @Perspective
    public PerspectiveDefinition getPerspective() {
        PerspectiveDefinitionImpl p = new PerspectiveDefinitionImpl(ClosableSimpleWorkbenchPanelPresenter.class.getName());
        p.setName("Process Instances");
        DefaultPlaceRequest defaultPlaceRequest = new DefaultPlaceRequest("Process Instance List");
        defaultPlaceRequest.addParameter("processName", this.currentProcessDefinition);
        p.getRoot().addPart((PartDefinition)new PartDefinitionImpl((PlaceRequest)defaultPlaceRequest));
        return p;
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.contextualSearch.setSearchBehavior(new SearchBehavior(){

            public void execute(String searchFilter) {
                ProcessInstancesPerspective.this.searchEvents.fire((Object)new SearchEvent(searchFilter));
            }
        });
        this.currentProcessDefinition = place.getParameter("processName", "");
        this.setSearchTextEvents.fire((Object)new SetSearchTextEvent(this.currentProcessDefinition));
    }
}

