/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.instance.list.variables.dash;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;
import org.jbpm.console.ng.df.client.filter.FilterSettings;
import org.jbpm.console.ng.df.client.list.base.DataSetQueryHelper;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.jbpm.console.ng.gc.client.list.base.RefreshSelectorMenuBuilder;
import org.jbpm.console.ng.gc.client.list.base.events.SearchEvent;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.forms.client.editors.quicknewinstance.QuickNewProcessInstancePopup;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.console.ng.pr.model.events.NewProcessInstanceEvent;
import org.jbpm.console.ng.pr.model.events.ProcessInstancesUpdateEvent;
import org.jbpm.console.ng.pr.service.ProcessInstanceService;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.paging.PageResponse;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@Dependent
@WorkbenchScreen(identifier="DataSet Process Instance List With Variables")
public class DataSetProcessInstanceWithVariablesListPresenter
extends AbstractScreenListPresenter<ProcessInstanceSummary> {
    @Inject
    private DataSetProcessInstanceWithVariablesListView view;
    @Inject
    private Caller<ProcessInstanceService> processInstanceService;
    @Inject
    private Caller<KieSessionEntryPoint> kieSessionServices;
    @Inject
    private DataSetQueryHelper dataSetQueryHelper;
    @Inject
    private DataSetQueryHelper dataSetQueryHelperDomainSpecific;
    @Inject
    private ErrorPopupPresenter errorPopup;
    private RefreshSelectorMenuBuilder refreshSelectorMenuBuilder = new RefreshSelectorMenuBuilder((AbstractListPresenter)this);
    @Inject
    private QuickNewProcessInstancePopup newProcessInstancePopup;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public DataSetProcessInstanceWithVariablesListPresenter() {
    }

    public DataSetProcessInstanceWithVariablesListPresenter(DataSetProcessInstanceWithVariablesListView view, DataSetQueryHelper dataSetQueryHelper, DataSetQueryHelper dataSetQueryHelperDomainSpecific) {
        this();
        this.dataSetQueryHelper = dataSetQueryHelper;
        this.dataSetQueryHelperDomainSpecific = dataSetQueryHelperDomainSpecific;
        this.view = view;
    }

    public DataSetProcessInstanceWithVariablesListPresenter(DataSetProcessInstanceWithVariablesListView view, Caller<ProcessInstanceService> processInstanceService, Caller<KieSessionEntryPoint> kieSessionServices, DataSetQueryHelper dataSetQueryHelper, DataSetQueryHelper dataSetQueryHelperDomainSpecific) {
        this();
        this.dataSetQueryHelper = dataSetQueryHelper;
        this.processInstanceService = processInstanceService;
        this.kieSessionServices = kieSessionServices;
        this.dataSetQueryHelperDomainSpecific = dataSetQueryHelperDomainSpecific;
        this.view = view;
    }

    public void filterGrid(FilterSettings tableSettings) {
        this.dataSetQueryHelper.setCurrentTableSettings(tableSettings);
        this.refreshGrid();
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(Range visibleRange) {
        try {
            if (!this.isAddingDefaultFilters()) {
                FilterSettings currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings();
                if (currentTableSettings != null) {
                    currentTableSettings.setTablePageSize(this.view.getListGrid().getPageSize());
                    ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
                    if (columnSortList != null && columnSortList.size() > 0) {
                        this.dataSetQueryHelper.setLastOrderedColumn(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
                        this.dataSetQueryHelper.setLastSortOrder(columnSortList.size() > 0 && columnSortList.get(0).isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
                    } else {
                        this.dataSetQueryHelper.setLastOrderedColumn("start_date");
                        this.dataSetQueryHelper.setLastSortOrder(SortOrder.ASCENDING);
                    }
                    if (this.textSearchStr != null && this.textSearchStr.trim().length() > 0) {
                        DataSetFilter filter = new DataSetFilter();
                        ArrayList<ColumnFilter> filters = new ArrayList<ColumnFilter>();
                        filters.add(FilterFactory.likeTo((String)"processName", (String)("%" + this.textSearchStr.toLowerCase() + "%"), (boolean)false));
                        filters.add(FilterFactory.likeTo((String)"processInstanceDescription", (String)("%" + this.textSearchStr.toLowerCase() + "%"), (boolean)false));
                        filters.add(FilterFactory.likeTo((String)"user_identity", (String)("%" + this.textSearchStr.toLowerCase() + "%"), (boolean)false));
                        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                        if (currentTableSettings.getDataSetLookup().getFirstFilterOp() != null) {
                            currentTableSettings.getDataSetLookup().getFirstFilterOp().addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                        } else {
                            currentTableSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
                        }
                        this.textSearchStr = "";
                    }
                    this.dataSetQueryHelper.setCurrentTableSettings(currentTableSettings);
                    this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
                    this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(visibleRange.getStart()), this.createDataSetProcessInstanceCallback(visibleRange.getStart(), currentTableSettings));
                } else {
                    this.view.hideBusyIndicator();
                }
            }
        }
        catch (Exception e) {
            GWT.log((String)("Error looking up dataset with UUID [ jbpmProcessInstances ]" + e.getMessage()));
        }
    }

    protected DataSetReadyCallback createDataSetDomainSpecificCallback(final int startRange, final int totalRowSize, final List<ProcessInstanceSummary> instances) {
        return new DataSetReadyCallback(){

            public void callback(DataSet dataSet) {
                HashSet<String> columns = new HashSet<String>();
                for (int i = 0; i < dataSet.getRowCount(); ++i) {
                    Long processInstanceId = DataSetProcessInstanceWithVariablesListPresenter.this.dataSetQueryHelperDomainSpecific.getColumnLongValue(dataSet, "pid", i);
                    String variableName = DataSetProcessInstanceWithVariablesListPresenter.this.dataSetQueryHelperDomainSpecific.getColumnStringValue(dataSet, "varname", i);
                    String variableValue = DataSetProcessInstanceWithVariablesListPresenter.this.dataSetQueryHelperDomainSpecific.getColumnStringValue(dataSet, "varvalue", i);
                    for (ProcessInstanceSummary pis : instances) {
                        if (!pis.getProcessInstanceId().equals(processInstanceId)) continue;
                        pis.addDomainData(variableName, variableValue);
                        columns.add(variableName);
                    }
                }
                DataSetProcessInstanceWithVariablesListPresenter.this.view.addDomainSpecifColumns((ExtendedPagedTable<ProcessInstanceSummary>)DataSetProcessInstanceWithVariablesListPresenter.this.view.getListGrid(), columns);
                PageResponse processInstanceSummaryPageResponse = new PageResponse();
                processInstanceSummaryPageResponse.setPageRowList(instances);
                processInstanceSummaryPageResponse.setStartRowIndex(startRange);
                processInstanceSummaryPageResponse.setTotalRowSize(totalRowSize);
                processInstanceSummaryPageResponse.setTotalRowSizeExact(true);
                if (startRange + instances.size() == totalRowSize) {
                    processInstanceSummaryPageResponse.setLastPage(true);
                } else {
                    processInstanceSummaryPageResponse.setLastPage(false);
                }
                DataSetProcessInstanceWithVariablesListPresenter.this.updateDataOnCallback(processInstanceSummaryPageResponse);
            }

            public void notFound() {
                DataSetProcessInstanceWithVariablesListPresenter.this.view.hideBusyIndicator();
                DataSetProcessInstanceWithVariablesListPresenter.this.errorPopup.showMessage("Not found DataSet with UUID [  variables ] ");
                GWT.log((String)"DataSet with UUID [  variables ] not found.");
            }

            public boolean onError(ClientRuntimeError error) {
                DataSetProcessInstanceWithVariablesListPresenter.this.view.hideBusyIndicator();
                DataSetProcessInstanceWithVariablesListPresenter.this.errorPopup.showMessage("DataSet with UUID [  variables ] error: " + error.getThrowable());
                GWT.log((String)"DataSet with UUID [  variables ] error: ", (Throwable)error.getThrowable());
                return false;
            }
        };
    }

    protected DataSetReadyCallback createDataSetProcessInstanceCallback(final int startRange, final FilterSettings tableSettings) {
        return new DataSetReadyCallback(){

            public void notFound() {
                DataSetProcessInstanceWithVariablesListPresenter.this.view.hideBusyIndicator();
                DataSetProcessInstanceWithVariablesListPresenter.this.errorPopup.showMessage("Not found DataSet with UUID [  jbpmProcessInstances ] ");
                GWT.log((String)"DataSet with UUID [  jbpmProcessInstances ] not found.");
            }

            public boolean onError(ClientRuntimeError error) {
                DataSetProcessInstanceWithVariablesListPresenter.this.view.hideBusyIndicator();
                DataSetProcessInstanceWithVariablesListPresenter.this.errorPopup.showMessage("DataSet with UUID [  jbpmProcessInstances ] error: " + error.getThrowable());
                GWT.log((String)"DataSet with UUID [  jbpmProcessInstances ] error: ", (Throwable)error.getThrowable());
                return false;
            }

            public void callback(DataSet dataSet) {
                if (dataSet != null) {
                    ArrayList<ProcessInstanceSummary> myProcessInstancesFromDataSet = new ArrayList<ProcessInstanceSummary>();
                    for (int i = 0; i < dataSet.getRowCount(); ++i) {
                        myProcessInstancesFromDataSet.add(DataSetProcessInstanceWithVariablesListPresenter.this.createProcessInstanceSummaryFromDataSet(dataSet, i));
                    }
                    List ops = tableSettings.getDataSetLookup().getOperationList();
                    String filterValue = DataSetProcessInstanceWithVariablesListPresenter.this.isFilteredByProcessId(ops);
                    if (filterValue != null) {
                        DataSetProcessInstanceWithVariablesListPresenter.this.getDomainSpecifDataForProcessInstances(startRange, dataSet, filterValue, myProcessInstancesFromDataSet);
                    } else {
                        PageResponse processInstanceSummaryPageResponse = new PageResponse();
                        processInstanceSummaryPageResponse.setPageRowList(myProcessInstancesFromDataSet);
                        processInstanceSummaryPageResponse.setStartRowIndex(startRange);
                        processInstanceSummaryPageResponse.setTotalRowSize(dataSet.getRowCountNonTrimmed());
                        processInstanceSummaryPageResponse.setTotalRowSizeExact(true);
                        if (startRange + dataSet.getRowCount() == dataSet.getRowCountNonTrimmed()) {
                            processInstanceSummaryPageResponse.setLastPage(true);
                        } else {
                            processInstanceSummaryPageResponse.setLastPage(false);
                        }
                        DataSetProcessInstanceWithVariablesListPresenter.this.updateDataOnCallback(processInstanceSummaryPageResponse);
                    }
                }
                DataSetProcessInstanceWithVariablesListPresenter.this.view.hideBusyIndicator();
            }
        };
    }

    protected String isFilteredByProcessId(List<DataSetOp> ops) {
        for (DataSetOp dataSetOp : ops) {
            if (!dataSetOp.getType().equals((Object)DataSetOpType.FILTER)) continue;
            List filters = ((DataSetFilter)dataSetOp).getColumnFilterList();
            for (ColumnFilter filter : filters) {
                List parameters;
                if (!(filter instanceof CoreFunctionFilter)) continue;
                CoreFunctionFilter coreFilter = (CoreFunctionFilter)filter;
                if (!filter.getColumnId().toUpperCase().equals("processId".toUpperCase()) || (parameters = coreFilter.getParameters()).size() <= 0) continue;
                return parameters.get(0).toString();
            }
        }
        return null;
    }

    public void getDomainSpecifDataForProcessInstances(int startRange, DataSet dataSet, String filterValue, List<ProcessInstanceSummary> myProcessInstancesFromDataSet) {
        int rowCountNotTrimmed = dataSet.getRowCountNonTrimmed();
        FilterSettings variablesTableSettings = this.view.getVariablesTableSettings(filterValue);
        variablesTableSettings.setTablePageSize(-1);
        this.dataSetQueryHelperDomainSpecific.setDataSetHandler(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setCurrentTableSettings(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setLastOrderedColumn("pid");
        this.dataSetQueryHelperDomainSpecific.setLastSortOrder(SortOrder.ASCENDING);
        this.dataSetQueryHelperDomainSpecific.lookupDataSet(Integer.valueOf(0), this.createDataSetDomainSpecificCallback(startRange, rowCountNotTrimmed, myProcessInstancesFromDataSet));
    }

    private ProcessInstanceSummary createProcessInstanceSummaryFromDataSet(DataSet dataSet, int i) {
        return new ProcessInstanceSummary(this.dataSetQueryHelper.getColumnLongValue(dataSet, "processInstanceId", i).longValue(), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processId", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "externalId", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processName", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processVersion", i), this.dataSetQueryHelper.getColumnIntValue(dataSet, "status", i), this.dataSetQueryHelper.getColumnDateValue(dataSet, "start_date", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "user_identity", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processInstanceDescription", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "correlationKey", i), this.dataSetQueryHelper.getColumnLongValue(dataSet, "parentProcessInstanceId", i));
    }

    public void newInstanceCreated(@Observes NewProcessInstanceEvent pi) {
        this.refreshGrid();
    }

    public void newInstanceCreated(@Observes ProcessInstancesUpdateEvent pis) {
        this.refreshGrid();
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @OnFocus
    public void onFocus() {
        this.refreshGrid();
    }

    @OnOpen
    public void onOpen() {
        this.refreshGrid();
    }

    public void abortProcessInstance(long processInstanceId) {
        ((KieSessionEntryPoint)this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                DataSetProcessInstanceWithVariablesListPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).abortProcessInstance(processInstanceId);
    }

    public void abortProcessInstance(List<Long> processInstanceIds) {
        ((KieSessionEntryPoint)this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                DataSetProcessInstanceWithVariablesListPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).abortProcessInstances(processInstanceIds);
    }

    public void suspendProcessInstance(String processDefId, long processInstanceId) {
        ((KieSessionEntryPoint)this.kieSessionServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                DataSetProcessInstanceWithVariablesListPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ErrorPopup.showMessage((String)("Unexpected error encountered : " + throwable.getMessage()));
                return true;
            }
        })).suspendProcessInstance(processInstanceId);
    }

    public void bulkSignal(List<ProcessInstanceSummary> processInstances) {
        StringBuilder processIdsParam = new StringBuilder();
        if (processInstances != null) {
            for (ProcessInstanceSummary selected : processInstances) {
                if (selected.getState() != 1) {
                    this.view.displayNotification(this.constants.Signaling_Process_Instance_Not_Allowed() + "(id=" + selected.getId() + ")");
                    continue;
                }
                processIdsParam.append(selected.getId() + ",");
            }
            if (processIdsParam.length() > 0) {
                processIdsParam.deleteCharAt(processIdsParam.length() - 1);
            }
        } else {
            processIdsParam.append("-1");
        }
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
        placeRequestImpl.addParameter("processInstanceId", processIdsParam.toString());
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
        this.view.displayNotification(this.constants.Signaling_Process_Instance());
    }

    public void bulkAbort(List<ProcessInstanceSummary> processInstances) {
        if (processInstances != null && Window.confirm((String)"Are you sure that you want to abort the selected process instances?")) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (ProcessInstanceSummary selected : processInstances) {
                if (selected.getState() != 1) {
                    this.view.displayNotification(this.constants.Aborting_Process_Instance_Not_Allowed() + "(id=" + selected.getId() + ")");
                    continue;
                }
                ids.add(selected.getProcessInstanceId());
                this.view.displayNotification(this.constants.Aborting_Process_Instance() + "(id=" + selected.getId() + ")");
            }
            this.abortProcessInstance(ids);
        }
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Process_Instances();
    }

    @WorkbenchPartView
    public UberView<DataSetProcessInstanceWithVariablesListPresenter> getView() {
        return this.view;
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.New_Process_Instance()).respondsWith(new Command(){

            public void execute() {
                DataSetProcessInstanceWithVariablesListPresenter.this.newProcessInstancePopup.show();
            }
        })).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        DataSetProcessInstanceWithVariablesListPresenter.this.menuRefreshButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent clickEvent) {
                                DataSetProcessInstanceWithVariablesListPresenter.this.refreshGrid();
                            }
                        });
                        return DataSetProcessInstanceWithVariablesListPresenter.this.menuRefreshButton;
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.pr.client.editors.instance.list.ProcessInstanceListPresenter#menuRefreshButton";
                    }
                };
            }
        }).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.refreshSelectorMenuBuilder).endMenu()).newTopLevelCustomMenu(new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        DataSetProcessInstanceWithVariablesListPresenter.this.menuResetTabsButton.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent clickEvent) {
                                DataSetProcessInstanceWithVariablesListPresenter.this.view.restoreTabs();
                            }
                        });
                        return DataSetProcessInstanceWithVariablesListPresenter.this.menuResetTabsButton;
                    }

                    public boolean isEnabled() {
                        return true;
                    }

                    public void setEnabled(boolean enabled) {
                    }

                    public String getSignatureId() {
                        return "org.jbpm.console.ng.pr.client.editors.instance.list.ProcessInstanceList#menuResetTabsButton";
                    }
                };
            }
        }).endMenu()).build();
    }

    public void onGridPreferencesStoreLoaded() {
        this.refreshSelectorMenuBuilder.loadOptions(this.view.getRefreshValue());
    }

    protected void updateRefreshInterval(boolean enableAutoRefresh, int newInterval) {
        super.updateRefreshInterval(enableAutoRefresh, newInterval);
        this.view.saveRefreshValue(newInterval);
    }

    protected void onSearchEvent(@Observes SearchEvent searchEvent) {
        this.textSearchStr = searchEvent.getFilter();
        if (this.textSearchStr != null && this.textSearchStr.trim().length() > 0) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("textSearch", this.textSearchStr);
            this.dataSetQueryHelper.getCurrentTableSettings().getKey();
            this.view.applyFilterOnPresenter(this.dataSetQueryHelper.getCurrentTableSettings().getKey());
        }
    }

    public static interface DataSetProcessInstanceWithVariablesListView
    extends AbstractListView.ListView<ProcessInstanceSummary, DataSetProcessInstanceWithVariablesListPresenter> {
        public int getRefreshValue();

        public void restoreTabs();

        public void saveRefreshValue(int var1);

        public FilterSettings getVariablesTableSettings(String var1);

        public void addDomainSpecifColumns(ExtendedPagedTable<ProcessInstanceSummary> var1, Set<String> var2);

        public void applyFilterOnPresenter(String var1);
    }
}

