/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.pr.backend.server.VariableHelper;
import org.jbpm.console.ng.pr.model.DocumentKey;
import org.jbpm.console.ng.pr.model.DocumentSummary;
import org.jbpm.console.ng.pr.model.ProcessVariableSummary;
import org.jbpm.console.ng.pr.service.DocumentsService;
import org.jbpm.document.Document;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class DocumentsServiceImpl
implements DocumentsService {
    @Inject
    private RuntimeDataService dataService;
    @Inject
    private DefinitionService bpmn2Service;
    @Inject
    private ProcessService processService;

    public PageResponse<DocumentSummary> getData(QueryFilter filter) {
        PageResponse response = new PageResponse();
        Long processInstanceId = null;
        String processId = "";
        String deploymentId = "";
        if (filter.getParams() != null) {
            processInstanceId = Long.valueOf((String)filter.getParams().get("processInstanceId"));
            processId = (String)filter.getParams().get("processDefId");
            deploymentId = (String)filter.getParams().get("deploymentId");
        }
        org.kie.internal.query.QueryFilter qf = new org.kie.internal.query.QueryFilter(filter.getOffset().intValue(), filter.getCount() + 1, filter.getOrderBy(), filter.isAscending().booleanValue());
        HashMap<String, String> properties = new HashMap<String, String>(this.bpmn2Service.getProcessVariables(deploymentId, processId));
        Collection<ProcessVariableSummary> processVariables = VariableHelper.adaptCollection(this.dataService.getVariablesCurrentState(processInstanceId.longValue()), properties, processInstanceId);
        ArrayList<DocumentSummary> documents = new ArrayList<DocumentSummary>();
        for (ProcessVariableSummary pv : processVariables) {
            Document document;
            if (!"org.jbpm.document.Document".equals(pv.getType()) || (document = (Document)this.processService.getProcessInstanceVariable(processInstanceId, pv.getName())) == null) continue;
            documents.add(new DocumentSummary(document.getName(), document.getLastModified(), Long.valueOf(document.getSize()), document.getLink()));
        }
        response.setStartRowIndex(filter.getOffset().intValue());
        response.setTotalRowSize(documents.size() - 1);
        if (documents.size() > filter.getCount()) {
            response.setTotalRowSizeExact(false);
        } else {
            response.setTotalRowSizeExact(true);
        }
        if (!documents.isEmpty() && documents.size() > filter.getCount() + filter.getOffset()) {
            response.setPageRowList(new ArrayList(documents.subList(filter.getOffset(), filter.getOffset() + filter.getCount())));
            response.setLastPage(false);
        } else {
            response.setPageRowList(new ArrayList(documents));
            response.setLastPage(true);
        }
        return response;
    }

    public DocumentSummary getItem(DocumentKey key) {
        return null;
    }
}

