/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.backend;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefFactory;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.DataSetPreprocessor;
import org.dashbuilder.dataset.impl.SQLDataSetDefBuilderImpl;
import org.jbpm.dashboard.renderer.backend.DeploymentIdsPreprocessor;
import org.jbpm.persistence.settings.JpaSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.Startup;

@Startup
@ApplicationScoped
public class DataSetDefsBootstrap {
    private static final Logger logger = LoggerFactory.getLogger(DataSetDefsBootstrap.class);
    public static final String PROCESS_INSTANCE_TABLE = "ProcessInstanceLog";
    public static final String TASKS_MONITORING_DATASET = "tasksMonitoring";
    public static final String PROCESSES_MONITORING_DATASET = "processesMonitoring";
    @Inject
    DataSetDefRegistry dataSetDefRegistry;
    @Inject
    DeploymentIdsPreprocessor deploymentIdsPreprocessor;
    JpaSettings jpaSettings = JpaSettings.get();

    @PostConstruct
    protected void registerDataSetDefinitions() {
        String jbpmDataSource = this.jpaSettings.getDataSourceJndiName();
        DataSetDef processMonitoringDef = ((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)DataSetDefFactory.newSQLDataSetDef().uuid(PROCESSES_MONITORING_DATASET)).name("Processes monitoring")).dataSource(jbpmDataSource).dbTable(PROCESS_INSTANCE_TABLE, true).buildDef();
        DataSetDef taskMonitoringDef = ((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)DataSetDefFactory.newSQLDataSetDef().uuid(TASKS_MONITORING_DATASET)).name("Tasks monitoring")).dataSource(jbpmDataSource).dbSQL("select p.processName, p.externalId, t.* from ProcessInstanceLog p inner join BAMTaskSummary t on (t.processInstanceId = p.processInstanceId) inner join (select min(pk) as pk from BAMTaskSummary group by taskId) d on t.pk = d.pk", true).buildDef();
        processMonitoringDef.setPublic(false);
        taskMonitoringDef.setPublic(false);
        this.dataSetDefRegistry.registerDataSetDef(processMonitoringDef);
        this.dataSetDefRegistry.registerDataSetDef(taskMonitoringDef);
        logger.info("Process dashboard datasets registered");
        this.dataSetDefRegistry.registerPreprocessor(PROCESSES_MONITORING_DATASET, (DataSetPreprocessor)this.deploymentIdsPreprocessor);
        this.dataSetDefRegistry.registerPreprocessor(TASKS_MONITORING_DATASET, (DataSetPreprocessor)this.deploymentIdsPreprocessor);
    }
}

