/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.ClassObjectFilter;
import org.drools.core.command.impl.RegistryContext;
import org.jbpm.casemgmt.api.CaseNotFoundException;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.casemgmt.impl.model.instance.CaseFileInstanceImpl;
import org.jbpm.services.api.ProcessService;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReopenCaseCommand
extends CaseCommand<Void> {
    private static final long serialVersionUID = 6811181095390934146L;
    private static final Logger logger = LoggerFactory.getLogger(ReopenCaseCommand.class);
    private static CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
    private String caseId;
    private String deploymentId;
    private String caseDefinitionId;
    private Map<String, Object> data;
    private transient ProcessService processService;

    public ReopenCaseCommand(String caseId, String deploymentId, String caseDefinitionId, Map<String, Object> data, ProcessService processService) {
        this.caseId = caseId;
        this.deploymentId = deploymentId;
        this.caseDefinitionId = caseDefinitionId;
        this.data = data;
        this.processService = processService;
    }

    public Void execute(Context context) {
        CaseEventSupport caseEventSupport = this.getCaseEventSupport(context);
        caseEventSupport.fireBeforeCaseReopened(this.caseId, this.deploymentId, this.caseDefinitionId, this.data);
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        logger.debug("Updating case file in working memory");
        Collection caseFiles = ksession.getObjects((ObjectFilter)new ClassObjectFilter(CaseFileInstance.class));
        if (caseFiles.size() == 0) {
            throw new CaseNotFoundException("Case with id " + this.caseId + " was not found");
        }
        CaseFileInstance caseFile = (CaseFileInstance)caseFiles.iterator().next();
        FactHandle factHandle = ksession.getFactHandle((Object)caseFile);
        ((CaseFileInstanceImpl)caseFile).setCaseReopenDate(new Date());
        if (this.data != null && !this.data.isEmpty()) {
            caseFile.addAll(this.data);
        }
        ksession.update(factHandle, (Object)caseFile);
        logger.debug("Starting process instance for case {} and case definition {}", (Object)this.caseId, (Object)this.caseDefinitionId);
        CorrelationKey correlationKey = correlationKeyFactory.newCorrelationKey(this.caseId);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("CaseId", this.caseId);
        long processInstanceId = this.processService.startProcess(this.deploymentId, this.caseDefinitionId, correlationKey, params);
        logger.debug("Case {} successfully reopened (process instance id {})", (Object)this.caseId, (Object)processInstanceId);
        caseEventSupport.fireAfterCaseReopened(this.caseId, this.deploymentId, this.caseDefinitionId, this.data, processInstanceId);
        return null;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }
}

