/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.model.instance;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jbpm.casemgmt.api.model.CaseRole;
import org.jbpm.casemgmt.api.model.instance.CaseFileDataFilter;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseRoleInstance;
import org.jbpm.casemgmt.api.model.instance.CommentInstance;
import org.jbpm.casemgmt.impl.model.instance.CaseRoleInstanceImpl;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.internal.process.CaseAssignment;

public class CaseFileInstanceImpl
implements CaseFileInstance,
CaseAssignment,
Serializable {
    private static final long serialVersionUID = -4161603356119857561L;
    private String separator = System.getProperty("org.jbpm.ht.user.separator", ",");
    private String caseId;
    private Date caseStartDate;
    private Date caseEndDate;
    private Date caseReopenDate;
    private Map<String, Object> data = new HashMap<String, Object>();
    private Map<String, CaseRoleInstance> roles = new HashMap<String, CaseRoleInstance>();
    private List<CommentInstance> comments = new ArrayList<CommentInstance>();

    public CaseFileInstanceImpl() {
    }

    public CaseFileInstanceImpl(String caseId) {
        this.caseId = caseId;
        this.caseStartDate = new Date();
    }

    public CaseFileInstanceImpl(Map<String, Object> data) {
        this.data = data;
        this.caseStartDate = new Date();
    }

    public CaseFileInstanceImpl(String caseId, Map<String, Object> data) {
        this.caseId = caseId;
        this.data = data;
        this.caseStartDate = new Date();
    }

    public String getCaseId() {
        return this.caseId;
    }

    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    public Date getCaseStartDate() {
        return this.caseStartDate;
    }

    public Date getCaseEndDate() {
        return this.caseEndDate;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public Map<String, Object> getData(CaseFileDataFilter filter) {
        this.data.entrySet().stream().filter(p -> filter.accept((String)p.getKey(), p.getValue())).collect(Collectors.toMap(p -> (String)p.getKey(), p -> p.getValue()));
        return null;
    }

    public void addAll(Map<String, Object> data) {
        this.data.putAll(data);
    }

    public void add(String name, Object data) {
        this.data.put(name, data);
    }

    public void remove(String name) {
        this.data.remove(name);
    }

    public void remove(CaseFileDataFilter filter) {
        Map<String, Object> collect = this.getData(filter);
        collect.keySet().forEach(key -> this.data.remove(key));
    }

    public void removeAll() {
        this.data.clear();
    }

    public Object getData(String name) {
        return this.data.get(name);
    }

    public void setCaseEndDate(Date caseEndDate) {
        this.caseEndDate = caseEndDate;
    }

    public Date getCaseReopenDate() {
        return this.caseReopenDate;
    }

    public void setCaseReopenDate(Date caseReopenDate) {
        this.caseReopenDate = caseReopenDate;
    }

    public void assign(String roleName, OrganizationalEntity entity) {
        CaseRoleInstance caseRoleInstance = this.roles.get(roleName);
        if (caseRoleInstance == null) {
            throw new IllegalArgumentException("No role with name " + roleName + " was found");
        }
        ((CaseRoleInstanceImpl)caseRoleInstance).addRoleAssignment(entity);
    }

    public void remove(String roleName, OrganizationalEntity entity) {
        CaseRoleInstance caseRoleInstance = this.roles.get(roleName);
        if (caseRoleInstance != null) {
            ((CaseRoleInstanceImpl)caseRoleInstance).removeRoleAssignment(entity);
        }
    }

    public Collection<OrganizationalEntity> getAssignments(String roleName) {
        String[] roleNames = roleName.split(this.separator);
        ArrayList<OrganizationalEntity> foundAssignments = new ArrayList<OrganizationalEntity>();
        for (String role : roleNames) {
            CaseRoleInstance caseRoleInstance = this.roles.get(role);
            if (caseRoleInstance == null) {
                throw new IllegalArgumentException("No role with name " + role + " was found");
            }
            foundAssignments.addAll(caseRoleInstance.getRoleAssignments());
        }
        return foundAssignments;
    }

    public Collection<CaseRoleInstance> getAssignments() {
        return Collections.unmodifiableCollection(this.roles.values());
    }

    public void setupRoles(Collection<CaseRole> roles) {
        if (roles != null) {
            roles.stream().forEach(r -> this.roles.put(r.getName(), new CaseRoleInstanceImpl(r.getName(), r.getCardinality())));
        }
    }

    public Map<String, CaseRoleInstance> getRolesAssignments() {
        return this.roles;
    }

    public void setRolesAssignments(Map<String, CaseRoleInstance> roles) {
        this.roles = roles;
    }

    public Collection<CommentInstance> getComments() {
        return Collections.unmodifiableCollection(this.comments);
    }

    public void addComment(CommentInstance comment) {
        this.comments.add(comment);
    }

    public void removeComment(CommentInstance comment) {
        this.comments.remove(comment);
    }

    public void setCaseStartDate(Date caseStartDate) {
        this.caseStartDate = caseStartDate;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public void setComments(List<CommentInstance> comments) {
        this.comments = comments;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.caseEndDate == null ? 0 : this.caseEndDate.hashCode());
        result = 31 * result + (this.caseId == null ? 0 : this.caseId.hashCode());
        result = 31 * result + (this.caseStartDate == null ? 0 : this.caseStartDate.hashCode());
        result = 31 * result + (this.caseReopenDate == null ? 0 : this.caseReopenDate.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CaseFileInstanceImpl other = (CaseFileInstanceImpl)obj;
        if (this.caseEndDate == null ? other.caseEndDate != null : !this.caseEndDate.equals(other.caseEndDate)) {
            return false;
        }
        if (this.caseId == null ? other.caseId != null : !this.caseId.equals(other.caseId)) {
            return false;
        }
        if (this.caseStartDate == null ? other.caseStartDate != null : !this.caseStartDate.equals(other.caseStartDate)) {
            return false;
        }
        if (this.caseReopenDate == null ? other.caseReopenDate != null : !this.caseReopenDate.equals(other.caseReopenDate)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }
}

