/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.HashMap;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.services.api.ProcessService;
import org.kie.api.KieServices;
import org.kie.api.command.KieCommands;
import org.kie.internal.KieInternalServices;
import org.kie.internal.command.Context;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.runtime.manager.context.CaseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartCaseCommand
extends CaseCommand<Void> {
    private static final long serialVersionUID = 6811181095390934146L;
    private static final Logger logger = LoggerFactory.getLogger(StartCaseCommand.class);
    private static CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
    private static KieCommands commandsFactory = KieServices.Factory.get().getCommands();
    private String caseId;
    private String deploymentId;
    private String caseDefinitionId;
    private CaseFileInstance caseFile;
    private transient ProcessService processService;

    public StartCaseCommand(String caseId, String deploymentId, String caseDefinitionId, CaseFileInstance caseFile, ProcessService processService) {
        this.caseId = caseId;
        this.deploymentId = deploymentId;
        this.caseDefinitionId = caseDefinitionId;
        this.caseFile = caseFile;
        this.processService = processService;
    }

    public Void execute(Context context) {
        CaseEventSupport caseEventSupport = this.getCaseEventSupport(context);
        caseEventSupport.fireBeforeCaseStarted(this.caseId, this.deploymentId, this.caseDefinitionId, this.caseFile);
        logger.debug("Inserting case file into working memory");
        this.processService.execute(this.deploymentId, (org.kie.api.runtime.manager.Context)CaseContext.get((String)this.caseId), commandsFactory.newInsert((Object)this.caseFile));
        logger.debug("Starting process instance for case {} and case definition {}", (Object)this.caseId, (Object)this.caseDefinitionId);
        CorrelationKey correlationKey = correlationKeyFactory.newCorrelationKey(this.caseId);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("CaseId", this.caseId);
        long processInstanceId = this.processService.startProcess(this.deploymentId, this.caseDefinitionId, correlationKey, params);
        logger.debug("Case {} successfully started (process instance id {})", (Object)this.caseId, (Object)processInstanceId);
        caseEventSupport.fireAfterCaseStarted(this.caseId, this.deploymentId, this.caseDefinitionId, this.caseFile, processInstanceId);
        return null;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }
}

