/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TransactionRequiredException;
import javax.transaction.UserTransaction;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.runtime.process.InternalProcessRuntime;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAWorkingMemoryDbLogger
extends AbstractAuditLogger {
    private static final Logger logger = LoggerFactory.getLogger(JPAWorkingMemoryDbLogger.class);
    private static final String[] KNOWN_UT_JNDI_KEYS = new String[]{"UserTransaction", "java:jboss/UserTransaction", System.getProperty("jbpm.ut.jndi.lookup")};
    private boolean isJTA = true;
    private boolean sharedEM = false;
    private EntityManagerFactory emf;

    public JPAWorkingMemoryDbLogger(WorkingMemory workingMemory) {
        super(workingMemory);
        InternalProcessRuntime processRuntime = ((InternalWorkingMemory)workingMemory).getProcessRuntime();
        if (processRuntime != null) {
            processRuntime.addEventListener((ProcessEventListener)this);
        }
    }

    public JPAWorkingMemoryDbLogger(KieSession session) {
        super(session);
        Boolean bool = (Boolean)this.env.get("IS_JTA_TRANSACTION");
        if (bool != null) {
            this.isJTA = bool;
        }
        session.addEventListener((ProcessEventListener)this);
    }

    public JPAWorkingMemoryDbLogger(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        NodeInstanceLog log = (NodeInstanceLog)this.builder.buildEvent(event);
        this.persist(log);
    }

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
        NodeInstanceLog log = (NodeInstanceLog)this.builder.buildEvent(event, null);
        this.persist(log);
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        VariableInstanceLog log = (VariableInstanceLog)this.builder.buildEvent(event);
        this.persist(log);
    }

    public void beforeProcessStarted(ProcessStartedEvent event) {
        ProcessInstanceLog log = (ProcessInstanceLog)this.builder.buildEvent(event);
        this.persist(log);
        ((ProcessInstanceImpl)event.getProcessInstance()).getMetaData().put("ProcessInstanceLog", log);
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        List result;
        long processInstanceId = event.getProcessInstance().getId();
        EntityManager em = this.getEntityManager();
        UserTransaction ut = this.joinTransaction(em);
        ProcessInstanceLog log = (ProcessInstanceLog)((ProcessInstanceImpl)event.getProcessInstance()).getMetaData().get("ProcessInstanceLog");
        if (log == null && (result = em.createQuery("from ProcessInstanceLog as log where log.processInstanceId = :piId and log.end is null").setParameter("piId", (Object)processInstanceId).getResultList()) != null && result.size() != 0) {
            log = (ProcessInstanceLog)result.get(result.size() - 1);
        }
        if (log != null) {
            log = (ProcessInstanceLog)this.builder.buildEvent(event, (Object)log);
            em.merge((Object)log);
        }
        if (!this.sharedEM) {
            JPAWorkingMemoryDbLogger.flush(em, ut);
        }
    }

    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
    }

    public void dispose() {
    }

    private EntityManager getEntityManager() {
        if (this.env != null) {
            EntityManager em = (EntityManager)this.env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager");
            if (em != null) {
                this.sharedEM = true;
                return em;
            }
            EntityManagerFactory emf = (EntityManagerFactory)this.env.get("org.kie.api.persistence.jpa.EntityManagerFactory");
            if (emf != null) {
                return emf.createEntityManager();
            }
        } else {
            return this.emf.createEntityManager();
        }
        throw new RuntimeException("Could not find EntityManager, both command-scoped EM and EMF in environment are null");
    }

    private void persist(Object entity) {
        EntityManager em = this.getEntityManager();
        UserTransaction ut = this.joinTransaction(em);
        em.persist(entity);
        if (!this.sharedEM) {
            JPAWorkingMemoryDbLogger.flush(em, ut);
        }
    }

    private UserTransaction joinTransaction(EntityManager em) {
        boolean newTx = false;
        UserTransaction ut = null;
        if (this.isJTA) {
            block7: {
                try {
                    em.joinTransaction();
                }
                catch (TransactionRequiredException e) {
                    ut = JPAWorkingMemoryDbLogger.findUserTransaction();
                    try {
                        if (ut != null && ut.getStatus() == 6) {
                            ut.begin();
                            newTx = true;
                            em.joinTransaction();
                        }
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Unable to find or open a transaction: " + ex.getMessage(), ex);
                    }
                    if (newTx) break block7;
                    throw e;
                }
            }
            if (newTx) {
                return ut;
            }
        }
        return null;
    }

    private static void flush(EntityManager em, UserTransaction ut) {
        em.flush();
        em.clear();
        em.close();
        try {
            if (ut != null) {
                ut.commit();
            }
        }
        catch (Exception e) {
            logger.error("Unable to commit transaction: ", (Throwable)e);
        }
    }

    protected static UserTransaction findUserTransaction() {
        InitialContext context = null;
        try {
            context = new InitialContext();
            return (UserTransaction)context.lookup("java:comp/UserTransaction");
        }
        catch (NamingException ex) {
            for (String utLookup : KNOWN_UT_JNDI_KEYS) {
                if (utLookup == null) continue;
                try {
                    UserTransaction ut = (UserTransaction)context.lookup(utLookup);
                    return ut;
                }
                catch (NamingException e) {
                    logger.debug("User Transaction not found in JNDI under {}", (Object)utLookup);
                }
            }
            logger.warn("No user transaction found under known names");
            return null;
        }
    }
}

