/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.vimeo;

import com.clickntap.vimeo.Vimeo;
import com.clickntap.vimeo.VimeoResponse;
import java.util.HashMap;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.vimeo.SerializableVimeoResponse;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="GetInfoVimeoDefinitions.wid", name="GetInfoVimeo", displayName="GetInfoVimeo", defaultHandler="mvel: new org.jbpm.process.workitem.vimeo.GetVideoInfoWorkitemHandler(\"accessToken\")", documentation="vimeo-workitem/index.html", category="vimeo-workitem", icon="GetInfoVimeo.png", parameters={@WidParameter(name="VideoEndpoint", required=true)}, results={@WidResult(name="VideoInfo", runtimeType="org.jbpm.process.workitem.vimeo.SerializableVimeoResponse")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="vimeo-workitem", version="7.43.0.Final")}, serviceInfo=@WidService(category="Vimeo", description="Interact with videos on Vimeo", keywords="vimeo,video,get,info", action=@WidAction(title="Get info for existing video"), authinfo=@WidAuth(required=true, params={"accessToken"}, paramsdescription={"Vimeo access token"}, referencesite="https://developer.vimeo.com/api/authentication")))
public class GetVideoInfoWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String accessToken;
    public static final String RESULT = "VideoInfo";

    public GetVideoInfoWorkitemHandler(String accessToken) {
        this.accessToken = accessToken;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String videoEndPoint = (String)workItem.getParameter("VideoEndpoint");
            Vimeo vimeo = (Vimeo)workItem.getParameter("Vimeo");
            HashMap<String, SerializableVimeoResponse> results = new HashMap<String, SerializableVimeoResponse>();
            if (vimeo == null) {
                vimeo = new Vimeo(this.accessToken);
            }
            VimeoResponse vimeoResponse = vimeo.getVideoInfo(videoEndPoint);
            SerializableVimeoResponse serializableVimeoResponse = new SerializableVimeoResponse(vimeoResponse);
            results.put(RESULT, serializableVimeoResponse);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }
}

