/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.rss;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="RSSDefinitions.wid", name="RSS", displayName="RSS", defaultHandler="mvel: new org.jbpm.process.workitem.rss.RSSWorkItemHandler()", documentation="rss-workitem/index.html", category="rss-workitem", icon="RSS.png", parameters={@WidParameter(name="URL", required=true)}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="rss-workitem", version="7.62.0.Final")}, serviceInfo=@WidService(category="RSS", description="Create RSS feeds", keywords="rss,feed,create", action=@WidAction(title="Create a RSS feed from multiple sources"), authinfo=@WidAuth))
public class RSSWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private List<SyndFeed> feeds = new ArrayList<SyndFeed>();
    private SyndFeedInput input;

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            ArrayList<String> urls = new ArrayList<String>();
            String urlsList = (String)workItem.getParameter("URL");
            for (String s : urlsList.split(";")) {
                if (s == null || "".equals(s)) continue;
                urls.add(s);
            }
            for (String url : urls) {
                URL feedSource = new URL(url);
                if (this.input == null) {
                    this.input = new SyndFeedInput();
                }
                SyndFeed feed = this.input.build((Reader)new XmlReader(feedSource));
                this.feeds.add(feed);
            }
            manager.completeWorkItem(workItem.getId(), null);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public List<SyndFeed> getFeeds() {
        return this.feeds;
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setInput(SyndFeedInput input) {
        this.input = input;
    }
}

