/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.riot;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import net.rithms.riot.api.endpoints.match.dto.Match;
import net.rithms.riot.api.endpoints.match.dto.MatchReference;
import net.rithms.riot.constant.Platform;

public class RiotUtils {
    private static Comparator<MatchReference> matchTimestampComparator = Comparator.comparing(MatchReference::getTimestamp);
    private static Comparator<Match> matchCreationpComparator = Comparator.comparing(Match::getGameCreation);

    public static Platform getPlatform(String summonerPlatform) throws IllegalArgumentException {
        if (summonerPlatform != null && summonerPlatform.length() > 0) {
            try {
                return Platform.getPlatformByName((String)summonerPlatform);
            }
            catch (NoSuchElementException e) {
                throw new IllegalArgumentException("Unable to create platform from: " + summonerPlatform);
            }
        }
        return Platform.EUW;
    }

    public static MatchReference getLatestPlayedMatch(List<MatchReference> playedMatchesList) {
        Collections.sort(playedMatchesList, matchTimestampComparator);
        return playedMatchesList.get(0);
    }

    public static List<MatchReference> geNumberOfPlayedMatches(List<MatchReference> playedMatchesList, int numOfMatches) {
        Collections.sort(playedMatchesList, matchTimestampComparator);
        if (numOfMatches >= playedMatchesList.size()) {
            return playedMatchesList;
        }
        return playedMatchesList.subList(0, numOfMatches);
    }

    public static List<Match> getPlayedMatches(List<Match> playedMatchesList, int numOfMatches) {
        Collections.sort(playedMatchesList, matchCreationpComparator);
        if (numOfMatches >= playedMatchesList.size()) {
            return playedMatchesList;
        }
        return playedMatchesList.subList(0, numOfMatches);
    }
}

