/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.google.sheets;

import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.ValueRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.google.sheets.GoogleSheetsAuth;
import org.jbpm.process.workitem.google.sheets.ReadSheetValuesWorkitemHandler;
import org.jbpm.test.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GoogleSheetsWorkitemHandlerTest
extends AbstractBaseTest {
    @Mock
    GoogleSheetsAuth auth;
    @Mock
    Sheets sheetsClient;
    @Mock
    Sheets.Spreadsheets spreadsheets;
    @Mock
    Sheets.Spreadsheets.Values spreasheetsValues;
    @Mock
    Sheets.Spreadsheets.Values.Get spreasheetsValuesGet;

    @Before
    public void setUp() {
        try {
            ValueRange valueRange = new ValueRange();
            ArrayList testValues = new ArrayList();
            ArrayList<String> testRowValues = new ArrayList<String>();
            testRowValues.add("testValueOne");
            testRowValues.add("testValueTwo");
            testValues.add(testRowValues);
            valueRange.setValues(testValues);
            Mockito.when((Object)this.auth.getSheetsService(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.sheetsClient);
            Mockito.when((Object)this.sheetsClient.spreadsheets()).thenReturn((Object)this.spreadsheets);
            Mockito.when((Object)this.spreadsheets.values()).thenReturn((Object)this.spreasheetsValues);
            Mockito.when((Object)this.spreasheetsValues.get(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.spreasheetsValuesGet);
            Mockito.when((Object)this.spreasheetsValuesGet.execute()).thenReturn((Object)valueRange);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testReadSheetValues() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("SheetId", (Object)"testSheetId");
        workItem.setParameter("Range", (Object)"Class Data!A2:E");
        ReadSheetValuesWorkitemHandler handler = new ReadSheetValuesWorkitemHandler("testAppName", "{}");
        handler.setAuth(this.auth);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertTrue((boolean)(((Map)manager.getResults().get(workItem.getId())).get("SheetValues") instanceof List));
        List returnValues = (List)((Map)manager.getResults().get(workItem.getId())).get("SheetValues");
        Assert.assertNotNull((Object)returnValues);
        Assert.assertEquals((Object)"testValueOne", ((List)returnValues.get(0)).get(0));
        Assert.assertEquals((Object)"testValueTwo", ((List)returnValues.get(0)).get(1));
    }
}

