/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workitem.google.maps;

import com.google.maps.GeoApiContext;
import com.google.maps.GeocodingApi;
import com.google.maps.GeocodingApiRequest;
import com.google.maps.model.GeocodingResult;
import com.google.maps.model.LatLng;
import com.google.maps.model.LocationType;
import java.util.HashMap;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.workitem.google.maps.GoogleMapsAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GoogleMapsGeocodingDefinitions.wid", name="GoogleMapsGeocoding", displayName="GoogleMapsGeocoding", defaultHandler="mvel: new org.jbpm.process.workitem.google.maps.GeocodingWorkitemHandler(\"apiKey\")", documentation="google-maps-workitem/index.html", category="google-maps-workitem", icon="GoogleMapsGeocoding.png", parameters={@WidParameter(name="SearchType", required=true), @WidParameter(name="SearchLocation", required=true), @WidParameter(name="Bounds"), @WidParameter(name="LocationType")}, results={@WidResult(name="GeocodingResults", runtimeType="com.google.maps.model.GeocodingResult")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="google-maps-workitem", version="7.57.0.Final")}, serviceInfo=@WidService(category="Google Maps", description="Interact with Google Maps Services", keywords="google,maps,geocoding,locations", action=@WidAction(title="Get geocoding information using Google Maps"), authinfo=@WidAuth(required=true, params={"apiKey"}, paramsdescription={"Google maps api key"}, referencesite="https://developers.google.com/maps/premium/previous-licenses/clientside/auth")))
public class GeocodingWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String apiKey;
    private GeoApiContext geoApiContext;
    private GoogleMapsAuth auth = new GoogleMapsAuth();
    private static final String RESULTS_VALUE = "GeocodingResults";
    private static final Logger logger = LoggerFactory.getLogger(GeocodingWorkitemHandler.class);

    public GeocodingWorkitemHandler(String apiKey) throws Exception {
        this.apiKey = apiKey;
        try {
            this.geoApiContext = this.auth.authorize(apiKey);
        }
        catch (Exception e) {
            throw new IllegalAccessException("Unable to authenticate with google maps: " + e.getMessage());
        }
    }

    public GeocodingWorkitemHandler(GeoApiContext geoApiContext) {
        this.geoApiContext = geoApiContext;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        String searchType = (String)workItem.getParameter("SearchType");
        String searchLocation = (String)workItem.getParameter("SearchLocation");
        String bounds = (String)workItem.getParameter("Bounds");
        String[] locationType = (String[])workItem.getParameter("LocationType");
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            GeocodingApiRequest geocodingApiRequest = GeocodingApi.newRequest((GeoApiContext)this.geoApiContext);
            HashMap<String, GeocodingResult[]> results = new HashMap<String, GeocodingResult[]>();
            switch (searchType) {
                case "byaddress": {
                    geocodingApiRequest = geocodingApiRequest.address(searchLocation);
                    break;
                }
                case "byplaceid": {
                    geocodingApiRequest = geocodingApiRequest.place(searchLocation);
                    break;
                }
                case "bylatlong": {
                    try {
                        String[] searchLocationParts = searchLocation.split(",");
                        geocodingApiRequest = geocodingApiRequest.latlng(new LatLng(Double.parseDouble(searchLocationParts[0]), Double.parseDouble(searchLocationParts[1])));
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Unable to perform search by latlong - invalid location: " + searchLocation);
                    }
                }
                default: {
                    geocodingApiRequest = geocodingApiRequest.address(searchLocation);
                }
            }
            if (bounds != null && bounds.length() > 0) {
                String[] boundsParts = bounds.split(",");
                if (boundsParts.length == 4) {
                    try {
                        geocodingApiRequest = geocodingApiRequest.bounds(new LatLng(Double.parseDouble(boundsParts[0]), Double.parseDouble(boundsParts[1])), new LatLng(Double.parseDouble(boundsParts[2]), Double.parseDouble(boundsParts[3])));
                    }
                    catch (NumberFormatException e) {
                        logger.error("Invalid bounds format: " + bounds + ". Valid example could be: 34.172684,-118.604794,34.236144,-118.500938");
                    }
                } else {
                    logger.error("Invalid bounds: " + bounds + ". Valid example could be: 34.172684,-118.604794,34.236144,-118.500938");
                }
            }
            if (locationType != null) {
                switch (locationType) {
                    case "rooftop": {
                        geocodingApiRequest = geocodingApiRequest.locationType(new LocationType[]{LocationType.ROOFTOP});
                        break;
                    }
                    case "approximate": {
                        geocodingApiRequest = geocodingApiRequest.locationType(new LocationType[]{LocationType.APPROXIMATE});
                        break;
                    }
                    case "range": {
                        geocodingApiRequest = geocodingApiRequest.locationType(new LocationType[]{LocationType.RANGE_INTERPOLATED});
                        break;
                    }
                    case "center": {
                        geocodingApiRequest = geocodingApiRequest.locationType(new LocationType[]{LocationType.GEOMETRIC_CENTER});
                        break;
                    }
                }
            }
            GeocodingResult[] geocodingResults = (GeocodingResult[])geocodingApiRequest.await();
            results.put(RESULTS_VALUE, geocodingResults);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }
}

