/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workitem.google.maps;

import com.google.maps.GeoApiContext;
import com.google.maps.ImageResult;
import com.google.maps.StaticMapsApi;
import com.google.maps.StaticMapsRequest;
import com.google.maps.model.Size;
import java.util.HashMap;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.workitem.google.maps.GoogleMapsAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="GoogleMapsStaticMapsDefinitions.wid", name="GoogleMapsStaticMaps", displayName="GoogleMapsStaticMaps", defaultHandler="mvel: new org.jbpm.process.workitem.google.maps.StaticMapsWorkitemHandler(\"apiKey\")", documentation="google-maps-workitem/index.html", category="google-maps-workitem", icon="GoogleMapsStaticMaps.png", parameters={@WidParameter(name="Width", required=true), @WidParameter(name="Height", required=true), @WidParameter(name="CenterLocation", required=true), @WidParameter(name="Zoom"), @WidParameter(name="Scale"), @WidParameter(name="MapType"), @WidParameter(name="Markers")}, results={@WidResult(name="StaticMap", runtimeType="com.google.maps.ImageResult")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="google-maps-workitem", version="7.52.0.Final")}, serviceInfo=@WidService(category="Google Maps", description="Interact with Google Maps Services", keywords="google,maps,directions,locations", action=@WidAction(title="Get directions using Google Maps"), authinfo=@WidAuth(required=true, params={"apiKey"}, paramsdescription={"Google maps api key"}, referencesite="https://developers.google.com/maps/premium/previous-licenses/clientside/auth")))
public class StaticMapsWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String apiKey;
    private GeoApiContext geoApiContext;
    private GoogleMapsAuth auth = new GoogleMapsAuth();
    private static final String RESULTS_VALUE = "StaticMap";

    public StaticMapsWorkitemHandler(String apiKey) throws Exception {
        this.apiKey = apiKey;
        try {
            this.geoApiContext = this.auth.authorize(apiKey);
        }
        catch (Exception e) {
            throw new IllegalAccessException("Unable to authenticate with google maps: " + e.getMessage());
        }
    }

    public StaticMapsWorkitemHandler(GeoApiContext geoApiContext) {
        this.geoApiContext = geoApiContext;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        String width = (String)workItem.getParameter("Width");
        String height = (String)workItem.getParameter("Height");
        String centerLocation = (String)workItem.getParameter("CenterLocation");
        String zoom = (String)workItem.getParameter("Zoom");
        String scale = (String)workItem.getParameter("Scale");
        String mapType = (String)workItem.getParameter("MapType");
        String markers = (String)workItem.getParameter("Markers");
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            HashMap<String, ImageResult> results = new HashMap<String, ImageResult>();
            StaticMapsRequest staticMapsRequest = StaticMapsApi.newRequest((GeoApiContext)this.geoApiContext, (Size)new Size(Integer.parseInt(width), Integer.parseInt(height)));
            staticMapsRequest.center(centerLocation);
            if (zoom != null) {
                staticMapsRequest = staticMapsRequest.zoom(Integer.parseInt(zoom));
            }
            if (scale != null) {
                staticMapsRequest = staticMapsRequest.scale(Integer.parseInt(scale));
            }
            if (mapType != null) {
                staticMapsRequest = staticMapsRequest.maptype(StaticMapsRequest.StaticMapType.valueOf((String)mapType));
            }
            if (markers != null) {
                String[] markersArray;
                for (String newMarker : markersArray = markers.split(";")) {
                    String[] newMarkerInfo = newMarker.split(",");
                    StaticMapsRequest.Markers staticMarker = new StaticMapsRequest.Markers();
                    staticMarker.color(newMarkerInfo[0]);
                    staticMarker.label(newMarkerInfo[1]);
                    staticMarker.addLocation(newMarkerInfo[2]);
                    staticMapsRequest = staticMapsRequest.markers(staticMarker);
                }
            }
            ImageResult imageResult = (ImageResult)staticMapsRequest.await();
            results.put(RESULTS_VALUE, imageResult);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }
}

