/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workitem.google.maps;

import com.google.maps.GeoApiContext;
import com.google.maps.TimeZoneApi;
import com.google.maps.model.LatLng;
import java.util.HashMap;
import java.util.TimeZone;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.workitem.google.maps.GoogleMapsAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="GoogleMapsTimezoneDefinitions.wid", name="GoogleMapsTimezone", displayName="GoogleMapsTimezone", defaultHandler="mvel: new org.jbpm.process.workitem.google.maps.TimezoneWorkitemHandler(\"apiKey\")", documentation="google-maps-workitem/index.html", category="google-maps-workitem", icon="GoogleMapsTimezone.png", parameters={@WidParameter(name="LatLong", required=true)}, results={@WidResult(name="TimezonResults", runtimeType="java.util.TimeZone")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="google-maps-workitem", version="7.45.0.t20201009")}, serviceInfo=@WidService(category="Google Maps", description="Interact with Google Maps Services", keywords="google,maps,timezone,locations", action=@WidAction(title="Get timezone information using Google Maps"), authinfo=@WidAuth(required=true, params={"apiKey"}, paramsdescription={"Google maps api key"}, referencesite="https://developers.google.com/maps/premium/previous-licenses/clientside/auth")))
public class TimezoneWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String apiKey;
    private GeoApiContext geoApiContext;
    private GoogleMapsAuth auth = new GoogleMapsAuth();
    private static final String RESULTS_VALUE = "TimezonResults";

    public TimezoneWorkitemHandler(String apiKey) throws Exception {
        this.apiKey = apiKey;
        try {
            this.geoApiContext = this.auth.authorize(apiKey);
        }
        catch (Exception e) {
            throw new IllegalAccessException("Unable to authenticate with google maps: " + e.getMessage());
        }
    }

    public TimezoneWorkitemHandler(GeoApiContext geoApiContext) {
        this.geoApiContext = geoApiContext;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        String latlong = (String)workItem.getParameter("LatLong");
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String[] latlongParts = latlong.split(",");
            HashMap<String, TimeZone> results = new HashMap<String, TimeZone>();
            TimeZone timeZone = (TimeZone)TimeZoneApi.getTimeZone((GeoApiContext)this.geoApiContext, (LatLng)new LatLng(Double.parseDouble(latlongParts[0]), Double.parseDouble(latlongParts[1]))).await();
            results.put(RESULTS_VALUE, timeZone);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }
}

