/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workitem.google.maps;

import com.google.maps.GeoApiContext;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.workitem.google.maps.DirectionsWorkitemHandler;
import org.jbpm.workitem.google.maps.GeocodingWorkitemHandler;
import org.jbpm.workitem.google.maps.SpeedLimitsWorkitemHandler;
import org.jbpm.workitem.google.maps.StaticMapsWorkitemHandler;
import org.jbpm.workitem.google.maps.TimezoneWorkitemHandler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GoogleMapsWorkitemHandlerTest {
    @Mock
    GeoApiContext context;

    @Test
    public void testDirections() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Origin", (Object)"Atlanta");
        workItem.setParameter("Destination", (Object)"Dallas");
        DirectionsWorkitemHandler handler = new DirectionsWorkitemHandler(this.context);
        handler.setLogThrownException(true);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
    }

    @Test
    public void testSpeedLimits() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("PlaceIds", (Object)"id1,id2,id3,id4");
        SpeedLimitsWorkitemHandler handler = new SpeedLimitsWorkitemHandler(this.context);
        handler.setLogThrownException(true);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
    }

    @Test
    public void testStaticMap() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Width", (Object)"100");
        workItem.setParameter("Height", (Object)"100");
        workItem.setParameter("CenterLocation", (Object)"Atlanta");
        StaticMapsWorkitemHandler handler = new StaticMapsWorkitemHandler(this.context);
        handler.setLogThrownException(true);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
    }

    @Test
    public void testGeocoding() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("SearchType", (Object)"byaddress");
        workItem.setParameter("SearchLocation", (Object)"Atlanta, GA, USA");
        GeocodingWorkitemHandler handler = new GeocodingWorkitemHandler(this.context);
        handler.setLogThrownException(true);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
    }

    @Test
    public void testTimezone() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("LatLong", (Object)"-33.8688, 151.2093");
        TimezoneWorkitemHandler handler = new TimezoneWorkitemHandler(this.context);
        handler.setLogThrownException(true);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
    }
}

