/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workitem.google.maps;

import com.google.maps.DirectionsApi;
import com.google.maps.DirectionsApiRequest;
import com.google.maps.GeoApiContext;
import com.google.maps.model.DirectionsResult;
import com.google.maps.model.TravelMode;
import com.google.maps.model.Unit;
import java.util.HashMap;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.workitem.google.maps.GoogleMapsAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="GoogleMapsDirectionsDefinitions.wid", name="GoogleMapsDirections", displayName="GoogleMapsDirections", defaultHandler="mvel: new org.jbpm.process.workitem.google.maps.DirectionsWorkitemHandler(\"apiKey\")", documentation="google-maps-workitem/index.html", category="google-maps-workitem", icon="GoogleMapsDirections.png", parameters={@WidParameter(name="Origin", required=true), @WidParameter(name="Destination", required=true), @WidParameter(name="Mode"), @WidParameter(name="Avoid"), @WidParameter(name="Units")}, results={@WidResult(name="Directions", runtimeType="com.google.maps.model.DirectionsResult")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="google-maps-workitem", version="7.32.0.Final")}, serviceInfo=@WidService(category="Google Maps", description="Interact with Google Maps Services", keywords="google,maps,directions,locations", action=@WidAction(title="Get directions using Google Maps"), authinfo=@WidAuth(required=true, params={"apiKey"}, paramsdescription={"Google maps api key"}, referencesite="https://developers.google.com/maps/premium/previous-licenses/clientside/auth")))
public class DirectionsWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String apiKey;
    private GeoApiContext geoApiContext;
    private GoogleMapsAuth auth = new GoogleMapsAuth();
    private static final String RESULTS_VALUE = "Directions";

    public DirectionsWorkitemHandler(String apiKey) throws Exception {
        this.apiKey = apiKey;
        try {
            this.geoApiContext = this.auth.authorize(apiKey);
        }
        catch (Exception e) {
            throw new IllegalAccessException("Unable to authenticate with google maps: " + e.getMessage());
        }
    }

    public DirectionsWorkitemHandler(GeoApiContext geoApiContext) {
        this.geoApiContext = geoApiContext;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        String origin = (String)workItem.getParameter("Origin");
        String destination = (String)workItem.getParameter("Destination");
        String mode = (String)workItem.getParameter("Mode");
        String avoid = (String)workItem.getParameter("Avoid");
        String units = (String)workItem.getParameter("Units");
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            HashMap<String, DirectionsResult> results = new HashMap<String, DirectionsResult>();
            DirectionsApiRequest directionsApiRequest = DirectionsApi.newRequest((GeoApiContext)this.geoApiContext);
            directionsApiRequest = directionsApiRequest.origin(origin);
            directionsApiRequest = directionsApiRequest.destination(destination);
            if (mode != null) {
                switch (mode) {
                    case "driving": {
                        directionsApiRequest = directionsApiRequest.mode(TravelMode.DRIVING);
                        break;
                    }
                    case "walking": {
                        directionsApiRequest = directionsApiRequest.mode(TravelMode.WALKING);
                        break;
                    }
                    case "bicycling": {
                        directionsApiRequest = directionsApiRequest.mode(TravelMode.BICYCLING);
                        break;
                    }
                    case "transit": {
                        directionsApiRequest = directionsApiRequest.mode(TravelMode.TRANSIT);
                        break;
                    }
                    default: {
                        directionsApiRequest = directionsApiRequest.mode(TravelMode.DRIVING);
                    }
                }
            }
            if (avoid != null) {
                switch (avoid) {
                    case "tolls": {
                        directionsApiRequest = directionsApiRequest.avoid(new DirectionsApi.RouteRestriction[]{DirectionsApi.RouteRestriction.TOLLS});
                        break;
                    }
                    case "highways": {
                        directionsApiRequest = directionsApiRequest.avoid(new DirectionsApi.RouteRestriction[]{DirectionsApi.RouteRestriction.HIGHWAYS});
                        break;
                    }
                    case "ferries": {
                        directionsApiRequest = directionsApiRequest.avoid(new DirectionsApi.RouteRestriction[]{DirectionsApi.RouteRestriction.FERRIES});
                        break;
                    }
                }
            }
            if (units != null) {
                switch (units) {
                    case "metric": {
                        directionsApiRequest = directionsApiRequest.units(Unit.METRIC);
                        break;
                    }
                    case "imperial": {
                        directionsApiRequest = directionsApiRequest.units(Unit.IMPERIAL);
                        break;
                    }
                    default: {
                        directionsApiRequest = directionsApiRequest.units(Unit.METRIC);
                    }
                }
            }
            DirectionsResult directionsResult = (DirectionsResult)directionsApiRequest.await();
            results.put(RESULTS_VALUE, directionsResult);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }
}

