/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workitem.google.drive;

import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.util.DateTime;
import com.google.api.services.drive.Drive;
import java.io.File;
import java.io.FileOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.jbpm.document.Document;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.workitem.google.drive.GoogleDriveAuth;
import org.jbpm.workitem.google.drive.MediaUploadProgressListener;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GoogleUploadToDriveDefinitions.wid", name="GoogleUploadToDrive", displayName="GoogleUploadToDrive", defaultHandler="mvel: new org.jbpm.process.workitem.google.drive.MediaUploadWorkitemHandler()", documentation="google-drive-workitem/index.html", parameters={@WidParameter(name="DocToUpload", required=true), @WidParameter(name="DocMimeType", required=true), @WidParameter(name="UploadPath", required=true)}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="google-drive-workitem", version="7.14.0.Final")}, serviceInfo=@WidService(category="Google Drive", description="Upload and download media to/from Google Drive", keywords="google,drive,media,upload", action=@WidAction(title="Upload media to Google Drive")))
public class MediaUploadWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String appName;
    private String clientSecret;
    private GoogleDriveAuth auth = new GoogleDriveAuth();
    private static final Logger logger = LoggerFactory.getLogger(MediaUploadWorkitemHandler.class);

    public MediaUploadWorkitemHandler(String appName, String clentSecret) {
        this.appName = appName;
        this.clientSecret = clentSecret;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        Document docToUpload = (Document)workItem.getParameter("DocToUpload");
        String docMimeType = (String)workItem.getParameter("DocMimeType");
        String uploadPath = (String)workItem.getParameter("UploadPath");
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            Drive drive = this.auth.getDriveService(this.appName, this.clientSecret);
            com.google.api.services.drive.model.File fileMetadata = new com.google.api.services.drive.model.File();
            fileMetadata.setTitle(docToUpload.getName());
            fileMetadata.setAlternateLink(docToUpload.getLink());
            if (docToUpload.getLastModified() != null) {
                fileMetadata.setModifiedDate(new DateTime(docToUpload.getLastModified()));
            }
            File tempDocFile = File.createTempFile(FilenameUtils.getBaseName((String)docToUpload.getName()), "." + FilenameUtils.getExtension((String)docToUpload.getName()));
            FileOutputStream fos = new FileOutputStream(tempDocFile);
            fos.write(docToUpload.getContent());
            fos.close();
            FileContent mediaContent = new FileContent(docMimeType, tempDocFile);
            Drive.Files.Insert insert = drive.files().insert(fileMetadata, (AbstractInputStreamContent)mediaContent);
            MediaHttpUploader uploader = insert.getMediaHttpUploader();
            uploader.setDirectUploadEnabled(true);
            uploader.setProgressListener((MediaHttpUploaderProgressListener)new MediaUploadProgressListener());
            insert.execute();
            workItemManager.completeWorkItem(workItem.getId(), null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GoogleDriveAuth auth) {
        this.auth = auth;
    }
}

