/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.exec;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="ExecDefinitions.wid", name="Exec", displayName="Exec", defaultHandler="mvel: new org.jbpm.process.workitem.exec.ExecWorkItemHandler()", documentation="exec-workitem/index.html", category="exec-workitem", icon="Exec.png", parameters={@WidParameter(name="Command", required=true), @WidParameter(name="Arguments", runtimeType="java.util.List")}, results={@WidResult(name="Output")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="exec-workitem", version="7.28.0.Final")}, serviceInfo=@WidService(category="Exec", description="Execute a command", keywords="execute,comand", action=@WidAction(title="Execute a command")))
public class ExecWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler {
    public static final String RESULT = "Output";
    private String parsedCommandStr = "";

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String command = (String)workItem.getParameter("Command");
            List arguments = (List)workItem.getParameter("Arguments");
            HashMap<String, String> results = new HashMap<String, String>();
            CommandLine commandLine = CommandLine.parse((String)command);
            if (arguments != null && arguments.size() > 0) {
                commandLine.addArguments(arguments.toArray(new String[0]), true);
            }
            this.parsedCommandStr = commandLine.toString();
            DefaultExecutor executor = new DefaultExecutor();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)outputStream);
            executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
            executor.execute(commandLine);
            results.put(RESULT, outputStream.toString());
            outputStream.close();
            manager.completeWorkItem(workItem.getId(), results);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public String getParsedCommandStr() {
        return this.parsedCommandStr;
    }
}

