/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.xnio.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.xb.annotations.JBossXmlSchema;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;

@XmlType(name = "xnioType", propOrder = {})
@XmlRootElement(name = "xnio")
@JBossXmlSchema(namespace = "urn:jboss:xnio:2.1", elementFormDefault = XmlNsForm.QUALIFIED)
public final class XnioMetaData implements BeanMetaDataFactory, Serializable {

    private static final long serialVersionUID = -7168741664725963956L;

    private String provider;
    private List<ProviderMetaData> providers = arrayList();
    private List<PipeConnectorMetaData> pipeConnectors = arrayList();
    private List<PipeConnectorMetaData> pipeSourceConnectors = arrayList();
    private List<PipeConnectorMetaData> pipeSinkConnectors = arrayList();
    private List<TcpAcceptorMetaData> tcpAcceptors = arrayList();
    private List<TcpConnectorMetaData> tcpConnectors = arrayList();
    private List<TcpServerMetaData> tcpServers = arrayList();
    private List<TcpChannelSourceMetaData> tcpChannelSources = arrayList();
    private List<SslTcpConnectorMetaData> tcpSslConnectors = arrayList();
    private List<SslTcpServerMetaData> tcpSslServers = arrayList();
    private List<UdpServerMetaData> udpServers = arrayList();
    private List<OptionsOnlyMetaData> socketFactories = arrayList();
    private List<OptionsOnlyMetaData> serverSocketFactories = arrayList();
    private List<ChannelListenerMetaData> channelListeners = arrayList();
    private List<BindingMetaData> bindings = arrayList();

    private static <T> List<T> arrayList() {
        return new ArrayList<T>();
    }

    public String getProvider() {
        return provider;
    }

    @XmlAttribute
    public void setProvider(final String provider) {
        this.provider = provider;
    }

    public List<PipeConnectorMetaData> getPipeConnectors() {
        return pipeConnectors;
    }

    @XmlElement(name = "pipe-connector", type = PipeConnectorMetaData.class)
    public void setPipeConnectors(final List<PipeConnectorMetaData> pipeConnectors) {
        this.pipeConnectors = pipeConnectors;
    }

    public List<PipeConnectorMetaData> getPipeSourceConnectors() {
        return pipeSourceConnectors;
    }

    @XmlElement(name = "pipe-source-connector", type = PipeConnectorMetaData.class)
    public void setPipeSourceConnectors(final List<PipeConnectorMetaData> pipeSourceConnectors) {
        this.pipeSourceConnectors = pipeSourceConnectors;
    }

    public List<PipeConnectorMetaData> getPipeSinkConnectors() {
        return pipeSinkConnectors;
    }

    @XmlElement(name = "pipe-sink-connector", type = PipeConnectorMetaData.class)
    public void setPipeSinkConnectors(final List<PipeConnectorMetaData> pipeSinkConnectors) {
        this.pipeSinkConnectors = pipeSinkConnectors;
    }

    public List<TcpServerMetaData> getTcpServers() {
        return tcpServers;
    }

    @XmlElement(name = "tcp-server", type = TcpServerMetaData.class)
    public void setTcpServers(final List<TcpServerMetaData> tcpServers) {
        this.tcpServers = tcpServers;
    }

    public List<SslTcpServerMetaData> getTcpSslServers() {
        return tcpSslServers;
    }

    @XmlElement(name = "tcp-ssl-server", type = TcpServerMetaData.class)
    public void setTcpSslServers(final List<SslTcpServerMetaData> tcpSslServers) {
        this.tcpSslServers = tcpSslServers;
    }

    public List<TcpConnectorMetaData> getTcpConnectors() {
        return tcpConnectors;
    }

    @XmlElement(name = "tcp-connector", type = TcpConnectorMetaData.class)
    public void setTcpConnectors(final List<TcpConnectorMetaData> tcpConnectors) {
        this.tcpConnectors = tcpConnectors;
    }

    public List<SslTcpConnectorMetaData> getTcpSslConnectors() {
        return tcpSslConnectors;
    }

    @XmlElement(name = "tcp-ssl-connector", type = TcpConnectorMetaData.class)
    public void setTcpSslConnectors(final List<SslTcpConnectorMetaData> tcpSslConnectors) {
        this.tcpSslConnectors = tcpSslConnectors;
    }

    public List<TcpChannelSourceMetaData> getTcpChannelSources() {
        return tcpChannelSources;
    }

    @XmlElement(name = "tcp-channel-source", type = TcpChannelSourceMetaData.class)
    public void setTcpChannelSources(final List<TcpChannelSourceMetaData> tcpChannelSources) {
        this.tcpChannelSources = tcpChannelSources;
    }

    public List<UdpServerMetaData> getUdpServers() {
        return udpServers;
    }

    @XmlElement(name = "udp-server", type = UdpServerMetaData.class)
    public void setUdpServers(final List<UdpServerMetaData> udpServers) {
        this.udpServers = udpServers;
    }

    public List<TcpAcceptorMetaData> getTcpAcceptors() {
        return tcpAcceptors;
    }

    @XmlElement(name = "tcp-acceptor", type = TcpAcceptorMetaData.class)
    public void setTcpAcceptors(final List<TcpAcceptorMetaData> tcpAcceptors) {
        this.tcpAcceptors = tcpAcceptors;
    }

    public List<OptionsOnlyMetaData> getSocketFactories() {
        return socketFactories;
    }

    @XmlElement(name = "socket-factory", type = OptionsOnlyMetaData.class)
    public void setSocketFactories(final List<OptionsOnlyMetaData> socketFactories) {
        this.socketFactories = socketFactories;
    }

    public List<OptionsOnlyMetaData> getServerSocketFactories() {
        return serverSocketFactories;
    }

    @XmlElement(name = "server-socket-factory", type = OptionsOnlyMetaData.class)
    public void setServerSocketFactories(final List<OptionsOnlyMetaData> serverSocketFactories) {
        this.serverSocketFactories = serverSocketFactories;
    }

    public List<ProviderMetaData> getProviders() {
        return providers;
    }

    @XmlElement(name = "provider", type = ProviderMetaData.class)
    public void setProviders(final List<ProviderMetaData> providers) {
        this.providers = providers;
    }

    public List<ChannelListenerMetaData> getChannelListeners() {
        return channelListeners;
    }

    @XmlElement(name = "channel-listener", type = ChannelListenerMetaData.class)
    public void setChannelListeners(final List<ChannelListenerMetaData> channelListeners) {
        this.channelListeners = channelListeners;
    }

    public List<BindingMetaData> getBindings() {
        return bindings;
    }

    @XmlElement(name = "binding", type = BindingMetaData.class)
    public void setBindings(final List<BindingMetaData> bindings) {
        this.bindings = bindings;
    }

    @XmlTransient
    public List<BeanMetaData> getBeans() {
        final List<BeanMetaData> list = arrayList();
        final String provider = this.provider == null ? XnioMetaDataHelper.DEFAULT_PROVIDER_BEAN_NAME : this.provider;
        for (ProviderMetaData providerMetaData : providers) {
            XnioMetaDataHelper.add(list, provider, providerMetaData);
        }
        for (PipeConnectorMetaData pipeConnector : pipeConnectors) {
            XnioMetaDataHelper.add(list, provider, pipeConnector, "createPipeServer");
        }
        for (PipeConnectorMetaData pipeSourceConnector : pipeSourceConnectors) {
            XnioMetaDataHelper.add(list, provider, pipeSourceConnector, "createPipeSourceServer");
        }
        for (PipeConnectorMetaData pipeSinkConnector : pipeSinkConnectors) {
            XnioMetaDataHelper.add(list, provider, pipeSinkConnector, "createPipeSinkServer");
        }
        for (TcpServerMetaData tcpServer : tcpServers) {
            XnioMetaDataHelper.add(list, provider, tcpServer);
        }
        for (SslTcpServerMetaData tcpSslServer : tcpSslServers) {
            XnioMetaDataHelper.add(list, provider, tcpSslServer);
        }
        for (TcpConnectorMetaData tcpConnector : tcpConnectors) {
            XnioMetaDataHelper.add(list, provider, tcpConnector);
        }
        for (TcpChannelSourceMetaData tcpChannelSource : tcpChannelSources) {
            XnioMetaDataHelper.add(list, provider, tcpChannelSource);
        }
        for (TcpAcceptorMetaData tcpAcceptor : tcpAcceptors) {
            XnioMetaDataHelper.add(list, provider, tcpAcceptor);
        }
        for (UdpServerMetaData udpServer : udpServers) {
            XnioMetaDataHelper.add(list, provider, udpServer);
        }
        for (OptionsOnlyMetaData socketFactory : socketFactories) {
            XnioMetaDataHelper.add(list, provider, socketFactory, "createManagedSocketFactory", SocketFactory.class);
        }
        for (OptionsOnlyMetaData serverSocketFactory : serverSocketFactories) {
            XnioMetaDataHelper.add(list, provider, serverSocketFactory, "createServerSocketFactory", ServerSocketFactory.class);
        }
        for (ChannelListenerMetaData channelListener : channelListeners) {
            XnioMetaDataHelper.add(list, provider, channelListener);
        }
        for (BindingMetaData binding : bindings) {
            XnioMetaDataHelper.add(list, provider, binding);
        }
        return list;
    }
}
